package jp.co.sra.jun.goodies.calendar;

import java.util.Calendar;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.jun.system.support.JunSystem;
import jp.co.sra.jun.system.support.JunTestExamples;

/**
 * JunCalendarDateDialogTestExamples class
 * 
 *  @author    Nobuto Matsubara
 *  @created   2003/10/06 (by Nobuto Matsubara)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun472 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunCalendarDateDialogTestExamples.java,v 8.10 2008/02/20 06:31:12 nisinaka Exp $
 */
public class JunCalendarDateDialogTestExamples extends JunTestExamples {
	/**
	 * Example1: Call Request().
	 *
	 * @return boolean
	 */
	public static boolean Example1() {
		Calendar answer = JunCalendarDateDialog.Request();
		if (answer != null) {
			System.out.print(answer.get(Calendar.YEAR));
			System.out.print("." + answer.get(Calendar.MONTH));
			System.out.println("." + answer.get(Calendar.DATE));
		}
		return true;
	}

	/**
	 * Example2: Call Request().
	 *
	 * @return boolean
	 */
	public static boolean Example2() {
		Calendar answer = JunCalendarDateDialog.Request_(JunSystem.$String("Select date."));
		if (answer != null) {
			System.out.print(answer.get(Calendar.YEAR));
			System.out.print("." + answer.get(Calendar.MONTH));
			System.out.println("." + answer.get(Calendar.DATE));
		}
		return true;
	}

	/**
	 * Example3: Call Request().
	 *
	 * @return boolean
	 */
	public static boolean Example3() {
		Calendar date = Calendar.getInstance();
		date.add(Calendar.DATE, 100);
		Calendar answer = JunCalendarDateDialog.Request_initialDate_(JunSystem.$String("Select date."), date);
		if (answer != null) {
			System.out.print(answer.get(Calendar.YEAR));
			System.out.print("." + answer.get(Calendar.MONTH));
			System.out.println("." + answer.get(Calendar.DATE));
		}
		return true;
	}

	/**
	 * Example4: Call Request().
	 *
	 * @return boolean
	 */
	public static boolean Example4() {
		Calendar date = Calendar.getInstance();
		date.add(Calendar.DATE, 100);
		StBlockClosure acceptBlock = new StBlockClosure() {
			public Object value_(Object aModel) {
				JunCalendarDateModel dateModel = (JunCalendarDateModel) aModel;
				System.out.println(JunSystem.$String("Accept button was pressed."));
				System.out.println("	" + dateModel);
				return (Object) Boolean.TRUE;
			}
		};
		StBlockClosure cancelBlock = new StBlockClosure() {
			public Object value_(Object aModel) {
				JunCalendarDateModel dateModel = (JunCalendarDateModel) aModel;
				System.out.println(JunSystem.$String("Cancel button was pressed."));
				System.out.println("	" + dateModel);
				return (Object) Boolean.TRUE;
			}
		};
		Calendar answer = JunCalendarDateDialog.Request_initialDate_onAccept_onCancel_(JunSystem.$String("Select date."), date, acceptBlock, cancelBlock);
		if (answer != null) {
			System.out.print(answer.get(Calendar.YEAR));
			System.out.print("." + answer.get(Calendar.MONTH));
			System.out.println("." + answer.get(Calendar.DATE));
		}
		return true;
	}

	/**
	 * Execute all examples.
	 *
	 * @param args an array of command-line argumetns
	 */
	public static void main(java.lang.String[] args) {
		new JunCalendarDateDialogTestExamples();
	}
}
