package jp.co.sra.jun.goodies.calendar;

import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Iterator;
import java.util.Vector;

import jp.co.sra.jun.system.dialog.JunTextInputField;
import jp.co.sra.jun.system.framework.JunAbstractController;
import jp.co.sra.jun.system.framework.JunDialog;
import jp.co.sra.jun.system.support.JunSystem;
import jp.co.sra.smalltalk.StRectangle;
import jp.co.sra.smalltalk.StSymbol;

/**
 * JunCalendarDateController class
 * 
 *  @author    Nobuto Matsubara
 *  @created   2003/10/06 (by Nobuto Matsubara)
 *  @updated   2004/09/21 (by nisinaka)
 *  @version   699 (with StPL8.9) based on Jun473 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunCalendarDateController.java,v 8.16 2008/02/20 06:31:12 nisinaka Exp $
 */
public class JunCalendarDateController extends JunAbstractController implements MouseListener {

	private MouseEvent mEvent;

	/**
	 * Mouse button pressed event.
	 * @param e MouseEvent
	 * @category control defaults
	 */
	public void mousePressed(MouseEvent e) {
		mEvent = e;
		if (mEvent.isMetaDown()) {
			this.view()._showPopupMenu(mEvent.getX(), mEvent.getY());
		} else {
			this.buttonActivity();
		}
	}

	/**
	 * Execute active button event
	 * @category activities
	 */
	public void buttonActivity() {
		Point point = new Point(mEvent.getX(), mEvent.getY());
		StSymbol key;
		StRectangle box;
		for (int i = 0; i < this.getView().frames().size(); ++i) {
			Object[] array = (Object[]) this.getView().frames().get(i);
			key = (StSymbol) array[0];
			box = (StRectangle) array[array.length - 1];
			if (box.containsPoint_(point)) {
				if (key == $("year")) {
					this.yearActivity_(array);
				}
				if (key == $("month")) {
					this.monthActivity_(array);
				}
				if (key == $("weekday")) {
					this.weekdayActivity_(array);
				}
				if (key == $("day")) {
					this.dayActivity_(array);
				}
				if (key == $("button")) {
					this.buttonActivity_(array);
				}
			}
		}
	}

	/**
	 * Set active button event
	 * @category activities
	 */
	public void buttonActivity_(Object[] anArray) {
		StSymbol symbol = (StSymbol) anArray[1];
		if (symbol == $("yearDown")) {
			this.getCalendarDateModel().yearDown();
		}
		if (symbol == $("yearUp")) {
			this.getCalendarDateModel().yearUp();
		}
		if (symbol == $("monthDown")) {
			this.getCalendarDateModel().monthDown();
		}
		if (symbol == $("monthUp")) {
			this.getCalendarDateModel().monthUp();
		}
	}

	/**
	 * Set active button day event
	 * @category activities
	 */
	public void dayActivity_(Object[] anArray) {
		Point aPoint = (Point) anArray[1];
		int day = this.getCalendarDateModel().atPoint_(aPoint);
		this.getCalendarDateModel().day_(day);
	}

	/**
	 * Set active button month event
	 * @category activities
	 */
	public void monthActivity_(Object[] anArray) {
		String answer;
		if (mEvent.isShiftDown() || mEvent.isAltDown()) {
			answer = JunDialog.Request_(JunSystem.$String("Month?"), String.valueOf(this.getCalendarDateModel().month()));
		} else {
			StRectangle rect = detectFrame(this.getView().frames(), $("month")).insetBy_(2);
			if (rect == null) {
				return;
			}
			answer = JunTextInputField.PopUpIn_forView_initialAnswer_(rect.toRectangle(), this.getView().toComponent(), String.valueOf(this.getCalendarDateModel().month()));
		}
		if (answer == null || answer.length() == 0) {
			return;
		}

		try {
			int month = Integer.parseInt(answer);
			this.getCalendarDateModel().month_(month);
		} catch (NumberFormatException e) {
			JunDialog.Warn_(answer + JunSystem.$String(" is invalid value."));
		}
	}

	/**
	 * Set active button weekday event
	 * @category activities
	 */
	public void weekdayActivity_(Object[] anArray) {
		return;
	}

	/**
	 * Set active button year event
	 * @category activities
	 */
	public void yearActivity_(Object[] anArray) {
		String answer;
		if (mEvent.isShiftDown() || mEvent.isAltDown()) {
			answer = JunDialog.Request_(JunSystem.$String("Year?"), String.valueOf(this.getCalendarDateModel().year()));
		} else {
			StRectangle rect = detectFrame(this.getView().frames(), $("year")).insetBy_(2);
			if (rect == null) {
				return;
			}
			answer = JunTextInputField.PopUpIn_forView_initialAnswer_(rect.toRectangle(), this.getView().toComponent(), String.valueOf(this.getCalendarDateModel().year()));
		}
		if (answer == null || answer.length() == 0) {
			return;
		}

		try {
			int year = Integer.parseInt(answer);
			this.getCalendarDateModel().year_(year);
		} catch (NumberFormatException e) {
			JunDialog.Warn_(answer + JunSystem.$String(" is invalid value."));
		}
	}

	/**
	 * Detect frame.
	 * @param frames java.util.Vector
	 * @param aSymbol StSymbol
	 * @return StRectangle
	 * @category private
	 */
	private StRectangle detectFrame(Vector frames, StSymbol aSymbol) {
		Iterator frameIterator = frames.iterator();
		while (frameIterator.hasNext()) {
			Object[] aFrame = (Object[]) frameIterator.next();
			if (aFrame[0].equals(aSymbol)) {
				return (StRectangle) aFrame[aFrame.length - 1];
			}
		}
		return null;
	}

	/**
	 * Return default view
	 * @category defaults
	 */
	public JunCalendarDateView getView() {
		return (JunCalendarDateView) this.view();
	}

	/**
	 * Return default model
	 * @category defaults
	 */
	public JunCalendarDateModel getCalendarDateModel() {
		return (JunCalendarDateModel) this.model();
	}

}
