package jp.co.sra.jun.goodies.calendar;

import java.awt.Dimension;
import jp.co.sra.smalltalk.WindowSpecLayout;
import jp.co.sra.jun.system.framework.JunAbstractViewJPanel;

/**
 * JunCalendarDateAndTimeIntervalViewSwing class
 * 
 *  @author    Nobuto Matsubara
 *  @created   2003/10/06 (by Nobuto Matsubara)
 *  @updated   2004/09/21 (by nisinaka)
 *  @version   699 (with StPL8.9) based on Jun473 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunCalendarDateAndTimeIntervalViewSwing.java,v 8.12 2008/02/20 06:31:12 nisinaka Exp $
 */
public class JunCalendarDateAndTimeIntervalViewSwing extends JunAbstractViewJPanel implements JunCalendarDateAndTimeIntervalView {

	protected JunCalendarDateViewSwing fromDateView;
	protected JunCalendarTimeViewSwing fromTimeView;
	protected JunCalendarDateViewSwing toDateView;
	protected JunCalendarTimeViewSwing toTimeView;

	/**
	 * Create a new instance of <code>JunCalendarDateAndTimeIntervalViewSwing</code> and initialize it.
	 * 
	 * @param aCalendarDateAndTimeIntervalModel JunCalendarDateAndTimeIntervalModel
	 * @category Instance creation
	 */
	public JunCalendarDateAndTimeIntervalViewSwing(JunCalendarDateAndTimeIntervalModel aCalendarDateAndTimeIntervalModel) {
		super(aCalendarDateAndTimeIntervalModel);
	}

	/**
	 * Answer my date view.
	 *
	 * @return JunCalendarDateViewSwing
	 * @category accessing
	 */
	public JunCalendarDateViewSwing fromDateView() {
		if (fromDateView == null) {
			fromDateView = new JunCalendarDateViewSwing(this.getModel().fromCalendarDateAndTimeModel().calendarDateModel());
		}
		return fromDateView;
	}

	/**
	 * Answer my time view.
	 *
	 * @return JunCalendarTimeViewSwing
	 * @category accessing
	 */
	public JunCalendarTimeViewSwing fromTimeView() {
		if (fromTimeView == null) {
			fromTimeView = new JunCalendarTimeViewSwing(this.getModel().fromCalendarDateAndTimeModel().calendarTimeModel());
		}
		return fromTimeView;
	}

	/**
	 * Answer my date view.
	 *
	 * @return JunCalendarDateViewSwing
	 * @category accessing
	 */
	public JunCalendarDateViewSwing toDateView() {
		if (toDateView == null) {
			toDateView = new JunCalendarDateViewSwing(this.getModel().toCalendarDateAndTimeModel().calendarDateModel());
		}
		return toDateView;
	}

	/**
	 * Answer my time view.
	 *
	 * @return JunCalendarTimeViewSwing
	 * @category accessing
	 */
	public JunCalendarTimeViewSwing toTimeView() {
		if (toTimeView == null) {
			toTimeView = new JunCalendarTimeViewSwing(this.getModel().toCalendarDateAndTimeModel().calendarTimeModel());
		}
		return toTimeView;
	}

	/**
	 * Get model.
	 *
	 * @return JunCalendarDateAndTimeModel
	 * @category accessing
	 */
	public JunCalendarDateAndTimeIntervalModel getModel() {
		return (JunCalendarDateAndTimeIntervalModel) this.model();
	}

	/**
	 * Build this component.
	 * @category interface opening
	 */
	protected void buildComponent() {
		this.setLayout(new WindowSpecLayout());
		this.add(this.fromDateView(), WindowSpecLayout.Position(0f, 1, 0f, 1, 0.67f, 0, 0.5f, 0));
		this.add(this.fromTimeView(), WindowSpecLayout.Position(0.67f, 0, 0f, 1, 1f, -1, 0.5f, 0));
		this.add(this.toDateView(), WindowSpecLayout.Position(0f, 1, 0.5f, 0, 0.67f, 0, 1f, -1));
		this.add(this.toTimeView(), WindowSpecLayout.Position(0.67f, 0, 0.5f, 0, 1f, -1, 1f, -1));
		this.setPreferredSize(new Dimension(450, 400));
	}

}
