package jp.co.sra.jun.goodies.calendar;

import java.util.Calendar;

import jp.co.sra.jun.system.support.JunSystem;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StView;

/**
 * JunCalendarDateAndTimeIntervalModel class
 * 
 *  @author    Nobuto Matsubara
 *  @created   2003/10/06 (by Nobuto Matsubara)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun472 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunCalendarDateAndTimeIntervalModel.java,v 8.11 2008/02/20 06:31:12 nisinaka Exp $
 */
public class JunCalendarDateAndTimeIntervalModel extends JunCalendarModel {
	protected JunCalendarDateAndTimeModel fromCalendarDateAndTimeModel;
	protected JunCalendarDateAndTimeModel toCalendarDateAndTimeModel;

	/**
	 * Create a new instance of <code>JunCalendarDateAndTimeIntervalModel</code> and initialize it.
	 * 
	 * @category Instance creation
	 */
	public JunCalendarDateAndTimeIntervalModel() {
		Calendar[] fromDateAndTime = { Calendar.getInstance(), Calendar.getInstance() };
		Calendar[] toDateAndTime = { Calendar.getInstance(), Calendar.getInstance() };
		this.fromCalendarDateAndTimeModel().dateAndTime_(fromDateAndTime);
		this.toCalendarDateAndTimeModel().dateAndTime_(toDateAndTime);
	}

	/**
	 * Create instance and set dateAndTime from fromDateAndTime to toDateAndTime.
	 *
	 * @param fromDateAndTime java.util.Calendar
	 * @param toDateAndTime java.util.Calendar
	 * @category Utilities
	 */
	public static JunCalendarDateAndTimeIntervalModel From_to_(Calendar[] fromDateAndTime, Calendar[] toDateAndTime) {
		JunCalendarDateAndTimeIntervalModel calendarDateAndTimeIntervalModel = new JunCalendarDateAndTimeIntervalModel();
		calendarDateAndTimeIntervalModel.fromCalendarDateAndTimeModel().dateAndTime_(fromDateAndTime);
		calendarDateAndTimeIntervalModel.toCalendarDateAndTimeModel().dateAndTime_(toDateAndTime);
		return calendarDateAndTimeIntervalModel;
	}

	/**
	 * Answer fromCalendarDateAndTimeModel.
	 *
	 * @return JunCalendarDateAndTimeModel
	 * @category accessing
	 */
	public JunCalendarDateAndTimeModel fromCalendarDateAndTimeModel() {
		if (fromCalendarDateAndTimeModel == null) {
			fromCalendarDateAndTimeModel = new JunCalendarDateAndTimeModel();
			final JunCalendarDateAndTimeIntervalModel this_ = this;
			fromCalendarDateAndTimeModel.validateBlock_(new StBlockClosure() {
				public Object value_value_(Object oldDateAndTime, Object newDateAndTime) {
					return (Object) this_.validateFromDateAndTime_with_((Calendar[]) oldDateAndTime, (Calendar[]) newDateAndTime);
				}
			});
		}
		return fromCalendarDateAndTimeModel;
	}

	/**
	 * Answer fromCaalendarDateAndTimeModel and toCalendarDateAndTimeModel.
	 *
	 * @return Object[]
	 * @category accessing
	 */
	public JunCalendarDateAndTimeModel[] dateAndTimes() {
		JunCalendarDateAndTimeModel[] array = new JunCalendarDateAndTimeModel[2];
		array[0] = this.fromCalendarDateAndTimeModel();
		array[1] = this.toCalendarDateAndTimeModel();
		return array;
	}

	/**
	 * Answer toCalendarDateAndTimeModel.
	 *
	 * @return JunCalendarDateAndTimeModel
	 * @category accessing
	 */
	public JunCalendarDateAndTimeModel toCalendarDateAndTimeModel() {
		if (toCalendarDateAndTimeModel == null) {
			toCalendarDateAndTimeModel = new JunCalendarDateAndTimeModel();
			final JunCalendarDateAndTimeIntervalModel this_ = this;
			toCalendarDateAndTimeModel.validateBlock_(new StBlockClosure() {
				public Object value_value_(Object oldDateAndTime, Object newDateAndTime) {
					return (Object) this_.validateToDateAndTime_with_((Calendar[]) oldDateAndTime, (Calendar[]) newDateAndTime);
				}
			});
		}
		return toCalendarDateAndTimeModel;
	}

	/**
	 * Default view.
	 *
	 * @return jp.co.sra.smalltalk.StView
	 * @category defaults
	 */
	public StView defaultView() {
		JunCalendarDateAndTimeIntervalView aView;
		if (GetDefaultViewMode() == VIEW_AWT) {
			aView = new JunCalendarDateAndTimeIntervalViewAwt(this);
		} else {
			aView = new JunCalendarDateAndTimeIntervalViewSwing(this);
		}
		return aView;
	}

	/**
	 * Amswer old dateAndTime.
	 *
	 * @param oldDateAndTime Calendar[]
	 * @param newDateAndTime Calendar[]
	 * @return Calendar[]
	 * @category private
	 */
	private Calendar[] validateFromDateAndTime_with_(Calendar[] oldDateAndTime, Calendar[] newDateAndTime) {
		if (((Calendar) newDateAndTime[0]).before((Calendar) (this.toCalendarDateAndTimeModel().dateAndTime()[0]))) {
			return newDateAndTime;
		}
		if (((Calendar) newDateAndTime[0]).equals((Calendar) (this.toCalendarDateAndTimeModel().dateAndTime()[0]))
				&& (((Calendar) newDateAndTime[1]).before((Calendar) (this.toCalendarDateAndTimeModel().dateAndTime()[1])) || ((Calendar) newDateAndTime[1]).equals((Calendar) (this.toCalendarDateAndTimeModel().dateAndTime()[1])))) {
			return newDateAndTime;
		}
		return (Calendar[]) this.toCalendarDateAndTimeModel().dateAndTime();
	}

	/**
	 * Amswer latest dateAndTime.
	 *
	 * @param oldDateAndTime Calendar[]
	 * @param newDateAndTime Calendar[]
	 * @return Calendar[]
	 * @category private
	 */
	private Calendar[] validateToDateAndTime_with_(Calendar[] oldDateAndTime, Calendar[] newDateAndTime) {
		if (((Calendar) newDateAndTime[0]).after((Calendar) (this.fromCalendarDateAndTimeModel().dateAndTime()[0]))) {
			return newDateAndTime;
		}
		if (((Calendar) newDateAndTime[0]).equals((Calendar) (this.fromCalendarDateAndTimeModel().dateAndTime()[0]))
				&& (((Calendar) newDateAndTime[1]).after((Calendar) (this.fromCalendarDateAndTimeModel().dateAndTime()[1])) || ((Calendar) newDateAndTime[1]).equals((Calendar) (this.fromCalendarDateAndTimeModel().dateAndTime()[1])))) {
			return newDateAndTime;
		}
		return (Calendar[]) this.fromCalendarDateAndTimeModel().dateAndTime();
	}

	/**
	 * Print current date and time.
	 * 
	 * @return java.lang.String
	 * @category printing
	 */
	public java.lang.String toString() {
		StringBuffer buf = new StringBuffer();
		buf.append("(");
		buf.append(this.dateAndTimes()[0]);
		buf.append(") (");
		buf.append(this.dateAndTimes()[1]);
		buf.append(")");
		return buf.toString();
	}

	/**
	 * Return Window title.
	 * @return java.lang.String
	 * @category interface opening
	 */
	protected String windowTitle() {
		return JunSystem.$String("Period (Date and Time)");
	}
}
