package jp.co.sra.jun.goodies.calendar;

import java.awt.Button;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import jp.co.sra.jun.system.support.JunSystem;
import jp.co.sra.smalltalk.StSimpleDialogViewAwt;
import jp.co.sra.smalltalk.WindowSpecLayout;

/**
 * JunCalendarDateAndTimeIntervalDialogViewAwt class
 * 
 *  @author    Nobuto Matsubara
 *  @created   2003/10/06 (by Nobuto Matsubara)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun472 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunCalendarDateAndTimeIntervalDialogViewAwt.java,v 8.12 2008/02/20 06:31:12 nisinaka Exp $
 */
public class JunCalendarDateAndTimeIntervalDialogViewAwt extends StSimpleDialogViewAwt implements JunCalendarDateAndTimeIntervalDialogView {
	protected Button acceptButton;
	protected Button cancelButton;
	protected JunCalendarDateViewAwt fromDateView;
	protected JunCalendarDateViewAwt toDateView;
	protected JunCalendarTimeViewAwt fromTimeView;
	protected JunCalendarTimeViewAwt toTimeView;

	/**
	 * Create a new instance of <code>JunCalendarDateAndTimeIntervalDialogViewAwt</code> and initialize it with the JunCalendarDateAndDateAndTimeIntervalDialog.
	 * 
	 * @param newCalendarDateAndTimeIntervalDialog JunCalendarDateAndTimeIntervalDialog
	 * @category Instance creation
	 */
	public JunCalendarDateAndTimeIntervalDialogViewAwt(JunCalendarDateAndTimeIntervalDialog newCalendarDateAndTimeIntervalDialog) {
		super(newCalendarDateAndTimeIntervalDialog);
	}

	/**
	 * Answer the default dialog.
	 *
	 * @return java.awt.Dialog
	 * @category defaults
	 */
	public Dialog defaultDialog() {
		Dialog aDialog = new Dialog(new Frame(), this.getCalendarDateAndTimeIntervalDialog().windowTitle(), true);
		aDialog.add(this);
		aDialog.pack();
		return aDialog;
	}

	/**
	 * Answer my model as a JunCalendarDateAndTimeIntervalDialog.
	 * @return JunCalendarDateAndTimeIntervalDialog
	 * @category accessing
	 */
	public JunCalendarDateAndTimeIntervalDialog getCalendarDateAndTimeIntervalDialog() {
		return (JunCalendarDateAndTimeIntervalDialog) this.model();
	}

	/**
	 * Answer my accept button.
	 * @return java.awt.Button
	 * @category actions
	 */
	protected Button acceptButton() {
		if (acceptButton == null) {
			acceptButton = new Button(JunSystem.$String("Accept"));
			acceptButton.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					if (((Boolean) getCalendarDateAndTimeIntervalDialog().acceptButtonPressed()).booleanValue()) {
						getCalendarDateAndTimeIntervalDialog().accept().value_(true);
					}
				}
			});
		}
		return acceptButton;
	}

	/**
	 * Build this component.
	 * 
	 * @see jp.co.sra.smalltalk.StViewPanel#buildComponent()
	 * @category initialize-release
	 */
	protected void buildComponent() {
		this.setLayout(new WindowSpecLayout());
		this.add(this.fromDateView(), WindowSpecLayout.Position(0f, 1, 0f, 1, 0f, 300, 0.5f, 0));
		this.add(this.fromTimeView(), WindowSpecLayout.Position(0f, 300, 0f, 1, 1f, -102, 0.5f, 0));
		this.add(this.toDateView(), WindowSpecLayout.Position(0f, 1, 0.5f, 0, 0f, 300, 1f, -1));
		this.add(this.toTimeView(), WindowSpecLayout.Position(0f, 300, 0.5f, 0, 1f, -102, 1f, -1));
		this.add(this.cancelButton(), WindowSpecLayout.Position(1f, -96, 0f, 56, 1f, -8, 0f, 88));
		this.add(this.acceptButton(), WindowSpecLayout.Position(1f, -96, 0f, 16, 1f, -8, 0f, 48));
		defaultButton = this.acceptButton();
		this.setSize(new Dimension(550, 400));
	}

	/**
	 * Answer my cancel button.
	 *
	 * @return java.awt.Button
	 * @category actions
	 */
	protected Button cancelButton() {
		if (cancelButton == null) {
			cancelButton = new Button(JunSystem.$String("Cancel"));
			cancelButton.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					if (((Boolean) getCalendarDateAndTimeIntervalDialog().cancelButtonPressed()).booleanValue()) {
						getCalendarDateAndTimeIntervalDialog().cancel().value_(true);
					}
				}
			});
		}
		return cancelButton;
	}

	/**
	 * Answer from date view.
	 *
	 * @return JunCalendarDateViewAwt
	 * @category accessing
	 */
	protected JunCalendarDateViewAwt fromDateView() {
		if (fromDateView == null) {
			fromDateView = new JunCalendarDateViewAwt(this.getCalendarDateAndTimeIntervalDialog().calendarDateAndTimeIntervalModel().fromCalendarDateAndTimeModel().calendarDateModel());
		}
		return fromDateView;
	}

	/**
	 * Answer to date view.
	 *
	 * @return JunCalendarDateViewAwt
	 * @category accessing
	 */
	protected JunCalendarDateViewAwt toDateView() {
		if (toDateView == null) {
			toDateView = new JunCalendarDateViewAwt(this.getCalendarDateAndTimeIntervalDialog().calendarDateAndTimeIntervalModel().toCalendarDateAndTimeModel().calendarDateModel());
		}
		return toDateView;
	}

	/**
	 * Answer from Time view.
	 *
	 * @return JunCalendarTimeViewAwt
	 * @category accessing
	 */
	protected JunCalendarTimeViewAwt fromTimeView() {
		if (fromTimeView == null) {
			fromTimeView = new JunCalendarTimeViewAwt(this.getCalendarDateAndTimeIntervalDialog().calendarDateAndTimeIntervalModel().fromCalendarDateAndTimeModel().calendarTimeModel());
		}
		return fromTimeView;
	}

	/**
	 * Answer to Time view.
	 *
	 * @return JunCalendarTimeViewAwt
	 * @category accessing
	 */
	protected JunCalendarTimeViewAwt toTimeView() {
		if (toTimeView == null) {
			toTimeView = new JunCalendarTimeViewAwt(this.getCalendarDateAndTimeIntervalDialog().calendarDateAndTimeIntervalModel().toCalendarDateAndTimeModel().calendarTimeModel());
		}
		return toTimeView;
	}
}
