package jp.co.sra.jun.goodies.calendar;

import java.awt.Dialog;
import java.util.Calendar;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StSimpleDialog;
import jp.co.sra.smalltalk.StView;
import jp.co.sra.jun.system.support.JunSystem;

/**
 * JunCalendarDateAndTimeDialog class
 * 
 *  @author    Nobuto Matsubara
 *  @created   2003/10/06 (by Nobuto Matsubara)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun472 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunCalendarDateAndTimeDialog.java,v 8.11 2008/02/20 06:31:12 nisinaka Exp $
 */
public class JunCalendarDateAndTimeDialog extends StSimpleDialog {
	protected JunCalendarDateAndTimeModel calendarDateAndTimeModel;
	protected StBlockClosure acceptBlock;
	protected StBlockClosure cancelBlock;

	/**
	 * Open a calendarDateAndTime dialog and return selected date and time.
	 *
	 * @return JunCalendarDateAndTimeModel
	 * @category Utilities
	 */
	public static JunCalendarDateAndTimeModel Request() {
		return JunCalendarDateAndTimeDialog.Request_(null);
	}

	/**
	 * Open a calendarDateAndTime dialog and return selected date and time.
	 *
	 * @param messageString java.lang.String
	 * @return JunCalendarDateAndTimeModel
	 * @category Utilities
	 */
	public static JunCalendarDateAndTimeModel Request_(String messageString) {
		Calendar[] dateAndTime = { Calendar.getInstance(), Calendar.getInstance() };
		return JunCalendarDateAndTimeDialog.Request_initialDateAndTime_(messageString, dateAndTime);
	}

	/**
	 * Initialize date and time , open a calendarDateAndTime dialog and return selected date and time.
	 *
	 * @param messageString java.lang.String
	 
	 * @return JunCalendarDateAndTimeModel
	 * @category Utilities
	 */
	public static JunCalendarDateAndTimeModel Request_initialDateAndTime_(String messageString, Calendar[] dateAndTime) {
		return JunCalendarDateAndTimeDialog.Request_initialDateAndTime_onAccept_onCancel_(messageString, dateAndTime, null, null);
	}

	/**
	 * Initialize date and time , set accept button and cancel button,
	 * open a calendarDateAndTime dialog and return selected date and time.
	 *
	 * @param messageString java.lang.String
	 * @param acceptBlock jp.co.sra.smalltalk.StBlockClosure
	 * @param cancelBlock jp.co.sra.smalltalk.StBlockClosure
	 * @return JunCalendarDateAndTimeModel
	 * @category Utilities
	 */
	public static JunCalendarDateAndTimeModel Request_initialDateAndTime_onAccept_onCancel_(String messageString, Calendar[] dateAndTime, StBlockClosure acceptBlock, StBlockClosure cancelBlock) {
		JunCalendarDateAndTimeDialog calendarDateAndTimeDialog = new JunCalendarDateAndTimeDialog();
		if (dateAndTime != null) {
			calendarDateAndTimeDialog.calendarDateAndTimeModel_(JunCalendarDateAndTimeModel.DateAndTime_(dateAndTime));
		}
		Dialog dialog = calendarDateAndTimeDialog.allButOpenDialog();
		if (messageString != null) {
			dialog.setTitle(messageString);
		}
		if (acceptBlock != null) {
			calendarDateAndTimeDialog.acceptBlock_(acceptBlock);
		}
		if (cancelBlock != null) {
			calendarDateAndTimeDialog.cancelBlock_(cancelBlock);
		}
		_ShowAtMousePoint(dialog);
		if (calendarDateAndTimeDialog.accept()._booleanValue()) {
			return calendarDateAndTimeDialog.calendarDateAndTimeModel();
		} else {
			return null;
		}
	}

	/**
	 * Set an action accept to a block..
	 * @param aBlock StBlockClosure
	 * @category accessing
	 */
	public void acceptBlock_(StBlockClosure aBlock) {
		acceptBlock = aBlock;
	}

	/**
	 * Return aCalendarDateAndTimeModel.
	 *
	 * @return JunCalendarDateAndTimeModel
	 * @category accessing
	 */
	public JunCalendarDateAndTimeModel calendarDateAndTimeModel() {
		if (calendarDateAndTimeModel == null) {
			calendarDateAndTimeModel = new JunCalendarDateAndTimeModel();
		}
		return calendarDateAndTimeModel;
	}

	/**
	 * Set aCalendarDateAndTimeModel.
	 *
	 * @param aCalendarDateAndTimeModel JunCalendarDateAndTimeModel
	 * @category accessing
	 */
	public void calendarDateAndTimeModel_(JunCalendarDateAndTimeModel aCalendarDateAndTimeModel) {
		calendarDateAndTimeModel = aCalendarDateAndTimeModel;
	}

	/**
	 * Set a calcel action to a block.
	 * @param aBlock StBlockClosure
	 * @category accessing
	 */
	public void cancelBlock_(StBlockClosure aBlock) {
		cancelBlock = aBlock;
	}

	/**
	 * Return result of accept button pressed.
	 * @return boolean
	 * @category actions
	 */
	public Object acceptButtonPressed() {
		if (!(acceptBlock == null)) {
			return acceptBlock.value_(this.calendarDateAndTimeModel());
		}
		return new Boolean(true);
	}

	/**
	 * Return result of cancel button pressed.
	 * @return boolean
	 * @category actions
	 */
	public Object cancelButtonPressed() {
		if (!(cancelBlock == null)) {
			return acceptBlock.value_(this.calendarDateAndTimeModel());
		}
		return new Boolean(true);
	}

	/**
	 * Answer a default view.
	 *
	 * @return jp.co.sra.smalltalk.StView
	 * @category defaults
	 */
	public StView defaultView() {
		if (GetDefaultViewMode() == VIEW_AWT) {
			return new JunCalendarDateAndTimeDialogViewAwt(this);
		} else {
			return new JunCalendarDateAndTimeDialogViewSwing(this);
		}
	}

	/**
	 * Answer a window title.
	 *
	 * @return java.lang.String
	 * @category interface opening
	 */
	protected String windowTitle() {
		return JunSystem.$String("Date and Time Dialog");
	}
}
