package jp.co.sra.jun.goodies.button;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;

import jp.co.sra.smalltalk.DependentEvent;
import jp.co.sra.smalltalk.StController;
import jp.co.sra.smalltalk.StDisplayable;

import jp.co.sra.jun.system.framework.JunAbstractViewCanvas;

/**
 * JunButtonViewAwt class
 * 
 *  @author    He Weijie
 *  @created   1998/08/27 (by He Weijie)
 *  @updated   1999/11/12 (by MATSUDA Ryouichi)
 *  @updated   2002/11/21 (by nisinaka)
 *  @updated   2003/03/24 (by nisinaka)
 *  @updated   2004/09/21 (by nisinaka)
 *  @version   699 (with StPL8.9) based on Jun519 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunButtonViewAwt.java,v 8.10 2008/02/20 06:31:11 nisinaka Exp $
 */
public class JunButtonViewAwt extends JunAbstractViewCanvas implements JunButtonView {

	/**
	 * Create a new instance of JunButtonViewAwt.
	 * 
	 * @category Instance creation
	 */
	public JunButtonViewAwt() {
		super();
	}

	/**
	 * Create a new instance of JunButtonViewAwt and initialize it.
	 * 
	 * @param aButtonModel jp.co.sra.jun.goodies.button.JunButtonModel
	 * @category Instance creation
	 */
	public JunButtonViewAwt(JunButtonModel aButtonModel) {
		super(aButtonModel);
	}

	/**
	 * Create a new instance of JunButtonViewAwt and initialize it.
	 *
	 * @param aButtonModel jp.co.sra.jun.goodies.button.JunButtonModel
	 * @param aDimension java.awt.Dimension
	 * @category Instance creation
	 */
	public JunButtonViewAwt(JunButtonModel aButtonModel, Dimension aDimension) {
		super(aButtonModel);
		this.setSize(aDimension);
	}

	/**
	 * Build this component.
	 * 
	 * @see jp.co.sra.smalltalk.StViewCanvas#buildComponent()
	 * @category initialize-release
	 */
	protected void buildComponent() {
		this.setSize(100, 100);
	}

	/**
	 * Answer my model as JunButtonModel.
	 * 
	 * @return jp.co.sra.jun.goodies.button.JunButtonModel
	 * @category model accessing
	 */
	public JunButtonModel getButtonModel() {
		return (JunButtonModel) this.model();
	}

	/**
	 * Answer my default controller
	 * 
	 * @return jp.co.sra.smalltalk.StController
	 * @category controller accessing
	 */
	protected StController defaultController() {
		return new JunButtonController();
	}

	/**
	 * Display the receiver on the graphics.
	 * 
	 * @param aGraphics java.awt.Graphics
	 * @category displaying
	 */
	public void displayOn_(Graphics aGraphics) {
		if (this.isShowing() == false) {
			return;
		}

		if (this.getButtonModel().value() == true) {
			this.displayTrueOn_(aGraphics);
		} else {
			this.displayFalseOn_(aGraphics);
		}
	}

	/**
	 * Update the view when the value of the model is true.
	 * 
	 * @param aGraphics java.awt.Graphics
	 * @category displaying
	 */
	public void displayTrueOn_(Graphics aGraphics) {
		Rectangle box = new Rectangle(0, 0, this.getSize().width, this.getSize().height);
		aGraphics.clipRect(box.x, box.y, box.width, box.height);
		aGraphics.setColor(Gray30);
		aGraphics.fillRect(box.x, box.y, box.width, box.height);

		aGraphics.setColor(Color.black);
		StDisplayable visual = this.getButtonModel().visual();
		Rectangle bounds = visual.bounds();
		visual.displayOn_at_(aGraphics, new Point((box.width - bounds.width) / 2, (box.height - bounds.height) / 2));

		aGraphics.setColor(Gray20);
		aGraphics.drawLine(box.x, box.y, (box.x + box.width) - 1, box.y);
		aGraphics.drawLine(box.x, box.y, box.x, (box.y + box.height) - 1);
		aGraphics.setColor(Gray80);
		aGraphics.drawLine(box.x, (box.y + box.height) - 1, (box.x + box.width) - 1, (box.y + box.height) - 1);
		aGraphics.drawLine((box.x + box.width) - 1, box.y, (box.x + box.width) - 1, (box.y + box.height) - 1);

		if (this.getButtonModel().isActive() == false) {
			aGraphics.setColor(Gray90);
			Dimension extent = this.getSize();
			for (int y = 0; y < extent.height; y++) {
				for (int x = 0; x < extent.width; x++) {
					if ((x + y) % 2 == 1) {
						aGraphics.drawRect(x, y, 0, 0);
					}
				}
			}
		}
	}

	/**
	 * Update the view when the value of the model is false.
	 * 
	 * @param aGraphics java.awt.Graphics
	 * @category displaying
	 */
	public void displayFalseOn_(Graphics aGraphics) {
		Rectangle box = new Rectangle(0, 0, this.getSize().width, this.getSize().height);
		aGraphics.clipRect(box.x, box.y, box.width, box.height);
		aGraphics.setColor(Gray70);
		aGraphics.fillRect(box.x, box.y, box.width, box.height);

		aGraphics.setColor(Color.black);
		StDisplayable visual = this.getButtonModel().visual();
		Rectangle bounds = visual.bounds();
		visual.displayOn_at_(aGraphics, new Point((box.width - bounds.width) / 2, (box.height - bounds.height) / 2));

		aGraphics.setColor(Gray80);
		aGraphics.drawLine(box.x, box.y, (box.x + box.width) - 1, box.y);
		aGraphics.drawLine(box.x, box.y, box.x, (box.y + box.height) - 1);
		aGraphics.setColor(Gray20);
		aGraphics.drawLine(box.x, (box.y + box.height) - 1, (box.x + box.width) - 1, (box.y + box.height) - 1);
		aGraphics.drawLine((box.x + box.width) - 1, box.y, (box.x + box.width) - 1, (box.y + box.height) - 1);

		if (this.getButtonModel().isActive() == false) {
			aGraphics.setColor(Gray90);
			Dimension extent = this.getSize();
			for (int y = 0; y < extent.height; y++) {
				for (int x = 0; x < extent.width; x++) {
					if ((x + y) % 2 == 1) {
						aGraphics.drawRect(x, y, 0, 0);
					}
				}
			}
		}
	}

	/**
	 * Update the receiver according to the change notification from the model.
	 * 
	 * @param evt jp.co.sra.smalltalk.DependentEvent
	 * @category updating
	 */
	public void update_(DependentEvent evt) {
		if (this.isShowing() == false) {
			return;
		}

		if (evt.getAspect() == $("visual")) {
			this.repaint();
			return;
		}
		super.update_(evt);
	}

}
