package jp.co.sra.jun.goodies.animation;

import java.awt.Color;
import java.awt.Rectangle;

import jp.co.sra.jun.system.framework.JunAbstractView;

/**
 * JunCartoonMovieView interface
 * 
 *  @author    Nobuto Matsubara
 *  @created   2004/02/05 (By Nobuto Matsubara)
 *  @updated   2004/09/21 (by nisinaka)
 *  @updated   2007/11/05 (by nisinaka)
 *  @version   699 (with StPL8.9) based on Jun519 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunCartoonMovieView.java,v 8.11 2008/02/20 06:31:11 nisinaka Exp $
 */
public interface JunCartoonMovieView extends JunAbstractView {

	/**
	 * Answer my model as JunCartoonMovie.
	 * 
	 * @return jp.co.sra.jun.goodies.animation.JunCartoonMovie
	 * @category model accessing
	 */
	public JunCartoonMovie getCartoonMovie();

	/**
	 * Answer bounds.
	 * 
	 * @return java.awt.Rectangle
	 */
	public Rectangle getBounds();

	/**
	 * Answer background color.
	 * 
	 * @return java.awt.Color
	 */
	public Color backgroundColor();

}
