package jp.co.sra.jun.geometry.surfaces;

import jp.co.sra.jun.geometry.basic.Jun3dPoint;

/**
 * Jun3dPolygonTestExamples class
 * 
 *  @author    nisinaka
 *  @created   1998/12/02 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: Jun3dPolygonTestExamples.java,v 8.10 2008/02/20 06:30:58 nisinaka Exp $
 */
public class Jun3dPolygonTestExamples extends jp.co.sra.jun.system.support.JunTestExamples {

	/**
	 * Execute all examples.
	 * 
	 * @param args java.lang.String[]
	 * @category Main
	 */
	public static void main(String[] args) {
		new Jun3dPolygonTestExamples();
	}

	/**
	 * Test case of the method "containsPoint_()".
	 * 
	 * @return boolean
	 * @category Testing
	 */
	public static boolean Test1() {
		Jun3dPoint[] points = new Jun3dPoint[6];
		points[0] = new Jun3dPoint(0, 0, 0);
		points[1] = new Jun3dPoint(1, 0, 0);
		points[2] = new Jun3dPoint(1, 0, 0);
		points[3] = new Jun3dPoint(2, 0, 0);
		points[4] = new Jun3dPoint(2, 2, 0);
		points[5] = new Jun3dPoint(0, 2, 0);

		Jun3dPolygon polygon = Jun3dPolygon.Vertexes_(points);

		return polygon.containsPoint_(new Jun3dPoint(1, 1, 0)) == true;
	}

	/**
	 * Test case of the method "containsPoint_()".
	 * 
	 * @return boolean
	 * @category Testing
	 */
	public static boolean Test2() {
		Jun3dPoint[] points = new Jun3dPoint[8];
		points[0] = new Jun3dPoint(0, 0, 0);
		points[1] = new Jun3dPoint(3, 0, 0);
		points[2] = new Jun3dPoint(3, 2, 0);
		points[3] = new Jun3dPoint(2, 2, 0);
		points[4] = new Jun3dPoint(2, 1, 0);
		points[5] = new Jun3dPoint(1, 1, 0);
		points[6] = new Jun3dPoint(1, 2, 0);
		points[7] = new Jun3dPoint(0, 2, 0);

		Jun3dPolygon polygon = Jun3dPolygon.Vertexes_(points);

		return polygon.containsPoint_(new Jun3dPoint(1.5, 2, 0)) == false;
	}

	/**
	 * Test case of the method "nearestPointFromPoint_()".
	 * 
	 * @return boolean
	 * @category Testing
	 */
	public static boolean Test3() {
		Jun3dPoint[] points = new Jun3dPoint[3];
		points[0] = new Jun3dPoint(0.5, 0, 1);
		points[1] = new Jun3dPoint(0, 0, 1);
		points[2] = new Jun3dPoint(0, 0.5, 1);

		Jun3dPolygon polygon = Jun3dPolygon.Vertexes_(points);
		Jun3dPoint nearestPoint = polygon.nearestPointFromPoint_(new Jun3dPoint(0, 1, 0.5));

		return (Math.abs(nearestPoint.x()) < Jun3dPolygon.ACCURACY) && (nearestPoint.y() == 0.5) && (nearestPoint.z() == 1);
	}

	/**
	 * Test case of the method "asArrayOfTriangles()".
	 * 
	 * @return boolean
	 * @category Testing
	 */
	public static boolean Test4() {
		Jun3dPoint[] points = new Jun3dPoint[4];
		points[0] = new Jun3dPoint(0, 0, 0);
		points[1] = new Jun3dPoint(1, 0, 0);
		points[2] = new Jun3dPoint(1, 1, 0);
		points[3] = new Jun3dPoint(0, 1, 0);

		Jun3dPolygon polygon = Jun3dPolygon.Vertexes_(points);
		Jun3dPolygon[] triangles = polygon.asArrayOfTrianglePolygons();

		if (triangles.length != 2) {
			return false;
		}

		System.out.println(triangles[0].printString());
		System.out.println(triangles[1].printString());

		return true;
	}

	/**
	 * Test case of the method "asArrayOfConvexPolygons()".
	 * 
	 * @return boolean
	 * @category Testing
	 */
	public static boolean Test5() {
		Jun3dPoint[] points = new Jun3dPoint[4];
		points[0] = new Jun3dPoint(0, 0, 0);
		points[1] = new Jun3dPoint(1, 0, -1);
		points[2] = new Jun3dPoint(1, 1, 0);
		points[3] = new Jun3dPoint(0, 1, -1);

		Jun3dPolygon polygon = Jun3dPolygon.Vertexes_(points);
		Jun3dPolygon[] triangles = polygon.asArrayOfTrianglePolygons();

		if (triangles.length != 2) {
			return false;
		}

		System.out.println(triangles[0].printString());
		System.out.println(triangles[1].printString());

		return true;
	}

	/**
	 * Test case of the method "isConvex()".
	 * 
	 * @return boolean
	 * @category Testing
	 */
	public static boolean Test6() {
		Jun3dPoint[] points = new Jun3dPoint[8];
		points[0] = new Jun3dPoint(0, 0, 0);
		points[1] = new Jun3dPoint(3, 0, 0);
		points[2] = new Jun3dPoint(3, 2, 0);
		points[3] = new Jun3dPoint(2, 2, 0);
		points[4] = new Jun3dPoint(2, 1, 0);
		points[5] = new Jun3dPoint(1, 1, 0);
		points[6] = new Jun3dPoint(1, 2, 0);
		points[7] = new Jun3dPoint(0, 2, 0);

		Jun3dPolygon polygon = Jun3dPolygon.Vertexes_(points);

		return polygon.isConvex() == false;
	}

	/**
	 * Test case of the method "isConvex()".
	 * 
	 * @return boolean
	 * @category Testing
	 */
	public static boolean Test7() {
		Jun3dPoint[] points = new Jun3dPoint[8];
		points[0] = new Jun3dPoint(0, 0, 0);
		points[1] = new Jun3dPoint(3, 0, 0);
		points[2] = new Jun3dPoint(3, 2, 0);
		points[3] = new Jun3dPoint(2, 2, 0);
		points[4] = new Jun3dPoint(2, 1, 0);
		points[5] = new Jun3dPoint(1, 1, 0);
		points[6] = new Jun3dPoint(1, 2, 0);
		points[7] = new Jun3dPoint(0, 2, 0);

		Jun3dPolygon polygon = Jun3dPolygon.Vertexes_(points);
		polygon.asJunOpenGL3dObject().show();

		return polygon.isConvex() == false;
	}
}
