package jp.co.sra.jun.geometry.support;

import jp.co.sra.jun.system.framework.JunAbstractObject;

/**
 * JunBSplineFunction class
 * 
 *  @author    nisinaka
 *  @created   2004/11/16 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunBSplineFunction.java,v 8.12 2008/02/20 06:30:58 nisinaka Exp $
 */
public class JunBSplineFunction extends JunAbstractObject {

	protected double[] knotVector;
	protected int order;

	/**
	 * Create a new instance of JunBSplineFunction and initialize it.
	 * 
	 * @category Instance creation
	 */
	public JunBSplineFunction(double[] knotVector, int order) {
		super();
		this.setKnotVector_order_(knotVector, order);
	}

	/**
	 * Answer a value specified with I & T.
	 * 
	 * @param i int
	 * @param t double
	 * @return double
	 * @category accessing
	 */
	public double i_t_(int i, double t) {
		double n = this.i_k_t_(i, order - 1, t * (this.maxT() - this.minT()) + this.minT());
		if (Double.isNaN(n)) {
			return (i == knotVector.length - order - 1) ? 1 : 0;
		}
		return n;
	}

	/**
	 * Answer the reversed JunBSplineFunction.
	 * 
	 * @return jp.co.sra.jun.geometry.support.JunBSplineFunction
	 * @category converting
	 */
	public JunBSplineFunction reversed() {
		int size = knotVector.length;
		double last = knotVector[size - 1];
		double[] reversedKnotVector = new double[size];
		for (int i = 0; i < knotVector.length; i++) {
			reversedKnotVector[i] = last - knotVector[size - 1 - i];
		}
		return new JunBSplineFunction(reversedKnotVector, order);
	}

	/**
	 * Set my attributes.
	 * 
	 * @param knotVector double[]
	 * @param order int
	 * @category private
	 */
	protected void setKnotVector_order_(double[] knotVector, int order) {
		this.knotVector = knotVector;
		this.order = order;
	}

	/**
	 * Answer a value specified with I & K & T.
	 * 
	 * @param i int
	 * @param k int
	 * @param t double
	 * @return double
	 * @category private
	 */
	protected double i_k_t_(int i, int k, double t) {
		if (k == 0) {
			return (knotVector[i] <= t && t < knotVector[i + 1]) ? 1 : Double.NaN;
		}

		double n1 = this.i_k_t_(i, k - 1, t);
		double f1 = Double.isNaN(n1) ? Double.NaN : (t - knotVector[i]) * n1 / (knotVector[i + k] - knotVector[i]);
		double n2 = this.i_k_t_(i + 1, k - 1, t);
		double f2 = Double.isNaN(n2) ? Double.NaN : (knotVector[i + k + 1] - t) * n2 / (knotVector[i + k + 1] - knotVector[i + 1]);

		if (Double.isNaN(f1)) {
			return f2;
		} else if (Double.isNaN(f2)) {
			return f1;
		}

		return f1 + f2;
	}

	/**
	 * Answer the maximum value of T.
	 * 
	 * @return double
	 * @category private
	 */
	protected double maxT() {
		return knotVector[knotVector.length - order];
	}

	/**
	 * Answer the minimum value of T.
	 * 
	 * @return double
	 * @category private
	 */
	protected double minT() {
		return knotVector[order - 1];
	}

}
