package jp.co.sra.jun.geometry.pluralities;

import java.awt.Rectangle;

import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.surfaces.Jun3dTriangle;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dCompoundObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;
import jp.co.sra.jun.system.support.JunTestExamples;

/**
 * Jun3dTrianglesTestExamples class
 * 
 *  @author    Mitsuhiro Asada
 *  @created   2007/06/05 (by m-asada)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun667 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: Jun3dTrianglesTestExamples.java,v 8.5 2008/02/20 06:30:57 nisinaka Exp $
 */
public class Jun3dTrianglesTestExamples extends JunTestExamples {
	/**
	 * Example1:
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example1() {
		Jun3dTriangle triangle = new Jun3dPoint(0 , 0 , 1).triangle_and_(new Jun3dPoint(1 , 0 , 0), new Jun3dPoint(0 , 1 , 0));
		Jun3dTriangles triangles = triangle.asTriangles();
		System.out.println(triangles.printString());

		return true;
	}

	/**
	 * Example2:
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example2() {
		Jun3dTriangle triangle = new Jun3dPoint(0 , 0 , 1).triangle_and_(new Jun3dPoint(1 , 0 , 0), new Jun3dPoint(0 , 1 , 0));
		Jun3dTriangles triangles = triangle.asTriangles().subdivideLevel_(4);
		JunOpenGL3dCompoundObject compoundObect = triangles.asJunOpenGL3dObject().asCompoundObject();
		compoundObect.add_(JunOpenGL3dObject.XyzArrows());
		compoundObect.showIn_(new Rectangle(200, 250, 400, 400)).wireframePresentation();

		return true;
	}

	/**
	 * Execute all examples.
	 * 
	 * @param args java.lang.String[]
	 * @category Main
	 */
	public static void main(String[] args) {
		new Jun3dTrianglesTestExamples();
	}
}
