package jp.co.sra.jun.geometry.pluralities;

import java.awt.Color;

import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.boundaries.Jun3dBoundingBall;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dCompoundObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;
import jp.co.sra.jun.system.support.JunTestExamples;

/**
 * Jun3dBoundingBallsTestExamples class
 * 
 *  @author    Mitsuhiro Asada
 *  @created   2007/05/30 (by m-asada)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun667 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: Jun3dBoundingBallsTestExamples.java,v 8.5 2008/02/20 06:30:57 nisinaka Exp $
 */
public class Jun3dBoundingBallsTestExamples extends JunTestExamples {
	/**
	 * Example1:
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example1() {
		Jun3dBoundingBall boundingBall = new Jun3dPoint(0, 0, 0).ball_(2);
		Jun3dBoundingBoxes detailedBoundingBoxes = boundingBall.detailedBoundingBoxes();
		Jun3dBoundingBalls detailedBoundingBalls = boundingBall.detailedBoundingBalls();

		JunOpenGL3dCompoundObject compoundObject = new JunOpenGL3dCompoundObject();
		compoundObject.add_(boundingBall.asJunOpenGL3dObjectColor_alpha_(Color.cyan, 0.5f));
		compoundObject.add_(detailedBoundingBoxes.asJunOpenGL3dObjectColor_alpha_(Color.magenta, 0.25f));
		compoundObject.add_(detailedBoundingBalls.asJunOpenGL3dObjectColor_alpha_(Color.yellow, 0.25f));
		compoundObject.add_(JunOpenGL3dObject.Axes().scaledBy_(4));
		compoundObject.show().selectAll();

		return true;
	}

	/**
	 * Execute all examples.
	 * 
	 * @param args java.lang.String[]
	 * @category Main
	 */
	public static void main(String[] args) {
		new Jun3dBoundingBallsTestExamples();
	}
}
