package jp.co.sra.jun.geometry.pluralities;

import jp.co.sra.smalltalk.StBlockClosure;

import jp.co.sra.jun.geometry.boundaries.Jun3dBoundingBall;
import jp.co.sra.jun.geometry.boundaries.Jun3dBoundingBox;
import jp.co.sra.jun.geometry.boundaries.JunBoundingObject;
import jp.co.sra.jun.geometry.transformations.Jun3dTransformation;

/**
 * Jun3dBoundingBalls class
 * 
 *  @author    Mitsuhiro Asada
 *  @created   2007/05/30 (by m-asada)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun697 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: Jun3dBoundingBalls.java,v 8.8 2008/02/20 06:30:57 nisinaka Exp $
 */
public class Jun3dBoundingBalls extends JunBoundingBalls {
	/**
	 * Create a new instance of <code>Jun3dBoundingBalls</code> and initialize it.
	 * 
	 * @category Instance creation
	 */
	public Jun3dBoundingBalls() {
		super();
	}

	/**
	 * Answer my current bounding ball.
	 * 
	 * @return jp.co.sra.jun.geometry.boundaries.Jun3dBoundingBall
	 * @category accessing
	 */
	public Jun3dBoundingBall boundingBall() {
		if (this.isEmpty()) {
			return new Jun3dBoundingBall(null);
		}
		Jun3dBoundingBall boundingBall = null;
		JunBoundingObject[] objects = this.boundingObjects();
		for (int i = 0; i < objects.length; i++) {
			Jun3dBoundingBall each = (Jun3dBoundingBall) objects[i];
			if (boundingBall == null) {
				boundingBall = each.boundingBall();
			} else {
				boundingBall = each.boundingBall().merge_(boundingBall);
			}
		}
		return boundingBall;
	}

	/**
	 * Answer my bounding balls.
	 * 
	 * @return jp.co.sra.jun.geometry.boundaries.Jun3dBoundingBall[]
	 * @category accessing
	 */
	public Jun3dBoundingBall[] boundingBalls() {
		return (Jun3dBoundingBall[]) this._boundingObjects().toArray(new Jun3dBoundingBall[this._boundingObjects().size()]);
	}

	/**
	 * Answer my current bounding box.
	 * 
	 * @return jp.co.sra.jun.geometry.boundaries.Jun3dBoundingBox
	 * @category accessing
	 */
	public Jun3dBoundingBox boundingBox() {
		if (this.isEmpty()) {
			return new Jun3dBoundingBox();
		}
		Jun3dBoundingBox boundingBox = null;
		JunBoundingObject[] objects = this.boundingObjects();
		for (int i = 0; i < objects.length; i++) {
			Jun3dBoundingBall each = (Jun3dBoundingBall) objects[i];
			if (boundingBox == null) {
				boundingBox = each.boundingBox();
			} else {
				boundingBox = each.boundingBox().merge_(boundingBox);
			}
		}
		return boundingBox;
	}

	/**
	 * Convert to a <code>Jun2dBoundingBall</code>.
	 * 
	 * @return jp.co.sra.jun.geometry.boundaries.Jun3dBoundingBall
	 * @category converting
	 */
	public Jun3dBoundingBall asBoundingBall() {
		return this.boundingBall();
	}

	/**
	 * Convert to a <code>Jun2dBoundingBox</code>.
	 * 
	 * @return jp.co.sra.jun.geometry.boundaries.Jun3dBoundingBox
	 * @category converting
	 */
	public Jun3dBoundingBox asBoundingBox() {
		return this.boundingBox();
	}

	/**
	 * Answer <code>true</code> if the receiver is a 3d geometry element.
	 * 
	 * @return boolean
	 * @see jp.co.sra.jun.geometry.abstracts.JunGeometry#is3d()
	 * @category testing
	 */
	public boolean is3d() {
		return true;
	}

	/**
	 * Answer <code>true</code> if the receiver touches the specified bounding object, otherwise <code>false</code>.
	 * 
	 * @param aBoundingObject jp.co.sra.jun.geometry.boundaries.Jun3dBoundingBall
	 * @return boolean
	 * @category testing
	 */
	public boolean touches_(final Jun3dBoundingBall aBoundingObject) {
		return this.detect_ifNone_(new StBlockClosure() {
			public Object value(Object each) {
				return new Boolean(((Jun3dBoundingBall) each).touches_(aBoundingObject));
			}
		}, new StBlockClosure() {
			public Object value(Object each) {
				return null;
			}
		}) != null;
	}

	/**
	 * Apply a transformation 'aTransformation' to the receiver.
	 * 
	 * @return jp.co.sra.jun.geometry.pluralities.Jun3dBoundingBalls
	 * @param aTransformation jp.co.sra.jun.geometry.transformations.Jun3dTransformation
	 * @category transforming
	 */
	public Jun3dBoundingBalls transform_(Jun3dTransformation aTransformation) {
		Jun3dBoundingBalls transformedCopy = new Jun3dBoundingBalls();
		JunBoundingObject[] boundingBalls = this.boundingBalls();
		for (int i = 0; i < boundingBalls.length; i++) {
			this.add_(boundingBalls[i].transform_(aTransformation));
		}
		return transformedCopy;
	}
}
