package jp.co.sra.jun.geometry.forms;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;

import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StImage;
import jp.co.sra.smalltalk.StValueHolder;

import jp.co.sra.jun.geometry.basic.Jun2dPoint;
import jp.co.sra.jun.geometry.surfaces.Jun2dTriangle;
import jp.co.sra.jun.goodies.image.framework.JunImageDisplayModel;
import jp.co.sra.jun.goodies.movie.support.JunImagesToMovie;
import jp.co.sra.jun.goodies.utilities.JunControlUtility;
import jp.co.sra.jun.goodies.utilities.JunImageUtility;
import jp.co.sra.jun.goodies.utilities.JunSensorUtility;
import jp.co.sra.jun.system.framework.JunDialog;

/**
 * JunFormTriangulation1TestExamples class
 * 
 *  @author    nisinaka
 *  @created   2007/06/19 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun632 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunFormTriangulation1TestExamples.java,v 8.6 2008/02/20 06:30:57 nisinaka Exp $
 */
public class JunFormTriangulation1TestExamples extends JunForm2dRegionTestExamples {

	protected static DecimalFormat EightDigitsDecimalFormat = new DecimalFormat("00000000");
	protected static DecimalFormat TwoDigitsDecimalFormat = new DecimalFormat("00");

	/**
	 * Example1: 
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example1() {
		ArrayList aList = new ArrayList();
		Point aPoint = new Point(100, 100);
		Jun2dPoint[][] polylines = ExamplePolylines();
		for (int index = 0; index < polylines.length; index++) {
			final JunFormTriangulation1 formTriangulation = new JunFormTriangulation1(polylines[index]);

			Point extentPoint = formTriangulation.boundingBox().extent()._toPoint();
			BufferedImage aBufferedImage = JunImageUtility.ImageExtent_displayBlock_(new Dimension(extentPoint.x, extentPoint.y), new StBlockClosure() {
				public Object value_(Object anObject) {
					Graphics2D aGraphics = (Graphics2D) anObject;
					formTriangulation.displayOn_(aGraphics);
					return null;
				}
			});
			StImage anImage = new StImage(aBufferedImage);

			JunImageDisplayModel aModel = JunImageDisplayModel.Show_at_(anImage, aPoint);
			aList.add(aModel);
			aModel.closeTogether_(aList);

			aPoint.translate(20, 20);
		}

		return true;
	}

	/**
	 * Example2: 
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example2() {
		ArrayList aList = new ArrayList();
		Point aPoint = new Point(100, 100);
		Jun2dPoint[][] polylines = ExamplePolylines();
		for (int index = 0; index < polylines.length; index++) {
			final JunFormTriangulation1 formTriangulation = new JunFormTriangulation1(polylines[index]);

			Point extentPoint = formTriangulation.boundingBox().extent()._toPoint();
			final Dimension extent = new Dimension(extentPoint.x, extentPoint.y);
			final JunImageDisplayModel aModel = JunImageDisplayModel.Show_label_at_(new StImage(extent), "Triangulation 1 (" + extent.width + "x" + extent.height + ")", aPoint);
			aList.add(aModel);
			aModel.closeTogether_(aList);

			formTriangulation.trianglesInterim_(new StBlockClosure() {
				public Object value_value_value_(Object o1, Object o2, Object o3) {
					final Jun2dTriangle[] triangles = (Jun2dTriangle[]) o1;
					final Jun2dTriangle[] insides = (Jun2dTriangle[]) o2;
					final Jun2dTriangle[] outsides = (Jun2dTriangle[]) o3;

					JunControlUtility.Do_framesPerSecond_(new StBlockClosure() {
						public Object value() {
							BufferedImage anImage = JunImageUtility.ImageExtent_displayBlock_(extent, new StBlockClosure() {
								public Object value_(Object anObject) {
									Graphics2D aGraphics = (Graphics2D) anObject;
									formTriangulation.displayOn_triangles_insides_outsides_(aGraphics, triangles, insides, outsides);
									return null;
								}
							});
							aModel.image_(anImage);
							aModel.redisplay();

							return null;
						}
					}, (JunSensorUtility.AnyButtonPressed() || JunSensorUtility.AltDown() || JunSensorUtility.CtrlDown()) ? 0 : 15);

					return null;
				}
			});

			BufferedImage anImage = JunImageUtility.ImageExtent_displayBlock_(extent, new StBlockClosure() {
				public Object value_(Object anObject) {
					Graphics2D aGraphics = (Graphics2D) anObject;
					formTriangulation.displayOn_(aGraphics);
					return null;
				}
			});
			aModel.image_(anImage);
			aModel.redisplay();

			aPoint.translate(20, 20);
		}

		return true;
	}

	/**
	 * Example3: 
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example3() {
		if (JunDialog.Confirm_($String("Do you want to create all JPEG files for animation?"), false) == false) {
			return false;
		}

		ArrayList aList = new ArrayList();
		int prefixNumber = 100000;
		final StValueHolder indexHolder = new StValueHolder(1 + prefixNumber);
		Point aPoint = new Point(100, 100);
		Jun2dPoint[][] polylines = ExamplePolylines();
		for (int i = 0; i < polylines.length; i++) {
			final JunFormTriangulation1 formTriangulation = new JunFormTriangulation1(polylines[i]);

			Point extentPoint = formTriangulation.boundingBox().extent()._toPoint();
			final Dimension extent = new Dimension(extentPoint.x, extentPoint.y);
			final JunImageDisplayModel aModel = JunImageDisplayModel.Show_label_at_(new StImage(extent), "Triangulation 1 (" + extent.width + "x" + extent.height + ")", aPoint);
			aList.add(aModel);
			aModel.closeTogether_(aList);

			formTriangulation.trianglesInterim_(new StBlockClosure() {
				public Object value_value_value_(Object o1, Object o2, Object o3) {
					final Jun2dTriangle[] triangles = (Jun2dTriangle[]) o1;
					final Jun2dTriangle[] insides = (Jun2dTriangle[]) o2;
					final Jun2dTriangle[] outsides = (Jun2dTriangle[]) o3;

					BufferedImage anImage = JunImageUtility.ImageExtent_displayBlock_(extent, new StBlockClosure() {
						public Object value_(Object anObject) {
							Graphics2D aGraphics = (Graphics2D) anObject;
							formTriangulation.displayOn_triangles_insides_outsides_(aGraphics, triangles, insides, outsides);
							return null;
						}
					});
					aModel.image_(anImage);
					aModel.redisplay();

					int index = indexHolder._intValue();
					String aString = EightDigitsDecimalFormat.format(index);
					try {
						JunImageUtility.WriteImage_to_(anImage, new File(aString + ".jpg"));
					} catch (IOException e) {
						e.printStackTrace();
					}
					indexHolder.value_(index + 1);

					return null;
				}
			});

			BufferedImage anImage = JunImageUtility.ImageExtent_displayBlock_(extent, new StBlockClosure() {
				public Object value_(Object anObject) {
					Graphics2D aGraphics = (Graphics2D) anObject;
					formTriangulation.displayOn_(aGraphics);
					return null;
				}
			});
			aModel.image_(anImage);
			aModel.redisplay();

			int index = indexHolder._intValue();
			String aString = EightDigitsDecimalFormat.format(index);
			try {
				JunImageUtility.WriteImage_to_(anImage, new File(aString + ".jpg"));
			} catch (IOException e) {
				e.printStackTrace();
			}
			indexHolder.value_(1 + (index + prefixNumber) / prefixNumber * prefixNumber);

			aPoint.translate(20, 20);
		}

		return true;
	}

	/**
	 * Example4: 
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example4() {
		if (JunDialog.Confirm_($String("Do you want to create a movie file for animation?"), false) == false) {
			return false;
		}

		ArrayList aList = new ArrayList();
		Point aPoint = new Point(100, 100);
		Jun2dPoint[][] polylines = ExamplePolylines();
		for (int i = 0; i < polylines.length; i++) {
			final JunFormTriangulation1 formTriangulation = new JunFormTriangulation1(polylines[i]);

			Point extentPoint = formTriangulation.boundingBox().extent()._toPoint();
			final Dimension extent = new Dimension(extentPoint.x, extentPoint.y);
			final JunImageDisplayModel aModel = JunImageDisplayModel.Show_label_at_(new StImage(extent), "Triangulation 1 (" + extent.width + "x" + extent.height + ")", aPoint);
			aList.add(aModel);
			aModel.closeTogether_(aList);

			final int tick = 50;
			String aString = TwoDigitsDecimalFormat.format(i + 1);
			aString = "Triangulation_1_" + aString;
			File aFile = new File(aString + ".mov");
			JunImagesToMovie.File_extent_do_(aFile, extent, new StBlockClosure() {
				public Object value_(Object anObject) {
					final JunImagesToMovie imagesToMovie = (JunImagesToMovie) anObject;

					formTriangulation.trianglesInterim_(new StBlockClosure() {
						public Object value_value_value_(Object o1, Object o2, Object o3) {
							final Jun2dTriangle[] triangles = (Jun2dTriangle[]) o1;
							final Jun2dTriangle[] insides = (Jun2dTriangle[]) o2;
							final Jun2dTriangle[] outsides = (Jun2dTriangle[]) o3;

							BufferedImage anImage = JunImageUtility.ImageExtent_displayBlock_(extent, new StBlockClosure() {
								public Object value_(Object anObject) {
									Graphics2D aGraphics = (Graphics2D) anObject;
									formTriangulation.displayOn_triangles_insides_outsides_(aGraphics, triangles, insides, outsides);
									return null;
								}
							});
							aModel.image_(anImage);
							aModel.redisplay();

							imagesToMovie.add_milliseconds_(new StImage(anImage), tick);

							return null;
						}
					});

					BufferedImage anImage = JunImageUtility.ImageExtent_displayBlock_(extent, new StBlockClosure() {
						public Object value_(Object anObject) {
							Graphics2D aGraphics = (Graphics2D) anObject;
							formTriangulation.displayOn_(aGraphics);
							return null;
						}
					});
					aModel.image_(anImage);
					aModel.redisplay();

					imagesToMovie.add_milliseconds_(new StImage(anImage), tick);

					return null;
				}
			});

			aPoint.translate(20, 20);
		}

		return true;
	}

	/**
	 * Answer the example polylines.
	 * 
	 * @return jp.co.sra.jun.geometry.basic.Jun2dPoint[]
	 * @category Examples
	 */
	protected static Jun2dPoint[][] ExamplePolylines() {
		Jun2dPoint[][] polylines = ExampleOriginalPolylines();
		return new Jun2dPoint[][] { polylines[3], polylines[9] };
	}

	/**
	 * Execute all examples.
	 * 
	 * @param args an array of command-line arguments
	 * @category Main
	 */
	public static void main(java.lang.String[] args) {
		new JunFormTriangulation1TestExamples();
	}

}
