package jp.co.sra.jun.geometry.forms;

import jp.co.sra.jun.geometry.basic.Jun2dPoint;
import jp.co.sra.jun.geometry.surfaces.Jun2dTriangle;

/**
 * JunFormTriangleTerminal class
 * 
 *  @author    Mitsuhiro Asada
 *  @created   2007/06/15 (by m-asada)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun500 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunFormTriangleTerminal.java,v 8.5 2008/02/20 06:30:57 nisinaka Exp $
 */
public class JunFormTriangleTerminal extends JunFormTriangleNode {
	protected Jun2dPoint tp;

	/**
	 * Create a new instance of <code>JunFormTriangleTerminal</code> and initialize it.
	 * 
	 * @param aPoint1 jp.co.sra.jun.geometry.basic.Jun2dPoint
	 * @param aPoint2 jp.co.sra.jun.geometry.basic.Jun2dPoint
	 * @param aPoint3 jp.co.sra.jun.geometry.basic.Jun2dPoint
	 * @category Instance creation
	 */
	public JunFormTriangleTerminal(Jun2dPoint aPoint1, Jun2dPoint aPoint2, Jun2dPoint aPoint3) {
		super(aPoint1, aPoint2, aPoint3);
	}

	/**
	 * Create a new instance of <code>JunFormTriangleTerminal</code> and initialize it.
	 * 
	 * @param pointArray jp.co.sra.jun.geometry.basic.Jun2dPoint[]
	 * @category Instance creation
	 */
	public JunFormTriangleTerminal(Jun2dPoint[] pointArray) {
		super(pointArray);
	}

	/**
	 * Create a new instance of <code>JunFormTriangleTerminal</code> and initialize it.
	 * 
	 * @param pointArray jp.co.sra.jun.geometry.basic.Jun2dPoint[]
	 * @param spinePoints jp.co.sra.jun.geometry.basic.Jun2dPoint[]
	 * @category Instance creation
	 */
	public JunFormTriangleTerminal(Jun2dPoint[] pointArray, Jun2dPoint[] spinePoints) {
		super(pointArray, spinePoints);
	}

	/**
	 * Create a new instance of <code>JunFormTriangleTerminal</code> and initialize it.
	 * 
	 * @param aTriangle jp.co.sra.jun.geometry.surfaces.Jun2dTriangle
	 * @category Instance creation
	 */
	public JunFormTriangleTerminal(Jun2dTriangle aTriangle) {
		super(aTriangle);
	}

	/**
	 * Answer the receiver's terminal point.
	 * 
	 * @return jp.co.sra.jun.geometry.basic.Jun2dPoint
	 * @category accessing
	 */
	public Jun2dPoint tp() {
		if (tp == null) {
			if (this.sp1() != null) {
				tp = this.p3();
			}
			if (this.sp2() != null) {
				tp = this.p1();
			}
			if (this.sp3() != null) {
				tp = this.p2();
			}
		}
		return tp;
	}

	/**
	 * Answer <code>true</code> if the receiver is terminal, otherwise <code>false</code>
	 * 
	 * @return boolean
	 * @see jp.co.sra.jun.geometry.forms.JunFormTriangleNode#isTerminal()
	 * @category testing
	 */
	public boolean isTerminal() {
		return true;
	}
}
