package jp.co.sra.jun.geometry.forms;

import java.io.IOException;
import java.io.Writer;

import jp.co.sra.jun.geometry.basic.Jun2dPoint;
import jp.co.sra.jun.geometry.surfaces.Jun2dTriangle;
import jp.co.sra.jun.system.framework.JunAbstractObject;

/**
 * JunFormTriangle class
 * 
 *  @author    Mitsuhiro Asada
 *  @created   2007/06/14 (by m-asada)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun697 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunFormTriangle.java,v 8.6 2008/02/20 06:30:57 nisinaka Exp $
 */
public class JunFormTriangle extends JunAbstractObject {
	protected Jun2dPoint p1;
	protected Jun2dPoint p2;
	protected Jun2dPoint p3;

	/**
	 * Create a new instance of <code>JunFormTriangle</code> and initialize it.
	 * 
	 * @category Instance creation
	 */
	protected JunFormTriangle() {
		super();
	}

	/**
	 * Create a new instance of <code>JunFormTriangle</code> and initialize it.
	 * 
	 * @param aPoint1 jp.co.sra.jun.geometry.basic.Jun2dPoint
	 * @param aPoint2 jp.co.sra.jun.geometry.basic.Jun2dPoint
	 * @param aPoint3 jp.co.sra.jun.geometry.basic.Jun2dPoint
	 * @category Instance creation
	 */
	public JunFormTriangle(Jun2dPoint aPoint1, Jun2dPoint aPoint2, Jun2dPoint aPoint3) {
		this();
		this.setP1_(aPoint1);
		this.setP2_(aPoint2);
		this.setP3_(aPoint3);
	}

	/**
	 * Create a new instance of <code>JunFormTriangle</code> and initialize it.
	 * 
	 * @param pointArray jp.co.sra.jun.geometry.basic.Jun2dPoint[]
	 * @category Instance creation
	 */
	public JunFormTriangle(Jun2dPoint[] pointArray) {
		this(pointArray[0], pointArray[1], pointArray[2]);
	}

	/**
	 * Create a new instance of <code>JunFormTriangle</code> and initialize it.
	 * 
	 * @param aTriangle jp.co.sra.jun.geometry.surfaces.Jun2dTriangle
	 * @category Instance creation
	 */
	public JunFormTriangle(Jun2dTriangle aTriangle) {
		this(aTriangle.p1(), aTriangle.p2(), aTriangle.p3());
	}

	/**
	 * Answer the receiver's p1.
	 * 
	 * @return jp.co.sra.jun.geometry.basic.Jun2dPoint
	 * @category accessing
	 */
	public Jun2dPoint p1() {
		return p1;
	}

	/**
	 * Answer the receiver's p2.
	 * 
	 * @return jp.co.sra.jun.geometry.basic.Jun2dPoint
	 * @category accessing
	 */
	public Jun2dPoint p2() {
		return p2;
	}

	/**
	 * Answer the receiver's p3.
	 * 
	 * @return jp.co.sra.jun.geometry.basic.Jun2dPoint
	 * @category accessing
	 */
	public Jun2dPoint p3() {
		return p3;
	}

	/**
	 * Answer the receiver's points.
	 * 
	 * @return jp.co.sra.jun.geometry.basic.Jun2dPoint[]
	 * @category accessing
	 */
	public Jun2dPoint[] points() {
		return this.asPointArray();
	}

	/**
	 * Convert to an array of <code>JunPoint</code>.
	 * 
	 * @return jp.co.sra.jun.geometry.basic.Jun2dPoint[]
	 * @category converting
	 */
	public Jun2dPoint[] asPointArray() {
		return new Jun2dPoint[] { this.p1(), this.p2(), this.p3() };
	}

	/**
	 * Convert to an array of <code>JunPoint</code>.
	 * 
	 * @return jp.co.sra.jun.geometry.basic.Jun2dPoint[]
	 * @category converting
	 */
	public Jun2dPoint[] asPolyline() {
		return this.asPointArray();
	}

	/**
	 * Convert to an array of <code>JunPoint</code>.
	 * 
	 * @return jp.co.sra.jun.geometry.basic.Jun2dPoint[]
	 * @category converting
	 */
	public Jun2dPoint[] asPolylineLoop() {
		return new Jun2dPoint[] { this.p1(), this.p2(), this.p3(), this.p1() };
	}

	/**
	 * Print my string representation on aWriter.
	 * 
	 * @param aWriter java.io.Writer
	 * @throws java.io.IOException if failed.
	 * @see jp.co.sra.smalltalk.StObject#printOn_(java.io.Writer)
	 * @category printing
	 */
	public void printOn_(Writer aWriter) throws IOException {
		aWriter.write("triangle (");
		Jun2dPoint[] points = this.points();
		for (int i = 0; i < points.length; i++) {
			points[i].printOn_(aWriter);
			if (i < points.length - 1) {
				aWriter.write(", ");
			}
		}
		aWriter.write(")");
	}

	/**
	 * Set the receiver's p1.
	 * 
	 * @param aPoint jp.co.sra.jun.geometry.basic.Jun2dPoint
	 * @category private
	 */
	protected void setP1_(Jun2dPoint aPoint) {
		p1 = aPoint;
	}

	/**
	 * Set the receiver's p2.
	 * 
	 * @param aPoint jp.co.sra.jun.geometry.basic.Jun2dPoint
	 * @category private
	 */
	protected void setP2_(Jun2dPoint aPoint) {
		p2 = aPoint;
	}

	/**
	 * Set the receiver's p3.
	 * 
	 * @param aPoint jp.co.sra.jun.geometry.basic.Jun2dPoint
	 * @category private
	 */
	protected void setP3_(Jun2dPoint aPoint) {
		p3 = aPoint;
	}
}
