package jp.co.sra.jun.geometry.forms;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;

import jp.co.sra.smalltalk.StBlockClosure;

import jp.co.sra.jun.geometry.basic.Jun2dPoint;
import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.goodies.cursors.JunCursors;
import jp.co.sra.jun.goodies.image.framework.JunImageDisplayModel;
import jp.co.sra.jun.opengl.display.JunOpenGLDisplayModel;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dCompoundObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dPolygon;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dPolyline;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dVertex;

/**
 * JunFormCreationTestExamples class
 * 
 *  @author    Mitsuhiro Asada
 *  @created   2007/06/21 (by m-asada)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun668 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunFormCreationTestExamples.java,v 8.5 2008/02/20 06:30:57 nisinaka Exp $
 */
public class JunFormCreationTestExamples extends JunForm2dRegionTestExamples {
	/**
	 * Example1: Show polylines. 
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example1() {
		Point aPoint = new Point(100, 100);
		Jun2dPoint[][] polylines = ExamplePolylines();
		for (int index = 0; index < polylines.length; index++) {
			final JunFormCreation formCreation = new JunFormCreation(polylines[index]);

			Point extentPoint = formCreation.boundingBox().extent()._toPoint();
			BufferedImage aPixmap = new BufferedImage(extentPoint.x, extentPoint.y, BufferedImage.TYPE_INT_ARGB);
			Graphics graphicsContext = aPixmap.getGraphics();
			JunCursors cursor = new JunCursors(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));
			try {
				cursor._show();

				graphicsContext.setColor(Color.white);
				graphicsContext.fillRect(0, 0, aPixmap.getWidth(), aPixmap.getHeight());
				formCreation.points();
				formCreation.displayPolylineOn_(graphicsContext);
			} finally {
				if (graphicsContext != null) {
					graphicsContext.dispose();
					graphicsContext = null;
				}
				cursor._restore();
			}
			JunImageDisplayModel.Show_at_(aPixmap, aPoint);

			aPoint.translate(20, 20);
		}

		return true;
	}

	/**
	 * Example2: Show triangulated triangles.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example2() {
		Point aPoint = new Point(100, 100);
		Jun2dPoint[][] polylines = ExamplePolylines();
		for (int index = 0; index < polylines.length; index++) {
			final JunFormCreation formCreation = new JunFormCreation(polylines[index]);

			Point extentPoint = formCreation.boundingBox().extent()._toPoint();
			BufferedImage aPixmap = new BufferedImage(extentPoint.x, extentPoint.y, BufferedImage.TYPE_INT_ARGB);
			Graphics graphicsContext = aPixmap.getGraphics();
			JunCursors cursor = new JunCursors(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));
			try {
				cursor._show();

				graphicsContext.setColor(Color.white);
				graphicsContext.fillRect(0, 0, aPixmap.getWidth(), aPixmap.getHeight());
				formCreation.triangulatedTriangles();
				formCreation.displayTriangulatedTrianglesOn_(graphicsContext);
			} finally {
				if (graphicsContext != null) {
					graphicsContext.dispose();
					graphicsContext = null;
				}
				cursor._restore();
			}
			JunImageDisplayModel.Show_at_(aPixmap, aPoint);

			aPoint.translate(20, 20);
		}

		return true;
	}

	/**
	 * Example3: Show draft triangle nodes.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example3() {
		Point aPoint = new Point(100, 100);
		Jun2dPoint[][] polylines = ExamplePolylines();
		for (int index = 0; index < polylines.length; index++) {
			final JunFormCreation formCreation = new JunFormCreation(polylines[index]);

			Point extentPoint = formCreation.boundingBox().extent()._toPoint();
			BufferedImage aPixmap = new BufferedImage(extentPoint.x, extentPoint.y, BufferedImage.TYPE_INT_ARGB);
			Graphics graphicsContext = aPixmap.getGraphics();
			JunCursors cursor = new JunCursors(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));
			try {
				cursor._show();

				graphicsContext.setColor(Color.white);
				graphicsContext.fillRect(0, 0, aPixmap.getWidth(), aPixmap.getHeight());
				formCreation.draftTriangleNodes();
				formCreation.displayDraftTriangleNodesOn_(graphicsContext);
			} finally {
				if (graphicsContext != null) {
					graphicsContext.dispose();
					graphicsContext = null;
				}
				cursor._restore();
			}
			JunImageDisplayModel.Show_at_(aPixmap, aPoint);

			aPoint.translate(20, 20);
		}

		return true;
	}

	/**
	 * Example4: Show triangle nodes.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example4() {
		Point aPoint = new Point(100, 100);
		Jun2dPoint[][] polylines = ExamplePolylines();
		for (int index = 0; index < polylines.length; index++) {
			final JunFormCreation formCreation = new JunFormCreation(polylines[index]);

			Point extentPoint = formCreation.boundingBox().extent()._toPoint();
			BufferedImage aPixmap = new BufferedImage(extentPoint.x, extentPoint.y, BufferedImage.TYPE_INT_ARGB);
			Graphics graphicsContext = aPixmap.getGraphics();
			JunCursors cursor = new JunCursors(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));
			try {
				cursor._show();

				graphicsContext.setColor(Color.white);
				graphicsContext.fillRect(0, 0, aPixmap.getWidth(), aPixmap.getHeight());
				formCreation.triangleNodes();
				formCreation.displayTriangleNodesOn_(graphicsContext);
			} finally {
				if (graphicsContext != null) {
					graphicsContext.dispose();
					graphicsContext = null;
				}
				cursor._restore();
			}
			JunImageDisplayModel.Show_at_(aPixmap, aPoint);

			aPoint.translate(20, 20);
		}

		return true;
	}

	/**
	 * Example5: Show chordal axes.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example5() {
		Point aPoint = new Point(100, 100);
		Jun2dPoint[][] polylines = ExamplePolylines();
		for (int index = 0; index < polylines.length; index++) {
			final JunFormCreation formCreation = new JunFormCreation(polylines[index]);

			Point extentPoint = formCreation.boundingBox().extent()._toPoint();
			BufferedImage aPixmap = new BufferedImage(extentPoint.x, extentPoint.y, BufferedImage.TYPE_INT_ARGB);
			Graphics graphicsContext = aPixmap.getGraphics();
			JunCursors cursor = new JunCursors(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));
			try {
				cursor._show();

				graphicsContext.setColor(Color.white);
				graphicsContext.fillRect(0, 0, aPixmap.getWidth(), aPixmap.getHeight());
				formCreation.chordalAxes();
				formCreation.displayChordalAxesOn_(graphicsContext);
			} finally {
				if (graphicsContext != null) {
					graphicsContext.dispose();
					graphicsContext = null;
				}
				cursor._restore();
			}
			JunImageDisplayModel.Show_at_(aPixmap, aPoint);

			aPoint.translate(20, 20);
		}

		return true;
	}

	/**
	 * Example6: Show spine polylines.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example6() {
		Point aPoint = new Point(100, 100);
		Jun2dPoint[][] polylines = ExamplePolylines();
		for (int index = 0; index < polylines.length; index++) {
			final JunFormCreation formCreation = new JunFormCreation(polylines[index]);

			Point extentPoint = formCreation.boundingBox().extent()._toPoint();
			BufferedImage aPixmap = new BufferedImage(extentPoint.x, extentPoint.y, BufferedImage.TYPE_INT_ARGB);
			Graphics graphicsContext = aPixmap.getGraphics();
			JunCursors cursor = new JunCursors(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));
			try {
				cursor._show();

				graphicsContext.setColor(Color.white);
				graphicsContext.fillRect(0, 0, aPixmap.getWidth(), aPixmap.getHeight());
				formCreation.spinePolylines();
				formCreation.displaySpinePolylinesOn_(graphicsContext);
			} finally {
				if (graphicsContext != null) {
					graphicsContext.dispose();
					graphicsContext = null;
				}
				cursor._restore();
			}
			JunImageDisplayModel.Show_at_(aPixmap, aPoint);

			aPoint.translate(20, 20);
		}

		return true;
	}

	/**
	 * Example7: Show spines and triangles.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example7() {
		Point aPoint = new Point(100, 100);
		Jun2dPoint[][] polylines = ExamplePolylines();
		for (int index = 0; index < polylines.length; index++) {
			final JunFormCreation formCreation = new JunFormCreation(polylines[index]);

			Point extentPoint = formCreation.boundingBox().extent()._toPoint();
			BufferedImage aPixmap = new BufferedImage(extentPoint.x, extentPoint.y, BufferedImage.TYPE_INT_ARGB);
			Graphics graphicsContext = aPixmap.getGraphics();
			JunCursors cursor = new JunCursors(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));
			try {
				cursor._show();

				graphicsContext.setColor(Color.white);
				graphicsContext.fillRect(0, 0, aPixmap.getWidth(), aPixmap.getHeight());
				formCreation.spines();
				formCreation.triangles();
				formCreation.displayOn_(graphicsContext);
			} finally {
				if (graphicsContext != null) {
					graphicsContext.dispose();
					graphicsContext = null;
				}
				cursor._restore();
			}
			JunImageDisplayModel.Show_at_(aPixmap, aPoint);

			aPoint.translate(20, 20);
		}

		return true;
	}

	/**
	 * Example8: Show .
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example8() {
		Point aPoint = new Point(100, 100);
		Jun2dPoint[][] polylines = ExamplePolylines();
		for (int index = 0; index < polylines.length; index++) {
			final JunFormCreation formCreation = new JunFormCreation(polylines[index]);
			JunOpenGL3dCompoundObject compoundObject;

			JunCursors cursor = new JunCursors(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));
			try {
				cursor._show();

				JunOpenGL3dCompoundObject spineBody0 = formCreation.spineBody0();
				spineBody0.primitivesDo_(new StBlockClosure() {
					public Object value_(Object obj) {
						JunOpenGL3dObject each = (JunOpenGL3dObject) obj;
						each.paint_(Color.red);
						if (each instanceof JunOpenGL3dPolyline) {
							((JunOpenGL3dPolyline) each).lineWidth_(3);
						} else {
							((JunOpenGL3dVertex) each).size_(3);
						}
						return null;
					}
				});

				JunOpenGL3dCompoundObject spineBody1 = formCreation.spineBody1();
				spineBody1.primitivesDo_(new StBlockClosure() {
					public Object value_(Object obj) {
						JunOpenGL3dObject each = (JunOpenGL3dObject) obj;
						each.paint_(Color.red);
						if (each instanceof JunOpenGL3dPolyline) {
							((JunOpenGL3dPolyline) each).lineWidth_(3);
						} else {
							((JunOpenGL3dVertex) each).size_(3);
						}
						return null;
					}
				});

				JunOpenGL3dCompoundObject spineBody2 = formCreation.spineBody2();
				spineBody2.primitivesDo_(new StBlockClosure() {
					public Object value_(Object obj) {
						JunOpenGL3dObject each = (JunOpenGL3dObject) obj;
						each.paint_(Color.red);
						if (each instanceof JunOpenGL3dPolyline) {
							((JunOpenGL3dPolyline) each).lineWidth_(3);
						} else {
							((JunOpenGL3dVertex) each).size_(3);
						}
						return null;
					}
				});

				JunOpenGL3dCompoundObject simpleBody0 = formCreation.simpleBody0();
				simpleBody0.objectsDo_(new StBlockClosure() {
					public Object value_(Object obj) {
						JunOpenGL3dObject each = (JunOpenGL3dObject) obj;
						each.paint_(Color.cyan);
						if (each instanceof JunOpenGL3dPolygon) {
							((JunOpenGL3dPolygon) each).halftone_(0.75);
						}
						return null;
					}
				});

				JunOpenGL3dCompoundObject simpleBody1 = formCreation.simpleBody1();
				simpleBody1.objectsDo_(new StBlockClosure() {
					public Object value_(Object obj) {
						JunOpenGL3dObject each = (JunOpenGL3dObject) obj;
						each.paint_(Color.magenta);
						if (each instanceof JunOpenGL3dPolygon) {
							((JunOpenGL3dPolygon) each).halftone_(0.25);
						}
						return null;
					}
				});

				JunOpenGL3dCompoundObject simpleBody2 = formCreation.simpleBody2();
				simpleBody2.objectsDo_(new StBlockClosure() {
					public Object value_(Object obj) {
						JunOpenGL3dObject each = (JunOpenGL3dObject) obj;
						each.paint_(Color.yellow);
						if (each instanceof JunOpenGL3dPolygon) {
							((JunOpenGL3dPolygon) each).halftone_(0.25);
						}
						return null;
					}
				});

				compoundObject = new JunOpenGL3dCompoundObject();
				compoundObject.add_(spineBody0);
				compoundObject.add_(spineBody1);
				compoundObject.add_(spineBody2);
				compoundObject.add_(simpleBody0);
				compoundObject.add_(simpleBody1);
				compoundObject.add_(simpleBody2);
			} finally {
				cursor._restore();
			}

			JunOpenGLDisplayModel displayModel = new JunOpenGLDisplayModel();
			displayModel.displayObject_(compoundObject);
			displayModel.defaultEyePoint_(new Jun3dPoint(0, 2500, -1000));
			displayModel.defaultSightPoint_(new Jun3dPoint(0, 0, 0));
			displayModel.defaultUpVector_(new Jun3dPoint(0, -1, 0));
			displayModel.openIn_(new Rectangle(aPoint, new Dimension(300, 300)));

			aPoint.translate(20, 20);
		}

		return true;
	}

	/**
	 * Example8a: Show simple body.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example8a() {
		Point aPoint = new Point(100, 100);
		Jun2dPoint[][] polylines = ExamplePolylines();
		for (int index = 0; index < polylines.length; index++) {
			final JunFormCreation formCreation = new JunFormCreation(polylines[index]);
			JunOpenGL3dCompoundObject compoundObject;

			JunCursors cursor = new JunCursors(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));
			try {
				cursor._show();
				compoundObject = formCreation.simpleBody();
			} finally {
				cursor._restore();
			}

			JunOpenGLDisplayModel displayModel = new JunOpenGLDisplayModel();
			displayModel.displayObject_(compoundObject);
			displayModel.defaultEyePoint_(new Jun3dPoint(0, 2500, -1000));
			displayModel.defaultSightPoint_(new Jun3dPoint(0, 0, 0));
			displayModel.defaultUpVector_(new Jun3dPoint(0, -1, 0));
			displayModel.openIn_(new Rectangle(aPoint, new Dimension(300, 300)));

			aPoint.translate(20, 20);
		}

		return true;
	}

	/**
	 * Example9: Show .
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example9() {
		Point aPoint = new Point(100, 100);
		Jun2dPoint[][] polylines = ExamplePolylines();
		for (int index = 0; index < polylines.length; index++) {
			final JunFormCreation formCreation = new JunFormCreation(polylines[index]);
			JunOpenGL3dCompoundObject compoundObject;

			JunCursors cursor = new JunCursors(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));
			try {
				cursor._show();
				compoundObject = formCreation.body();
				compoundObject.paint_(Color.red);
			} finally {
				cursor._restore();
			}

			JunOpenGLDisplayModel displayModel = new JunOpenGLDisplayModel();
			displayModel.displayObject_(compoundObject);
			displayModel.defaultEyePoint_(new Jun3dPoint(0, 2500, -1000));
			displayModel.defaultSightPoint_(new Jun3dPoint(0, 0, 0));
			displayModel.defaultUpVector_(new Jun3dPoint(0, -1, 0));
			displayModel.openIn_(new Rectangle(aPoint, new Dimension(300, 300)));
			displayModel.hiddenlinePresentation();

			aPoint.translate(20, 20);
		}

		return true;
	}

	/**
	 * Example9a: Show .
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example9a() {
		Point aPoint = new Point(100, 100);
		Jun2dPoint[][] polylines = ExamplePolylines();
		for (int index = 0; index < polylines.length; index++) {
			final JunFormCreation formCreation = new JunFormCreation(polylines[index]);
			JunOpenGL3dCompoundObject compoundObject;

			JunCursors cursor = new JunCursors(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));
			try {
				cursor._show();
				compoundObject = formCreation.body();
				compoundObject.paint_(Color.red);
			} finally {
				cursor._restore();
			}

			JunOpenGLDisplayModel displayModel = new JunOpenGLDisplayModel();
			displayModel.displayObject_(compoundObject);
			displayModel.defaultEyePoint_(new Jun3dPoint(0, 2500, -1000));
			displayModel.defaultSightPoint_(new Jun3dPoint(0, 0, 0));
			displayModel.defaultUpVector_(new Jun3dPoint(0, -1, 0));
			displayModel.openIn_(new Rectangle(aPoint, new Dimension(300, 300)));

			aPoint.translate(20, 20);
		}

		return true;
	}

	/**
	 * Execute all examples.
	 * 
	 * @param args an array of command-line arguments
	 * @category Main
	 */
	public static void main(String[] args) {
		new JunFormCreationTestExamples();
	}
}
