package jp.co.sra.jun.geometry.curves;

import java.io.IOException;
import java.io.Writer;

import jp.co.sra.jun.geometry.abstracts.JunCurve;
import jp.co.sra.jun.geometry.basic.Jun2dPoint;
import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.basic.JunPoint;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dPolyline;

/**
 * JunPolyline class
 * 
 *  @author    nisinaka
 *  @created   2006/08/18 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun682 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunPolyline.java,v 8.12 2008/02/20 06:30:57 nisinaka Exp $
 */
public abstract class JunPolyline extends JunCurve {

	/**
	 * Answer my points.
	 * 
	 * @return jp.co.sra.jun.geometry.basic.JunPoint[]
	 * @category accessing
	 */
	protected abstract JunPoint[] _points();

	/**
	 * Convert to an array of <code>Jun2dPoint</code>.
	 * 
	 * @return jp.co.sra.jun.geometry.basic.Jun2dPoint[]
	 * @category converting
	 */
	public abstract Jun2dPoint[] as2dPoints();

	/**
	 * Convert to an array of <code>Jun3dPoint</code>.
	 * 
	 * @return jp.co.sra.jun.geometry.basic.Jun3dPoint[]
	 * @category converting
	 */
	public abstract Jun3dPoint[] as3dPoints();

	/**
	 * Convert to a <code>JunOpenGL3dObject</code>.
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @see jp.co.sra.jun.geometry.abstracts.JunGeometry#asJunOpenGL3dObject()
	 * @category converting
	 */
	public JunOpenGL3dObject asJunOpenGL3dObject() {
		JunOpenGL3dPolyline aBody = new JunOpenGL3dPolyline(this.as3dPoints());
		aBody.paint_(this.defaultColor());
		return aBody;
	}

	/**
	 * Convert the receiver as a <code>JunNurbsCurve</code>.
	 * 
	 * @return jp.co.sra.jun.geometry.curves.JunNurbsCurve
	 * @see jp.co.sra.jun.geometry.abstracts.JunCurve#asNurbsCurve()
	 * @category converting
	 */
	public JunNurbsCurve asNurbsCurve() {
		return JunNurbsCurve.BezierControlPoints_(this.as3dPoints());
	}

	/**
	 * Print my string representation on the writer.
	 * 
	 * @param aWriter java.io.Writer
	 * @throws java.io.IOException
	 * @see jp.co.sra.jun.geometry.abstracts.JunGeometry#printOn_(java.io.Writer)
	 * @category printing
	 */
	public void printOn_(Writer aWriter) throws IOException {
		aWriter.write(this._className().toString());
		aWriter.write('(');
		JunPoint[] points = this._points();
		for (int i = 0; i < points.length; i++) {
			points[i].printOn_(aWriter);
			aWriter.write(' ');
		}
		aWriter.write(')');
	}

}
