package jp.co.sra.jun.geometry.curves;

import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.basic.JunPoint;
import jp.co.sra.jun.system.support.JunTestExamples;

/**
 * JunNurbsCurveTestExamples class
 * 
 *  @author    nisinaka
 *  @created   2004/11/16 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunNurbsCurveTestExamples.java,v 8.10 2008/02/20 06:30:57 nisinaka Exp $
 */
public class JunNurbsCurveTestExamples extends JunTestExamples {

	/**
	 * Example_BezierCurve:
	 * 
	 * @return boolean
	 */
	public static boolean Example_BezierCurve() {
		ExampleBezierCurve().asJunOpenGL3dNurbsCurve().yourselfAndControlPointsObject().show();
		return true;
	}

	/**
	 * Example_BSplineCurve:
	 * 
	 * @return boolean
	 */
	public static boolean Example_BSplineCurve() {
		ExampleBSplineCurve().asJunOpenGL3dNurbsCurve().yourselfAndControlPointsObject().show();
		return true;
	}

	/**
	 * Example_Circle:
	 * 
	 * @return boolean
	 */
	public static boolean Example_Circle() {
		ExampleCircle().asJunOpenGL3dNurbsCurve().yourselfAndControlPointsObject().show();
		return true;
	}

	/**
	 * Test1: Test for atT_(double) method.
	 * 
	 * @return boolean
	 */
	public static boolean Test1() {
		JunNurbsCurve aNurbsCurve;

		aNurbsCurve = ExampleBezierCurve();
		System.out.println(aNurbsCurve.atT_(0.0) + "->" + aNurbsCurve.atT_(0.5) + "->" + aNurbsCurve.atT_(1.0));
		if (aNurbsCurve.atT_(0.0).equals(new Jun3dPoint(1.0, -1.0, 0.0)) == false) {
			return false;
		}
		if (aNurbsCurve.atT_(0.5).equals(new Jun3dPoint(-0.25, 0.25, 0.0)) == false) {
			return false;
		}
		if (aNurbsCurve.atT_(1.0).equals(new Jun3dPoint(1.0, -1.0, 0.0)) == false) {
			return false;
		}

		aNurbsCurve = ExampleBSplineCurve();
		System.out.println(aNurbsCurve.atT_(0.0) + "->" + aNurbsCurve.atT_(0.5) + "->" + aNurbsCurve.atT_(1.0));
		if (aNurbsCurve.atT_(0.0).minus_(new Jun3dPoint(166.66666666666669, -833.3333333333333, 0.0)).length() > JunPoint.ACCURACY) {
			return false;
		}
		if (aNurbsCurve.atT_(0.5).minus_(new Jun3dPoint(833.3333333333333, -833.3333333333333, 0.0)).length() > JunPoint.ACCURACY) {
			return false;
		}
		if (aNurbsCurve.atT_(1.0).minus_(new Jun3dPoint(666.6666666666667, 666.6666666666667, 0.0)).length() > JunPoint.ACCURACY) {
			return false;
		}

		aNurbsCurve = ExampleCircle();
		System.out.println(aNurbsCurve.atT_(0.0) + "->" + aNurbsCurve.atT_(0.5) + "->" + aNurbsCurve.atT_(1.0));
		if (aNurbsCurve.atT_(0.0).equals(new Jun3dPoint(0.0, -1.0, 0.0)) == false) {
			return false;
		}
		if (aNurbsCurve.atT_(0.5).equals(new Jun3dPoint(0.0, 0.0, 0.0)) == false) {
			return false;
		}
		if (aNurbsCurve.atT_(1.0).equals(new Jun3dPoint(0.0, -1.0, 0.0)) == false) {
			return false;
		}

		return true;
	}

	/**
	 * Execute all examples.
	 * 
	 * @param args java.lang.String[]
	 */
	public static void main(String[] args) {
		new JunNurbsCurveTestExamples();
	}

	/**
	 * Create an examle instance of JunNurbsCurve which represents a Bezier curve.
	 * 
	 * @return jp.co.sra.jun.geometry.curves.JunNurbsCurve
	 */
	protected static JunNurbsCurve ExampleBezierCurve() {
		Jun3dPoint[] controlPoints = new Jun3dPoint[5];
		controlPoints[0] = new Jun3dPoint(1, -1, 0);
		controlPoints[1] = new Jun3dPoint(-1, -1, 0);
		controlPoints[2] = new Jun3dPoint(-1, 1, 0);
		controlPoints[3] = new Jun3dPoint(1, 1, 0);
		controlPoints[4] = new Jun3dPoint(1, -1, 0);
		return JunNurbsCurve.BezierControlPoints_(controlPoints);
	}

	/**
	 * Create an examle instance of JunNurbsCurve which represents a BSpline curve.
	 * 
	 * @return jp.co.sra.jun.geometry.curves.JunNurbsCurve
	 */
	protected static JunNurbsCurve ExampleBSplineCurve() {
		Jun3dPoint[] controlPoints = new Jun3dPoint[9];
		controlPoints[0] = new Jun3dPoint(1000, -1000, 0);
		controlPoints[1] = new Jun3dPoint(-1000, -1000, 0);
		controlPoints[2] = new Jun3dPoint(-1000, 1000, 0);
		controlPoints[3] = new Jun3dPoint(1000, 1000, 0);
		controlPoints[4] = new Jun3dPoint(1000, -1000, 0);
		controlPoints[5] = new Jun3dPoint(-1000, -1000, 0);
		controlPoints[6] = new Jun3dPoint(-1000, 1000, 0);
		controlPoints[7] = new Jun3dPoint(1000, 1000, 0);
		controlPoints[8] = new Jun3dPoint(1000, -1000, 0);
		double[] knotVector = new double[] { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12 };
		return JunNurbsCurve.BSplineControlPoints_knotVector_(controlPoints, knotVector);
	}

	/**
	 * Create an examle instance of JunNurbsCurve which represents a circle.
	 * 
	 * @return jp.co.sra.jun.geometry.curves.JunNurbsCurve
	 */
	protected static JunNurbsCurve ExampleCircle() {
		Jun3dPoint[] controlPoints = new Jun3dPoint[9];
		controlPoints[0] = new Jun3dPoint(0, -1, 0);
		controlPoints[1] = new Jun3dPoint(1, -1, 0);
		controlPoints[2] = new Jun3dPoint(1, 0, 0);
		controlPoints[3] = new Jun3dPoint(1, 1, 0);
		controlPoints[4] = new Jun3dPoint(0, 1, 0);
		controlPoints[5] = new Jun3dPoint(-1, 1, 0);
		controlPoints[6] = new Jun3dPoint(-1, 0, 0);
		controlPoints[7] = new Jun3dPoint(-1, -1, 0);
		controlPoints[8] = new Jun3dPoint(0, -1, 0);
		double[] weights = new double[9];
		weights[0] = 1.0;
		weights[1] = Math.sqrt(0.5);
		weights[2] = 1.0;
		weights[3] = Math.sqrt(0.5);
		weights[4] = 1.0;
		weights[5] = Math.sqrt(0.5);
		weights[6] = 1.0;
		weights[7] = Math.sqrt(0.5);
		weights[8] = 1.0;
		double[] knotVector = { 0, 0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 4 };
		return new JunNurbsCurve(controlPoints, weights, knotVector);
	}

}
