package jp.co.sra.jun.geometry.curves;

import java.awt.Color;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;

import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StSymbol;

import jp.co.sra.jun.geometry.basic.Jun2dPoint;
import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.surfaces.Jun2dTriangle;
import jp.co.sra.jun.geometry.surfaces.Jun3dPolygon;
import jp.co.sra.jun.geometry.transformations.Jun2dTransformation;
import jp.co.sra.jun.opengl.display.JunOpenGLDisplayModel;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dCompoundObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dPolyline;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dVertex;
import jp.co.sra.jun.system.support.JunTestExamples;

/**
 * Jun2dPolylineTestExamples class
 * 
 *  @author    nisinaka
 *  @created   2006/08/18 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun682 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: Jun2dPolylineTestExamples.java,v 8.11 2008/02/20 06:30:57 nisinaka Exp $
 */
public class Jun2dPolylineTestExamples extends JunTestExamples {

	/**
	 * Example1: Create an example polyline and convert it as JunOpenGL3dObject.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example1() {
		JunOpenGL3dCompoundObject aBody = new JunOpenGL3dCompoundObject();
		Jun2dPolyline aPolyline = ExamplePolyline1();
		aBody.add_(aPolyline.asJunOpenGL3dObject());
		aBody.show();

		return true;
	}

	/**
	 * Example2: 
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example2() {
		Jun2dPolyline aPolyline = ExamplePolyline2();

		HashMap projectionTable = new HashMap();
		projectionTable.put($("upVector"), new Jun3dPoint(0, 1, 0));
		projectionTable.put($("zoomHeight"), new Double(300));
		projectionTable.put($("shading"), $("smoothShading"));
		projectionTable.put($("eyePoint"), aPolyline.from().as3dPoint().plus_(new Jun3dPoint(0, 0, 10000)));
		projectionTable.put($("viewFactor"), new Double(10));
		projectionTable.put($("presentation"), $("soldPresentation"));
		projectionTable.put($("sightPoint"), aPolyline.from().as3dPoint());

		double scaleFactor = 0;
		scaleFactor = Math.max(scaleFactor, Math.abs(aPolyline.boundingBox().origin().x() - aPolyline.from().x()));
		scaleFactor = Math.max(scaleFactor, Math.abs(aPolyline.boundingBox().corner().x() - aPolyline.from().x()));
		scaleFactor = Math.max(scaleFactor, Math.abs(aPolyline.boundingBox().origin().y() - aPolyline.from().y()));
		scaleFactor = Math.max(scaleFactor, Math.abs(aPolyline.boundingBox().corner().y() - aPolyline.from().y()));

		JunOpenGL3dCompoundObject aBody = new JunOpenGL3dCompoundObject();
		JunOpenGL3dPolyline anOpenGL3dPolyline = (JunOpenGL3dPolyline) aPolyline.asJunOpenGL3dObjectColor_(Color.black);
		anOpenGL3dPolyline.lineWidth_(1);
		aBody.add_(anOpenGL3dPolyline.translatedBy_(new Jun3dPoint(0, 0, 0.1)));
		aBody.add_(JunOpenGL3dObject.Axes().scaledBy_(scaleFactor * 1.2).translatedBy_(aPolyline.from().as3dPoint()));
		aBody.showProjectionTable_in_(projectionTable, new Rectangle(100 - 4, 300 - 23, 300 + 8, 300 + 26));

		aBody = (JunOpenGL3dCompoundObject) aBody.copy();
		Jun2dTriangle[] arrayOfTriangles = aPolyline.asArrayOfTriangles();
		for (int i = 0; i < arrayOfTriangles.length; i++) {
			aBody.add_(arrayOfTriangles[i].asJunOpenGL3dObjectColor_(Color.getHSBColor((float) i / arrayOfTriangles.length, 1, 1)));
		}
		aBody.showProjectionTable_in_(projectionTable, new Rectangle(410 - 4, 300 - 23, 300 + 8, 300 + 26));

		return true;
	}

	/**
	 * Example3: 
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example3() {
		final Jun2dPolyline aPolyline1 = ExamplePolyline31();
		final Jun2dPolyline aPolyline2 = ExamplePolyline32();

		JunOpenGL3dCompoundObject aBody = new JunOpenGL3dCompoundObject();

		HashMap projectionTable = new HashMap();
		projectionTable.put($("sightPoint"), new Jun3dPoint(99.5, 159.5, 0.0));
		projectionTable.put($("shading"), $("smoothShading"));
		projectionTable.put($("upVector"), new Jun3dPoint(0, -1, 0));
		projectionTable.put($("viewFactor"), new Double(10));
		projectionTable.put($("presentation"), $("soldPresentation"));
		projectionTable.put($("zoomHeight"), new Double(370));
		projectionTable.put($("eyePoint"), new Jun3dPoint(0, 0, -10000));

		final JunOpenGLDisplayModel aModel = aBody.showProjectionTable_(projectionTable);

		final StBlockClosure aBlock = new StBlockClosure() {
			public Object value_(Object anObject) {
				JunOpenGL3dCompoundObject aBody = (JunOpenGL3dCompoundObject) anObject;

				Jun2dPoint[] points = aPolyline1.points();
				for (int i = 0; i < points.length; i++) {
					JunOpenGL3dVertex vertex = (JunOpenGL3dVertex) points[i].plus_(new Jun3dPoint(0, 0, -0.1)).asJunOpenGL3dObject();
					vertex.size_(5);
					aBody.add_(vertex);
				}

				points = aPolyline2.points();
				for (int i = 0; i < points.length; i++) {
					JunOpenGL3dVertex vertex = (JunOpenGL3dVertex) points[i].plus_(new Jun3dPoint(0, 0, -0.1)).asJunOpenGL3dObject();
					vertex.size_(5);
					aBody.add_(vertex);
				}

				JunOpenGL3dPolyline polyline = (JunOpenGL3dPolyline) aPolyline1.asJunOpenGL3dObject();
				polyline.lineWidth_(3);
				aBody.add_(polyline);

				polyline = (JunOpenGL3dPolyline) aPolyline2.asJunOpenGL3dObject();
				polyline.lineWidth_(3);
				aBody.add_(polyline);

				return aBody;
			}
		};

		Jun2dTriangle[] triangles = aPolyline1.sew_interim_(aPolyline2, new StBlockClosure() {
			public Object value_value_(Object o1, Object o2) {
				Jun2dPoint[] points = (Jun2dPoint[]) o1;
				StSymbol symbol = (StSymbol) o2;

				JunOpenGL3dCompoundObject aBody = new JunOpenGL3dCompoundObject();
				aBlock.value_(aBody);

				Jun3dPoint[] _3dPoints = new Jun3dPoint[points.length];
				for (int i = 0; i < _3dPoints.length; i++) {
					_3dPoints[i] = new Jun3dPoint(points[i], 0.1);
				}
				JunOpenGL3dObject aPolygon = Jun3dPolygon.Points_(_3dPoints).asJunOpenGL3dObject();
				Color aColor = (symbol == $("pending")) ? Color.cyan : Color.magenta;
				aPolygon.paint_(aColor);

				aBody.add_(aPolygon);

				aModel.displayObject_(aBody);
				aModel.changed_($("object"));

				try {
					int time = (symbol == $("pending")) ? 300 : 900;
					Thread.sleep(time);
				} catch (InterruptedException e) {
					e.printStackTrace();
				}

				return null;
			}
		});

		aBody = new JunOpenGL3dCompoundObject();
		aBlock.value_(aBody);
		for (int i = 0; i < triangles.length; i++) {
			Jun3dPoint[] points = new Jun3dPoint[] { new Jun3dPoint(triangles[i].p3(), 0.1), new Jun3dPoint(triangles[i].p2(), 0.1), new Jun3dPoint(triangles[i].p1(), 0.1) };
			JunOpenGL3dObject aPolygon = Jun3dPolygon.Points_(points).asJunOpenGL3dObject();
			aPolygon.paint_(Color.magenta);
			aBody.add_(aPolygon);
		}

		aModel.hiddenlinePresentation();
		aModel.displayObject_(aBody);
		aModel.changed_($("object"));

		return true;
	}

	/**
	 * Example4:
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example4() {
		Jun2dPolyline aPolyline = ExamplePolyline();
		//aPolyline.showWithUnitArrows();
		aPolyline.subdivideAsSpline().showWithUnitArrows();

		return true;
	}

	/**
	 * Example5:
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example5() {
		Jun2dPolyline aPolyline = new Jun2dPolyline(ExamplePointCollectionOf2dSinCurve()).subdivideAsSpline();
		aPolyline.showWithAxes();

		return true;
	}

	/**
	 * Create an example polyline.
	 * 
	 * @return jp.co.sra.jun.geometry.curves.Jun2dPolyline
	 * @category Examples
	 */
	protected static Jun2dPolyline ExamplePolyline() {
		Jun2dPolyline lines = new Jun2dPoint(0, 0).to_(new Jun2dPoint(1, 1)).subdivideLevel_(2);
		double delta = 0.1;
		Jun2dLine line = new Jun2dPoint(0, 0).to_(new Jun2dPoint(-1, 1));
		Jun2dPoint[] points = lines.points();
		points[1] = line.translatedBy_(points[1]).atT_(-delta);
		points[3] = line.translatedBy_(points[3]).atT_(delta);
		return new Jun2dPolyline(points);
	}

	/**
	 * Create an example polyline.
	 * 
	 * @return jp.co.sra.jun.geometry.curves.Jun2dPolyline
	 * @category Examples
	 */
	protected static Jun2dPolyline ExamplePolyline1() {
		Jun2dPoint[] points = new Jun2dPoint[5];
		points[0] = new Jun2dPoint(50, 50);
		points[1] = new Jun2dPoint(-50, 50);
		points[2] = new Jun2dPoint(-50, -50);
		points[3] = new Jun2dPoint(50, -50);
		points[4] = points[0];
		return new Jun2dPolyline(points);
	}

	/**
	 * Create an example polyline.
	 * 
	 * @return jp.co.sra.jun.geometry.curves.Jun2dPolyline
	 * @category Examples
	 */
	protected static Jun2dPolyline ExamplePolyline2() {
		ArrayList aList = new ArrayList();
		aList.add(new Jun2dPoint(115, 142));
		aList.add(new Jun2dPoint(109, 136));
		aList.add(new Jun2dPoint(97, 119));
		aList.add(new Jun2dPoint(92, 111));
		aList.add(new Jun2dPoint(90, 100));
		aList.add(new Jun2dPoint(95, 78));
		aList.add(new Jun2dPoint(102, 64));
		aList.add(new Jun2dPoint(116, 50));
		aList.add(new Jun2dPoint(132, 49));
		aList.add(new Jun2dPoint(142, 55));
		aList.add(new Jun2dPoint(154, 66));
		aList.add(new Jun2dPoint(160, 83));
		aList.add(new Jun2dPoint(160, 99));
		aList.add(new Jun2dPoint(156, 110));
		aList.add(new Jun2dPoint(153, 123));
		aList.add(new Jun2dPoint(152, 131));
		aList.add(new Jun2dPoint(156, 137));
		aList.add(new Jun2dPoint(165, 141));
		aList.add(new Jun2dPoint(180, 144));
		aList.add(new Jun2dPoint(198, 149));
		aList.add(new Jun2dPoint(210, 158));
		aList.add(new Jun2dPoint(215, 168));
		aList.add(new Jun2dPoint(215, 182));
		aList.add(new Jun2dPoint(210, 191));
		aList.add(new Jun2dPoint(199, 194));
		aList.add(new Jun2dPoint(183, 190));
		aList.add(new Jun2dPoint(170, 184));
		aList.add(new Jun2dPoint(162, 183));
		aList.add(new Jun2dPoint(149, 187));
		aList.add(new Jun2dPoint(140, 193));
		aList.add(new Jun2dPoint(132, 199));
		aList.add(new Jun2dPoint(122, 206));
		aList.add(new Jun2dPoint(110, 210));
		aList.add(new Jun2dPoint(96, 210));
		aList.add(new Jun2dPoint(83, 207));
		aList.add(new Jun2dPoint(74, 203));
		aList.add(new Jun2dPoint(71, 195));
		aList.add(new Jun2dPoint(73, 185));
		aList.add(new Jun2dPoint(81, 178));
		aList.add(new Jun2dPoint(94, 173));
		aList.add(new Jun2dPoint(106, 172));
		aList.add(new Jun2dPoint(112, 170));
		aList.add(new Jun2dPoint(117, 169));
		aList.add(new Jun2dPoint(124, 165));
		aList.add(new Jun2dPoint(125, 162));
		aList.add(new Jun2dPoint(125, 159));

		Jun2dTransformation aTransformation = Jun2dTransformation.Unity();
		Jun2dPoint[] points = (Jun2dPoint[]) aList.toArray(new Jun2dPoint[aList.size()]);
		for (int i = 0; i < points.length; i++) {
			points[i] = points[i].transform_(aTransformation);
		}

		return new Jun2dPolyline(points);
	}

	/**
	 * Create an example polyline.
	 * 
	 * @return jp.co.sra.jun.geometry.curves.Jun2dPolyline
	 * @category Examples
	 */
	protected static Jun2dPolyline ExamplePolyline31() {
		return new Jun2dPolyline(new Jun2dPoint[] { new Jun2dPoint(59, 5), new Jun2dPoint(41, 50), new Jun2dPoint(113, 149), new Jun2dPoint(5, 221), new Jun2dPoint(5, 257), new Jun2dPoint(32, 314) });
	}

	/**
	 * Create an example polyline.
	 * 
	 * @return jp.co.sra.jun.geometry.curves.Jun2dPolyline
	 * @category Examples
	 */
	protected static Jun2dPolyline ExamplePolyline32() {
		return new Jun2dPolyline(new Jun2dPoint[] { new Jun2dPoint(194, 50), new Jun2dPoint(185, 122), new Jun2dPoint(149, 172), new Jun2dPoint(185, 275) });
	}

	/**
	 * Answer the example point collection of 2D sin curve.
	 * 
	 * @return jp.co.sra.jun.geometry.basic.Jun2dPoint[]
	 * @category Examples
	 */
	protected static Jun2dPoint[] ExamplePointCollectionOf2dSinCurve() {
		int numberOfPoints = 501;
		Collection pointCollection = new ArrayList(numberOfPoints);
		for (int i = 0; i < numberOfPoints; i++) {
			double x = i / (double) numberOfPoints;
			double y = 0.4 * Math.sin(10 * 2 * Math.PI * x);
			pointCollection.add(new Jun3dPoint(x, y, 0));
		}

		JunOpenGL3dPolyline aPolyline = new JunOpenGL3dPolyline(pointCollection);
		aPolyline = (JunOpenGL3dPolyline) JunOpenGL3dObject.From_to_with_(new Jun3dPoint(0, 0, 0), new Jun3dPoint(3, 2, 1), aPolyline);
		Jun3dPoint[] a3dPoints = aPolyline.vertexes();
		Jun2dPoint[] a2dPoints = new Jun2dPoint[a3dPoints.length];
		for (int i = 0; i < a2dPoints.length; i++) {
			a2dPoints[i] = a3dPoints[i].as2dPoint();
		}
		return a2dPoints;
	}

	/**
	 * Execute all examples.
	 * 
	 * @param args java.lang.String[]
	 * @category Main
	 */
	public static void main(String[] args) {
		new Jun2dPolylineTestExamples();
	}

}
