package jp.co.sra.jun.geometry.curves;

import jp.co.sra.jun.geometry.basic.*;
import jp.co.sra.jun.system.support.*;

/**
 * Jun2dLineTestExamples class
 * 
 *  @author    nisinaka
 *  @created   1998/10/09 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: Jun2dLineTestExamples.java,v 8.10 2008/02/20 06:30:57 nisinaka Exp $
 */
public class Jun2dLineTestExamples extends JunTestExamples {
	/**
	 * DOCUMENT ME!
	 * 
	 * @return DOCUMENT ME!
	 * @category Examples
	 */
	public static boolean Example1() {
		Jun2dPoint fromPoint = new Jun2dPoint(10, 20);
		Jun2dPoint toPoint = new Jun2dPoint(0, 0);
		Jun2dLine aLine = new Jun2dLine(fromPoint, toPoint);
		System.out.println(aLine.printString());

		return true;
	}

	/**
	 * Execute all examples.
	 * 
	 * @param args java.lang.String[]
	 * @category Main
	 */
	public static void main(String[] args) {
		new Jun2dLineTestExamples();
	}

	/**
	 * Test for intersectingPointWithLine_().
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Test1() {
		Jun2dLine line1 = new Jun2dLine(new Jun2dPoint(0, 0), new Jun2dPoint(1, 1));
		Jun2dLine line2 = new Jun2dLine(new Jun2dPoint(0, 2), new Jun2dPoint(6, 0));
		Jun2dPoint intersectingPoint = line1.intersectingPointWithLine_(line2);

		return (intersectingPoint.x() == 1.5) && (intersectingPoint.y() == 1.5);
	}

	/**
	 * Test for lineSegmentIntersectingPointWithLine_().
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Test2() {
		Jun2dLine line1 = new Jun2dLine(new Jun2dPoint(0, 0), new Jun2dPoint(1, 1));
		Jun2dLine line2 = new Jun2dLine(new Jun2dPoint(0, 2), new Jun2dPoint(6, 0));
		Jun2dPoint intersectingPoint = line1.lineSegmentIntersectingPointWithLineSegment_(line2);

		return intersectingPoint == null;
	}

	/**
	 * Test for angleWithLine_().
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Test3() {
		Jun2dLine line1 = new Jun2dLine(new Jun2dPoint(0, 0), new Jun2dPoint(1, 1));
		Jun2dLine line2 = new Jun2dLine(new Jun2dPoint(0, 0), new Jun2dPoint(-1, -1));
		JunAngle angle = line1.angleWithLine_(line2);

		return angle.deg() == 180.0d;
	}
}
