package jp.co.sra.jun.geometry.coordinate;

import jp.co.sra.jun.geometry.abstracts.JunGeometry;
import jp.co.sra.jun.geometry.transformations.JunTransformation;

/**
 * JunCoordinateSystem class
 * 
 *  @author    nisinaka
 *  @created   1998/09/28 (by nisinaka)
 *  @updated   2000/01/06 (by nisinaka)
 *  @updated   2006/10/11 (by nisinaka)
 *  @version   699 (with StPL8.9) based on Jun610 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunCoordinateSystem.java,v 8.11 2008/02/20 06:30:57 nisinaka Exp $
 */
public abstract class JunCoordinateSystem extends JunGeometry {

	/**
	 * Answer my current transformation.
	 * 
	 * @return jp.co.sra.jun.geometry.transformations.JunTransformation
	 * @category accessing
	 */
	public abstract JunTransformation _transformation();

	/**
	 * Answer my global inverse transformation.
	 * 
	 * @return jp.co.sra.jun.geometry.transformations.JunTransformation
	 * @category accessing
	 */
	public abstract JunTransformation _globalInvTransformation();

	/**
	 * Answer a geometry object which is interpreted by this coordinate system.
	 * 
	 * @param aGeometry jp.co.sra.jun.geometry.abstracts.JunGeometry
	 * @return jp.co.sra.jun.geometry.abstracts.JunGeometry
	 * @category applying transformation
	 */
	public JunGeometry interprete_(JunGeometry aGeometry) {
		return aGeometry.interpretedBy_(this);
	}

}
