package jp.co.sra.jun.geometry.boxtree;

import jp.co.sra.jun.geometry.abstracts.JunGeometry;

/**
 * JunBoundingBoxTree class
 * 
 *  @author    Mitsuhiro Asada
 *  @created   2007/06/26 (by m-asada)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun666 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunBoundingBoxTree.java,v 8.5 2008/02/20 06:30:56 nisinaka Exp $
 */
public abstract class JunBoundingBoxTree extends JunGeometry {
	protected int levelNumber;

	/**
	 * Create a new instance of <code>JunBoundingBoxTree</code> and initialize it.
	 * 
	 * @category Instance creation
	 */
	public JunBoundingBoxTree() {
		super();
	}
	
	/**
	 * Initialize the receiver.
	 * 
	 * @see jp.co.sra.jun.geometry.abstracts.JunGeometry#initialize()
	 * @category initialize-release
	 */
	protected void initialize() {
		super.initialize();
		
		levelNumber = Integer.MIN_VALUE;
	}

	/**
	 * Answer the receiver's contained points.
	 * 
	 * @return jp.co.sra.jun.geometry.abstracts.JunGeometry[]
	 * @category accessing
	 */
	public abstract JunGeometry[] containedObjects();
	
	/**
	 * Answer the receiver's levelNumber.
	 * 
	 * @return int
	 * @category accessing
	 */
	public int levelNumber() {
		if (levelNumber < 0) {
			levelNumber = 0;
		}
		return levelNumber;
	}

	/**
	 * Answer <code>true</code> if the receiver is equal to the object.
	 * 
	 * @return boolean
	 * @param anObject java.lang.Object
	 * @see jp.co.sra.jun.geometry.abstracts.JunGeometry#equals(java.lang.Object)
	 * @category comparing
	 */
	public boolean equals(Object anObject) {
		return this.equal_(anObject);
	}
}
