package jp.co.sra.jun.geometry.boxtree;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StInterval;

import jp.co.sra.jun.geometry.abstracts.JunGeometry;
import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.boundaries.Jun3dBoundingBox;
import jp.co.sra.jun.geometry.curves.Jun3dLine;
import jp.co.sra.jun.geometry.forms.JunForm2dRegionTestExamples;
import jp.co.sra.jun.geometry.forms.JunFormCreation;
import jp.co.sra.jun.geometry.surfaces.Jun3dTriangle;
import jp.co.sra.jun.goodies.cursors.JunCursors;
import jp.co.sra.jun.goodies.utilities.JunControlUtility;
import jp.co.sra.jun.opengl.display.JunOpenGLDisplayModel;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dCompoundObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dPolygon;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dPolyline;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dVertex;

/**
 * Jun3dBoundingBoxNodeTestExamples class
 * 
 *  @author    Mitsuhiro Asada
 *  @created   2007/05/29 (by Mitsuhiro Asada)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun666 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: Jun3dBoundingBoxNodeTestExamples.java,v 8.6 2008/02/20 06:30:56 nisinaka Exp $
 */
public class Jun3dBoundingBoxNodeTestExamples extends JunForm2dRegionTestExamples {
	/**
	 * Example1: Example point collection of 3D line.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example1() {
		Jun3dBoundingBoxNode boundingBoxNode = new Jun3dBoundingBoxNode(ExamplePointCollectionOf3dLine());
		Jun3dBoundingBoxNodeTestExamples.ExampleDisplay_levelInterval_(boundingBoxNode, new StInterval(0, 18));

		return true;
	}

	/**
	 * Example2: Example point collection of 3D sin curve.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example2() {
		Jun3dBoundingBoxNode boundingBoxNode = new Jun3dBoundingBoxNode(ExamplePointCollectionOf3dSinCurve());
		Jun3dBoundingBoxNodeTestExamples.ExampleDisplay_levelInterval_(boundingBoxNode, new StInterval(0, 18));

		return true;
	}

	/**
	 * Example3: Example point collection of 3D half ball.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example3() {
		Jun3dBoundingBoxNode boundingBoxNode = new Jun3dBoundingBoxNode(ExamplePointCollectionOf3dHalfBall());
		Jun3dBoundingBoxNodeTestExamples.ExampleDisplay_levelInterval_(boundingBoxNode, new StInterval(0, 18));

		return true;
	}

	/**
	 * Example4: Example segment collection of 3D line.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example4() {
		Jun3dBoundingBoxNode boundingBoxNode = new Jun3dBoundingBoxNode(ExampleSegmentCollectionOf3dLine());
		Jun3dBoundingBoxNodeTestExamples.ExampleDisplay_levelInterval_(boundingBoxNode, new StInterval(0, 18));

		return true;
	}

	/**
	 * Example5: Example segment collection of 3D sin curve.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example5() {
		Jun3dBoundingBoxNode boundingBoxNode = new Jun3dBoundingBoxNode(ExampleSegmentCollectionOf3dSinCurve());
		Jun3dBoundingBoxNodeTestExamples.ExampleDisplay_levelInterval_(boundingBoxNode, new StInterval(0, 18));

		return true;
	}

	/**
	 * Example6: Example patch collection of 3D half ball.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example6() {
		Jun3dBoundingBoxNode boundingBoxNode = new Jun3dBoundingBoxNode(ExamplePatchCollectionOf3dHalfBall());
		Jun3dBoundingBoxNodeTestExamples.ExampleDisplay_levelInterval_(boundingBoxNode, new StInterval(0, 18));

		return true;
	}

	/**
	 * Example7: Example patch collection of 3D half ball.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example7() {
		Jun3dBoundingBoxNode boundingBoxNode = new Jun3dBoundingBoxNode(ExamplePatchCollectionOf3dHalfBall());
		boundingBoxNode.messageToSubdivide_($("subdivide"));
		boundingBoxNode.compareWithBlock_(new StBlockClosure() {
			public Object value_value_(Object object, Object box) {
				Jun3dTriangle geometry = (Jun3dTriangle) object;
				Jun3dBoundingBox boundingBox = (Jun3dBoundingBox) box;
				Set set = new HashSet();
				Jun3dTriangle[] triangles = geometry.detailedTrianglesLevel_(1);
				for (int i = 0; i < triangles.length; i++) {
					Jun3dPoint[] points = triangles[i].points();
					for (int j = 0; j < points.length; j++) {
						set.add(points[j]);
					}
				}
				Jun3dPoint[] points = (Jun3dPoint[]) set.toArray(new Jun3dPoint[set.size()]);
				boolean containsPoint = false;
				for (int i = 0; i < points.length; i++) {
					if (boundingBox.containsPoint_(points[i])) {
						containsPoint = true;
						break;
					}
				}
				return new Boolean(containsPoint);
			}
		});
		Jun3dBoundingBoxNodeTestExamples.ExampleDisplay_levelInterval_(boundingBoxNode, new StInterval(0, 4));

		return true;
	}

	/**
	 * Example8: Example patch collection of 3D polyline.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example8() {
		Jun3dBoundingBoxNode boundingBoxNode = new Jun3dBoundingBoxNode(ExamplePatchCollectionOf3dPolyline());
		boundingBoxNode.messageToSubdivide_($("subdivide"));
		Jun3dBoundingBoxNodeTestExamples.ExampleDisplay_levelInterval_(boundingBoxNode, new StInterval(0, 4));

		return true;
	}

	/**
	 * Example: Display the specified bounding box node with interval parameter.
	 * 
	 * @param boundingBoxNode jp.co.sra.jun.geometry.boxtree.Jun3dBoundingBoxNode
	 * @param anInterval jp.co.sra.smalltalk.StInterval
	 * @return jp.co.sra.jun.geometry.boxtree.Jun3dBoundingBoxNode
	 * @category Examples
	 */
	protected static Jun3dBoundingBoxNode ExampleDisplay_levelInterval_(Jun3dBoundingBoxNode boundingBoxNode, StInterval anInterval) {
		JunOpenGLDisplayModel displayModel = new JunOpenGLDisplayModel();
		displayModel.openIn_(new Rectangle(200, 100, 600 + 6, 400 + 26));
		((Frame) displayModel.getWindow()).setTitle("Bounding Box Node");
		for (int levelNumber = (int) Math.round(anInterval.start()); levelNumber <= anInterval.last(); levelNumber = levelNumber + (int) anInterval.step()) {
			Jun3dBoundingBoxNode[] subdividedNodes;
			JunCursors cursor = new JunCursors(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));
			try {
				cursor._show();
				subdividedNodes = boundingBoxNode.subdividedNodesLevel_(levelNumber);
			} finally {
				cursor._restore();
			}
			ExampleDisplay_with_with_with_(displayModel, boundingBoxNode, levelNumber, subdividedNodes);
		}
		return boundingBoxNode;
	}

	/**
	 * Example: Display a <code>JunOpenGLDisplayModel</code> with the specified bounding box node.
	 * 
	 * @param displayModel jp.co.sra.jun.opengl.display.JunOpenGLDisplayModel
	 * @param boundingBoxNode jp.co.sra.jun.geometry.boxtree.Jun3dBoundingBoxNode
	 * @param levelNumber int
	 * @param subdividedNodes jp.co.sra.jun.geometry.boxtree.Jun3dBoundingBoxNode[]
	 * @category Examples
	 */
	protected static void ExampleDisplay_with_with_with_(final JunOpenGLDisplayModel displayModel, Jun3dBoundingBoxNode boundingBoxNode, final int levelNumber, final Jun3dBoundingBoxNode[] subdividedNodes) {
		final JunOpenGL3dCompoundObject compoundObject = new JunOpenGL3dCompoundObject();
		JunOpenGL3dCompoundObject subObject = new JunOpenGL3dCompoundObject();
		JunGeometry[] objects = boundingBoxNode.containedObjects();
		for (int i = 0; i < objects.length; i++) {
			JunOpenGL3dObject body = null;
			if (objects[i].isPoint()) {
				JunOpenGL3dVertex vertext = (JunOpenGL3dVertex) objects[i].asJunOpenGL3dObjectColor_(Color.gray);
				vertext.size_(3);
				body = vertext;
			}
			if (objects[i].isLine()) {
				JunOpenGL3dCompoundObject compoundBody = new JunOpenGL3dCompoundObject();
				Jun3dLine object = (Jun3dLine) objects[i];
				JunOpenGL3dPolyline line = (JunOpenGL3dPolyline) object.asJunOpenGL3dObjectColor_(Color.black);
				line.lineWidth_(2);
				compoundBody = line.asCompoundObject();
				JunOpenGL3dVertex from = (JunOpenGL3dVertex) object.from().asJunOpenGL3dObjectColor_(Color.black);
				from.size_(3);
				compoundBody.add_(from);
				JunOpenGL3dVertex last = (JunOpenGL3dVertex) object.last().asJunOpenGL3dObjectColor_(Color.black);
				last.size_(3);
				compoundBody.add_(last);
				body = compoundBody;
			}
			if (objects[i].isTriangle()) {
				JunOpenGL3dCompoundObject compoundBody = new JunOpenGL3dCompoundObject();
				Jun3dTriangle object = (Jun3dTriangle) objects[i];
				JunOpenGL3dPolyline polyline = new JunOpenGL3dPolyline(object.asPointArray());
				polyline.paint_(Color.gray);
				polyline.lineWidth_(1);
				compoundBody.add_(polyline);
				JunOpenGL3dVertex p1 = (JunOpenGL3dVertex) object.p3().asJunOpenGL3dObjectColor_(Color.black);
				p1.size_(3);
				compoundBody.add_(p1);
				JunOpenGL3dVertex p2 = (JunOpenGL3dVertex) object.p3().asJunOpenGL3dObjectColor_(Color.black);
				p2.size_(3);
				compoundBody.add_(p2);
				JunOpenGL3dVertex p3 = (JunOpenGL3dVertex) object.p3().asJunOpenGL3dObjectColor_(Color.black);
				p3.size_(3);
				compoundBody.add_(p3);
				body = compoundBody;
			}
			if (body != null) {
				subObject.add_(body);
			}
		}

		compoundObject.add_(subObject);
		subObject = new JunOpenGL3dCompoundObject();
		for (int n = 0; n < subdividedNodes.length; n++) {
			subObject.add_(subdividedNodes[n].asJunOpenGL3dObject());
		}

		compoundObject.add_(subObject);
		subObject = (JunOpenGL3dCompoundObject) JunOpenGL3dObject.XyzUnitArrows().scaledBy_(boundingBoxNode.boundingBox().extent());
		compoundObject.add_(subObject);

		JunControlUtility.Do_forMilliseconds_(new StBlockClosure() {
			public Object value() {
				displayModel.displayObject_(compoundObject);
				displayModel.resetView();
				System.out.print("level ");
				System.out.print(Integer.toString(levelNumber));
				System.out.print(" -> ");
				System.out.print(Integer.toString(subdividedNodes.length));
				System.out.println(subdividedNodes.length > 1 ? " boxes" : " box");
				return null;
			}
		}, 2000);
	}

	/**
	 * Answer the example patch collection of 3D half ball.
	 * 
	 * @return jp.co.sra.jun.geometry.surfaces.Jun3dTriangle[]
	 * @category Examples
	 */
	protected static Jun3dTriangle[] ExamplePatchCollectionOf3dHalfBall() {
		final Collection patchCollection = new ArrayList();
		JunOpenGL3dObject.Ball_(4).polygonsDo_(new StBlockClosure() {
			public Object value_(Object obj) {
				JunOpenGL3dPolygon polygon = (JunOpenGL3dPolygon) obj;
				Jun3dPoint[] vertexes = polygon.vertexes();
				Jun3dPoint p1 = vertexes[0];
				Jun3dPoint p2 = vertexes[1];
				Jun3dPoint p3 = vertexes[2];
				Jun3dTriangle triangle = p1.triangle_and_(p2, p3);
				if (triangle.centerOfIncircle().z() >= 0d) {
					p1 = p1.translatedBy_(new Jun3dPoint(1, 1, 0));
					p2 = p2.translatedBy_(new Jun3dPoint(1, 1, 0));
					p3 = p3.translatedBy_(new Jun3dPoint(1, 1, 0));
					triangle = p1.triangle_and_(p2, p3);
					patchCollection.add(triangle);
				}
				return null;
			}
		});
		return (Jun3dTriangle[]) patchCollection.toArray(new Jun3dTriangle[patchCollection.size()]);
	}

	/**
	 * Answer the example patch collection of 3D polyline.
	 * 
	 * @return jp.co.sra.jun.geometry.surfaces.Jun3dTriangle[]
	 * @category Examples
	 */
	protected static Jun3dTriangle[] ExamplePatchCollectionOf3dPolyline() {
		final List patchCollection = new ArrayList();
		new JunFormCreation(JunForm2dRegionTestExamples.ExamplePolyline4()).body().polygonsDo_(new StBlockClosure() {
			public Object value_(Object obj) {
				JunOpenGL3dPolygon polygon = (JunOpenGL3dPolygon) obj;
				Jun3dPoint[] vertexes = polygon.vertexes();
				Jun3dPoint p1 = vertexes[0];
				Jun3dPoint p2 = vertexes[1];
				Jun3dPoint p3 = vertexes[2];
				Jun3dTriangle triangle = p1.triangle_and_(p2, p3);
				patchCollection.add(triangle);
				return null;
			}
		});
		Jun3dBoundingBox boundingBox = null;
		Jun3dTriangle[] triangles = (Jun3dTriangle[]) patchCollection.toArray(new Jun3dTriangle[patchCollection.size()]);
		for (int i = 0; i < triangles.length; i++) {
			if (boundingBox == null) {
				boundingBox = triangles[i].boundingBox();
			} else {
				boundingBox = boundingBox.merge_(triangles[i].boundingBox());
			}
		}
		for (int i = 0; i < triangles.length; i++) {
			patchCollection.set(i, triangles[i].translatedBy_(boundingBox.origin().negated()));
		}
		return (Jun3dTriangle[]) patchCollection.toArray(new Jun3dTriangle[patchCollection.size()]);
	}

	/**
	 * Answer the example point collection of 3D half ball.
	 * 
	 * @return jp.co.sra.jun.geometry.basic.Jun3dPoint[]
	 * @category Examples
	 */
	protected static Jun3dPoint[] ExamplePointCollectionOf3dHalfBall() {
		Collection pointCollection = new ArrayList();
		Jun3dPoint[] ballPoints = JunOpenGL3dObject.Ball_(4).asPointArray();
		for (int i = 0; i < ballPoints.length; i++) {
			if (ballPoints[i].z() >= 0) {
				pointCollection.add(ballPoints[i].translatedBy_(new Jun3dPoint(1, 1, 0)));
			}
		}
		return (Jun3dPoint[]) pointCollection.toArray(new Jun3dPoint[pointCollection.size()]);
	}

	/**
	 * Answer the example point collection of 3D line.
	 * 
	 * @return jp.co.sra.jun.geometry.basic.Jun3dPoint[]
	 * @category Examples
	 */
	protected static Jun3dPoint[] ExamplePointCollectionOf3dLine() {
		Jun3dLine aLine = new Jun3dPoint(0, 0, 0).to_(new Jun3dPoint(3, 2, 1));
		Collection pointCollection = new ArrayList();
		for (int i = 0; i <= 100; i++) {
			double t = 0.01 * i;
			pointCollection.add(aLine.atT_(t));
		}
		return (Jun3dPoint[]) pointCollection.toArray(new Jun3dPoint[pointCollection.size()]);
	}

	/**
	 * Answer the example point collection of 3D sin curve.
	 * 
	 * @return jp.co.sra.jun.geometry.basic.Jun3dPoint[]
	 * @category Examples
	 */
	protected static Jun3dPoint[] ExamplePointCollectionOf3dSinCurve() {
		int numberOfPoints = 501;
		Collection pointCollection = new ArrayList(numberOfPoints);
		for (int i = 0; i < numberOfPoints; i++) {
			double x = i / (double) numberOfPoints;
			double y = 0.4 * Math.sin(10 * 2 * Math.PI * x);
			pointCollection.add(new Jun3dPoint(x, y, 0));
		}

		JunOpenGL3dPolyline aPolyline = new JunOpenGL3dPolyline(pointCollection);
		aPolyline = (JunOpenGL3dPolyline) JunOpenGL3dObject.From_to_with_(new Jun3dPoint(0, 0, 0), new Jun3dPoint(3, 2, 1), aPolyline);
		Jun3dPoint[] pointArray = aPolyline.vertexes();
		return pointArray;
	}

	/**
	 * Answer the example segment collection of 3D line.
	 * 
	 * @return jp.co.sra.jun.geometry.curves.Jun3dLine[]
	 * @category Examples
	 */
	protected static Jun3dLine[] ExampleSegmentCollectionOf3dLine() {
		Jun3dLine aLine = new Jun3dPoint(0, 0, 0).to_(new Jun3dPoint(3, 2, 1));
		Collection pointCollection = new ArrayList();
		for (int i = 0; i <= 100; i++) {
			double t = 0.01 * i;
			pointCollection.add(aLine.atT_(t));
		}
		Collection segmentCollection = new ArrayList(pointCollection.size() - 1);
		Jun3dPoint[] points = (Jun3dPoint[]) pointCollection.toArray(new Jun3dPoint[pointCollection.size()]);
		for (int i = 0; i < points.length - 1; i++) {
			segmentCollection.add(points[i].to_(points[i + 1]));
		}
		return (Jun3dLine[]) segmentCollection.toArray(new Jun3dLine[segmentCollection.size()]);
	}

	/**
	 * Answer the example segment collection of 3D sin curve.
	 * 
	 * @return jp.co.sra.jun.geometry.curves.Jun3dLine[]
	 * @category Examples
	 */
	protected static Jun3dLine[] ExampleSegmentCollectionOf3dSinCurve() {
		int numberOfPoints = 501;
		Collection pointCollection = new ArrayList(numberOfPoints);
		for (int i = 0; i < numberOfPoints; i++) {
			double x = i / (double) numberOfPoints;
			double y = 0.4 * Math.sin(10 * 2 * Math.PI * x);
			pointCollection.add(new Jun3dPoint(x, y, 0));
		}

		JunOpenGL3dPolyline aPolyline = new JunOpenGL3dPolyline(pointCollection);
		aPolyline = (JunOpenGL3dPolyline) JunOpenGL3dObject.From_to_with_(new Jun3dPoint(0, 0, 0), new Jun3dPoint(3, 2, 1), aPolyline);
		Jun3dPoint[] pointArray = aPolyline.vertexes();
		Collection segmentCollection = new ArrayList(pointCollection.size() - 1);
		for (int i = 0; i < pointArray.length - 1; i++) {
			segmentCollection.add(pointArray[i].to_(pointArray[i + 1]));
		}
		return (Jun3dLine[]) segmentCollection.toArray(new Jun3dLine[segmentCollection.size()]);
	}

	/**
	 * Execute all examples.
	 * 
	 * @param args java.lang.String[]
	 * @category Main
	 */
	public static void main(String[] args) {
		new Jun3dBoundingBoxNodeTestExamples();
	}
}
