package jp.co.sra.jun.geometry.boundaries;

import jp.co.sra.jun.geometry.abstracts.JunGeometry;

/**
 * JunBoundingObject class
 * 
 *  @author    Mitsuhiro Asada
 *  @created   2004/10/19 (by Mitsuhiro Asada)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun610 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunBoundingObject.java,v 8.11 2008/02/20 06:30:56 nisinaka Exp $
 */
public abstract class JunBoundingObject extends JunGeometry {

	/**
	 * Answer true if the receiver is a bounding object, otherwise false.
	 * 
	 * @return boolean
	 * @see jp.co.sra.jun.geometry.abstracts.JunGeometry#isBoundingObject()
	 * @category testing
	 */
	public boolean isBoundingObject() {
		return false;
	}

	/**
	 * Answer true if the receiver is empty, otherwise false.
	 * 
	 * @return boolean
	 * @category testing
	 */
	public boolean isEmpty() {
		if (this.is3d()) {
			return this.volume() < this.accuracy();
		}
		if (this.is2d()) {
			return this.area() < this.accuracy();
		}
		return false;
	}

}
