package jp.co.sra.jun.geometry.boundaries;

import java.io.IOException;
import java.io.Writer;

import jp.co.sra.smalltalk.StObject;

import jp.co.sra.jun.geometry.basic.JunPoint;

/**
 * JunBoundingBall class
 * 
 *  @author    NISHIHARA Satoshi
 *  @created   2000/01/24 (by NISHIHARA Satoshi)
 *  @updated   2004/10/19 (by Mitsuhiro Asada)
 *  @updated   2006/10/10 (by nisinaka)
 *  @version   699 (with StPL8.9) based on Jun666 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunBoundingBall.java,v 8.13 2008/02/20 06:30:56 nisinaka Exp $
 */
public abstract class JunBoundingBall extends JunBoundingObject {

	protected JunPoint center;
	protected double radius;

	/**
	 * Initialize this object.
	 * 
	 * @category initialize-release
	 * @see jp.co.sra.jun.geometry.abstracts.JunGeometry#initialize()
	 */
	protected void initialize() {
		super.initialize();
		center = null;
		radius = 0.0d;
	}

	/**
	 * Answer my radius.
	 * 
	 * @return double
	 * @category accessing
	 */
	public double radius() {
		return radius;
	}

	/**
	 * Set my radius.
	 * 
	 * @param aNumber double
	 * @category accessing
	 */
	public void radius_(double aNumber) {
		radius = Math.abs(aNumber);
	}

	/**
	 * Answer my width.
	 * 
	 * @return double
	 * @category accessing
	 */
	public double width() {
		return this._boundingBox().width();
	}

	/**
	 * Answer my height.
	 * 
	 * @return double
	 * @category accessing
	 */
	public double height() {
		return this._boundingBox().height();
	}

	/**
	 * Answer my depth.
	 * 
	 * @return double
	 * @category accessing
	 */
	public abstract double depth();

	/**
	 * Answer my center point.
	 * 
	 * @return jp.co.sra.jun.geometry.basic.JunPoint
	 * @category accessing
	 */
	protected JunPoint _center() {
		return center;
	}

	/**
	 * Set my center point.
	 * 
	 * @param aPoint jp.co.sra.jun.geometry.basic.JunPoint
	 * @category accessing
	 */
	protected void _center(JunPoint aPoint) {
		center = aPoint;
	}

	/**
	 * Answer my bounding box.
	 * 
	 * @return jp.co.sra.jun.geometry.boundaries.JunBoundingBox
	 * @category accessing
	 */
	protected abstract JunBoundingBox _boundingBox();

	/**
	 * Answer true if the receiver is equal to the object while concerning an accuracy.
	 * 
	 * @param anObject java.lang.Object
	 * @return boolean
	 * @see jp.co.sra.jun.geometry.abstracts.JunGeometry#equal_(java.lang.Object)
	 * @category comparing
	 */
	public boolean equal_(Object anObject) {
		if (this.getClass() != anObject.getClass()) {
			return false;
		}

		JunBoundingBall aBoundingBall = (JunBoundingBall) anObject;
		return center.equal_(aBoundingBall.center) && this.isEqualNumber_to_(radius, aBoundingBall.radius);
	}

	/**
	 * Answer true if the Object is equal to the receiver, otherwise false.
	 * 
	 * @param anObject java.lang.Object
	 * @return boolean
	 * @see jp.co.sra.jun.geometry.abstracts.JunGeometry#equals(java.lang.Object)
	 * @category comparing
	 */
	public boolean equals(Object anObject) {
		if (this.getClass() != anObject.getClass()) {
			return false;
		}

		JunBoundingBall aBoundingBall = (JunBoundingBall) anObject;
		return center.equals(aBoundingBall.center) && radius == aBoundingBall.radius;
	}

	/**
	 * Computes a hash code for this object.
	 * 
	 * @return int
	 * @see java.lang.Object#hashCode()
	 * @category comparing
	 */
	public int hashCode() {
		long bitsRadius = Double.doubleToLongBits(radius);
		int radiusHash = (int) (bitsRadius ^ (bitsRadius >> 32));
		return center.hashCode() | radiusHash;
	}

	/**
	 * Do an extra copy of the receiver.
	 * 
	 * @return jp.co.sra.smalltalk.StObject
	 * @see jp.co.sra.smalltalk.StObject#postCopy()
	 * @category copying
	 */
	public StObject postCopy() {
		super.postCopy();
		center = (JunPoint) center.copy();
		radius = this.radius();
		return this;
	}

	/**
	 * Print my storable string representation on the writer.
	 * 
	 * @param aWriter java.io.Writer
	 * @throws java.io.IOException
	 * @see jp.co.sra.smalltalk.StObject#storeOn_(java.io.Writer)
	 * @category printing
	 */
	public void storeOn_(Writer aWriter) throws IOException {
		aWriter.write("(");
		this._center().printOn_(aWriter);
		aWriter.write(" ball:");
		aWriter.write(String.valueOf(this.radius()));
		aWriter.write(")");
	}

	/**
	 * Answer true if the receiver is a bounding ball, otherwise false.
	 * 
	 * @return boolean
	 * @see jp.co.sra.jun.geometry.abstracts.JunGeometry#isBoundingBall()
	 * @category testing
	 */
	public boolean isBoundingBall() {
		return true;
	}

}
