package jp.co.sra.jun.geometry.boundaries;

import jp.co.sra.jun.geometry.basic.Jun2dPoint;
import jp.co.sra.jun.system.support.JunTestExamples;

/**
 * Jun2dBoundingBoxTestExamples class
 * 
 *  @author    nisinaka
 *  @created   1998/10/01 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun582 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: Jun2dBoundingBoxTestExamples.java,v 8.11 2008/02/20 06:30:55 nisinaka Exp $
 */
public class Jun2dBoundingBoxTestExamples extends JunTestExamples {
	/**
	 * DOCUMENT ME!
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example1() {
		Jun2dPoint originPoint = new Jun2dPoint(0, 0);
		Jun2dPoint cornerPoint = new Jun2dPoint(100, 100);
		Jun2dBoundingBox aBoundingBox = Jun2dBoundingBox.Origin_corner_(originPoint, cornerPoint);
		System.out.println(aBoundingBox.printString());

		return true;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example2() {
		Jun2dPoint aPoint1 = new Jun2dPoint(0, 100);
		Jun2dPoint aPoint2 = new Jun2dPoint(100, 0);
		Jun2dBoundingBox aBoundingBox = Jun2dBoundingBox.Vertex_vertex_(aPoint1, aPoint2);
		System.out.println(aBoundingBox.printString());

		return true;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example3() {
		Jun2dPoint aPoint1 = new Jun2dPoint(0, 100);
		Jun2dPoint aPoint2 = new Jun2dPoint(100, 0);
		Jun2dBoundingBox aBoundingBox = Jun2dBoundingBox.Vertex_vertex_(aPoint1, aPoint2);
		System.out.println(aBoundingBox.expandedBy_(10).printString());

		return true;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example4() {
		Jun2dPoint aPoint1 = new Jun2dPoint(0, 100);
		Jun2dPoint aPoint2 = new Jun2dPoint(100, 0);
		Jun2dBoundingBox aBoundingBox = Jun2dBoundingBox.Vertex_vertex_(aPoint1, aPoint2);
		System.out.println(aBoundingBox.insetBy_(10).printString());

		return true;
	}

	/**
	 * Example: for subdivide.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean _ExampleSubdivide() {
		new Jun2dPoint(0, 0).box_(new Jun2dPoint(1, 1)).subdivide().showWithUnitArrows().wireframePresentation();
		new Jun2dPoint(0, 0).box_(new Jun2dPoint(1, 1)).subdivide2().showWithUnitArrows().wireframePresentation();
		new Jun2dPoint(0, 0).box_(new Jun2dPoint(1, 0.9)).subdivide2().showWithUnitArrows().wireframePresentation();
		new Jun2dPoint(0, 0).box_(new Jun2dPoint(0.9, 1)).subdivide2().showWithUnitArrows().wireframePresentation();

		return true;
	}

	/**
	 * Execute all examples.
	 * 
	 * @param args java.lang.String[]
	 * @throws Exception DOCUMENT ME!
	 * @category Main
	 */
	public static void main(String[] args) throws Exception {
		new Jun2dBoundingBoxTestExamples();
	}
}
