package jp.co.sra.jun.delaunay.twoD;

import jp.co.sra.smalltalk.*;

/**
 * Jun2dDelaunayList class
 * 
 *  @author    Ryouichi Matsuda
 *  @created   2002/01/14 (by Ryouichi Matsuda)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: Jun2dDelaunayList.java,v 8.12 2008/02/20 06:30:54 nisinaka Exp $
 */
public class Jun2dDelaunayList extends Jun2dDelaunayElement {
	/**
	 * Create a new instance of <code>Jun2dDelaunayList</code> and initialize it.
	 * 
	 * @category Instance creation
	 */
	public Jun2dDelaunayList() {
		super();
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @param aJun2dDelaunayElement jp.co.sra.jun.delaunay.twoD.Jun2dDelaunayElement
	 * 
	 * @return jp.co.sra.jun.delaunay.twoD.Jun2dDelaunayElement
	 */
	public Jun2dDelaunayElement add_(Jun2dDelaunayElement aJun2dDelaunayElement) {
		if (aJun2dDelaunayElement.next() != null) {
			aJun2dDelaunayElement.removedFromList();
		}

		prev.setNext_(aJun2dDelaunayElement);
		aJun2dDelaunayElement.setPrev_(prev);
		aJun2dDelaunayElement.setNext_(this);
		this.setPrev_(aJun2dDelaunayElement);

		return aJun2dDelaunayElement;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @param anInteger int
	 * 
	 * @return jp.co.sra.jun.delaunay.twoD.Jun2dDelaunayElement
	 */
	public Jun2dDelaunayElement at_(int anInteger) {
		Jun2dDelaunayElement element;

		element = this;

		for (int i = 0; i < anInteger; i++) {
			element = element.next();

			if (element == this) {
				throw SmalltalkException.Error("out of bounds");
			}
		}

		return element;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @param anInteger int
	 * @param aJun2dDelaunayElement jp.co.sra.jun.delaunay.twoD.Jun2dDelaunayElement
	 */
	public void at_put_(int anInteger, Jun2dDelaunayElement aJun2dDelaunayElement) {
		throw SmalltalkException.ShouldNotImplement();
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @param aBlock jp.co.sra.smalltalk.StBlockClosure
	 * @param errorBlock jp.co.sra.smalltalk.StBlockClosure
	 * 
	 * @return jp.co.sra.jun.delaunay.twoD.Jun2dDelaunayElement
	 */
	public Jun2dDelaunayElement detect_ifNone_(final StBlockClosure aBlock, StBlockClosure errorBlock) {
		Object o;

		o = this.do_(new StBlockClosure() {
			public Object value_(Object element) {
				if (aBlock.value_(element) == Boolean.TRUE) {
					return element;
				}

				return null;
			}
		});

		if (o != null) {
			return (Jun2dDelaunayElement) o;
		}

		return (Jun2dDelaunayElement) errorBlock.value();
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @param aBlock jp.co.sra.smalltalk.StBlockClosure
	 * 
	 * @return DOCUMENT ME!
	 */
	public Object do_(StBlockClosure aBlock) {
		Jun2dDelaunayElement element;

		element = next;

		while (element != this) {
			Jun2dDelaunayElement nextElement;
			Object o;

			nextElement = element.next();
			o = aBlock.value_(element);

			if (o != null) {
				return o;
			}

			element = nextElement;
		}

		return null;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return jp.co.sra.jun.delaunay.twoD.Jun2dDelaunayElement
	 */
	public Jun2dDelaunayElement first() {
		if (next == this) {
			SmalltalkException.Error("out of bounds");
		}

		return next;
	}

	/**
	 * Initialize the receiver when created.
	 * 
	 * @see jp.co.sra.jun.system.framework.JunAbstractObject#initialize()
	 * @category initialize-release
	 */
	protected void initialize() {
		next = this;
		prev = this;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return jp.co.sra.jun.delaunay.twoD.Jun2dDelaunayElement
	 */
	public Jun2dDelaunayElement last() {
		if (prev == this) {
			SmalltalkException.Error("out of bounds");
		}

		return prev;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @param aJun2dDelaunayElement jp.co.sra.jun.delaunay.twoD.Jun2dDelaunayElement
	 * 
	 * @return jp.co.sra.jun.delaunay.twoD.Jun2dDelaunayElement
	 */
	public Jun2dDelaunayElement remove_(Jun2dDelaunayElement aJun2dDelaunayElement) {
		return aJun2dDelaunayElement.removedFromList();
	}
}
