package jp.co.sra.jun.delaunay.twoD;

import java.awt.Graphics;

import jp.co.sra.jun.system.framework.JunAbstractObject;

/**
 * Jun2dDelaunayElement class
 * 
 *  @author    Ryouichi Matsuda
 *  @created   2002/01/14 (by Ryouichi Matsuda)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun697 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: Jun2dDelaunayElement.java,v 8.11 2008/02/20 06:30:54 nisinaka Exp $
 */
public abstract class Jun2dDelaunayElement extends JunAbstractObject {
	// 1.0d-8
	public static final double DECIMAL_8 = 0.00000001d;
	// 1.0d-12
	public static final double DECIMAL_12 = 0.000000000001d;
	protected Jun2dDelaunayElement next;
	protected Jun2dDelaunayElement prev;

	/**
	 * Display the receiver on the specified graphic context.
	 * 
	 * @param aGraphicContext java.awt.Graphics
	 * @category display
	 */
	public void displayOn_(Graphics aGraphicContext) {
		// do nothing.
	}

	/**
	 * display.
	 * 
	 * @category private
	 */
	protected void display() {
		// should not implement...
	}

	/**
	 * Get next element.
	 * 
	 * @return jp.co.sra.jun.delaunay.twoD.Jun2dDelaunayElement
	 * @category private
	 */
	protected Jun2dDelaunayElement next() {
		return next;
	}

	/**
	 * Get previous element.
	 * 
	 * @return jp.co.sra.jun.delaunay.twoD.Jun2dDelaunayElement
	 * @category private
	 */
	protected Jun2dDelaunayElement prev() {
		return prev;
	}

	/**
	 * Removed from List.
	 * 
	 * @return jp.co.sra.jun.delaunay.twoD.Jun2dDelaunayElement
	 * @category private
	 */
	protected Jun2dDelaunayElement removedFromList() {
		prev.setNext_(next);
		next.setPrev_(prev);
		next = null;
		prev = null;

		return this;
	}

	/**
	 * Set next element.
	 * 
	 * @param aJun2dDelaunayElement jp.co.sra.jun.delaunay.twoD.Jun2dDelaunayElement
	 * @category private
	 */
	protected void setNext_(Jun2dDelaunayElement aJun2dDelaunayElement) {
		next = aJun2dDelaunayElement;
	}

	/**
	 * Set previous element.
	 * 
	 * @param aJun2dDelaunayElement jp.co.sra.jun.delaunay.twoD.Jun2dDelaunayElement
	 * @category private
	 */
	protected void setPrev_(Jun2dDelaunayElement aJun2dDelaunayElement) {
		prev = aJun2dDelaunayElement;
	}
}
