/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.smalltalk.menu;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import jp.co.sra.smalltalk.DependentEvent;
import jp.co.sra.smalltalk.StObject;
import jp.co.sra.smalltalk.StSymbol;
import jp.co.sra.smalltalk.menu.MenuEvent;
import jp.co.sra.smalltalk.menu.StMenuItem;
import jp.co.sra.smalltalk.menu.StMenuItemView;

public class StMenuItemViewSwing
extends StObject
implements StMenuItemView {
    protected StMenuItem menuItem;
    protected JComponent menuItemView;

    public StMenuItemViewSwing(StMenuItem stMenuItem) {
        this.initialize();
        this.setMenuItem(stMenuItem);
    }

    protected void initialize() {
        this.menuItem = null;
        this.menuItemView = null;
    }

    public void release() {
        this.setMenuItem(null);
        super.release();
    }

    public StMenuItem getMenuItem() {
        return this.menuItem;
    }

    public void setMenuItem(StMenuItem stMenuItem) {
        if (this.menuItem != null) {
            this.menuItem.removeDependentListener(this);
        }
        this.menuItem = stMenuItem;
        if (this.menuItem != null) {
            this.menuItem.addDependentListener(this);
        }
    }

    public Window getWindow() {
        return this.menuItemView == null ? null : SwingUtilities.getWindowAncestor(this.menuItemView);
    }

    protected JComponent menuItemView() {
        if (this.menuItemView == null) {
            this.menuItemView = this.createMenuItemView();
            this.updateMenuItemView();
        }
        return this.menuItemView;
    }

    public JMenuItem toMenuItem() {
        return (JMenuItem)this.menuItemView();
    }

    public void update_(DependentEvent dependentEvent) {
        StSymbol stSymbol = dependentEvent.getAspect();
        if (stSymbol == StMenuItemViewSwing.$("enabled")) {
            this.updateEnabled();
        } else if (stSymbol == StMenuItemViewSwing.$("label")) {
            this.updateLabel();
        } else if (stSymbol == StMenuItemViewSwing.$("labelImage")) {
            this.updateLabelImage();
        }
    }

    protected void updateEnabled() {
        this.toMenuItem().setEnabled(this.getMenuItem().isEnabled());
    }

    protected void updateLabel() {
        this.toMenuItem().setText(this.getMenuItem().labelString());
    }

    protected void updateLabelImage() {
        if (this.getMenuItem().labelImage() == null) {
            this.toMenuItem().setIcon(null);
        } else {
            this.toMenuItem().setIcon(new ImageIcon(this.getMenuItem().labelImage()));
        }
    }

    protected void updateMenuItemView() {
        this.updateEnabled();
        this.updateLabel();
        this.updateLabelImage();
    }

    protected JComponent createMenuItemView() {
        JMenuItem jMenuItem = new JMenuItem();
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                StMenuItemViewSwing.this.performMenu(StObject.$("action"), actionEvent);
            }
        });
        if (this.getMenuItem().shortcutKeyCharacter() > 0) {
            int n = this.getMenuItem().shortcutKeyCharacter();
            int n2 = this.getMenuItem().shortcutModifiers();
            jMenuItem.setAccelerator(KeyStroke.getKeyStroke(n, n2));
        }
        return jMenuItem;
    }

    protected void performMenu(StSymbol stSymbol, Object object) {
        MenuEvent menuEvent = new MenuEvent(this, stSymbol, object);
        this.getMenuItem().performMenu(menuEvent);
    }

    protected static StMenuItemViewSwing _New(StMenuItem stMenuItem) {
        if (stMenuItem == null) {
            return null;
        }
        Class<?> clazz = null;
        try {
            clazz = Class.forName(stMenuItem.getClass().getName() + "ViewSwing");
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        return clazz == null ? null : (StMenuItemViewSwing)StObject._New(clazz, stMenuItem);
    }
}

