/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.smalltalk.menu;

import java.awt.Component;
import java.awt.MenuComponent;
import java.awt.MenuContainer;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import jp.co.sra.smalltalk.DependentEvent;
import jp.co.sra.smalltalk.StObject;
import jp.co.sra.smalltalk.StSymbol;
import jp.co.sra.smalltalk.menu.MenuEvent;
import jp.co.sra.smalltalk.menu.StMenuItem;
import jp.co.sra.smalltalk.menu.StMenuItemView;

public class StMenuItemViewAwt
extends StObject
implements StMenuItemView {
    protected StMenuItem menuItem;
    protected MenuComponent menuItemView;

    public StMenuItemViewAwt(StMenuItem stMenuItem) {
        this.initialize();
        this.setMenuItem(stMenuItem);
    }

    protected void initialize() {
        this.menuItem = null;
        this.menuItemView = null;
    }

    public void release() {
        this.setMenuItem(null);
        super.release();
    }

    public StMenuItem getMenuItem() {
        return this.menuItem;
    }

    public void setMenuItem(StMenuItem stMenuItem) {
        if (this.menuItem != null) {
            this.menuItem.removeDependentListener(this);
        }
        this.menuItem = stMenuItem;
        if (this.menuItem != null) {
            this.menuItem.addDependentListener(this);
        }
    }

    public Window getWindow() {
        Component component;
        if (this.menuItemView == null) {
            return null;
        }
        MenuContainer menuContainer = this.menuItemView.getParent();
        while (menuContainer != null && menuContainer instanceof MenuComponent) {
            menuContainer = ((MenuComponent)((Object)menuContainer)).getParent();
        }
        Component component2 = component = menuContainer instanceof Component ? (Component)menuContainer : null;
        while (component != null && !(component instanceof Window)) {
            component = component.getParent();
        }
        return (Window)component;
    }

    protected MenuComponent menuItemView() {
        if (this.menuItemView == null) {
            this.menuItemView = this.createMenuItemView();
            this.updateMenuItemView();
        }
        return this.menuItemView;
    }

    public MenuItem toMenuItem() {
        return (MenuItem)this.menuItemView();
    }

    public void update_(DependentEvent dependentEvent) {
        StSymbol stSymbol = dependentEvent.getAspect();
        if (stSymbol == StMenuItemViewAwt.$("enabled")) {
            this.updateEnabled();
        } else if (stSymbol == StMenuItemViewAwt.$("label")) {
            this.updateLabel();
        }
    }

    protected void updateEnabled() {
        this.toMenuItem().setEnabled(this.getMenuItem().isEnabled());
    }

    protected void updateLabel() {
        this.toMenuItem().setLabel(this.getMenuItem().labelString());
    }

    protected void updateMenuItemView() {
        this.updateEnabled();
        this.updateLabel();
    }

    protected MenuComponent createMenuItemView() {
        MenuItem menuItem = new MenuItem();
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                StMenuItemViewAwt.this.performMenu(StObject.$("action"), actionEvent);
            }
        });
        if (this.getMenuItem().shortcutKeyCharacter() > 0) {
            int n = this.getMenuItem().shortcutKeyCharacter();
            int n2 = this.getMenuItem().shortcutModifiers();
            if ((n2 & 2) == 0) {
                System.err.println("must specify CTRL_MASK as a shortcut modifier for AWT MenuItem - " + KeyEvent.getKeyModifiersText(n2));
            }
            if ((n2 & 0xFFFFFFFC) > 0) {
                System.err.println("can't specify a shortcut modifier besides CTRL_MASK and SHIFT_MASK for AWT MenuItem - " + KeyEvent.getKeyModifiersText(n2));
            }
            boolean bl = (n2 & 1) > 0;
            menuItem.setShortcut(new MenuShortcut(n, bl));
        }
        return menuItem;
    }

    protected void performMenu(StSymbol stSymbol, Object object) {
        MenuEvent menuEvent = new MenuEvent(this, stSymbol, object);
        this.getMenuItem().performMenu(menuEvent);
    }

    protected static StMenuItemViewAwt _New(StMenuItem stMenuItem) {
        if (stMenuItem == null) {
            return null;
        }
        Class<?> clazz = null;
        try {
            clazz = Class.forName(stMenuItem.getClass().getName() + "ViewAwt");
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        return clazz == null ? null : (StMenuItemViewAwt)StObject._New(clazz, stMenuItem);
    }
}

