/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.smalltalk;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import jp.co.sra.smalltalk.StObject;
import jp.co.sra.smalltalk.StSymbol;

public class StRectangle
extends StObject {
    protected int originX;
    protected int originY;
    protected int cornerX;
    protected int cornerY;

    public StRectangle(int n, int n2, int n3, int n4) {
        this.originX = n;
        this.originY = n2;
        this.cornerX = n3;
        this.cornerY = n4;
    }

    public StRectangle(Point point, Dimension dimension) {
        this(point.x, point.y, point.x + dimension.width, point.y + dimension.height);
    }

    public StRectangle(Dimension dimension) {
        this(0, 0, dimension.width, dimension.height);
    }

    public StRectangle(Rectangle rectangle) {
        this(rectangle.x, rectangle.y, rectangle.x + rectangle.width, rectangle.y + rectangle.height);
    }

    public static StRectangle Origin_corner_(Point point, Point point2) {
        return new StRectangle(point.x, point.y, point2.x, point2.y);
    }

    public static StRectangle Origin_extent_(Point point, Point point2) {
        return new StRectangle(point.x, point.y, point.x + point2.x, point.y + point2.y);
    }

    public static StRectangle Vertex_vertex_(Point point, Point point2) {
        return new StRectangle(Math.min(point.x, point2.x), Math.min(point.y, point2.y), Math.max(point.x, point2.x), Math.max(point.y, point2.y));
    }

    public int area() {
        return this.width() * this.height();
    }

    public int bottom() {
        return this.cornerY;
    }

    public Point bottomCenter() {
        return new Point((this.originX + this.cornerX) / 2, this.cornerY);
    }

    public Point bottomLeft() {
        return new Point(this.originX, this.cornerY);
    }

    public Point bottomRight() {
        return this.corner();
    }

    public Point center() {
        return new Point((this.originX + this.cornerX) / 2, (this.originY + this.cornerY) / 2);
    }

    public Point corner() {
        return new Point(this.cornerX, this.cornerY);
    }

    public int cornerX() {
        return this.cornerX;
    }

    public int cornerY() {
        return this.cornerY;
    }

    public Dimension extent() {
        return new Dimension(this.width(), this.height());
    }

    public int height() {
        return this.cornerY - this.originY;
    }

    public int left() {
        return this.originX;
    }

    public Point leftCenter() {
        return new Point(this.left(), this.center().y);
    }

    public Point origin() {
        return new Point(this.originX, this.originY);
    }

    public int originX() {
        return this.originX;
    }

    public int originY() {
        return this.originY;
    }

    public void origin_corner_(Point point, Point point2) {
        this.originX = point.x;
        this.originY = point.y;
        this.cornerX = point2.x;
        this.cornerY = point2.y;
    }

    public int right() {
        return this.cornerX;
    }

    public Point rightCenter() {
        return new Point(this.right(), this.center().y);
    }

    public int top() {
        return this.originY;
    }

    public Point topCenter() {
        return new Point((this.originX + this.cornerX) / 2, this.originY);
    }

    public Point topLeft() {
        return this.origin();
    }

    public Point topRight() {
        return new Point(this.cornerX, this.originY);
    }

    public int width() {
        return this.cornerX - this.originX;
    }

    public int x() {
        return this.originX();
    }

    public int y() {
        return this.originY();
    }

    public Point _pointAt(StSymbol stSymbol) {
        if (stSymbol == StRectangle.$("bottomCenter")) {
            return this.bottomCenter();
        }
        if (stSymbol == StRectangle.$("bottomLeft")) {
            return this.bottomLeft();
        }
        if (stSymbol == StRectangle.$("bottomRight")) {
            return this.bottomRight();
        }
        if (stSymbol == StRectangle.$("center")) {
            return this.center();
        }
        if (stSymbol == StRectangle.$("corner")) {
            return this.corner();
        }
        if (stSymbol == StRectangle.$("leftCenter")) {
            return this.leftCenter();
        }
        if (stSymbol == StRectangle.$("origin")) {
            return this.origin();
        }
        if (stSymbol == StRectangle.$("rightCenter")) {
            return this.rightCenter();
        }
        if (stSymbol == StRectangle.$("topCenter")) {
            return this.topCenter();
        }
        if (stSymbol == StRectangle.$("topLeft")) {
            return this.topLeft();
        }
        if (stSymbol == StRectangle.$("topRight")) {
            return this.topRight();
        }
        return null;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof StRectangle)) {
            return false;
        }
        StRectangle stRectangle = (StRectangle)object;
        return this.originX == stRectangle.originX && this.originY == stRectangle.originY && this.cornerX == stRectangle.cornerX && this.cornerY == stRectangle.cornerY;
    }

    public int hashCode() {
        int n = this.originX;
        n = n * 31 + this.originY;
        n = n * 31 + this.cornerX;
        n = n * 31 + this.cornerY;
        return n;
    }

    public StRectangle[] areasOutside_(StRectangle stRectangle) {
        int n;
        int n2;
        if (!this.intersects_(stRectangle)) {
            return new StRectangle[]{this};
        }
        ArrayList<StRectangle> arrayList = new ArrayList<StRectangle>();
        if (stRectangle.origin().y > this.originY) {
            n2 = stRectangle.origin().y;
            arrayList.add(new StRectangle(this.originX, this.originY, this.cornerX, n2));
        } else {
            n2 = this.originY;
        }
        if (stRectangle.corner().y < this.cornerY) {
            n = stRectangle.corner().y;
            arrayList.add(new StRectangle(this.originX, n, this.cornerX, this.cornerY));
        } else {
            n = this.cornerY;
        }
        if (stRectangle.origin().x > this.originX) {
            arrayList.add(new StRectangle(this.originX, n2, stRectangle.origin().x, n));
        }
        if (stRectangle.corner().x < this.cornerX) {
            arrayList.add(new StRectangle(stRectangle.corner().x, n2, this.corner().x, n));
        }
        StRectangle[] stRectangleArray = new StRectangle[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            stRectangleArray[i] = (StRectangle)arrayList.get(i);
        }
        return stRectangleArray;
    }

    public StRectangle expandedBy_(int n) {
        return new StRectangle(this.originX - n, this.originY - n, this.cornerX + n, this.cornerY + n);
    }

    public StRectangle expandedBy_(int n, int n2) {
        return new StRectangle(this.originX - n, this.originY - n2, this.cornerX + n, this.cornerY + n2);
    }

    public StRectangle expandedBy_(Point point) {
        return new StRectangle(this.originX - point.x, this.originY - point.y, this.cornerX + point.x, this.cornerY + point.y);
    }

    public StRectangle expandedBy_(StRectangle stRectangle) {
        return new StRectangle(this.originX - stRectangle.originX, this.originY - stRectangle.originY, this.cornerX + stRectangle.cornerX, this.cornerY + stRectangle.cornerY);
    }

    public StRectangle insetBy_(int n) {
        return new StRectangle(this.originX + n, this.originY + n, this.cornerX - n, this.cornerY - n);
    }

    public StRectangle insetBy_(Point point) {
        return new StRectangle(this.originX + point.x, this.originY + point.y, this.cornerX - point.x, this.cornerY - point.y);
    }

    public StRectangle insetBy_(StRectangle stRectangle) {
        return new StRectangle(this.originX + stRectangle.originX, this.originY + stRectangle.originY, this.cornerX - stRectangle.cornerX, this.cornerY - stRectangle.cornerY);
    }

    public StRectangle intersect_(StRectangle stRectangle) {
        return new StRectangle(Math.max(this.originX, stRectangle.originX), Math.max(this.originY, stRectangle.originY), Math.min(this.cornerX, stRectangle.cornerX), Math.min(this.cornerY, stRectangle.cornerY));
    }

    public boolean intersects_(StRectangle stRectangle) {
        return this.originX() < stRectangle.cornerX() && this.originY() < stRectangle.cornerY() && stRectangle.originX() < this.cornerX() && stRectangle.originY() < this.cornerY() && this.originX() < stRectangle.cornerX() && this.originY() < stRectangle.cornerY() && stRectangle.originX() < stRectangle.cornerX() && stRectangle.originY() < stRectangle.cornerY();
    }

    public StRectangle merge_(StRectangle stRectangle) {
        if (stRectangle != null) {
            return new StRectangle(Math.min(this.originX, stRectangle.originX), Math.min(this.originY, stRectangle.originY), Math.max(this.cornerX, stRectangle.cornerX), Math.max(this.cornerY, stRectangle.cornerY));
        }
        return new StRectangle(this.left(), this.top(), this.right(), this.bottom());
    }

    public boolean containsPoint_(Point point) {
        return this.originX <= point.x && this.originY <= point.y && point.x <= this.cornerX && point.y <= this.cornerY;
    }

    public StRectangle align_with_(Point point, Point point2) {
        return this.translatedBy_(point2.x - point.x, point2.y - point.y);
    }

    public StRectangle scaledBy_(double d, double d2) {
        Point point = new Point((int)Math.round((double)this.originX * d), (int)Math.round((double)this.originY * d2));
        Point point2 = new Point((int)Math.round((double)this.cornerX * d), (int)Math.round((double)this.cornerY * d2));
        return StRectangle.Vertex_vertex_(point, point2);
    }

    public StRectangle translatedBy_(int n, int n2) {
        return new StRectangle(this.originX + n, this.originY + n2, this.cornerX + n, this.cornerY + n2);
    }

    public void printOn_(Writer writer) throws IOException {
        writer.write(String.valueOf(this.originX));
        writer.write(64);
        writer.write(String.valueOf(this.originY));
        writer.write(" corner: ");
        writer.write(String.valueOf(this.cornerX));
        writer.write(64);
        writer.write(String.valueOf(this.cornerY));
    }

    public Rectangle toRectangle() {
        return new Rectangle(this.originX, this.originY, this.cornerX - this.originX, this.cornerY - this.originY);
    }
}

