/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.smalltalk;

import java.awt.AWTEvent;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.Writer;
import javax.swing.SwingUtilities;
import jp.co.sra.smalltalk.StObject;

public class StInputState
extends StObject
implements AWTEventListener {
    protected static StInputState DefaultState = new StInputState();
    protected int modifiers;
    protected Point lastDownPoint;
    protected Point lastUpPoint;

    public static StInputState Default() {
        return DefaultState;
    }

    private StInputState() {
        this.initialize();
        Toolkit.getDefaultToolkit().addAWTEventListener(this, 24L);
    }

    protected void initialize() {
        this.modifiers = 0;
        this.lastDownPoint = null;
        this.lastUpPoint = null;
    }

    public boolean shiftDown() {
        return (this.modifiers & 0x40) != 0;
    }

    public boolean ctrlDown() {
        return (this.modifiers & 0x80) != 0;
    }

    public boolean metaDown() {
        return (this.modifiers & 0x100) != 0;
    }

    public boolean altDown() {
        return (this.modifiers & 0x200) != 0;
    }

    public boolean button1Down() {
        return (this.modifiers & 0x400) != 0;
    }

    public boolean button2Down() {
        return (this.modifiers & 0x800) != 0;
    }

    public boolean button3Down() {
        return (this.modifiers & 0x1000) != 0;
    }

    public boolean anyButtonDown() {
        return (this.modifiers & 0x1C00) != 0;
    }

    public void eventDispatched(AWTEvent aWTEvent) {
        if (aWTEvent instanceof KeyEvent) {
            this.dispatchKeyEvent((KeyEvent)aWTEvent);
        } else if (aWTEvent instanceof MouseEvent) {
            this.dispatchMouseEvent((MouseEvent)aWTEvent);
        }
    }

    protected void dispatchKeyEvent(KeyEvent keyEvent) {
        this.dispatchInputEvent(keyEvent);
    }

    protected void dispatchMouseEvent(MouseEvent mouseEvent) {
        this.dispatchInputEvent(mouseEvent);
        Point point = null;
        switch (mouseEvent.getID()) {
            case 501: {
                point = mouseEvent.getPoint();
                SwingUtilities.convertPointToScreen(point, mouseEvent.getComponent());
                this.lastDownPoint = point;
                break;
            }
            case 502: {
                point = mouseEvent.getPoint();
                SwingUtilities.convertPointToScreen(point, mouseEvent.getComponent());
                this.lastUpPoint = point;
            }
        }
    }

    protected void dispatchInputEvent(InputEvent inputEvent) {
        this.modifiers = inputEvent.getModifiersEx();
    }

    public void printOn_(Writer writer) throws IOException {
        super.printOn_(writer);
        writer.write(40);
        writer.write(InputEvent.getModifiersExText(this.modifiers));
        writer.write(41);
    }
}

