/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.smalltalk;

import java.io.IOException;
import java.io.Writer;
import jp.co.sra.smalltalk.StObject;

public class StByteArray
extends StObject {
    protected byte[] byteArray = null;

    public StByteArray() {
        this(0);
    }

    public StByteArray(byte[] byArray) {
        this.byteArray = new byte[byArray.length];
        System.arraycopy(byArray, 0, this.byteArray, 0, byArray.length);
    }

    public StByteArray(int[] nArray) {
        this.byteArray = new byte[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            this.byteArray[i] = (byte)nArray[i];
        }
    }

    public StByteArray(int n) {
        this.byteArray = new byte[n];
        for (int i = 0; i < n; ++i) {
            this.byteArray[i] = 0;
        }
    }

    public static StByteArray FromPackedString_(String string) {
        int n = string.length();
        if (n == 0) {
            return new StByteArray();
        }
        char c = string.charAt(n - 1);
        int n2 = Math.round((float)n / 4.0f) * 3;
        if (c >= '`') {
            n2 = n2 - 3 + c - 96;
        }
        StByteArray stByteArray = new StByteArray(n2);
        if (n > 400) {
            StByteArray.SlowDecodeFromFrom_Starting_Into_(1, string, 1, stByteArray);
        } else {
            StByteArray.SlowDecodeFromFrom_Starting_Into_(1, string, 1, stByteArray);
        }
        return stByteArray;
    }

    private static void SlowDecodeFromFrom_Starting_Into_(int n, String string, int n2, StByteArray stByteArray) {
        int n3 = n2;
        int n4 = stByteArray.size();
        for (int i = n; i <= n4; i += 3) {
            int n5 = (string.charAt(n3 - 1) & 0x3F) << 18;
            n5 += (string.charAt(n3) & 0x3F) << 12;
            n5 += (string.charAt(n3 + 1) & 0x3F) << 6;
            stByteArray.at_put_(i, (byte)((n5 += string.charAt((n3 += 4) + 2) & 0x3F) >> 16));
            if (i >= n4) continue;
            stByteArray.at_put_(i + 1, (byte)(n5 >> 8 & 0xFF));
            if (i + 1 >= n4) continue;
            stByteArray.at_put_(i + 2, (byte)(n5 & 0xFF));
        }
    }

    public byte[] _asBytes() {
        byte[] byArray = new byte[this.byteArray.length];
        System.arraycopy(this.byteArray, 0, byArray, 0, this.byteArray.length);
        return byArray;
    }

    public int[] _asInts() {
        int[] nArray = new int[this.byteArray.length];
        for (int i = 0; i < this.byteArray.length; ++i) {
            nArray[i] = this.byteArray[i] & 0xFF;
        }
        return nArray;
    }

    public String asPackedString() {
        int n = this.size();
        StByteArray stByteArray = new StByteArray((n + 2) / 3 * 4);
        if (n > 300) {
            this.slowEncodeFrom_into_startingAt_(1, stByteArray, 1);
        } else {
            this.slowEncodeFrom_into_startingAt_(1, stByteArray, 1);
        }
        byte[] byArray = stByteArray._asBytes();
        StringBuffer stringBuffer = new StringBuffer(byArray.length);
        for (int i = 0; i < byArray.length; ++i) {
            char c = (char)byArray[i];
            if (c == '\'') {
                stringBuffer.append(c);
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public byte at_(int n) {
        return this.byteArray[n - 1];
    }

    public void at_put_(int n, byte by) {
        this.byteArray[n - 1] = by;
    }

    public final int size() {
        return this.byteArray.length;
    }

    public void storeOn_(Writer writer) throws IOException {
        if (this.byteArray.length > 200) {
            writer.write("(ByteArray fromPackedString: '");
            writer.write(this.asPackedString());
            writer.write("')");
        } else {
            writer.write("#[");
            if (this.byteArray.length > 0) {
                writer.write(String.valueOf(this.byteArray[0] & 0xFF));
                for (int i = 1; i < this.byteArray.length; ++i) {
                    writer.write(32);
                    writer.write(String.valueOf(this.byteArray[i] & 0xFF));
                }
            }
            writer.write(93);
        }
    }

    private void slowEncodeFrom_into_startingAt_(int n, StByteArray stByteArray, int n2) {
        int n3 = n;
        int n4 = n2;
        int n5 = this.size();
        while (n3 <= n5) {
            int n6 = (this.at_(n3) & 0xFF) << 16;
            if (n3 < n5) {
                n6 += (this.at_(n3 + 1) & 0xFF) << 8;
                if (n3 + 1 < n5) {
                    n6 += this.at_(n3 + 2) & 0xFF;
                }
            }
            n3 += 3;
            stByteArray.at_put_(n4, (byte)(((n6 ^= 0x820820) >> 18) + 32));
            stByteArray.at_put_(n4 + 1, (byte)((n6 >> 12 & 0x3F) + 32));
            stByteArray.at_put_(n4 + 2, (byte)((n6 >> 6 & 0x3F) + 32));
            stByteArray.at_put_(n4 + 3, (byte)((n6 & 0x3F) + 32));
            n4 += 4;
        }
        if (n5 % 3 != 0) {
            stByteArray.at_put_(n4 - 1, (byte)(n5 % 3 + 96));
        }
    }
}

