/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.smalltalk;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Window;
import java.io.Serializable;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.border.Border;
import jp.co.sra.smalltalk.DependentEvent;
import jp.co.sra.smalltalk.StApplicationModel;
import jp.co.sra.smalltalk.StApplicationWindow;
import jp.co.sra.smalltalk.StView;
import jp.co.sra.smalltalk.StViewSwing;
import jp.co.sra.smalltalk.menu.StMenuBar;
import jp.co.sra.smalltalk.menu.StMenuBarView;
import jp.co.sra.smalltalk.menu.StMenuBarViewSwing;

public class StApplicationWindowSwing
extends JFrame
implements StApplicationWindow {
    protected StApplicationModel application;
    protected StView view;
    protected StMenuBarViewSwing menuBarView;

    public StApplicationWindowSwing(StApplicationModel stApplicationModel, StView stView) {
        this.application_(stApplicationModel);
        this.view_(stView);
        this.buildWindow();
    }

    public StApplicationModel application() {
        return this.application;
    }

    public void application_(StApplicationModel stApplicationModel) {
        this.application = stApplicationModel;
    }

    public StView view() {
        return this.view;
    }

    public void view_(StView stView) {
        this.view = stView;
    }

    public StMenuBarView menuBarView() {
        return this.menuBarView;
    }

    protected void menuBarView_(StMenuBarViewSwing stMenuBarViewSwing) {
        if (this.view() instanceof StViewSwing) {
            stMenuBarViewSwing.setLightWeightPopupEnabled(((StViewSwing)this.view()).isLightWeightPopupEnabled());
        }
        this.setJMenuBar(stMenuBarViewSwing.toMenuBar());
        this.pack();
        this.menuBarView = stMenuBarViewSwing;
    }

    public Window toWindow() {
        return this;
    }

    public Frame toFrame() {
        return this;
    }

    public void update_(DependentEvent dependentEvent) {
    }

    public boolean updateWindowTitle() {
        if (this.application() == null) {
            return false;
        }
        String string = this.application().windowTitle();
        if (string == null) {
            return false;
        }
        this.setTitle(string);
        return true;
    }

    public boolean updateMenuBar() {
        if (this.application() == null) {
            return false;
        }
        StMenuBar stMenuBar = this.application()._menuBar();
        if (stMenuBar == null) {
            return false;
        }
        this.menuBarView_((StMenuBarViewSwing)this.view()._createMenuBarView(stMenuBar));
        return true;
    }

    protected void buildWindow() {
        Serializable serializable;
        if (this.application() == null) {
            return;
        }
        if (this.view() == null) {
            return;
        }
        this.updateWindowTitle();
        this.updateMenuBar();
        Component component = this.view().toComponent();
        if (this.application()._viewOnBorderedPanel()) {
            serializable = StApplicationWindowSwing._PanelWithBorder();
            serializable.setLayout(new BorderLayout());
            serializable.add(component, "Center");
            component = serializable;
        }
        this.getContentPane().add(component);
        this.pack();
        this.setDefaultCloseOperation(0);
        serializable = this.getInsets();
        Dimension dimension = this.view().toComponent().getPreferredSize();
        this.setSize(dimension.width + ((Insets)serializable).left + ((Insets)serializable).right, dimension.height + ((Insets)serializable).top + ((Insets)serializable).bottom);
        if (!this.application().windowResizable()) {
            this.setResizable(false);
        }
    }

    public static JPanel _PanelWithBorder() {
        JPanel jPanel = new JPanel(){

            public void paint(Graphics graphics) {
                this.paintChildren(graphics);
                this.paintBorder(graphics);
            }
        };
        jPanel.setBorder(new Border(){

            public Insets getBorderInsets(Component component) {
                return new Insets(2, 2, 2, 2);
            }

            public boolean isBorderOpaque() {
                return false;
            }

            public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
                graphics.setColor(Color.black);
                graphics.drawLine(1, 1, n3 - 3, 1);
                graphics.drawLine(1, 1, 1, n4 - 3);
                graphics.setColor(Color.gray);
                graphics.drawLine(0, 0, n3 - 2, 0);
                graphics.drawLine(0, 0, 0, n4 - 2);
                graphics.setColor(Color.lightGray);
                graphics.drawLine(1, n4 - 2, n3 - 2, n4 - 2);
                graphics.drawLine(n3 - 2, 1, n3 - 2, n4 - 2);
                graphics.setColor(Color.white);
                graphics.drawLine(0, n4 - 1, n3 - 1, n4 - 1);
                graphics.drawLine(n3 - 1, 0, n3 - 1, n4 - 1);
            }
        });
        return jPanel;
    }
}

