/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.qt4jun;

import java.awt.Dimension;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.WritableRaster;
import java.io.File;
import jp.co.sra.qt4jun.JunQTJPort;
import jp.co.sra.qt4jun.JunQTMovie;
import jp.co.sra.qt4jun.JunQTPort;
import quicktime.QTException;
import quicktime.QTSession;
import quicktime.io.OpenMovieFile;
import quicktime.io.QTFile;
import quicktime.qd.Pict;
import quicktime.qd.PixMap;
import quicktime.qd.QDGraphics;
import quicktime.qd.QDRect;
import quicktime.std.StdQTException;
import quicktime.std.movies.Movie;
import quicktime.std.movies.TimeInfo;
import quicktime.util.EndianOrder;
import quicktime.util.RawEncodedImage;

public class JunQTJMovie
implements JunQTMovie {
    protected Movie movie;

    static boolean canGetMovieFile() {
        return true;
    }

    static String getMovieFile() {
        QTFile qTFile;
        try {
            qTFile = QTFile.standardGetFilePreview((int[])QTFile.kStandardQTFileTypes);
        }
        catch (QTException qTException) {
            if (qTException.errorCode() == -128) {
                return null;
            }
            throw new Error(qTException.getMessage());
        }
        if (qTFile != null) {
            return qTFile.getPath();
        }
        return null;
    }

    static JunQTMovie openMovie(String string) {
        Movie movie;
        try {
            QTFile qTFile = new QTFile(string);
            OpenMovieFile openMovieFile = OpenMovieFile.asRead((QTFile)qTFile);
            movie = Movie.fromFile((OpenMovieFile)openMovieFile);
        }
        catch (QTException qTException) {
            throw new Error(qTException.getMessage());
        }
        if (movie != null) {
            return new JunQTJMovie(movie);
        }
        return null;
    }

    public JunQTJMovie(Movie movie) {
        this.movie = movie;
    }

    protected void finalize() {
        this.release();
    }

    public void release() {
        this.movie = null;
    }

    public void setActive(boolean bl) {
        try {
            this.movie.setActive(bl);
        }
        catch (StdQTException stdQTException) {
            throw new Error(stdQTException.getMessage());
        }
    }

    public Rectangle getBox() {
        QDRect qDRect;
        try {
            qDRect = this.movie.getBox();
        }
        catch (StdQTException stdQTException) {
            throw new Error(stdQTException.getMessage());
        }
        return new Rectangle(qDRect.getX(), qDRect.getY(), qDRect.getWidth(), qDRect.getHeight());
    }

    public void setBox(Rectangle rectangle) {
    }

    public int getDuration() {
        try {
            return this.movie.getDuration();
        }
        catch (StdQTException stdQTException) {
            throw new Error(stdQTException.getMessage());
        }
    }

    public int getNextInterestingTime(int n, int n2) {
        int[] nArray = new int[]{1702454643};
        try {
            TimeInfo timeInfo = this.movie.getNextInterestingTime(16, nArray, n, (float)n2);
            return timeInfo.time;
        }
        catch (StdQTException stdQTException) {
            throw new Error(stdQTException.getMessage());
        }
    }

    public void setSelection(int n, int n2) {
        try {
            this.movie.setSelection(n, n2);
        }
        catch (StdQTException stdQTException) {
            throw new Error(stdQTException.getMessage());
        }
    }

    public int getTimeScale() {
        try {
            return this.movie.getTimeScale();
        }
        catch (StdQTException stdQTException) {
            throw new Error(stdQTException.getMessage());
        }
    }

    public int getTimeValue() {
        try {
            return this.movie.getTime();
        }
        catch (StdQTException stdQTException) {
            throw new Error(stdQTException.getMessage());
        }
    }

    public void setTimeValue(int n) {
        try {
            this.movie.setTimeValue(n);
        }
        catch (StdQTException stdQTException) {
            throw new Error(stdQTException.getMessage());
        }
    }

    public double getVolume() {
        try {
            return this.movie.getVolume();
        }
        catch (StdQTException stdQTException) {
            throw new Error(stdQTException.getMessage());
        }
    }

    public void setVolume(double d) {
        try {
            this.movie.setVolume((float)d);
        }
        catch (StdQTException stdQTException) {
            throw new Error(stdQTException.getMessage());
        }
    }

    public Image getImageAt(int n, Dimension dimension) {
        try {
            Pict pict = this.movie.getPict(n);
            QDRect qDRect = new QDRect(0, 0, dimension.width, dimension.height);
            int n2 = QDGraphics.kDefaultPixelFormat;
            if (EndianOrder.isNativeLittleEndian()) {
                n2 = 1111970369;
            }
            QDGraphics qDGraphics = new QDGraphics(n2, qDRect);
            pict.draw(qDGraphics, qDRect);
            PixMap pixMap = qDGraphics.getPixMap();
            RawEncodedImage rawEncodedImage = pixMap.getPixelData();
            int n3 = pixMap.getRowBytes() / 4;
            int[] nArray = new int[n3 * dimension.height];
            rawEncodedImage.copyToArray(0, nArray, 0, nArray.length);
            ColorModel colorModel = ColorModel.getRGBdefault();
            WritableRaster writableRaster = colorModel.createCompatibleWritableRaster(dimension.width, dimension.height);
            BufferedImage bufferedImage = new BufferedImage(colorModel, writableRaster, false, null);
            bufferedImage.setRGB(0, 0, dimension.width, dimension.height, nArray, 0, n3);
            return bufferedImage;
        }
        catch (QTException qTException) {
            throw new Error(qTException.getMessage());
        }
    }

    public byte[] getSoundData(int n, int n2) {
        return null;
    }

    public JunQTMovie copySelection() {
        Movie movie;
        try {
            movie = this.movie.copySelection();
        }
        catch (QTException qTException) {
            throw new Error(qTException.getMessage());
        }
        if (movie != null) {
            return new JunQTJMovie(movie);
        }
        return null;
    }

    public void flattenToFile(File file) {
        try {
            QTFile qTFile = new QTFile(file);
            this.movie.flatten(1, qTFile, 1414942532, -1, -1879048192, -1, null);
        }
        catch (QTException qTException) {
            throw new Error(qTException.getMessage());
        }
    }

    public void goToBeginning() {
        try {
            this.movie.goToBeginning();
        }
        catch (StdQTException stdQTException) {
            throw new Error(stdQTException.getMessage());
        }
    }

    public void goToEnd() {
        try {
            this.movie.goToEnd();
        }
        catch (StdQTException stdQTException) {
            throw new Error(stdQTException.getMessage());
        }
    }

    public boolean isDone() {
        try {
            return this.movie.isDone();
        }
        catch (StdQTException stdQTException) {
            throw new Error(stdQTException.getMessage());
        }
    }

    public void start() {
        try {
            this.movie.start();
        }
        catch (StdQTException stdQTException) {
            throw new Error(stdQTException.getMessage());
        }
    }

    public void stop() {
        try {
            this.movie.stop();
        }
        catch (StdQTException stdQTException) {
            throw new Error(stdQTException.getMessage());
        }
    }

    public void task() {
    }

    public void update() {
        try {
            this.movie.update();
        }
        catch (StdQTException stdQTException) {
            throw new Error(stdQTException.getMessage());
        }
    }

    public void setPort(JunQTPort junQTPort) {
        ((JunQTJPort)junQTPort).setMovie(this.movie);
    }

    static {
        try {
            QTSession.open();
        }
        catch (QTException qTException) {
            throw new Error(qTException.getMessage());
        }
        String string = Integer.toHexString(QTSession.getQTVersion());
        System.out.println("JunQTJMovie: QuickTime version " + string);
    }
}

