/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.voronoi.twoD.diagram;

import java.awt.Point;
import java.io.IOException;
import java.io.Writer;
import jp.co.sra.jun.voronoi.twoD.diagram.JunVoronoi2dDot;
import jp.co.sra.jun.voronoi.twoD.diagram.JunVoronoi2dObject;
import jp.co.sra.jun.voronoi.twoD.diagram.JunVoronoi2dPoint;

public class JunVoronoi2dSide
extends JunVoronoi2dObject {
    protected JunVoronoi2dPoint from;
    protected JunVoronoi2dPoint to;
    protected JunVoronoi2dDot dot1;
    protected JunVoronoi2dDot dot2;

    public JunVoronoi2dSide(JunVoronoi2dPoint junVoronoi2dPoint, JunVoronoi2dPoint junVoronoi2dPoint2) {
        this.from_(junVoronoi2dPoint);
        this.to_(junVoronoi2dPoint2);
    }

    public JunVoronoi2dSide(Point point, Point point2) {
        this(new JunVoronoi2dPoint(point), new JunVoronoi2dPoint(point2));
    }

    protected void initialize() {
        super.initialize();
        this.from = null;
        this.to = null;
        this.dot1 = null;
        this.dot2 = null;
    }

    public JunVoronoi2dPoint from() {
        return this.from;
    }

    public void from_(JunVoronoi2dPoint junVoronoi2dPoint) {
        this.from = junVoronoi2dPoint;
    }

    public JunVoronoi2dPoint to() {
        return this.to;
    }

    public void to_(JunVoronoi2dPoint junVoronoi2dPoint) {
        this.to = junVoronoi2dPoint;
    }

    public JunVoronoi2dDot dot1() {
        return this.dot1;
    }

    public void dot1_(JunVoronoi2dDot junVoronoi2dDot) {
        this.dot1 = junVoronoi2dDot;
    }

    public JunVoronoi2dDot dot2() {
        return this.dot2;
    }

    public void dot2_(JunVoronoi2dDot junVoronoi2dDot) {
        this.dot2 = junVoronoi2dDot;
    }

    public JunVoronoi2dPoint intersectingPointWithSide_(JunVoronoi2dSide junVoronoi2dSide) {
        double d = this.from().x();
        double d2 = this.from().y();
        double d3 = this.to().x();
        double d4 = this.to().y();
        double d5 = junVoronoi2dSide.from().x();
        double d6 = junVoronoi2dSide.from().y();
        double d7 = junVoronoi2dSide.to().x();
        double d8 = junVoronoi2dSide.to().y();
        double d9 = d3 - d;
        double d10 = d4 - d2;
        double d11 = d7 - d5;
        double d12 = d8 - d6;
        double d13 = d5 - d;
        double d14 = d6 - d2;
        double d15 = d11 * d10 - d12 * d9;
        if (Math.abs(d15) < this.accuracy()) {
            return null;
        }
        double d16 = 1.0 / d15;
        double d17 = (d11 * d14 - d12 * d13) * d16;
        double d18 = (d9 * d14 - d10 * d13) * d16;
        if (d17 < 0.0 || 1.0 < d17 || d18 < 0.0 || 1.0 < d18) {
            return null;
        }
        double d19 = d + d9 * d17;
        double d20 = d2 + d10 * d17;
        return new JunVoronoi2dPoint(d19, d20);
    }

    public boolean isValid() {
        if (this.from == null || !this.from.isValid()) {
            return false;
        }
        if (this.to == null || !this.to.isValid()) {
            return false;
        }
        if (this.dot1 == null) {
            return false;
        }
        return this.dot2 != null;
    }

    public boolean isInvalid() {
        return !this.isValid();
    }

    public boolean isValid2() {
        if (this.from == null) {
            return false;
        }
        if (this.to == null) {
            return false;
        }
        if (this.dot1 == null) {
            return false;
        }
        return this.dot2 != null;
    }

    public void printOn_(Writer writer) throws IOException {
        writer.write("side ( ");
        this.from.printOn_(writer);
        writer.write(" , ");
        this.to.printOn_(writer);
        writer.write(" )");
    }
}

