/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.voronoi.twoD.diagram;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Random;
import javax.swing.JFrame;
import javax.swing.JPanel;
import jp.co.sra.jun.geometry.basic.Jun2dPoint;
import jp.co.sra.jun.geometry.basic.JunAngle;
import jp.co.sra.jun.geometry.surfaces.Jun2dCircle;
import jp.co.sra.jun.geometry.surfaces.Jun2dPolygon;
import jp.co.sra.jun.goodies.image.framework.JunImageDisplayModel;
import jp.co.sra.jun.goodies.utilities.JunImageUtility;
import jp.co.sra.jun.system.support.JunTestExamples;
import jp.co.sra.jun.voronoi.twoD.diagram.JunDelaunay2dDiagram;
import jp.co.sra.jun.voronoi.twoD.diagram.JunVoronoi2dDiagramTestExamples;
import jp.co.sra.smalltalk.StApplicationModel;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StColorValue;

public class JunDelaunay2dDiagramTestExamples
extends JunTestExamples {
    public static boolean Example1() {
        JunDelaunay2dDiagram junDelaunay2dDiagram = new JunDelaunay2dDiagram(200, 200);
        for (int i = 0; i < 50; ++i) {
            Jun2dPoint jun2dPoint = new Jun2dPoint(Math.random() * (double)junDelaunay2dDiagram.width(), Math.random() * (double)junDelaunay2dDiagram.height());
            junDelaunay2dDiagram.add_(jun2dPoint);
        }
        System.out.println("area: " + junDelaunay2dDiagram.area());
        junDelaunay2dDiagram.show();
        return true;
    }

    public static boolean Example2() {
        JunDelaunay2dDiagram junDelaunay2dDiagram = new JunDelaunay2dDiagram(200, 200);
        for (int i = 0; i < 50; ++i) {
            Jun2dPoint jun2dPoint = new Jun2dPoint(Math.random() * (double)junDelaunay2dDiagram.width(), Math.random() * (double)junDelaunay2dDiagram.height());
            junDelaunay2dDiagram.add_(jun2dPoint);
        }
        junDelaunay2dDiagram.show();
        junDelaunay2dDiagram.asVoronoiDiagram().show();
        System.out.println("area: " + junDelaunay2dDiagram.area());
        return true;
    }

    public static boolean Example3() {
        final JunDelaunay2dDiagram junDelaunay2dDiagram = new JunDelaunay2dDiagram(200, 200);
        final JPanel jPanel = new JPanel(){

            public void paint(Graphics graphics) {
                junDelaunay2dDiagram.displayOn_(graphics);
            }
        };
        jPanel.setPreferredSize(new Dimension(200, 200));
        JFrame jFrame = new JFrame();
        jFrame.setTitle(junDelaunay2dDiagram.labelString());
        jFrame.getContentPane().setLayout(new BorderLayout());
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                windowEvent.getWindow().dispose();
            }
        });
        jFrame.getContentPane().add(jPanel);
        jFrame.pack();
        StApplicationModel._ShowAtMousePoint((Window)jFrame);
        Thread thread = new Thread(){

            public void run() {
                while (jPanel.isShowing()) {
                    junDelaunay2dDiagram.add_(new Jun2dPoint(Math.random() * (double)junDelaunay2dDiagram.width(), Math.random() * (double)junDelaunay2dDiagram.height()));
                    jPanel.paintImmediately(jPanel.getBounds());
                    Thread.yield();
                }
            }
        };
        thread.setPriority(4);
        thread.start();
        return true;
    }

    public static boolean Example4() {
        JunDelaunay2dDiagram junDelaunay2dDiagram = new JunDelaunay2dDiagram(200, 200);
        Jun2dPoint[] jun2dPointArray = new Jun2dPoint[]{new Jun2dPoint(0.1, 0.1), new Jun2dPoint(0.1, 0.9), new Jun2dPoint(0.9, 0.1), new Jun2dPoint(0.9, 0.9), new Jun2dPoint(0.5, 0.5), new Jun2dPoint(0.1, 0.5), new Jun2dPoint(0.9, 0.5), new Jun2dPoint(0.5, 0.1), new Jun2dPoint(0.5, 0.9)};
        for (int i = 0; i < jun2dPointArray.length; ++i) {
            double d = jun2dPointArray[i].x() * (double)junDelaunay2dDiagram.width();
            double d2 = jun2dPointArray[i].y() * (double)junDelaunay2dDiagram.height();
            junDelaunay2dDiagram.add_(new Jun2dPoint(d, d2));
        }
        System.out.println("area: " + junDelaunay2dDiagram.area());
        junDelaunay2dDiagram.show();
        return true;
    }

    public static boolean Example5() {
        JunDelaunay2dDiagram junDelaunay2dDiagram = new JunDelaunay2dDiagram(200, 200);
        int n = 0;
        for (int i = 0; i <= 10; ++i) {
            for (int j = 0; j <= 10; ++j) {
                if (n % 2 == 0) {
                    double d = (double)j / 10.0 * (double)junDelaunay2dDiagram.width();
                    double d2 = (double)i / 10.0 * (double)junDelaunay2dDiagram.height();
                    junDelaunay2dDiagram.add_(new Jun2dPoint(d, d2));
                }
                ++n;
            }
        }
        System.out.println("area: " + junDelaunay2dDiagram.area());
        junDelaunay2dDiagram.show();
        return true;
    }

    public static boolean Example6() {
        JunDelaunay2dDiagram junDelaunay2dDiagram = new JunDelaunay2dDiagram(200, 200);
        ArrayList<Jun2dPoint> arrayList = new ArrayList<Jun2dPoint>();
        arrayList.add(new Jun2dPoint(0.0, 0.0));
        int n = 10;
        for (int i = 0; i <= 360; i += n) {
            JunAngle junAngle = JunAngle.FromDeg_(i);
            arrayList.add(new Jun2dPoint(junAngle.cos(), junAngle.sin()));
            junAngle = JunAngle.FromDeg_(i + n / 2);
            arrayList.add(new Jun2dPoint(junAngle.cos() * 0.5, junAngle.sin() * 0.5));
        }
        Jun2dPoint[] jun2dPointArray = arrayList.toArray(new Jun2dPoint[arrayList.size()]);
        for (int i = 0; i < jun2dPointArray.length; ++i) {
            double d = (jun2dPointArray[i].x() + 1.0) * (double)junDelaunay2dDiagram.width() / 2.0;
            double d2 = (jun2dPointArray[i].y() + 1.0) * (double)junDelaunay2dDiagram.height() / 2.0;
            junDelaunay2dDiagram.add_(new Jun2dPoint(d, d2));
        }
        System.out.println("area: " + junDelaunay2dDiagram.area());
        junDelaunay2dDiagram.show();
        return true;
    }

    public static boolean Example7() {
        return JunVoronoi2dDiagramTestExamples.Example7();
    }

    public static boolean Example8() {
        return JunVoronoi2dDiagramTestExamples.Example8();
    }

    public static boolean Example9() {
        JunDelaunay2dDiagram junDelaunay2dDiagram = new JunDelaunay2dDiagram(200, 200);
        junDelaunay2dDiagram.add_(new Jun2dPoint(50.0, 100.0));
        junDelaunay2dDiagram.add_(new Jun2dPoint(150.0, 100.0));
        System.out.println("area: " + junDelaunay2dDiagram.area());
        junDelaunay2dDiagram.show();
        return true;
    }

    public static boolean ExampleA() {
        Dimension dimension = new Dimension(200, 200);
        int n = 50;
        final Color color = StColorValue.Navy;
        final JunDelaunay2dDiagram junDelaunay2dDiagram = new JunDelaunay2dDiagram(dimension);
        BufferedImage bufferedImage = JunImageUtility.ImageExtent_(dimension);
        JunImageDisplayModel junImageDisplayModel = JunImageDisplayModel.Show_label_(bufferedImage, "Convex Hull");
        Random random = new Random();
        for (int i = 0; i < n; ++i) {
            junDelaunay2dDiagram.add_(new Jun2dPoint(random.nextDouble() * (double)dimension.width, random.nextDouble() * (double)dimension.height));
            bufferedImage = JunImageUtility.ImageExtent_displayBlock_(dimension, new StBlockClosure(){

                public Object value_(Object object) {
                    Graphics graphics = (Graphics)object;
                    junDelaunay2dDiagram.displayOn_(graphics);
                    Jun2dPolygon jun2dPolygon = junDelaunay2dDiagram.convexHull();
                    Jun2dPoint[] jun2dPointArray = jun2dPolygon.points();
                    int[] nArray = new int[jun2dPointArray.length + 1];
                    int[] nArray2 = new int[jun2dPointArray.length + 1];
                    for (int i = 0; i < jun2dPointArray.length; ++i) {
                        nArray[i] = (int)Math.round(jun2dPointArray[i].x());
                        nArray2[i] = (int)Math.round(jun2dPointArray[i].y());
                    }
                    nArray[nArray.length - 1] = (int)Math.round(jun2dPointArray[0].x());
                    nArray2[nArray2.length - 1] = (int)Math.round(jun2dPointArray[0].y());
                    graphics.setColor(color);
                    graphics.drawPolyline(nArray, nArray2, nArray.length);
                    return null;
                }
            });
            junImageDisplayModel.image_(bufferedImage);
            junImageDisplayModel.redisplay();
        }
        return true;
    }

    public static boolean ExampleB() {
        Dimension dimension = new Dimension(200, 200);
        int n = 50;
        final Color color = Color.blue;
        final Color color2 = Color.green;
        final Dimension dimension2 = new Dimension(3, 3);
        int n2 = (int)Math.ceil(new Jun2dPoint(0.0, 0.0).distance_(new Jun2dPoint(dimension.width, dimension.height)));
        Dimension dimension3 = new Dimension(n2, n2);
        final Point point = new Point((dimension3.width - dimension.width) / 2, (dimension3.height - dimension.height) / 2);
        Random random = new Random();
        final Jun2dPoint[] jun2dPointArray = new Jun2dPoint[n];
        JunDelaunay2dDiagram junDelaunay2dDiagram = new JunDelaunay2dDiagram(dimension);
        BufferedImage bufferedImage = JunImageUtility.ImageExtent_(dimension3);
        JunImageDisplayModel junImageDisplayModel = JunImageDisplayModel.Show_label_(bufferedImage, "Minimal Enclosing Circle");
        for (int i = 0; i < n; ++i) {
            Jun2dPoint jun2dPoint;
            jun2dPointArray[i] = jun2dPoint = new Jun2dPoint(random.nextDouble() * (double)dimension.width, random.nextDouble() * (double)dimension.height);
            junDelaunay2dDiagram.add_(jun2dPoint);
            final Jun2dCircle jun2dCircle = junDelaunay2dDiagram.minimalEnclosingCircle();
            bufferedImage = JunImageUtility.ImageExtent_displayBlock_(dimension3, new StBlockClosure(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object value_(Object object) {
                    Graphics2D graphics2D = (Graphics2D)((Graphics)object).create();
                    try {
                        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                        graphics2D.translate(point.x, point.y);
                        graphics2D.setColor(color);
                        for (int i = 0; i < jun2dPointArray.length && jun2dPointArray[i] != null; ++i) {
                            int n = (int)Math.round(jun2dPointArray[i].x() * 2.0 - 4.0 + 1.0) / 2;
                            int n2 = (int)Math.round(jun2dPointArray[i].y() * 2.0 - 4.0 + 1.0) / 2;
                            graphics2D.drawArc(n, n2, 4, 4, 0, 360);
                        }
                        graphics2D.setColor(color2);
                        graphics2D.drawArc((int)(jun2dCircle.center().x() - jun2dCircle.radius()), (int)(jun2dCircle.center().y() - jun2dCircle.radius()), (int)(jun2dCircle.radius() * 2.0), (int)(jun2dCircle.radius() * 2.0), 0, 360);
                        Rectangle rectangle = new Rectangle((int)(jun2dCircle.center().x() - (double)dimension2.width / 2.0), (int)(jun2dCircle.center().y() - (double)dimension2.height / 2.0), dimension2.width, dimension2.height);
                        graphics2D.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                    }
                    finally {
                        if (graphics2D != null) {
                            graphics2D.dispose();
                        }
                    }
                    return null;
                }
            });
            junImageDisplayModel.image_(bufferedImage);
            junImageDisplayModel.redisplay();
        }
        return true;
    }

    public static void main(String[] stringArray) {
        new JunDelaunay2dDiagramTestExamples();
    }
}

