/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.topology.graph;

import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.Writer;
import jp.co.sra.jun.geometry.basic.Jun2dPoint;
import jp.co.sra.jun.goodies.lisp.JunLispList;
import jp.co.sra.jun.goodies.tables.JunAttributeTable;
import jp.co.sra.jun.topology.graph.JunElementalStuff;
import jp.co.sra.smalltalk.StComposedText;
import jp.co.sra.smalltalk.StImage;
import jp.co.sra.smalltalk.StRectangle;
import jp.co.sra.smalltalk.StSymbol;

public class JunElementalNode
extends JunElementalStuff {
    protected static JunAttributeTable DefaultAttributes = new JunAttributeTable();
    protected static StSymbol[] AttributeSymbolsToReset = new StSymbol[]{JunElementalNode.$((String)"labelString"), JunElementalNode.$((String)"locationPoint"), JunElementalNode.$((String)"foregroundColor"), JunElementalNode.$((String)"backgroundColor"), JunElementalNode.$((String)"borderColor"), JunElementalNode.$((String)"borderWidth")};
    protected StImage visualObject;
    protected StRectangle boundingBox;

    public JunElementalNode() {
    }

    public JunElementalNode(JunLispList junLispList) {
        super(junLispList);
    }

    public JunElementalNode(String string) {
        this();
        this.setLabelString_(string);
    }

    protected void initialize() {
        super.initialize();
        this.flushVisualObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StImage visualObject() {
        if (this.visualObject == null) {
            Font font = StComposedText.DefaultFont();
            if (this.labelEmphasis()) {
                font = font.deriveFont(1);
            }
            StComposedText stComposedText = new StComposedText(this.labelString(), font);
            StRectangle stRectangle = new StRectangle(stComposedText.bounds());
            stRectangle = stRectangle.expandedBy_(new StRectangle(1, 1, 2, 2));
            stRectangle = stRectangle.expandedBy_(this.borderWidth());
            stRectangle = new StRectangle(0, 0, stRectangle.width(), stRectangle.height());
            StImage stImage = new StImage(stRectangle.width(), stRectangle.height());
            Graphics graphics = null;
            try {
                graphics = stImage.image().getGraphics();
                graphics.setColor(this.borderColor());
                graphics.fillRect(stRectangle.x(), stRectangle.y(), stRectangle.width(), stRectangle.height());
                stRectangle = stRectangle.insetBy_(this.borderWidth());
                graphics.setColor(this.backgroundColor());
                graphics.fillRect(stRectangle.x(), stRectangle.y(), stRectangle.width(), stRectangle.height());
                StRectangle stRectangle2 = new StRectangle(stComposedText.bounds());
                stRectangle2 = stRectangle2.align_with_(stRectangle2.center(), stRectangle.center());
                graphics.setColor(this.foregroundColor());
                stComposedText.displayOn_at_(graphics, stRectangle2.origin());
            }
            finally {
                if (graphics != null) {
                    graphics.dispose();
                }
            }
            this.visualObject = stImage;
        }
        return this.visualObject;
    }

    public StRectangle boundingBox() {
        if (this.boundingBox == null) {
            StRectangle stRectangle = new StRectangle(this.visualObject().bounds());
            this.boundingBox = stRectangle = stRectangle.align_with_(stRectangle.center(), this.locationPoint());
        }
        return this.boundingBox;
    }

    public int width() {
        return this.boundingBox().width();
    }

    public int height() {
        return this.boundingBox().height();
    }

    public Point origin() {
        return this.boundingBox().origin();
    }

    public void origin_(Point point) {
        StRectangle stRectangle = this.boundingBox();
        this.locationPoint_(stRectangle.align_with_(stRectangle.origin(), point).center());
    }

    public Point center() {
        return this.boundingBox().center();
    }

    public void center_(Point point) {
        StRectangle stRectangle = this.boundingBox();
        this.locationPoint_(stRectangle.align_with_(stRectangle.center(), point).center());
    }

    protected StSymbol[] attributeSymbolsToReset() {
        return AttributeSymbolsToReset;
    }

    public void flushVisualObject() {
        this.visualObject = null;
        this.flushBoundingBox();
    }

    protected void flushBoundingBox() {
        this.boundingBox = null;
    }

    protected JunAttributeTable defaultAttributes() {
        return DefaultAttributes;
    }

    public void printOn_(Writer writer) throws IOException {
        writer.write("node(");
        writer.write(this.labelString());
        writer.write(41);
    }

    public void displayOn_at_(Graphics graphics, Point point) {
        StRectangle stRectangle = this.boundingBox().translatedBy_(point.x, point.y);
        Rectangle rectangle = graphics.getClipBounds();
        if (rectangle == null || stRectangle.toRectangle().intersects(rectangle)) {
            this.visualObject().displayOn_at_(graphics, stRectangle.origin());
        }
    }

    public void displayOn_at_scaledBy_(Graphics graphics, Point point, Jun2dPoint jun2dPoint) {
        Rectangle rectangle;
        StRectangle stRectangle = this.boundingBox().translatedBy_(point.x, point.y);
        if ((stRectangle = stRectangle.scaledBy_(jun2dPoint.x(), jun2dPoint.y())).area() <= 0) {
            stRectangle = stRectangle.expandedBy_(new StRectangle(0, 0, 1, 1));
        }
        if ((rectangle = graphics.getClipBounds()) == null || stRectangle.toRectangle().intersects(rectangle)) {
            graphics.setColor(this.backgroundColor());
            graphics.fillRect(stRectangle.x(), stRectangle.y(), stRectangle.width(), stRectangle.height());
            stRectangle = stRectangle.insetBy_(new StRectangle(0, 0, 1, 1));
            graphics.setColor(this.borderColor());
            graphics.drawRect(stRectangle.x(), stRectangle.y(), stRectangle.width(), stRectangle.height());
        }
    }
}

