/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.topology.elements;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Vector;
import jp.co.sra.jun.geometry.abstracts.JunCurve;
import jp.co.sra.jun.geometry.abstracts.JunSurface;
import jp.co.sra.jun.geometry.basic.Jun2dPoint;
import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.boundaries.Jun2dPolygonalBoundary;
import jp.co.sra.jun.geometry.boundaries.Jun3dBoundingBox;
import jp.co.sra.jun.geometry.curves.Jun3dLine;
import jp.co.sra.jun.geometry.curves.JunNurbsCurve;
import jp.co.sra.jun.geometry.surfaces.Jun2dPolygon;
import jp.co.sra.jun.geometry.surfaces.Jun3dPolygon;
import jp.co.sra.jun.geometry.surfaces.JunNurbsSurface;
import jp.co.sra.jun.goodies.lisp.JunLispCons;
import jp.co.sra.jun.goodies.lisp.JunLispList;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dCompoundObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;
import jp.co.sra.jun.opengl.support.JunOpenGLRenderingContext;
import jp.co.sra.jun.topology.abstracts.JunTopologicalElement;
import jp.co.sra.jun.topology.abstracts.JunTopologicalElementProxy;
import jp.co.sra.jun.topology.elements.JunBody;
import jp.co.sra.jun.topology.elements.JunEdge;
import jp.co.sra.jun.topology.elements.JunLoopProxy;
import jp.co.sra.jun.topology.elements.JunVertex;
import jp.co.sra.smalltalk.SmalltalkException;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StValueHolder;

public class JunLoop
extends JunTopologicalElement {
    protected JunEdge edge;
    protected JunLoop parentLoop;
    protected JunLoop childLoop;
    protected JunSurface surface;

    public static final JunLoop Edge_(JunEdge junEdge) {
        JunLoop junLoop = new JunLoop();
        junLoop.edge_(junEdge);
        return junLoop;
    }

    public JunLoop addChildLoop_(JunLoop junLoop) {
        if (this.isChildLoop()) {
            throw SmalltalkException.Error((String)"should not be a child loop.");
        }
        junLoop.parentLoop_(this);
        junLoop.childLoop_(this.childLoop());
        this.childLoop = junLoop;
        return junLoop;
    }

    public JunOpenGL3dObject asJunOpenGL3dObject() {
        JunSurface junSurface = this.surface();
        if (junSurface == null) {
            return null;
        }
        if (!(junSurface instanceof Jun3dPolygon)) {
            return null;
        }
        final Jun3dPolygon jun3dPolygon = (Jun3dPolygon)junSurface;
        if (!this.hasChildLoop()) {
            return jun3dPolygon.asJunOpenGL3dObject();
        }
        Jun2dPolygon jun2dPolygon = jun3dPolygon.parameterPolygon();
        final Jun2dPolygonalBoundary jun2dPolygonalBoundary = new Jun2dPolygonalBoundary();
        jun2dPolygonalBoundary.addPolygon_(jun2dPolygon);
        this.childLoopsDo_(new StBlockClosure(){

            public Object value_(Object object) {
                JunLoop junLoop = (JunLoop)object;
                Vector<Jun2dPoint> vector = new Vector<Jun2dPoint>();
                Jun3dPoint[] jun3dPointArray = junLoop.points();
                for (int i = 0; i < jun3dPointArray.length; ++i) {
                    vector.addElement(jun3dPolygon.parameterPointAtPoint_(jun3dPointArray[i]));
                }
                jun2dPolygonalBoundary.addHole_(new Jun2dPolygon(vector));
                return null;
            }
        });
        Jun2dPolygon[] jun2dPolygonArray = jun2dPolygonalBoundary.asArrayOfPolygons();
        if (jun2dPolygonArray.length == 1) {
            Jun3dPolygon jun3dPolygon2 = Jun3dPolygon.Origin_uVector_vVector_parameterPolygon_(jun3dPolygon.origin(), jun3dPolygon.uVector(), jun3dPolygon.vVector(), jun2dPolygonArray[0]);
            return jun3dPolygon2.asJunOpenGL3dObject();
        }
        JunOpenGL3dCompoundObject junOpenGL3dCompoundObject = new JunOpenGL3dCompoundObject();
        for (int i = 0; i < jun2dPolygonArray.length; ++i) {
            Jun3dPolygon jun3dPolygon3 = Jun3dPolygon.Origin_uVector_vVector_parameterPolygon_(jun3dPolygon.origin(), jun3dPolygon.uVector(), jun3dPolygon.vVector(), jun2dPolygonArray[i]);
            junOpenGL3dCompoundObject.add_(jun3dPolygon3.asJunOpenGL3dObject());
        }
        return junOpenGL3dCompoundObject;
    }

    public JunLoopProxy asProxyIn_(JunBody junBody) {
        return (JunLoopProxy)this.asProxyIn_advise_(junBody, null);
    }

    public JunTopologicalElementProxy asProxyIn_advise_(JunBody junBody, JunTopologicalElementProxy junTopologicalElementProxy) {
        JunLoopProxy junLoopProxy = (JunLoopProxy)junBody.proxyForLoop_(this);
        if (junLoopProxy != null) {
            return junLoopProxy;
        }
        return junBody.addLoop_as_(this, (JunLoopProxy)junTopologicalElementProxy);
    }

    public JunOpenGL3dObject asWireframedOpenGL3dObject() {
        final JunOpenGL3dCompoundObject junOpenGL3dCompoundObject = new JunOpenGL3dCompoundObject();
        this.edgesDo_(new StBlockClosure(){

            public Object value_(Object object) {
                JunEdge junEdge = (JunEdge)object;
                JunCurve junCurve = junEdge.curve();
                if (junCurve instanceof Jun3dLine) {
                    junOpenGL3dCompoundObject.add_(((Jun3dLine)junCurve).asJunOpenGL3dObject());
                } else if (junCurve instanceof JunNurbsCurve) {
                    junOpenGL3dCompoundObject.add_(((JunNurbsCurve)junCurve).asJunOpenGL3dObject());
                }
                return null;
            }
        });
        return junOpenGL3dCompoundObject;
    }

    public final JunSurface basicSurface() {
        return this.surface;
    }

    public Jun3dBoundingBox boundingBox() {
        return ((Jun3dPolygon)this.surface()).boundingBox();
    }

    public final JunLoop childLoop() {
        return this.childLoop;
    }

    public final void childLoop_(JunLoop junLoop) {
        this.childLoop = junLoop;
    }

    public JunLoop[] childLoops() {
        final Vector vector = new Vector();
        this.childLoopsDo_(new StBlockClosure(){

            public Object value_(Object object) {
                vector.addElement(object);
                return null;
            }
        });
        Object[] objectArray = new JunLoop[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public Object childLoopsDo_(StBlockClosure stBlockClosure) {
        if (this.isChildLoop()) {
            throw SmalltalkException.Error((String)"should not be a child loop.");
        }
        JunLoop junLoop = this.childLoop();
        while (junLoop != null) {
            JunLoop junLoop2 = junLoop.childLoop();
            Object object = stBlockClosure.value_((Object)junLoop);
            if (object != null) {
                return object;
            }
            junLoop = junLoop2;
        }
        return null;
    }

    public JunEdge detectEdge_ifNone_(final StBlockClosure stBlockClosure, StBlockClosure stBlockClosure2) {
        Object object = this.edgesDo_(new StBlockClosure(){

            public Object value_(Object object) {
                if (((Boolean)stBlockClosure.value_(object)).booleanValue()) {
                    return object;
                }
                return null;
            }
        });
        return (JunEdge)(object != null ? object : stBlockClosure2.value());
    }

    public JunVertex detectVertex_ifNone_(final StBlockClosure stBlockClosure, StBlockClosure stBlockClosure2) {
        Object object = this.vertexEdgeVertexDo_(new StBlockClosure(){

            public Object value_value_value_(Object object, Object object2, Object object3) {
                if (((Boolean)stBlockClosure.value_(object)).booleanValue()) {
                    return object;
                }
                return null;
            }
        });
        return (JunVertex)(object != null ? object : stBlockClosure2.value());
    }

    public final JunEdge edge() {
        return this.edge;
    }

    public final void edge_(JunEdge junEdge) {
        this.edge = junEdge;
    }

    public JunEdge edgeForVertex_and_(final JunVertex junVertex, final JunVertex junVertex2) {
        return (JunEdge)this.vertexEdgeVertexDo_(new StBlockClosure(){

            public Object value_value_value_(Object object, Object object2, Object object3) {
                if (object == junVertex && object3 == junVertex2 || object == junVertex2 && object3 == junVertex) {
                    return object2;
                }
                return null;
            }
        });
    }

    public JunEdge edgeFromVertex_(final JunVertex junVertex) {
        return (JunEdge)this.vertexEdgeVertexDo_(new StBlockClosure(){

            public Object value_value_value_(Object object, Object object2, Object object3) {
                if (object == junVertex) {
                    return object2;
                }
                return null;
            }
        });
    }

    public JunEdge[] edges() {
        final Vector vector = new Vector(this.numberOfEdges());
        this.edgesDo_(new StBlockClosure(){

            public Object value_(Object object) {
                vector.addElement(object);
                return null;
            }
        });
        Object[] objectArray = new JunEdge[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public Object edgesDo_(final StBlockClosure stBlockClosure) {
        return this.vertexEdgeVertexDo_(new StBlockClosure(){

            public Object value_value_value_(Object object, Object object2, Object object3) {
                return stBlockClosure.value_(object2);
            }
        });
    }

    public Object edgesWhileTrue_do_(final StBlockClosure stBlockClosure, final StBlockClosure stBlockClosure2) {
        final JunLoop junLoop = this;
        return this.edgesDo_(new StBlockClosure(){

            public Object value_(Object object) {
                if (!((Boolean)stBlockClosure.value_(object)).booleanValue()) {
                    return junLoop;
                }
                stBlockClosure2.value_(object);
                return null;
            }
        });
    }

    public JunEdge edgeToVertex_(final JunVertex junVertex) {
        StBlockClosure stBlockClosure = new StBlockClosure(){

            public Object value_value_value_(Object object, Object object2, Object object3) {
                if (junVertex == object3) {
                    return object2;
                }
                return null;
            }
        };
        return (JunEdge)this.edge().onLoop_vertexEdgeVertexDo_(this, stBlockClosure);
    }

    public JunEdge firstEdge() {
        return this.edge();
    }

    public JunVertex firstVertex() {
        JunEdge junEdge = this.firstEdge();
        return junEdge.oppositeVertexOfVertex_(junEdge.directionVertexOnLoop_(this));
    }

    public void forget() {
        if (this.isChildLoop()) {
            throw SmalltalkException.Error((String)"should not be a child loop.");
        }
        this.detouchFromParentChildReference();
        this.edge = null;
        this.parentLoop = null;
        this.childLoop = null;
        this.surface = null;
    }

    public void fromLispList_forLoops_edges_vertexes_(JunLispCons junLispCons, final JunLoop[] junLoopArray, final JunEdge[] junEdgeArray, JunVertex[] junVertexArray) {
        final JunLoop junLoop = this;
        ((JunLispCons)((Object)junLispCons.tail())).do_(new StBlockClosure(){

            public Object value_(Object object) {
                JunLispCons junLispCons = (JunLispCons)((Object)object);
                if (junLispCons.head() == 12.$((String)"edge")) {
                    JunLoop.this.edge = junEdgeArray[(Integer)junLispCons.tail() - 1];
                }
                if (junLispCons.head() == 12.$((String)"parentLoop")) {
                    JunLoop.this.parentLoop = junLispCons.tail() == JunLispList.NullList() ? null : junLoopArray[(Integer)junLispCons.tail() - 1];
                }
                if (junLispCons.head() == 12.$((String)"childLoop")) {
                    JunLoop.this.childLoop = junLispCons.tail() == JunLispList.NullList() ? null : junLoopArray[(Integer)junLispCons.tail() - 1];
                }
                if (junLispCons.head() == 12.$((String)"surface")) {
                    JunLoop.this.surface = junLispCons.tail() == JunLispList.NullList() ? null : junLoop.surfaceFromList_((JunLispList)((Object)junLispCons.tail()));
                }
                return null;
            }
        });
    }

    public boolean hasChildLoop() {
        return this.isParentLoop() && this.childLoop != null;
    }

    public boolean includesEdge_(final JunEdge junEdge) {
        Object object = this.edgesDo_(new StBlockClosure(){

            public Object value_(Object object) {
                if (object == junEdge) {
                    return Boolean.TRUE;
                }
                return null;
            }
        });
        return object != null;
    }

    public boolean includesPathFrom_to_(final JunVertex junVertex, final JunVertex junVertex2) {
        Object object = this.vertexEdgeVertexDo_(new StBlockClosure(){

            public Object value_value_value_(Object object, Object object2, Object object3) {
                if (object == junVertex && object3 == junVertex2) {
                    return Boolean.TRUE;
                }
                return null;
            }
        });
        return object != null;
    }

    public boolean includesVertex_(final JunVertex junVertex) {
        Object object = this.vertexesDo_(new StBlockClosure(){

            public Object value_(Object object) {
                if (object == junVertex) {
                    return Boolean.TRUE;
                }
                return null;
            }
        });
        return object != null;
    }

    public boolean isChildLoop() {
        return !this.isParentLoop();
    }

    public boolean isKilled() {
        return this.edge == null;
    }

    public boolean isParentLoop() {
        return this.parentLoop() == null;
    }

    public void neighborLoopsDo_(final StBlockClosure stBlockClosure) {
        final JunLoop junLoop = this;
        this.edgesDo_(new StBlockClosure(){

            public Object value_(Object object) {
                JunEdge junEdge = (JunEdge)object;
                JunLoop junLoop2 = junEdge.oppositeLoopOfLoop_(junLoop);
                if (junLoop != junLoop2) {
                    stBlockClosure.value_((Object)junLoop2);
                }
                return null;
            }
        });
    }

    public JunLoop neighborLoopWithVertex_(JunVertex junVertex) {
        final JunLoop junLoop = this;
        return (JunLoop)junVertex.loopsDo_(new StBlockClosure(){

            public Object value_(Object object) {
                if (object != junLoop) {
                    return object;
                }
                return null;
            }
        });
    }

    public JunVertex nextVertexOfVertex_(final JunVertex junVertex) {
        return (JunVertex)this.edge().onLoop_vertexEdgeVertexDo_(this, new StBlockClosure(){

            public Object value_value_value_(Object object, Object object2, Object object3) {
                if (junVertex == object) {
                    return object3;
                }
                return null;
            }
        });
    }

    public int numberOfChildLoops() {
        final StValueHolder stValueHolder = new StValueHolder(0);
        if (!this.isChildLoop()) {
            this.childLoopsDo_(new StBlockClosure(){

                public Object value_(Object object) {
                    stValueHolder.value_(stValueHolder._intValue() + 1);
                    return null;
                }
            });
        }
        return stValueHolder._intValue();
    }

    public int numberOfEdges() {
        final StValueHolder stValueHolder = new StValueHolder(0);
        this.vertexEdgeVertexDo_(new StBlockClosure(){

            public Object value_value_value_(Object object, Object object2, Object object3) {
                stValueHolder.value_(stValueHolder._intValue() + 1);
                return null;
            }
        });
        return stValueHolder._intValue();
    }

    public int numberOfVertexes() {
        final StValueHolder stValueHolder = new StValueHolder(0);
        this.vertexEdgeVertexDo_(new StBlockClosure(){

            public Object value_value_value_(Object object, Object object2, Object object3) {
                stValueHolder.value_(stValueHolder._intValue() + 1);
                return null;
            }
        });
        return stValueHolder._intValue();
    }

    public final JunLoop parentLoop() {
        return this.parentLoop;
    }

    public final void parentLoop_(JunLoop junLoop) {
        this.parentLoop = junLoop;
    }

    public Jun3dPoint[] points() {
        final Vector vector = new Vector();
        this.pointsDo_(new StBlockClosure(){

            public Object value_(Object object) {
                vector.addElement(object);
                return null;
            }
        });
        Jun3dPoint[] jun3dPointArray = new Jun3dPoint[vector.size()];
        vector.copyInto((Object[])jun3dPointArray);
        return jun3dPointArray;
    }

    public void pointsDo_(final StBlockClosure stBlockClosure) {
        StBlockClosure stBlockClosure2 = new StBlockClosure(){

            public Object value_value_value_(Object object, Object object2, Object object3) {
                stBlockClosure.value_((Object)((JunVertex)object).point());
                return null;
            }
        };
        this.vertexEdgeVertexDo_(stBlockClosure2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printOn_(Writer writer) throws IOException {
        final BufferedWriter bufferedWriter = writer instanceof BufferedWriter ? (BufferedWriter)writer : new BufferedWriter(writer);
        try {
            bufferedWriter.write("Loop (");
            if (this.edge() != null) {
                this.vertexEdgeVertexDo_(new StBlockClosure(){

                    public Object value_value_value_(Object object, Object object2, Object object3) {
                        try {
                            bufferedWriter.newLine();
                            ((JunVertex)object).printOn_(bufferedWriter);
                            bufferedWriter.write("->");
                            ((JunVertex)object3).printOn_(bufferedWriter);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        return null;
                    }
                });
            } else {
                bufferedWriter.write("removed");
            }
            bufferedWriter.write(41);
        }
        finally {
            bufferedWriter.flush();
        }
    }

    public void removeChildLoop_(final JunLoop junLoop) {
        if (this.isChildLoop()) {
            throw SmalltalkException.Error((String)"should not be a child loop.");
        }
        junLoop.parentLoop_(null);
        if (this.childLoop() == junLoop) {
            this.childLoop_(junLoop.childLoop());
            junLoop.childLoop_(null);
            return;
        }
        Object object = this.childLoopsDo_(new StBlockClosure(){

            public Object value_(Object object) {
                JunLoop junLoop2 = (JunLoop)object;
                if (junLoop2.childLoop() == junLoop) {
                    junLoop2.childLoop_(junLoop.childLoop());
                    junLoop.childLoop_(null);
                    return junLoop;
                }
                return null;
            }
        });
        if (object == null) {
            throw SmalltalkException.Error((String)"internal error");
        }
    }

    public void renderOn_(JunOpenGLRenderingContext junOpenGLRenderingContext) {
        ((JunNurbsSurface)this.surface()).renderOn_(junOpenGLRenderingContext);
    }

    public void repatch() {
        if (this.basicSurface() == null) {
            return;
        }
        this.surface_(null);
    }

    public final void setSurface_(JunSurface junSurface) {
        this.surface = junSurface;
    }

    public JunSurface surface() {
        JunSurface junSurface = this.basicSurface();
        if (junSurface != null) {
            return junSurface;
        }
        return this.defaultSurface();
    }

    public final void surface_(JunSurface junSurface) {
        this.surface = junSurface;
    }

    public JunSurface surfaceFromList_(JunLispList junLispList) {
        throw SmalltalkException.ShouldNotImplement();
    }

    public void surroundingEdgesDo_(final StBlockClosure stBlockClosure) {
        this.edgesDo_(stBlockClosure);
        this.childLoopsDo_(new StBlockClosure(){

            public Object value_(Object object) {
                ((JunLoop)object).edgesDo_(stBlockClosure);
                return null;
            }
        });
    }

    public JunLispList toLispListForLoops_edges_vertexes_(JunLoop[] junLoopArray, JunEdge[] junEdgeArray, JunVertex[] junVertexArray) {
        int n;
        int n2 = -1;
        int n3 = -1;
        for (n = 0; n < junEdgeArray.length && junEdgeArray[n] != this.edge; ++n) {
        }
        for (int i = 0; i < junLoopArray.length; ++i) {
            if (junLoopArray[i] == this.parentLoop) {
                n2 = i;
            }
            if (junLoopArray[i] != this.childLoop) continue;
            n3 = i;
        }
        JunLispCons junLispCons = this.lispCons();
        junLispCons.head_(this.kindName());
        junLispCons.add_((Object)JunLispCons.Head_tail_(JunLoop.$((String)"edge"), new Integer(n + 1)));
        junLispCons.add_((Object)JunLispCons.Head_tail_(JunLoop.$((String)"parentLoop"), this.parentLoop == null ? this.lispNil() : new Integer(n2 + 1)));
        junLispCons.add_((Object)JunLispCons.Head_tail_(JunLoop.$((String)"childLoop"), this.childLoop == null ? this.lispNil() : new Integer(n3 + 1)));
        junLispCons.add_((Object)JunLispCons.Head_tail_(JunLoop.$((String)"surface"), (Object)this.lispNil()));
        return junLispCons;
    }

    public JunVertex vertex() {
        return this.edge().startVertex();
    }

    public Object vertexEdgeVertexDo_(StBlockClosure stBlockClosure) {
        JunVertex junVertex;
        JunEdge junEdge;
        JunEdge junEdge2 = junEdge = this.firstEdge();
        JunVertex junVertex2 = junVertex = this.firstVertex();
        while (junEdge2 != null) {
            JunVertex junVertex3 = junEdge2.oppositeVertexOfVertex_(junVertex2);
            Object object = stBlockClosure.value_value_value_((Object)junVertex2, (Object)junEdge2, (Object)junVertex3);
            if (object != null) {
                return object;
            }
            junVertex2 = junVertex3;
            if (junEdge != (junEdge2 = junEdge2.nextEdgeWithVertex_(junVertex2)) || junVertex2 != junVertex) continue;
            return null;
        }
        return null;
    }

    public JunVertex[] vertexes() {
        final Vector vector = new Vector(this.numberOfVertexes());
        this.vertexesDo_(new StBlockClosure(){

            public Object value_(Object object) {
                vector.addElement(object);
                return null;
            }
        });
        Object[] objectArray = new JunVertex[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public Object vertexesDo_(final StBlockClosure stBlockClosure) {
        return this.vertexEdgeVertexDo_(new StBlockClosure(){

            public Object value_value_value_(Object object, Object object2, Object object3) {
                return stBlockClosure.value_(object);
            }
        });
    }

    protected JunSurface defaultSurface() {
        JunVertex[] junVertexArray = this.vertexes();
        Jun3dPoint[] jun3dPointArray = new Jun3dPoint[junVertexArray.length];
        for (int i = 0; i < junVertexArray.length; ++i) {
            jun3dPointArray[i] = junVertexArray[i].point();
        }
        return Jun3dPolygon.Vertexes_(jun3dPointArray);
    }

    private void detouchFromParentChildReference() {
        if (this.isChildLoop()) {
            this.parentLoop().removeChildLoop_(this);
        }
    }

    protected double volume() {
        JunVertex[] junVertexArray = this.vertexes();
        Jun3dPoint[] jun3dPointArray = new Jun3dPoint[junVertexArray.length];
        for (int i = 0; i < junVertexArray.length; ++i) {
            jun3dPointArray[i] = junVertexArray[i].point();
        }
        double d = Jun2dPolygon.SignedAreaForPoints_(jun3dPointArray);
        double d2 = 0.0;
        for (int i = 0; i < jun3dPointArray.length; ++i) {
            d2 += jun3dPointArray[i].z();
        }
        return d * d2 / (double)jun3dPointArray.length;
    }
}

