/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.terrain.editor;

import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import jp.co.sra.jun.delaunay.twoD.Jun2dDelaunayProcessor;
import jp.co.sra.jun.geometry.basic.Jun2dPoint;
import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.basic.JunAngle;
import jp.co.sra.jun.geometry.boundaries.Jun2dBoundingBox;
import jp.co.sra.jun.geometry.boundaries.JunBorderGenerator;
import jp.co.sra.jun.geometry.curves.Jun2dLine;
import jp.co.sra.jun.goodies.button.JunButtonModel;
import jp.co.sra.jun.goodies.cursors.JunCursors;
import jp.co.sra.jun.goodies.progress.JunCursorAnimator;
import jp.co.sra.jun.goodies.wheels.JunThumbWheel;
import jp.co.sra.jun.opengl.display.JunOpenGLDisplayModel;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dCompoundObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dPolyline;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dPolylineLoop;
import jp.co.sra.jun.opengl.projection.JunOpenGLProjection;
import jp.co.sra.jun.opengl.projection.JunOpenGLProjector;
import jp.co.sra.jun.system.framework.JunDialog;
import jp.co.sra.jun.terrain.display.JunTerrainDisplayModel;
import jp.co.sra.jun.terrain.editor.JunTerrainEditController;
import jp.co.sra.jun.terrain.editor.JunTerrainEditViewAwt;
import jp.co.sra.jun.terrain.editor.JunTerrainEditViewSwing;
import jp.co.sra.jun.terrain.support.JunTerrainField;
import jp.co.sra.jun.terrain.support.JunTerrainTriangle;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StInputState;
import jp.co.sra.smalltalk.StInterval;
import jp.co.sra.smalltalk.StObject;
import jp.co.sra.smalltalk.StSymbol;
import jp.co.sra.smalltalk.StView;
import jp.co.sra.smalltalk.menu.MenuListener;
import jp.co.sra.smalltalk.menu.MenuPerformer;
import jp.co.sra.smalltalk.menu.StMenu;
import jp.co.sra.smalltalk.menu.StMenuBar;
import jp.co.sra.smalltalk.menu.StMenuItem;

public class JunTerrainEditModel
extends JunOpenGLDisplayModel {
    protected ArrayList peaks;
    protected Jun3dPoint[][] contours;
    protected double contourStep;
    protected double contourGrid;
    protected JunTerrainField terrainField;
    protected Jun2dBoundingBox mapBounds;
    protected Jun2dPoint sight;
    protected double zoomHeight;

    protected void initialize() {
        super.initialize();
        this.peaks = new ArrayList();
        this.contours = null;
        this.contourStep = Double.NaN;
        this.contourGrid = Double.NaN;
        this.terrainField = null;
        this.mapBounds = null;
        this.sight = null;
        this.zoomHeight = Double.NaN;
    }

    public Jun3dPoint[] peaks() {
        return this.peaks.toArray(new Jun3dPoint[this.peaks.size()]);
    }

    public Jun3dPoint[][] contours() {
        if (this.contours == null) {
            this.contours = this.computeContours();
        }
        return this.contours;
    }

    public double contourStep() {
        if (Double.isNaN(this.contourStep)) {
            this.contourStep = this.defaultContourStep();
        }
        return this.contourStep;
    }

    public void contourStep_(double d) {
        this.contourStep = d;
        this.flushContours();
        this.changed();
    }

    public double contourGrid() {
        if (Double.isNaN(this.contourGrid)) {
            this.contourGrid = this.defaultContourGrid();
        }
        return this.contourGrid;
    }

    public void contourGrid_(double d) {
        this.contourGrid = d;
        this.flushContours();
        this.changed();
    }

    public JunTerrainField terrainField() {
        if (this.terrainField == null) {
            this.terrainField = this.computeTerrainField();
        }
        return this.terrainField;
    }

    public JunOpenGL3dObject displayObject() {
        if (this.openGL3dObject == null) {
            this.computeDisplayObject();
        }
        return this.openGL3dObject;
    }

    public JunOpenGLProjection displayProjection() {
        return this.displayProjector().projection();
    }

    public JunOpenGLProjector displayProjector() {
        if (this.openGLProjector == null) {
            this.openGLProjector = new JunOpenGLProjector();
            this.openGLProjector.parallelProjection();
            this.openGLProjector.sightPoint_(this.sightPoint());
            this.openGLProjector.eyePoint_(this.eyePoint());
            this.openGLProjector.upVector_(this.defaultUpVector());
            this.openGLProjector.viewFactor_(this.defaultViewFactor());
            this.openGLProjector.zoomHeight_(this.defaultZoomHeight());
        }
        return this.openGLProjector;
    }

    public Jun2dBoundingBox mapBounds() {
        if (this.mapBounds == null) {
            this.mapBounds = this.defaultMapBounds();
        }
        return this.mapBounds;
    }

    public Jun3dPoint addPeak_(Jun3dPoint jun3dPoint) {
        this.peaks.add(jun3dPoint);
        this.flushContours();
        this.updateProjection();
        this.updateDisplayObject();
        return jun3dPoint;
    }

    public JunButtonModel peakButton() {
        if (!this.pushButtons().containsKey(JunTerrainEditModel.$((String)"peak"))) {
            JunButtonModel junButtonModel = new JunButtonModel();
            junButtonModel.value_(false);
            junButtonModel.visual_(JunCursors.PeakCursorImage());
            junButtonModel.action_(this.peakButtonAction());
            this.pushButtons().put(JunTerrainEditModel.$((String)"peak"), junButtonModel);
        }
        return (JunButtonModel)((Object)this.pushButtons().get(JunTerrainEditModel.$((String)"peak")));
    }

    protected StBlockClosure peakButtonAction() {
        return new StBlockClosure(){

            public Object value_(Object object) {
                JunButtonModel junButtonModel = (JunButtonModel)((Object)object);
                JunTerrainEditModel.this.setButtonState(1.$((String)"peak"), !junButtonModel.value());
                return null;
            }
        };
    }

    public JunButtonModel showButton() {
        if (!this.pushButtons().containsKey(JunTerrainEditModel.$((String)"show"))) {
            JunButtonModel junButtonModel = new JunButtonModel();
            junButtonModel.value_(false);
            junButtonModel.visual_(JunCursors.ReadCursorImage());
            junButtonModel.action_(this.showButtonAction());
            this.pushButtons().put(JunTerrainEditModel.$((String)"show"), junButtonModel);
        }
        return (JunButtonModel)((Object)this.pushButtons().get(JunTerrainEditModel.$((String)"show")));
    }

    protected StBlockClosure showButtonAction() {
        return new StBlockClosure(){

            public Object value_(Object object) {
                JunButtonModel junButtonModel = (JunButtonModel)((Object)object);
                JunTerrainEditModel.this.setButtonState(2.$((String)"show"), !junButtonModel.value());
                return null;
            }
        };
    }

    public StSymbol buttonState() {
        if (this.pushButtons().size() <= 3) {
            this.dragButton();
            this.peakButton();
            this.showButton();
        }
        return super.buttonState();
    }

    protected synchronized void setButtonState(StSymbol stSymbol, boolean bl) {
        super.setButtonState(stSymbol, bl);
    }

    public JunThumbWheel zThumbWheel() {
        JunThumbWheel junThumbWheel = new JunThumbWheel(true);
        junThumbWheel.compute_(new StBlockClosure(){

            public Object value_(Object object) {
                double d = 1.0 + ((Number)object).doubleValue() / 100.0;
                JunTerrainEditModel.this.zoom_(d);
                return null;
            }
        });
        return junThumbWheel;
    }

    public double defaultContourGrid() {
        return Math.min(this.mapBounds().width(), this.mapBounds().height()) / 20.0;
    }

    public double defaultContourStep() {
        return 10.0;
    }

    public Jun2dBoundingBox defaultMapBounds() {
        return Jun2dBoundingBox.Origin_corner_(new Jun2dPoint(-1000.0, -1000.0), new Jun2dPoint(1000.0, 1000.0));
    }

    public Jun2dPoint defaultSight() {
        return this.mapBounds().center();
    }

    public Jun3dPoint defaultUpVector() {
        return new Jun3dPoint(0.0, 1.0, 0.0);
    }

    public double defaultViewFactor() {
        return 10.0;
    }

    public double defaultZoomHeight() {
        return this.mapBounds().height() * 1.1;
    }

    public StView defaultView() {
        if (JunTerrainEditModel.GetDefaultViewMode() == 0) {
            return new JunTerrainEditViewAwt(this);
        }
        return new JunTerrainEditViewSwing(this);
    }

    protected String windowTitle() {
        return JunTerrainEditModel.$String((String)"Terrain Editor");
    }

    protected void drag_xy_(Jun2dPoint jun2dPoint, Jun2dPoint jun2dPoint2) {
        if (this.displayObject() == null) {
            return;
        }
        JunOpenGLProjection junOpenGLProjection = this.displayProjection();
        Jun3dPoint jun3dPoint = junOpenGLProjection.translateTo3dPointFromPoint_(jun2dPoint);
        Jun3dPoint jun3dPoint2 = junOpenGLProjection.translateTo3dPointFromPoint_(jun2dPoint2);
        Jun3dPoint jun3dPoint3 = jun3dPoint.minus_(jun3dPoint2);
        this.sight_(new Jun2dPoint(this.sight().x() + jun3dPoint3.x(), this.sight().y() + jun3dPoint3.y()));
    }

    protected void plotPeak_(JunTerrainEditController junTerrainEditController) {
        String string = JunDialog.Request_(JunTerrainEditModel.$String((String)"Input a peek height."), "100.0");
        if (string == null || string.length() == 0) {
            return;
        }
        try {
            double d = Double.parseDouble(string);
            Jun3dPoint jun3dPoint = this.mousePointFrom_(junTerrainEditController);
            this.addPeak_(new Jun3dPoint(jun3dPoint.x(), jun3dPoint.y(), d));
        }
        catch (NumberFormatException numberFormatException) {
            JunDialog.Warn_(string + JunTerrainEditModel.$String((String)" is invalid value."));
        }
    }

    protected JunTerrainDisplayModel showTerrain_(JunTerrainEditController junTerrainEditController) {
        Jun3dPoint jun3dPoint;
        JunAngle junAngle = JunAngle.FromDeg_(45.0);
        Jun2dLine jun2dLine = junTerrainEditController.mouse2dLineSegment();
        if (jun2dLine == null) {
            return null;
        }
        Jun3dPoint jun3dPoint2 = this.displayProjection().translateTo3dPointFromPoint_(jun2dLine.from());
        if (jun3dPoint2.distance_(jun3dPoint = this.displayProjection().translateTo3dPointFromPoint_(jun2dLine.to())) < -11.0) {
            return null;
        }
        JunTerrainDisplayModel junTerrainDisplayModel = new JunTerrainDisplayModel(this.terrainField());
        junTerrainDisplayModel.defaultZoomHeight_(jun3dPoint2.minus_(jun3dPoint).length() * junAngle.tan());
        junTerrainDisplayModel.defaultUpVector_(new Jun3dPoint(0.0, 0.0, 1.0));
        junTerrainDisplayModel.moveTo_sight_(new Jun2dPoint(jun3dPoint2.x(), jun3dPoint2.y()), new Jun2dPoint(jun3dPoint.x(), jun3dPoint.y()));
        JunOpenGLProjection junOpenGLProjection = junTerrainDisplayModel.displayProjection();
        junTerrainDisplayModel.defaultSightPoint_(junOpenGLProjection.sightPoint());
        junTerrainDisplayModel.defaultEyePoint_(junOpenGLProjection.eyePoint());
        junTerrainDisplayModel.open();
        return junTerrainDisplayModel;
    }

    public void zoom_(double d) {
        double d2 = d;
        if (StInputState.Default().shiftDown()) {
            d2 = d >= 1.0 ? 1.0 + (d - 1.0) * 0.1 : 1.0 - (1.0 - d) * 0.1;
        }
        this.zoomHeight_(this.zoomHeight() * d2);
    }

    public Jun3dPoint eyePoint() {
        return new Jun3dPoint(this.sight().x(), this.sight().y(), (this.topPeak() + 1.0) * 2.0);
    }

    public Jun2dPoint sight() {
        if (this.sight == null) {
            this.sight = this.defaultSight();
        }
        return this.sight;
    }

    public void sight_(Jun2dPoint jun2dPoint) {
        this.sight = jun2dPoint;
        this.updateProjection();
    }

    public Jun3dPoint sightPoint() {
        return new Jun3dPoint(this.sight().x(), this.sight().y(), 0.0);
    }

    public double zoomHeight() {
        if (Double.isNaN(this.zoomHeight)) {
            this.zoomHeight = this.defaultZoomHeight();
        }
        return this.zoomHeight;
    }

    public void zoomHeight_(double d) {
        this.zoomHeight = d;
        this.updateProjection();
    }

    public void fitSilently() {
    }

    public StMenuBar _menuBar() {
        if (this._menuBar == null) {
            this._menuBar = new StMenuBar();
            StMenu stMenu = new StMenu((Object)JunTerrainEditModel.$String((String)"Contours"));
            stMenu.add(new StMenuItem((Object)(JunTerrainEditModel.$String((String)"Grid") + "..."), (MenuListener)new MenuPerformer((StObject)this, "changeContourGrid")));
            stMenu.add(new StMenuItem((Object)(JunTerrainEditModel.$String((String)"Step") + "..."), (MenuListener)new MenuPerformer((StObject)this, "changeContourStep")));
            this._menuBar.add(stMenu);
            StMenu stMenu2 = new StMenu((Object)JunTerrainEditModel.$String((String)"View"));
            stMenu2.add(new StMenuItem((Object)JunTerrainEditModel.$String((String)"Center"), (MenuListener)new MenuPerformer((StObject)this, "sightCenter")));
            stMenu2.addSeparator();
            stMenu2.add(new StMenuItem((Object)JunTerrainEditModel.$String((String)"x 1"), (MenuListener)new MenuPerformer((StObject)this, "zoomX1")));
            stMenu2.add(new StMenuItem((Object)JunTerrainEditModel.$String((String)"x 2"), (MenuListener)new MenuPerformer((StObject)this, "zoomX2")));
            stMenu2.add(new StMenuItem((Object)JunTerrainEditModel.$String((String)"x 4"), (MenuListener)new MenuPerformer((StObject)this, "zoomX4")));
            stMenu2.add(new StMenuItem((Object)JunTerrainEditModel.$String((String)"x 8"), (MenuListener)new MenuPerformer((StObject)this, "zoomX8")));
            this._menuBar.add(stMenu2);
            StMenu stMenu3 = new StMenu((Object)JunTerrainEditModel.$String((String)"Misc"));
            stMenu3.add(new StMenuItem((Object)JunTerrainEditModel.$String((String)"Show terrain contour"), (MenuListener)new MenuPerformer((StObject)this, "showContour")));
            stMenu3.add(new StMenuItem((Object)JunTerrainEditModel.$String((String)"Show terrain field"), (MenuListener)new MenuPerformer((StObject)this, "showTerrainField")));
            this._menuBar.add(stMenu3);
        }
        return this._menuBar;
    }

    public void changeContourGrid() {
        String string = JunDialog.Request_(JunTerrainEditModel.$String((String)"Input a contour grid."), String.valueOf(this.contourGrid()));
        if (string == null) {
            return;
        }
        try {
            double d = Double.parseDouble(string);
            this.contourGrid_(d);
        }
        catch (NumberFormatException numberFormatException) {
            JunDialog.Warn_(string + JunTerrainEditModel.$String((String)" is invalid value."));
        }
    }

    public void changeContourStep() {
        String string = JunDialog.Request_(JunTerrainEditModel.$String((String)"Input a contour step."), String.valueOf(this.contourStep()));
        if (string == null) {
            return;
        }
        try {
            double d = Double.parseDouble(string);
            this.contourStep_(d);
        }
        catch (NumberFormatException numberFormatException) {
            JunDialog.Warn_(string + JunTerrainEditModel.$String((String)" is invalid value."));
        }
    }

    public void showContour() {
        this.displayObject().show();
    }

    public void showTerrainField() {
        JunOpenGL3dObject junOpenGL3dObject = this.terrainField().asJunOpenGL3dObject();
        junOpenGL3dObject.paint_(Color.green);
        junOpenGL3dObject.show();
    }

    public void sightCenter() {
        this.sight_(this.mapBounds().center());
    }

    public void zoomX1() {
        this.zoomHeight_(this.mapBounds().height() * 1.1);
    }

    public void zoomX2() {
        this.zoomHeight_(this.mapBounds().height() / 2.0 * 1.1);
    }

    public void zoomX4() {
        this.zoomHeight_(this.mapBounds().height() / 4.0 * 1.1);
    }

    public void zoomX8() {
        this.zoomHeight_(this.mapBounds().height() / 8.0 * 1.1);
    }

    public void updateMenuIndication() {
    }

    protected Jun3dPoint mousePointFrom_(JunTerrainEditController junTerrainEditController) {
        return this.displayProjection().translateTo3dPointFromPoint_(junTerrainEditController.mouse2dPoint());
    }

    protected Jun2dPoint regularizePoint_in_(Point point, Rectangle rectangle) {
        double d = ((double)point.x - (double)rectangle.width / 2.0) / ((double)rectangle.height / 2.0);
        double d2 = ((double)rectangle.height / 2.0 - (double)point.y) / ((double)rectangle.height / 2.0);
        return new Jun2dPoint(d, d2);
    }

    protected void computeDisplayObject() {
        ArrayList<JunOpenGL3dObject> arrayList = new ArrayList<JunOpenGL3dObject>();
        arrayList.add(this.mapBorderLine());
        Jun3dPoint[] jun3dPointArray = this.peaks();
        for (int i = 0; i < jun3dPointArray.length; ++i) {
            arrayList.add(this.peakMarkAt_(jun3dPointArray[i]));
        }
        Jun3dPoint[][] jun3dPointArray2 = this.contours();
        for (int i = 0; i < jun3dPointArray2.length; ++i) {
            arrayList.add(new JunOpenGL3dPolyline(jun3dPointArray2[i], Color.red));
        }
        this.openGL3dObject_(new JunOpenGL3dCompoundObject(arrayList));
    }

    protected JunOpenGL3dPolylineLoop mapBorderLine() {
        Jun2dBoundingBox jun2dBoundingBox = this.mapBounds();
        Jun2dPoint jun2dPoint = jun2dBoundingBox.origin();
        Jun2dPoint jun2dPoint2 = jun2dBoundingBox.corner();
        return new JunOpenGL3dPolylineLoop(new Jun3dPoint[]{new Jun3dPoint(jun2dPoint.x(), jun2dPoint.y(), 0.0), new Jun3dPoint(jun2dPoint2.x(), jun2dPoint.y(), 0.0), new Jun3dPoint(jun2dPoint2.x(), jun2dPoint2.y(), 0.0), new Jun3dPoint(jun2dPoint.x(), jun2dPoint2.y(), 0.0)}, Color.black);
    }

    protected JunOpenGL3dObject peakMarkAt_(Jun3dPoint jun3dPoint) {
        double d = this.mapBounds().height() / 20.0;
        JunOpenGL3dObject junOpenGL3dObject = new JunOpenGL3dPolylineLoop(new Jun3dPoint[]{new Jun3dPoint(0.0, 1.0, 0.0), new Jun3dPoint(-0.5, 0.0, 0.0), new Jun3dPoint(0.5, 0.0, 0.0)}, Color.blue);
        junOpenGL3dObject = junOpenGL3dObject.scaledBy_(d);
        return junOpenGL3dObject.translatedBy_(jun3dPoint);
    }

    protected void updateDisplayObject() {
        this.flushDisplayObject();
        this.changed_(JunTerrainEditModel.$((String)"object"));
    }

    protected void updateProjection() {
        this.displayProjector().sightPoint_(this.sightPoint());
        this.displayProjector().eyePoint_(this.eyePoint());
        this.displayProjector().upVector_(this.defaultUpVector());
        this.displayProjector().viewFactor_(this.defaultViewFactor());
        this.displayProjector().zoomHeight_(this.zoomHeight());
        this.changed_(JunTerrainEditModel.$((String)"projection"));
    }

    protected Jun3dPoint basic3dPointAt_(Jun2dPoint jun2dPoint) {
        return new Jun3dPoint(jun2dPoint.x(), jun2dPoint.y(), this.basicHeightAt_(jun2dPoint));
    }

    protected double basicHeightAt_(Jun2dPoint jun2dPoint) {
        double d;
        if (this.peaks.isEmpty()) {
            return 0.0;
        }
        double d2 = d = this.mapBounds().width() + this.mapBounds().height();
        double d3 = d;
        double d4 = Double.NaN;
        double d5 = Double.NaN;
        Jun3dPoint[] jun3dPointArray = this.peaks();
        for (int i = 0; i < jun3dPointArray.length; ++i) {
            Jun3dPoint jun3dPoint = jun3dPointArray[i];
            double d6 = jun2dPoint.distance_(new Jun2dPoint(jun3dPoint.x(), jun3dPoint.y()));
            if (d6 < d2) {
                d3 = d2;
                d5 = d4;
                d2 = d6;
                d4 = this.heightWithPeak_distance_(jun3dPoint, d6);
                continue;
            }
            if (!(d6 < d3)) continue;
            d3 = d6;
            d5 = this.heightWithPeak_distance_(jun3dPoint, d6);
        }
        return Double.isNaN(d5) ? d4 : (d3 * d4 + d2 * d5) / (d2 + d3);
    }

    protected Jun3dPoint[][] computeContours() {
        final StBlockClosure stBlockClosure = new StBlockClosure(){

            public Object value_value_(Object object, Object object2) {
                double d = ((Number)object).doubleValue();
                double d2 = ((Number)object2).doubleValue();
                return new Double(JunTerrainEditModel.this.basicHeightAt_(new Jun2dPoint(d, d2)));
            }
        };
        final ArrayList arrayList = new ArrayList();
        JunCursorAnimator.ClockCursors().showWhile_(new StBlockClosure(){

            public Object value() {
                Jun2dPoint jun2dPoint = JunTerrainEditModel.this.mapBounds().origin();
                Jun2dPoint jun2dPoint2 = JunTerrainEditModel.this.mapBounds().corner();
                double d = JunTerrainEditModel.this.topPeak();
                double d2 = JunTerrainEditModel.this.contourStep();
                for (double d3 = 0.0; d3 <= d; d3 += d2) {
                    double d4 = JunTerrainEditModel.this.contourGrid();
                    Jun2dPoint[][] jun2dPointArray = JunBorderGenerator.ContourPolylinesFrom_at_xInterval_yInterval_interim_(stBlockClosure, d3, new StInterval(jun2dPoint.x(), jun2dPoint2.x() + d4 / 2.0, d4), new StInterval(jun2dPoint.y(), jun2dPoint2.y() + d4 / 2.0, d4), null);
                    for (int i = 0; i < jun2dPointArray.length; ++i) {
                        Jun3dPoint[] jun3dPointArray = new Jun3dPoint[jun2dPointArray[i].length];
                        for (int j = 0; j < jun3dPointArray.length; ++j) {
                            Jun2dPoint jun2dPoint3 = jun2dPointArray[i][j];
                            jun3dPointArray[j] = new Jun3dPoint(jun2dPoint3.x(), jun2dPoint3.y(), d3);
                        }
                        arrayList.add(jun3dPointArray);
                    }
                }
                return null;
            }
        });
        return (Jun3dPoint[][])arrayList.toArray((T[])new Jun3dPoint[arrayList.size()][]);
    }

    protected JunTerrainField computeTerrainField() {
        Jun2dDelaunayProcessor jun2dDelaunayProcessor = new Jun2dDelaunayProcessor(this.mapBounds().expandedBy_(this.mapBounds().extent().dividedBy_(4.0)));
        jun2dDelaunayProcessor.insertPoint_(this.basic3dPointAt_(new Jun2dPoint(this.mapBounds().origin().x(), this.mapBounds().origin().x())));
        jun2dDelaunayProcessor.insertPoint_(this.basic3dPointAt_(new Jun2dPoint(this.mapBounds().corner().x(), this.mapBounds().origin().x())));
        jun2dDelaunayProcessor.insertPoint_(this.basic3dPointAt_(new Jun2dPoint(this.mapBounds().corner().x(), this.mapBounds().corner().x())));
        jun2dDelaunayProcessor.insertPoint_(this.basic3dPointAt_(new Jun2dPoint(this.mapBounds().origin().x(), this.mapBounds().corner().x())));
        Jun3dPoint[][] jun3dPointArray = this.contours();
        for (int i = 0; i < jun3dPointArray.length; ++i) {
            for (int j = 0; j < jun3dPointArray[i].length; ++j) {
                jun2dDelaunayProcessor.insertPoint_(jun3dPointArray[i][j]);
            }
        }
        final ArrayList arrayList = new ArrayList();
        jun2dDelaunayProcessor.convexHullTrianglesDo_(new StBlockClosure(){

            public Object value_value_value_(Object object, Object object2, Object object3) {
                arrayList.add(new JunTerrainTriangle((Jun3dPoint)((Object)object), (Jun3dPoint)((Object)object2), (Jun3dPoint)((Object)object3)));
                return null;
            }
        });
        return new JunTerrainField(arrayList.toArray(new JunTerrainTriangle[arrayList.size()]));
    }

    protected void flushContours() {
        if (this.contours != null) {
            this.contours = this.computeContours();
        }
        this.flushTerrainField();
        this.flushDisplayObject();
    }

    protected void flushTerrainField() {
        this.terrainField = null;
    }

    protected double heightWithPeak_distance_(Jun3dPoint jun3dPoint, double d) {
        return Math.max(jun3dPoint.z() - d / 3.0, 0.0);
    }

    protected double topPeak() {
        double d = 0.0;
        Jun3dPoint[] jun3dPointArray = this.peaks();
        for (int i = 0; i < jun3dPointArray.length; ++i) {
            Jun3dPoint jun3dPoint = jun3dPointArray[i];
            if (!(jun3dPoint.z() > d)) continue;
            d = jun3dPoint.z();
        }
        return d;
    }
}

