/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.system.framework;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Window;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import jp.co.sra.jun.goodies.cursors.JunCursors;
import jp.co.sra.jun.goodies.files.JunFileModel;
import jp.co.sra.jun.goodies.image.streams.JunImageStream;
import jp.co.sra.jun.goodies.image.streams.JunJpegImageStream;
import jp.co.sra.jun.goodies.image.support.JunImageProcessor;
import jp.co.sra.jun.goodies.movie.framework.JunMoviePlayer;
import jp.co.sra.jun.goodies.tables.JunAttributeTable;
import jp.co.sra.jun.graphics.navigator.JunFileRequesterDialog;
import jp.co.sra.jun.system.framework.JunApplicationModel;
import jp.co.sra.jun.system.support.JunSystem;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StImage;
import jp.co.sra.smalltalk.StObject;
import jp.co.sra.smalltalk.StView;
import jp.co.sra.smalltalk.menu.MenuListener;
import jp.co.sra.smalltalk.menu.MenuPerformer;
import jp.co.sra.smalltalk.menu.StMenu;
import jp.co.sra.smalltalk.menu.StMenuBar;
import jp.co.sra.smalltalk.menu.StMenuItem;
import jp.co.sra.smalltalk.menu.StPopupMenu;

public abstract class JunAbstractModel
extends JunApplicationModel {
    protected JunAttributeTable attributeTable;

    protected void initialize() {
        super.initialize();
        this.attributeTable = new JunAttributeTable();
    }

    public JunAttributeTable attributeTable() {
        return this.attributeTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StImage asImage() {
        StImage stImage = null;
        StView stView = this.getView();
        Dimension dimension = stView == null ? new Dimension(100, 100) : stView.toComponent().getBounds().getSize();
        JunCursors junCursors = new JunCursors(JunCursors.ExecuteCursor());
        try {
            junCursors._show();
            stImage = new StImage(dimension);
            Graphics graphics = stImage.image().getGraphics();
            try {
                Window window = this.getWindow();
                if (window == null) {
                    graphics.setColor(Color.white);
                } else {
                    graphics.setColor(window.getBackground());
                }
                graphics.drawRect(0, 0, stImage.width(), stImage.height());
                if (stView != null) {
                    stView.toComponent().paint(graphics);
                }
            }
            finally {
                if (graphics != null) {
                    graphics.dispose();
                }
            }
        }
        finally {
            junCursors._restore();
        }
        return stImage;
    }

    public StBlockClosure displayBlock() {
        return (StBlockClosure)this.attributeTable().at_ifAbsentPut_(JunAbstractModel.$((String)"displayBlock"), new StBlockClosure(){

            public Object value() {
                return null;
            }
        });
    }

    public void displayBlock_(final StBlockClosure stBlockClosure) {
        final JunAbstractModel junAbstractModel = this;
        this.attributeTable().at_put_(JunAbstractModel.$((String)"displayBlock"), new StBlockClosure(){

            public Object value_(Object object) {
                Graphics graphics = (Graphics)object;
                int n = stBlockClosure.numArgs();
                if (n == 0) {
                    stBlockClosure.value();
                }
                if (n == 1) {
                    stBlockClosure.value_((Object)graphics);
                }
                if (n == 2) {
                    stBlockClosure.value_value_((Object)graphics, (Object)junAbstractModel.getView());
                }
                if (n == 3) {
                    stBlockClosure.value_value_value_((Object)graphics, (Object)junAbstractModel.getView(), junAbstractModel.getView() == null ? null : junAbstractModel.getView().controller());
                }
                if (n == 4) {
                    stBlockClosure.valueWithArguments_(new Object[]{graphics, junAbstractModel.getView(), junAbstractModel.getView() == null ? null : junAbstractModel.getView().controller(), junAbstractModel.getViews()});
                }
                return null;
            }
        });
        this.changed();
    }

    public void displayOn_(Graphics graphics) {
        if (this.displayBlock() != null) {
            this.displayBlock().value_((Object)graphics);
        }
    }

    public void updateMenuIndication() {
        super.updateMenuIndication();
        this.updateFileMenuIndication();
        this.updateMiscMenuIndication();
        this.updateYellowButtonMenuIndication();
    }

    public void updateFileMenuIndication() {
        if (this._menuBar() == null) {
            return;
        }
        StMenu stMenu = (StMenu)this._menuBar().atNameKey_(JunAbstractModel.$((String)"fileMenu"));
        if (stMenu == null) {
            return;
        }
        StMenu stMenu2 = (StMenu)stMenu.atNameKey_(JunAbstractModel.$((String)"newModel"));
        if (stMenu2 != null) {
            stMenu2.enable();
        }
        if ((stMenu2 = (StMenu)stMenu.atNameKey_(JunAbstractModel.$((String)"quitModel"))) != null) {
            stMenu2.enable();
        }
    }

    public void updateMiscMenuIndication() {
        if (this._menuBar() == null) {
            return;
        }
        StMenu stMenu = (StMenu)this._menuBar().atNameKey_(JunAbstractModel.$((String)"miscMenu"));
        if (stMenu == null) {
            return;
        }
        StMenu stMenu2 = (StMenu)stMenu.atNameKey_(JunAbstractModel.$((String)"inspectModel"));
        if (stMenu2 != null) {
            stMenu2.enable();
        }
    }

    public void updateYellowButtonMenuIndication() {
        if (this._popupMenu() == null) {
            return;
        }
        StMenu stMenu = (StMenu)this._popupMenu().atNameKey_(JunAbstractModel.$((String)"yourself"));
        if (stMenu == null) {
            stMenu.enable();
        }
    }

    public void openImage() {
        JunFileModel.FileType[] fileTypeArray = new JunFileModel.FileType[]{new JunFileModel.FileType(JunAbstractModel.$String((String)"Gazou file", (String)"image files"), JunSystem.DefaultImageExtensionPatterns())};
        File file = JunFileRequesterDialog.RequestFile(JunAbstractModel.$String((String)"Select a gazou file.", (String)"Select a image file."), fileTypeArray, fileTypeArray[0]);
        if (file == null) {
            return;
        }
        this.openImageFrom_(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StImage openImageFrom_(File file) {
        if (!file.exists()) {
            return null;
        }
        StImage stImage = null;
        JunMoviePlayer junMoviePlayer = null;
        JunCursors junCursors = new JunCursors(JunCursors.ReadCursor());
        try {
            junCursors._show();
            junMoviePlayer = new JunMoviePlayer(file);
            stImage = junMoviePlayer.asImage();
        }
        catch (Exception exception) {
            stImage = JunImageProcessor.ImageFromFile_(file);
        }
        finally {
            if (junMoviePlayer != null) {
                junMoviePlayer.release();
                junMoviePlayer = null;
            }
            junCursors._restore();
        }
        return stImage;
    }

    public File saveImage() {
        JunFileModel.FileType[] fileTypeArray = new JunFileModel.FileType[]{new JunFileModel.FileType(JunAbstractModel.$String((String)"Gazou file", (String)"image files"), JunSystem.DefaultImageExtensionPatterns())};
        File file = JunFileRequesterDialog.RequestNewFile(JunAbstractModel.$String((String)"Input a gazou file.", (String)"Input a image file."), new File(this.defaultBaseName() + "." + JunSystem.DefaultImageExtension()), fileTypeArray, fileTypeArray[0]);
        if (file == null) {
            return null;
        }
        return this.saveImageTo_(file);
    }

    public void quitModel() {
        this.closeRequest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File saveImageTo_(File file) {
        StImage stImage = this.asImage();
        if (stImage == null) {
            return null;
        }
        JunImageStream junImageStream = null;
        JunCursors junCursors = new JunCursors(JunCursors.WriteCursor());
        try {
            junCursors._show();
            junImageStream = JunJpegImageStream.On_(new BufferedOutputStream(new FileOutputStream(file)));
            ((JunJpegImageStream)junImageStream).quality_(0.95f);
            junImageStream.nextPutImage_(stImage);
        }
        catch (IOException iOException) {
            System.out.println(iOException.getMessage());
            iOException.printStackTrace();
        }
        finally {
            if (junImageStream != null) {
                try {
                    junImageStream.flush();
                    junImageStream.close();
                }
                catch (IOException iOException) {
                    System.out.println(iOException.getMessage());
                    iOException.printStackTrace();
                }
            }
            junCursors._restore();
        }
        return file;
    }

    public StMenuBar _menuBar() {
        return (StMenuBar)this.attributeTable().at_ifAbsentPut_(JunAbstractModel.$((String)"menuBar"), new StBlockClosure(){

            public Object value() {
                StMenuBar stMenuBar = new StMenuBar();
                StMenu stMenu = new StMenu((Object)3.$String((String)"File"), 3.$((String)"fileMenu"));
                stMenu.add(new StMenuItem((Object)3.$String((String)"New"), 3.$((String)"New"), (MenuListener)new MenuPerformer((StObject)JunAbstractModel.this, "newModel")));
                stMenu.add(new StMenuItem((Object)3.$String((String)"Quit"), 3.$((String)"Quit"), (MenuListener)new MenuPerformer((StObject)JunAbstractModel.this, "quitModel")));
                stMenuBar.add(stMenu);
                StMenu stMenu2 = new StMenu((Object)3.$String((String)"Misc"), 3.$((String)"miscMenu"));
                stMenu2.add(new StMenuItem((Object)3.$String((String)"Inspect"), 3.$((String)"Inspect"), (MenuListener)new MenuPerformer((StObject)JunAbstractModel.this, "inspectModel")));
                stMenuBar.add(stMenu2);
                return stMenuBar;
            }
        });
    }

    public StPopupMenu _popupMenu() {
        return (StPopupMenu)this.attributeTable().at_ifAbsentPut_(JunAbstractModel.$((String)"_popupMenu"), new StBlockClosure(){

            public Object value() {
                return null;
            }
        });
    }
}

