/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.opengl.support;

import java.awt.Color;
import java.awt.Dimension;
import java.util.HashMap;
import jp.co.sra.jun.geometry.basic.Jun2dPoint;
import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.basic.JunAngle;
import jp.co.sra.jun.geometry.curves.JunNurbsCurve;
import jp.co.sra.jun.geometry.surfaces.JunNurbsSurface;
import jp.co.sra.jun.geometry.transformations.Jun3dTransformation;
import jp.co.sra.jun.opengl.projection.JunOpenGLParallelProjection;
import jp.co.sra.jun.opengl.projection.JunOpenGLPerspectiveProjection;
import jp.co.sra.jun.opengl.projection.JunOpenGLProjection;
import jp.co.sra.jun.opengl.support.JunOpenGLDrawable;
import jp.co.sra.jun.opengl.support.JunOpenGLInterface;
import jp.co.sra.jun.opengl.support.JunOpenGLResource;
import jp.co.sra.jun.opengl.texture.JunOpenGLStipple;
import jp.co.sra.jun.opengl.texture.JunOpenGLTexture;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StColorValue;
import jp.co.sra.smalltalk.StSymbol;

public class JunOpenGLRenderingContext
extends JunOpenGLResource
implements Cloneable {
    protected JunOpenGLDrawable drawable;
    protected Color color;
    protected float pointSize;
    protected float lineWidth;
    protected float nurbsSamplingTolerance;
    protected JunOpenGLProjection projection;
    protected Jun3dTransformation transformation;
    protected StSymbol presentation;
    protected StSymbol shading;
    protected int lightIndex;
    protected HashMap lightStates;
    protected JunOpenGLTexture texture;
    protected int textureCoordinateIndex;
    protected StBlockClosure textureCoordinateBlock;

    public JunOpenGLRenderingContext(JunOpenGLDrawable junOpenGLDrawable) {
        this.setDrawable(junOpenGLDrawable);
        this.initializeContext();
    }

    protected void initialize() {
        super.initialize();
        this.drawable = null;
        this.color = null;
        this.pointSize = 0.0f;
        this.lineWidth = Float.NaN;
        this.nurbsSamplingTolerance = 0.0f;
        this.projection = null;
        this.transformation = null;
        this.presentation = null;
        this.shading = null;
        this.lightIndex = -1;
        this.lightStates = null;
        this.texture = null;
        this.textureCoordinateIndex = -1;
        this.textureCoordinateBlock = null;
    }

    protected void initializeContext() {
        this.lightStates = new HashMap();
        this.projection_(this.defaultProjection());
        this.transformation = Jun3dTransformation.Unity();
        this.clearDepthBuffer();
        this.enableDepthTest();
        this.enableColorMaterial();
        this.setColor(this.defaultColor());
        this.resetLightIndex();
        this.disableCullFace();
        this.enableNormalize();
        this.disableBlending();
        this.disableTexture2d();
        this.nurbsSamplingTolerance_(this.defaultNurbsSamplingTolerance());
        this.initializeLighting();
    }

    protected void initializeLighting() {
        this.lightAmbientColor_(Color.black);
        for (int i = 0; i <= this.maxLightIndex(); ++i) {
            this.lightIndex_position_color_(i, Jun3dPoint.Zero(), Color.black);
            this.disableLightIndex_(i);
        }
        this.disableLighting();
    }

    protected JunOpenGLInterface getOpenGLInterface() {
        return this.getDrawable().getOpenGLInterface();
    }

    protected JunOpenGLDrawable getDrawable() {
        return this.drawable;
    }

    protected void setDrawable(JunOpenGLDrawable junOpenGLDrawable) {
        this.drawable = junOpenGLDrawable;
    }

    protected Color getColor() {
        if (this.color == null) {
            this.color = this.defaultColor();
        }
        return this.color;
    }

    protected void setColor(Color color) {
        if (color == null) {
            color = Color.white;
        }
        this.color = color;
        float[] fArray = this.color.getRGBComponents(null);
        this.getOpenGLInterface().glColor4f(fArray[0], fArray[1], fArray[2], fArray[3]);
    }

    public Color paint() {
        return new Color(this.getColor().getRGB());
    }

    public void paint_(Color color) {
        this.setColor(new Color(color.getRed(), color.getGreen(), color.getBlue(), this.getColor().getAlpha()));
    }

    public float alpha() {
        return (float)this.getColor().getAlpha() / 255.0f;
    }

    public void alpha_(float f) {
        int n = (int)((double)(f * 255.0f) + 0.5);
        this.setColor(new Color(this.getColor().getRed(), this.getColor().getGreen(), this.getColor().getBlue(), n));
    }

    public float pointSize() {
        return this.pointSize;
    }

    public void pointSize_(float f) {
        this.pointSize = f;
        this.getOpenGLInterface().glPointSize(this.pointSize);
    }

    public float lineWidth() {
        return this.lineWidth;
    }

    public void lineWidth_(float f) {
        this.lineWidth = f;
        this.getOpenGLInterface().glLineWidth(this.lineWidth);
    }

    public float nurbsSamplingTolerance() {
        return this.nurbsSamplingTolerance;
    }

    public void nurbsSamplingTolerance_(float f) {
        this.nurbsSamplingTolerance = f;
    }

    protected Color background() {
        return this.getDrawable().getBackgroundColor();
    }

    protected Color defaultColor() {
        return Color.black;
    }

    protected JunOpenGLProjection defaultProjection() {
        return JunOpenGLProjection.Default();
    }

    protected float defaultNurbsSamplingTolerance() {
        return 10.0f;
    }

    public void enableBlending() {
        this.getOpenGLInterface().glBlendFunc(770, 771);
        this.getOpenGLInterface().glEnable(3042);
    }

    public void disableBlending() {
        this.getOpenGLInterface().glDisable(3042);
    }

    public Object clone() {
        try {
            JunOpenGLRenderingContext junOpenGLRenderingContext = (JunOpenGLRenderingContext)super.clone();
            junOpenGLRenderingContext.color = new Color(this.color.getRGB(), true);
            return junOpenGLRenderingContext;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public void cullFaceBack() {
        this.getOpenGLInterface().glCullFace(1029);
    }

    public void cullFaceFront() {
        this.getOpenGLInterface().glCullFace(1028);
    }

    public void enableCullFace() {
        this.getOpenGLInterface().glEnable(2884);
    }

    public void disableCullFace() {
        this.getOpenGLInterface().glDisable(2884);
    }

    public void callDisplayList_(int n) {
        this.getOpenGLInterface().glCallList(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int createDisplayList_displayImmediately_(StBlockClosure stBlockClosure, boolean bl) {
        int n = this.getOpenGLInterface().glGenLists(1);
        int n2 = bl ? 4865 : 4864;
        this.getOpenGLInterface().glNewList(n, n2);
        try {
            stBlockClosure.value();
        }
        finally {
            this.getOpenGLInterface().glEndList();
        }
        return n;
    }

    public void clear() {
        this.clearDepthBuffer();
        this.clearColorBuffer();
    }

    protected void clearDepthBuffer() {
        this.getOpenGLInterface().glClear(256);
    }

    protected void clearColorBuffer() {
        float[] fArray = this.background().getRGBComponents(null);
        this.getOpenGLInterface().glClearColor(fArray[0], fArray[1], fArray[2], 1.0f);
        this.getOpenGLInterface().glClear(16384);
    }

    public void displayPoint_(Jun3dPoint jun3dPoint) {
        this.displayPoints_(new Jun3dPoint[]{jun3dPoint});
    }

    public void displayPoints_(Jun3dPoint[] jun3dPointArray) {
        this.getOpenGLInterface().glBegin(0);
        for (int i = 0; i < jun3dPointArray.length; ++i) {
            this.getOpenGLInterface().glVertex3d(jun3dPointArray[i].x(), jun3dPointArray[i].y(), jun3dPointArray[i].z());
        }
        this.getOpenGLInterface().glEnd();
    }

    public void displayLines_(Jun3dPoint[] jun3dPointArray) {
        this.getOpenGLInterface().glBegin(3);
        for (int i = 0; i < jun3dPointArray.length; ++i) {
            this.getOpenGLInterface().glVertex3d(jun3dPointArray[i].x(), jun3dPointArray[i].y(), jun3dPointArray[i].z());
        }
        this.getOpenGLInterface().glEnd();
    }

    public void displayLineLoop_(Jun3dPoint[] jun3dPointArray) {
        this.getOpenGLInterface().glBegin(2);
        for (int i = 0; i < jun3dPointArray.length; ++i) {
            this.getOpenGLInterface().glVertex3d(jun3dPointArray[i].x(), jun3dPointArray[i].y(), jun3dPointArray[i].z());
        }
        this.getOpenGLInterface().glEnd();
    }

    public void displayPolygon_(Jun3dPoint[] jun3dPointArray) {
        if (this.presentation() == JunOpenGLRenderingContext.$((String)"wireframe")) {
            this.displaySeeThroughWireframe_(jun3dPointArray);
        } else if (this.presentation() == JunOpenGLRenderingContext.$((String)"hiddenline")) {
            this.displayHiddenLineRendering_(jun3dPointArray);
        } else {
            Jun3dPoint jun3dPoint = this.normalVectorOfPoints_(jun3dPointArray);
            if (jun3dPoint == null) {
                return;
            }
            this.displayPolygon_normalVector_(jun3dPointArray, jun3dPoint);
        }
    }

    public void displayPolygon_normalVector_(Jun3dPoint[] jun3dPointArray, Jun3dPoint jun3dPoint) {
        this.displayPolygon_normalVectors_(jun3dPointArray, new Jun3dPoint[]{jun3dPoint});
    }

    public void displayPolygon_normalVectors_(Jun3dPoint[] jun3dPointArray, Jun3dPoint[] jun3dPointArray2) {
        if (this.presentation() == JunOpenGLRenderingContext.$((String)"wireframe")) {
            this.displaySeeThroughWireframe_(jun3dPointArray);
        } else if (this.presentation() == JunOpenGLRenderingContext.$((String)"hiddenline")) {
            this.displayHiddenLineRendering_(jun3dPointArray);
        } else {
            this.getOpenGLInterface().glBegin(9);
            for (int i = 0; i < jun3dPointArray.length; ++i) {
                Jun2dPoint jun2dPoint;
                if (this.textureCoordinateBlock != null && (jun2dPoint = (Jun2dPoint)((Object)this.textureCoordinateBlock.value_((Object)jun3dPointArray[i]))) != null) {
                    this.getOpenGLInterface().glTexCoord2d(jun2dPoint.x(), jun2dPoint.y());
                }
                if (jun3dPointArray2 != null && jun3dPointArray2.length > i) {
                    this.getOpenGLInterface().glNormal3d(jun3dPointArray2[i].x(), jun3dPointArray2[i].y(), jun3dPointArray2[i].z());
                }
                this.getOpenGLInterface().glVertex3d(jun3dPointArray[i].x(), jun3dPointArray[i].y(), jun3dPointArray[i].z());
            }
            this.getOpenGLInterface().glEnd();
        }
    }

    public void displayPolygon_colors_normalVectors_(Jun3dPoint[] jun3dPointArray, Color[] colorArray, Jun3dPoint[] jun3dPointArray2) {
        if (this.presentation() == JunOpenGLRenderingContext.$((String)"wireframe")) {
            this.displaySeeThroughWireframe_(jun3dPointArray);
        } else if (this.presentation() == JunOpenGLRenderingContext.$((String)"hiddenline")) {
            this.displayHiddenLineRendering_(jun3dPointArray);
        } else {
            this.getOpenGLInterface().glBegin(9);
            float f = this.alpha();
            for (int i = 0; i < jun3dPointArray.length; ++i) {
                Object object;
                if (this.textureCoordinateBlock != null && (object = (Jun2dPoint)((Object)this.textureCoordinateBlock.value_((Object)jun3dPointArray[i]))) != null) {
                    this.getOpenGLInterface().glTexCoord2d(((Jun2dPoint)((Object)object)).x(), ((Jun2dPoint)((Object)object)).y());
                }
                if (colorArray != null && colorArray.length > i) {
                    object = colorArray[i].getRGBColorComponents(null);
                    this.getOpenGLInterface().glColor4f((float)object[0], (float)object[1], (float)object[2], f);
                }
                if (jun3dPointArray2 != null && jun3dPointArray2.length > i) {
                    this.getOpenGLInterface().glNormal3d(jun3dPointArray2[i].x(), jun3dPointArray2[i].y(), jun3dPointArray2[i].z());
                }
                this.getOpenGLInterface().glVertex3d(jun3dPointArray[i].x(), jun3dPointArray[i].y(), jun3dPointArray[i].z());
            }
            this.getOpenGLInterface().glEnd();
        }
    }

    public void displayNurbsCurve_(JunNurbsCurve junNurbsCurve) {
        int n;
        float[] fArray = new float[junNurbsCurve.knotVector().length];
        for (int i = 0; i < junNurbsCurve.knotVector().length; ++i) {
            fArray[i] = (float)junNurbsCurve.knotVector()[i];
        }
        Jun3dPoint[] jun3dPointArray = junNurbsCurve.controlPoints();
        double[] dArray = junNurbsCurve.weights();
        float[] fArray2 = new float[junNurbsCurve.controlPointSize() * 4];
        for (n = 0; n < junNurbsCurve.controlPointSize(); ++n) {
            Jun3dPoint jun3dPoint = jun3dPointArray[n];
            double d = dArray[n];
            fArray2[n * 4 + 0] = (float)(jun3dPoint.x() * d);
            fArray2[n * 4 + 1] = (float)(jun3dPoint.y() * d);
            fArray2[n * 4 + 2] = (float)(jun3dPoint.z() * d);
            fArray2[n * 4 + 3] = (float)d;
        }
        this.getOpenGLInterface().glEnable(3456);
        n = this.getOpenGLInterface().gluNewNurbsRenderer();
        this.getOpenGLInterface().gluNurbsProperty(n, 100203, this.nurbsSamplingTolerance);
        this.getOpenGLInterface().glPushMatrix();
        this.getOpenGLInterface().gluBeginCurve(n);
        this.getOpenGLInterface().gluNurbsCurve(n, fArray.length, fArray, 4, fArray2, junNurbsCurve.order(), 3480);
        this.getOpenGLInterface().gluEndCurve(n);
        this.getOpenGLInterface().glPopMatrix();
        this.getOpenGLInterface().gluDeleteNurbsRenderer(n);
    }

    public void displayNurbsSurface_(JunNurbsSurface junNurbsSurface) {
        if (this.presentation() == JunOpenGLRenderingContext.$((String)"wireframe")) {
            this.displayNurbsSurface_displayMode_(junNurbsSurface, 100240);
        } else if (this.presentation() == JunOpenGLRenderingContext.$((String)"hiddenline")) {
            this.disableLighting();
            Color color = null;
            if (this.paint().equals(Color.white)) {
                color = this.paint();
                this.paint_(StColorValue.Brightness_((double)0.95));
            }
            this.getOpenGLInterface().glEnable(2929);
            this.getOpenGLInterface().glPolygonMode(1032, 6913);
            this.displayNurbsSurface_displayMode_(junNurbsSurface, 100240);
            if (color != null) {
                this.paint_(color);
            }
            color = this.paint();
            this.paint_(Color.white);
            this.getOpenGLInterface().glPolygonMode(1032, 6914);
            this.getOpenGLInterface().glEnable(32823);
            this.getOpenGLInterface().glPolygonOffset(1.0f, 1.0f);
            this.displayNurbsSurface_displayMode_(junNurbsSurface, 100012);
            this.getOpenGLInterface().glDisable(32823);
            this.paint_(color);
            this.enableLighting();
        } else {
            this.displayNurbsSurface_displayMode_(junNurbsSurface, 100012);
        }
    }

    protected void displaySeeThroughWireframe_(Jun3dPoint[] jun3dPointArray) {
        this.displayLineLoop_(jun3dPointArray);
    }

    protected void displayHiddenLineRendering_(Jun3dPoint[] jun3dPointArray) {
        this.getOpenGLInterface().glPolygonMode(1032, 6913);
        this.getOpenGLInterface().glBegin(2);
        for (int i = 0; i < jun3dPointArray.length; ++i) {
            this.getOpenGLInterface().glVertex3d(jun3dPointArray[i].x(), jun3dPointArray[i].y(), jun3dPointArray[i].z());
        }
        this.getOpenGLInterface().glEnd();
        this.disableLighting();
        Color color = this.paint();
        this.paint_(this.background());
        this.getOpenGLInterface().glPolygonMode(1032, 6914);
        this.getOpenGLInterface().glEnable(32823);
        this.getOpenGLInterface().glPolygonOffset(1.0f, 1.0f);
        this.getOpenGLInterface().glBegin(9);
        for (int i = 0; i < jun3dPointArray.length; ++i) {
            this.getOpenGLInterface().glVertex3d(jun3dPointArray[i].x(), jun3dPointArray[i].y(), jun3dPointArray[i].z());
        }
        this.getOpenGLInterface().glEnd();
        this.getOpenGLInterface().glDisable(32823);
        this.paint_(color);
        this.enableLighting();
    }

    protected void displayNurbsSurface_displayMode_(JunNurbsSurface junNurbsSurface, int n) {
        int n2;
        int n3;
        float[] fArray = new float[junNurbsSurface.uKnotVector().length];
        for (int i = 0; i < junNurbsSurface.uKnotVector().length; ++i) {
            fArray[i] = (float)junNurbsSurface.uKnotVector()[i];
        }
        float[] fArray2 = new float[junNurbsSurface.vKnotVector().length];
        for (n3 = 0; n3 < junNurbsSurface.vKnotVector().length; ++n3) {
            fArray2[n3] = (float)junNurbsSurface.vKnotVector()[n3];
        }
        n3 = junNurbsSurface.uSize();
        int n4 = junNurbsSurface.vSize();
        float[] fArray3 = new float[n3 * n4 * 4];
        int n5 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            for (int i = 0; i < n4; ++i) {
                Jun3dPoint jun3dPoint = junNurbsSurface.controlPointAtU_v_(n2, i);
                double d = junNurbsSurface.weightAtU_v_(n2, i);
                fArray3[n5++] = (float)(jun3dPoint.x() * d);
                fArray3[n5++] = (float)(jun3dPoint.y() * d);
                fArray3[n5++] = (float)(jun3dPoint.z() * d);
                fArray3[n5++] = (float)d;
            }
        }
        this.getOpenGLInterface().glEnable(3456);
        n2 = this.getOpenGLInterface().gluNewNurbsRenderer();
        this.getOpenGLInterface().gluNurbsProperty(n2, 100203, this.nurbsSamplingTolerance);
        this.getOpenGLInterface().gluNurbsProperty(n2, 100204, n);
        this.getOpenGLInterface().glPushMatrix();
        this.getOpenGLInterface().gluBeginSurface(n2);
        this.getOpenGLInterface().gluNurbsSurface(n2, fArray.length, fArray, fArray2.length, fArray2, 4 * n4, 4, fArray3, junNurbsSurface.uOrder(), junNurbsSurface.vOrder(), 3512);
        this.getOpenGLInterface().gluEndSurface(n2);
        this.getOpenGLInterface().glPopMatrix();
        this.getOpenGLInterface().gluDeleteNurbsRenderer(n2);
    }

    public void enableDithering() {
        this.getOpenGLInterface().glEnable(3024);
    }

    public void disableDithering() {
        this.getOpenGLInterface().glDisable(3024);
    }

    public void fogColor_(Color color) {
        this.getOpenGLInterface().glFogfv(2918, JunOpenGLRenderingContext.GetRGBA(color, 1.0f));
    }

    public void fogExp2Density_(float f) {
        this.getOpenGLInterface().glFogi(2917, 2049);
        this.getOpenGLInterface().glFogf(2914, f);
    }

    public void fogExpDensity(float f) {
        this.getOpenGLInterface().glFogi(2917, 2048);
        this.getOpenGLInterface().glFogf(2914, f);
    }

    public void fogLinearStartDensity_endDensity_(float f, float f2) {
    }

    public void enableFog() {
        this.getOpenGLInterface().glEnable(2912);
    }

    public void disableFog() {
        this.getOpenGLInterface().glDisable(2912);
    }

    public int getLightIndex() {
        this.lightIndex = this.lightIndex % this.maxLightIndex() + 1;
        return this.lightIndex;
    }

    public void lightAmbientColor_(Color color) {
        this.lightAmbientColor_alpha_twoSide_(color, 1.0f, false);
    }

    public void lightAmbientColor_alpha_(Color color, float f) {
        this.lightAmbientColor_alpha_twoSide_(color, f, false);
    }

    public void lightAmbientColor_alpha_twoSide_(Color color, float f, boolean bl) {
        this.getOpenGLInterface().glLightModelfv(2899, JunOpenGLRenderingContext.GetRGBA(color, f));
        this.getOpenGLInterface().glLightModelf(2897, 0.0f);
        this.getOpenGLInterface().glLightModelf(2898, bl ? 1.0f : 0.0f);
    }

    public void lightIndex_position_color_(int n, Jun3dPoint jun3dPoint, Color color) {
        this.lightIndex_position_direction_cutoffAngle_color_alpha_(n, jun3dPoint, null, null, color, 1.0f);
    }

    public void lightIndex_position_direction_cutoffAngle_color_alpha_(int n, Jun3dPoint jun3dPoint, Jun3dPoint jun3dPoint2, JunAngle junAngle, Color color, float f) {
        this.lightIndex_position_direction_cutoffAngle_color_alpha_linearAttenuation_quadraticAttenuation_constantAttenuation_(n, jun3dPoint, jun3dPoint2, junAngle, color, f, 0.0f, 0.0f, 1.0f);
    }

    public void lightIndex_position_direction_cutoffAngle_color_alpha_linearAttenuation_quadraticAttenuation_constantAttenuation_(int n, Jun3dPoint jun3dPoint, Jun3dPoint jun3dPoint2, JunAngle junAngle, Color color, float f, float f2, float f3, float f4) {
        Float f5;
        float[] fArray;
        float[] fArray2;
        StBlockClosure stBlockClosure = new StBlockClosure(){

            public Object value_value_(Object object, Object object2) {
                float[] fArray = (float[])object;
                Jun3dPoint jun3dPoint = (Jun3dPoint)((Object)object2);
                fArray[0] = (float)jun3dPoint.x();
                fArray[1] = (float)jun3dPoint.y();
                fArray[2] = (float)jun3dPoint.z();
                return this;
            }
        };
        StBlockClosure stBlockClosure2 = new StBlockClosure(){

            public Object value_value_value_(Object object, Object object2, Object object3) {
                float[] fArray = (float[])object;
                Jun3dPoint jun3dPoint = (Jun3dPoint)((Object)object2);
                Number number = (Number)object3;
                fArray[0] = (float)jun3dPoint.x();
                fArray[1] = (float)jun3dPoint.y();
                fArray[2] = (float)jun3dPoint.z();
                fArray[3] = number.floatValue();
                return this;
            }
        };
        StBlockClosure stBlockClosure3 = new StBlockClosure(){

            public Object value_value_value_(Object object, Object object2, Object object3) {
                float[] fArray = (float[])object;
                Color color = (Color)object2;
                Number number = (Number)object3;
                fArray[0] = (float)color.getRed() / 255.0f;
                fArray[1] = (float)color.getGreen() / 255.0f;
                fArray[2] = (float)color.getBlue() / 255.0f;
                fArray[3] = number.floatValue();
                return this;
            }
        };
        Jun3dPoint jun3dPoint3 = jun3dPoint;
        Jun3dPoint jun3dPoint4 = jun3dPoint2;
        if (jun3dPoint3 == null) {
            if (jun3dPoint4 == null) {
                return;
            }
            fArray2 = new float[4];
            stBlockClosure2.value_value_value_((Object)fArray2, (Object)jun3dPoint4.negated(), (Object)new Float(0.0f));
            fArray = new float[3];
            stBlockClosure.value_value_((Object)fArray, (Object)jun3dPoint4);
            f5 = new Float(90.0f);
        } else if (jun3dPoint4 == null) {
            fArray2 = new float[4];
            stBlockClosure2.value_value_value_((Object)fArray2, (Object)jun3dPoint3, (Object)new Float(1.0f));
            fArray = null;
            f5 = null;
        } else {
            fArray2 = new float[4];
            stBlockClosure2.value_value_value_((Object)fArray2, (Object)jun3dPoint3, (Object)new Float(1.0f));
            fArray = new float[3];
            stBlockClosure.value_value_((Object)fArray, (Object)jun3dPoint4);
            f5 = junAngle == null ? new Float(1.0f) : new Float(junAngle.deg());
        }
        float[] fArray3 = new float[4];
        stBlockClosure3.value_value_value_((Object)fArray3, (Object)(color == null ? Color.white : color), (Object)new Float(f));
        Object[] objectArray = new Object[]{fArray2, fArray, f5, fArray3, new Float(f2), new Float(f3), new Float(f4)};
        this.lightIndex_put_(n, objectArray);
    }

    public void lightIndex_position_parallel_color_alpha_(int n, Jun3dPoint jun3dPoint, boolean bl, Color color, float f) {
        this.lightIndex_position_direction_cutoffAngle_color_alpha_(n, null, jun3dPoint.negated(), null, color, f);
    }

    protected void lightIndex_put_(int n, Object[] objectArray) {
        float[] fArray = (float[])objectArray[0];
        float[] fArray2 = (float[])objectArray[1];
        Float f = (Float)objectArray[2];
        float[] fArray3 = (float[])objectArray[3];
        Float f2 = (Float)objectArray[4];
        Float f3 = (Float)objectArray[5];
        Float f4 = (Float)objectArray[6];
        this.enableLightIndex_(n);
        int n2 = 16384 + n;
        if (fArray != null) {
            this.getOpenGLInterface().glLightfv(n2, 4611, fArray);
        } else {
            this.getOpenGLInterface().glLightfv(n2, 4611, new float[]{0.0f, 0.0f, 1.0f, 0.0f});
        }
        if (fArray2 != null) {
            this.getOpenGLInterface().glLightfv(n2, 4612, fArray2);
        } else {
            this.getOpenGLInterface().glLightfv(n2, 4612, new float[]{0.0f, 0.0f, -1.0f});
        }
        if (f != null) {
            this.getOpenGLInterface().glLightf(n2, 4614, f.floatValue());
        } else {
            this.getOpenGLInterface().glLightf(n2, 4614, 180.0f);
        }
        if (fArray3 != null) {
            this.getOpenGLInterface().glLightfv(n2, 4609, fArray3);
            this.getOpenGLInterface().glLightfv(n2, 4610, fArray3);
            this.getOpenGLInterface().glLightf(n2, 4616, f2.floatValue());
            this.getOpenGLInterface().glLightf(n2, 4617, f3.floatValue());
            this.getOpenGLInterface().glLightf(n2, 4615, f4.floatValue());
        } else {
            this.getOpenGLInterface().glLightfv(n2, 4609, new float[]{1.0f, 1.0f, 1.0f, 1.0f});
            this.getOpenGLInterface().glLightfv(n2, 4610, new float[]{1.0f, 1.0f, 1.0f, 1.0f});
            this.getOpenGLInterface().glLightf(n2, 4616, 0.0f);
            this.getOpenGLInterface().glLightf(n2, 4617, 0.0f);
            this.getOpenGLInterface().glLightf(n2, 4615, 0.0f);
        }
    }

    public void enableLighting() {
        this.getOpenGLInterface().glEnable(2896);
    }

    public void disableLighting() {
        this.getOpenGLInterface().glDisable(2896);
    }

    public void enableLightIndex_(int n) {
        int n2 = 16384 + n;
        this.lightStates.put(new Integer(n), Boolean.TRUE);
        this.getOpenGLInterface().glEnable(n2);
    }

    public void disableLightIndex_(int n) {
        int n2 = 16384 + n;
        this.lightStates.put(new Integer(n), Boolean.FALSE);
        this.getOpenGLInterface().glDisable(n2);
    }

    protected int maxLightIndex() {
        return 7;
    }

    protected void resetLightIndex() {
        this.lightIndex = 0;
    }

    public void materialAmbient_(Color color) {
        this.materialAmbient_alpha_(color, 1.0f);
    }

    public void materialAmbient_alpha_(Color color, float f) {
        this.getOpenGLInterface().glMaterialfv(1032, 4608, JunOpenGLRenderingContext.GetRGBA(color, f));
    }

    public void materialDiffuse_(Color color) {
        this.materialDiffuse_alpha_(color, 1.0f);
    }

    public void materialDiffuse_alpha_(Color color, float f) {
        this.getOpenGLInterface().glMaterialfv(1032, 4609, JunOpenGLRenderingContext.GetRGBA(color, f));
    }

    public void materialEmission_(Color color) {
        this.materialEmission_alpha_(color, 1.0f);
    }

    public void materialEmission_alpha_(Color color, float f) {
        this.getOpenGLInterface().glMaterialfv(1032, 5632, JunOpenGLRenderingContext.GetRGBA(color, f));
    }

    public void materialShininess_(float f) {
        this.getOpenGLInterface().glMaterialf(1032, 5633, f);
    }

    public void materialSpecular_(Color color) {
        this.materialSpecular_alpha_(color, 1.0f);
    }

    public void materialSpecular_alpha_(Color color, float f) {
        this.getOpenGLInterface().glMaterialfv(1032, 4610, JunOpenGLRenderingContext.GetRGBA(color, f));
    }

    public void enableColorMaterial() {
        this.getOpenGLInterface().glEnable(2903);
    }

    public void disableColorMaterial() {
        this.getOpenGLInterface().glDisable(2903);
    }

    public void enableNormalize() {
        this.getOpenGLInterface().glEnable(2977);
    }

    public void disableNormalize() {
        this.getOpenGLInterface().glDisable(2977);
    }

    public void solidPresentation() {
        this.presentation_(JunOpenGLRenderingContext.$((String)"solid"));
    }

    public void wireframePresentation() {
        this.presentation_(JunOpenGLRenderingContext.$((String)"wireframe"));
    }

    public void hiddenlinePresentation() {
        this.presentation_(JunOpenGLRenderingContext.$((String)"hiddenline"));
    }

    protected StSymbol presentation() {
        if (this.presentation == null) {
            this.presentation = JunOpenGLRenderingContext.$((String)"solid");
        }
        return this.presentation;
    }

    protected void presentation_(StSymbol stSymbol) {
        if (stSymbol == JunOpenGLRenderingContext.$((String)"solid") || stSymbol == JunOpenGLRenderingContext.$((String)"wireframe") || stSymbol == JunOpenGLRenderingContext.$((String)"hiddenline")) {
            this.presentation = stSymbol;
        }
    }

    public void parallelProjection_(JunOpenGLParallelProjection junOpenGLParallelProjection) {
        JunOpenGLParallelProjection junOpenGLParallelProjection2 = (JunOpenGLParallelProjection)junOpenGLParallelProjection.copy();
        this.setProjection(junOpenGLParallelProjection2);
        Dimension dimension = this.getDrawable().getSize();
        double d = dimension.getWidth() / dimension.getHeight();
        double d2 = junOpenGLParallelProjection2.height() / 2.0;
        double d3 = d2 * d;
        Jun3dPoint jun3dPoint = junOpenGLParallelProjection2.eyePoint();
        Jun3dPoint jun3dPoint2 = junOpenGLParallelProjection2.sightPoint();
        Jun3dPoint jun3dPoint3 = junOpenGLParallelProjection2.upVector();
        this.getOpenGLInterface().glMatrixMode(5889);
        this.getOpenGLInterface().glLoadIdentity();
        this.getOpenGLInterface().glOrtho(-d3, d3, -d2, d2, junOpenGLParallelProjection2.near(), junOpenGLParallelProjection2.far());
        this.getOpenGLInterface().glMatrixMode(5888);
        this.getOpenGLInterface().glLoadIdentity();
        this.getOpenGLInterface().gluLookAt(jun3dPoint.x(), jun3dPoint.y(), jun3dPoint.z(), jun3dPoint2.x(), jun3dPoint2.y(), jun3dPoint2.z(), jun3dPoint3.x(), jun3dPoint3.y(), jun3dPoint3.z());
    }

    public void perspective_(JunOpenGLPerspectiveProjection junOpenGLPerspectiveProjection) {
        JunOpenGLPerspectiveProjection junOpenGLPerspectiveProjection2 = (JunOpenGLPerspectiveProjection)junOpenGLPerspectiveProjection.copy();
        this.setProjection(junOpenGLPerspectiveProjection2);
        Dimension dimension = this.getDrawable().getSize();
        double d = dimension.getWidth() / dimension.getHeight();
        Jun3dPoint jun3dPoint = junOpenGLPerspectiveProjection2.eyePoint();
        Jun3dPoint jun3dPoint2 = junOpenGLPerspectiveProjection2.sightPoint();
        Jun3dPoint jun3dPoint3 = junOpenGLPerspectiveProjection2.upVector();
        this.getOpenGLInterface().glMatrixMode(5889);
        this.getOpenGLInterface().glLoadIdentity();
        this.getOpenGLInterface().gluPerspective(junOpenGLPerspectiveProjection2.fovy().deg(), d, junOpenGLPerspectiveProjection2.near(), junOpenGLPerspectiveProjection2.far());
        this.getOpenGLInterface().glMatrixMode(5888);
        this.getOpenGLInterface().glLoadIdentity();
        this.getOpenGLInterface().gluLookAt(jun3dPoint.x(), jun3dPoint.y(), jun3dPoint.z(), jun3dPoint2.x(), jun3dPoint2.y(), jun3dPoint2.z(), jun3dPoint3.x(), jun3dPoint3.y(), jun3dPoint3.z());
    }

    public JunOpenGLProjection projection() {
        return (JunOpenGLProjection)this.projection.copy();
    }

    public void projection_(JunOpenGLProjection junOpenGLProjection) {
        junOpenGLProjection.projectOn_(this);
    }

    public void flatShading() {
        this.shading = JunOpenGLRenderingContext.$((String)"flat");
        this.getOpenGLInterface().glShadeModel(7424);
    }

    public void smoothShading() {
        this.shading = JunOpenGLRenderingContext.$((String)"smooth");
        this.getOpenGLInterface().glShadeModel(7425);
    }

    public StSymbol shading() {
        return this.shading;
    }

    public void lineSmoothNicest() {
        this.getOpenGLInterface().glHint(3154, 4354);
    }

    public void lineSmoothFastest() {
        this.getOpenGLInterface().glHint(3154, 4353);
    }

    public void lineSmoothDontCare() {
        this.getOpenGLInterface().glHint(3154, 4352);
    }

    public void enableLineSmooth() {
        this.getOpenGLInterface().glEnable(2848);
        this.lineSmoothNicest();
    }

    public void disableLineSmooth() {
        this.getOpenGLInterface().glDisable(2848);
    }

    public void polygonSmoothNicest() {
        this.getOpenGLInterface().glHint(3155, 4354);
    }

    public void polygonSmoothFastest() {
        this.getOpenGLInterface().glHint(3155, 4353);
    }

    public void polygonSmoothDontCare() {
        this.getOpenGLInterface().glHint(3155, 4352);
    }

    public void enablePolygonSmooth() {
        this.getOpenGLInterface().glEnable(2881);
        this.polygonSmoothNicest();
    }

    public void disablePolygonSmooth() {
        this.getOpenGLInterface().glDisable(2881);
    }

    public void lineStippleFactor_pattern_(int n, short s) {
        this.getOpenGLInterface().glLineStipple(n, s);
    }

    public void enableLineStipple() {
        this.getOpenGLInterface().glEnable(2852);
    }

    public void disableLineStipple() {
        this.getOpenGLInterface().glDisable(2852);
    }

    public void polygonStipple_(JunOpenGLStipple junOpenGLStipple) {
        this.getOpenGLInterface().glPolygonStipple(junOpenGLStipple.pointerOfPixels());
    }

    public void enablePolygonStipple() {
        this.getOpenGLInterface().glEnable(2882);
    }

    public void disablePolygonStipple() {
        this.getOpenGLInterface().glDisable(2882);
    }

    public JunOpenGLTexture texture() {
        return this.texture;
    }

    public void texture_(JunOpenGLTexture junOpenGLTexture) {
        if (junOpenGLTexture != null) {
            this.getOpenGLInterface().glPixelStorei(3317, 1);
            if (junOpenGLTexture.mipmap()) {
                this.getOpenGLInterface().gluBuild2DMipmaps(3553, 3, junOpenGLTexture.width(), junOpenGLTexture.height(), 6407, 5121, junOpenGLTexture.pointerOfPixels());
            } else {
                this.getOpenGLInterface().glTexImage2D(3553, 0, 3, junOpenGLTexture.width(), junOpenGLTexture.height(), 0, 6407, 5121, junOpenGLTexture.pointerOfPixels());
            }
            this.getOpenGLInterface().glTexParameteri(3553, 10242, junOpenGLTexture.clamp() ? 10496 : 10497);
            this.getOpenGLInterface().glTexParameteri(3553, 10243, junOpenGLTexture.clamp() ? 10496 : 10497);
            this.getOpenGLInterface().glTexParameteri(3553, 10240, junOpenGLTexture.nearest() ? 9728 : 9729);
            if (junOpenGLTexture.mipmap()) {
                this.getOpenGLInterface().glTexParameteri(3553, 10241, junOpenGLTexture.nearest() ? 9984 : 9987);
            } else {
                this.getOpenGLInterface().glTexParameteri(3553, 10241, junOpenGLTexture.nearest() ? 9728 : 9729);
            }
            if (junOpenGLTexture.modulate()) {
                this.getOpenGLInterface().glTexEnvi(8960, 8704, 8448);
            } else {
                this.getOpenGLInterface().glTexEnvi(8960, 8704, 8449);
            }
            if (junOpenGLTexture.hasCoordinates()) {
                this.textureCoordinateBlock = new StBlockClosure(){

                    public Object value_(Object object) {
                        if (JunOpenGLRenderingContext.this.textureCoordinateIndex() > JunOpenGLRenderingContext.this.texture.coordinates().length - 1) {
                            JunOpenGLRenderingContext.this.textureCoordinateIndex_(0);
                        }
                        Jun2dPoint jun2dPoint = JunOpenGLRenderingContext.this.texture.coordinates()[JunOpenGLRenderingContext.this.textureCoordinateIndex()];
                        JunOpenGLRenderingContext.this.textureCoordinateIndex_(JunOpenGLRenderingContext.this.textureCoordinateIndex() + 1);
                        return jun2dPoint;
                    }
                };
            } else {
                this.getOpenGLInterface().glTexGeni(8192, 9472, 9217);
                this.getOpenGLInterface().glTexGenfv(8192, 9473, junOpenGLTexture.pointerOfParametersForS());
                this.getOpenGLInterface().glTexGeni(8193, 9472, 9217);
                this.getOpenGLInterface().glTexGenfv(8193, 9473, junOpenGLTexture.pointerOfParametersForT());
                this.getOpenGLInterface().glEnable(3168);
                this.getOpenGLInterface().glEnable(3169);
                this.getOpenGLInterface().glEnable(3553);
            }
        } else {
            this.textureCoordinateBlock = null;
        }
        this.texture = junOpenGLTexture;
    }

    public int textureCoordinateIndex() {
        if (this.textureCoordinateIndex < 0) {
            this.textureCoordinateIndex = 0;
        }
        return this.textureCoordinateIndex;
    }

    public void textureCoordinateIndex_(int n) {
        this.textureCoordinateIndex = n;
    }

    public void enableTexture2d() {
        this.getOpenGLInterface().glEnable(3553);
    }

    public void disableTexture2d() {
        this.getOpenGLInterface().glDisable(3553);
    }

    public Jun3dTransformation transformation() {
        return this.transformation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void productTransformation_while_(Jun3dTransformation jun3dTransformation, StBlockClosure stBlockClosure) {
        Jun3dTransformation jun3dTransformation2 = this.transformation;
        this.transformation = this.transformation.product_(jun3dTransformation);
        double[] dArray = jun3dTransformation.asArray();
        try {
            this.getOpenGLInterface().glPushMatrix();
            this.getOpenGLInterface().glMultMatrixd(dArray);
            stBlockClosure.value();
        }
        finally {
            this.getOpenGLInterface().glPopMatrix();
            this.transformation = jun3dTransformation2;
        }
    }

    public void flush() {
        this.getOpenGLInterface().glFlush();
    }

    public void enableDepthTest() {
        this.getOpenGLInterface().glEnable(2929);
    }

    public void disableDepthTest() {
        this.getOpenGLInterface().glDisable(2929);
    }

    public void enableDepthMask() {
        this.getOpenGLInterface().glDepthMask(true);
    }

    public void disableDepthMask() {
        this.getOpenGLInterface().glDepthMask(false);
    }

    public Jun3dPoint normalVectorOfPoints_(Jun3dPoint[] jun3dPointArray) {
        return JunOpenGLRenderingContext.NormalVectorOfPoints_(jun3dPointArray);
    }

    public Jun3dPoint normalUnitVectorOfPoints_(Jun3dPoint[] jun3dPointArray) {
        return JunOpenGLRenderingContext.NormalUnitVectorOfPoints_(jun3dPointArray);
    }

    private void setProjection(JunOpenGLProjection junOpenGLProjection) {
        this.projection = junOpenGLProjection;
    }

    public static Jun3dPoint NormalVectorOfPoints_(Jun3dPoint[] jun3dPointArray) {
        int n = jun3dPointArray.length;
        if (n < 3) {
            return null;
        }
        int n2 = n / 3;
        Jun3dPoint jun3dPoint = jun3dPointArray[0];
        Jun3dPoint jun3dPoint2 = jun3dPointArray[1].plus_(n2);
        Jun3dPoint jun3dPoint3 = jun3dPointArray[2].plus_(n2 * 2);
        Jun3dPoint jun3dPoint4 = new Jun3dPoint(jun3dPoint2.x() - jun3dPoint.x(), jun3dPoint2.y() - jun3dPoint.y(), jun3dPoint2.z() - jun3dPoint.z());
        Jun3dPoint jun3dPoint5 = new Jun3dPoint(jun3dPoint3.x() - jun3dPoint2.x(), jun3dPoint3.y() - jun3dPoint2.y(), jun3dPoint3.z() - jun3dPoint2.z());
        return jun3dPoint4.product_(jun3dPoint5);
    }

    public static Jun3dPoint NormalUnitVectorOfPoints_(Jun3dPoint[] jun3dPointArray) {
        Jun3dPoint jun3dPoint = JunOpenGLRenderingContext.NormalVectorOfPoints_(jun3dPointArray);
        if (jun3dPoint == null) {
            return null;
        }
        return jun3dPoint.unitVector();
    }

    public static float[] GetRGBA(Color color, float f) {
        float[] fArray = color.getRGBComponents(null);
        fArray[3] = f;
        return fArray;
    }
}

