/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.opengl.projection;

import java.util.ArrayList;
import java.util.Collection;
import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.opengl.lights.JunOpenGLLight;
import jp.co.sra.jun.opengl.lights.JunOpenGLSpotLight;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;
import jp.co.sra.jun.opengl.projection.JunOpenGLProjection;
import jp.co.sra.jun.opengl.support.JunOpenGLRenderingContext;
import jp.co.sra.jun.system.framework.JunAbstractObject;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StBlockValue;
import jp.co.sra.smalltalk.StBlockValued;
import jp.co.sra.smalltalk.StObject;
import jp.co.sra.smalltalk.StSymbol;
import jp.co.sra.smalltalk.StValueHolder;
import jp.co.sra.smalltalk.StValued;

public class JunOpenGLProjector
extends JunAbstractObject
implements StBlockValued {
    protected JunOpenGLProjection projection;
    protected StSymbol shading;
    protected StSymbol presentation;
    protected ArrayList lights;
    protected boolean lineSmoothBoolean;
    protected boolean polygonSmoothBoolean;

    protected void initialize() {
        super.initialize();
        this.shading = this.defaultShading();
        this.presentation = this.defaultPresentation();
        this.projection = this.defaultProjection();
        this.lights = new ArrayList();
    }

    public JunOpenGLProjection projection() {
        return (JunOpenGLProjection)this.projection.copy();
    }

    public void projection_(JunOpenGLProjection junOpenGLProjection) {
        this.projection = (JunOpenGLProjection)junOpenGLProjection.copy();
    }

    public Jun3dPoint eyePoint() {
        return this.projection.eyePoint();
    }

    public void eyePoint_(Jun3dPoint jun3dPoint) {
        if (this.projection.eyePoint() == null || !this.sightPoint().equal_((Object)jun3dPoint)) {
            this.projection.eyePoint_(jun3dPoint);
        }
    }

    public Jun3dPoint sightPoint() {
        return this.projection.sightPoint();
    }

    public void sightPoint_(Jun3dPoint jun3dPoint) {
        if (this.projection.sightPoint() == null || !this.eyePoint().equal_((Object)jun3dPoint)) {
            this.projection.sightPoint_(jun3dPoint);
        }
    }

    public void eyePoint_sightPoint_(Jun3dPoint jun3dPoint, Jun3dPoint jun3dPoint2) {
        this.projection.eyePoint_sightPoint_(jun3dPoint, jun3dPoint2);
    }

    public Jun3dPoint upVector() {
        return this.projection.upVector();
    }

    public Jun3dPoint unitUpVector() {
        return this.projection.unitUpVector();
    }

    public Jun3dPoint unitSightVector() {
        return this.projection.unitSightVector();
    }

    public Jun3dPoint unitRightVector() {
        return this.projection.unitRightVector();
    }

    public void upVector_(Jun3dPoint jun3dPoint) {
        this.projection.upVector_(jun3dPoint);
    }

    public double viewFactor() {
        return this.projection.viewFactor();
    }

    public void viewFactor_(double d) {
        d = d < 2.0 ? 2.0 : d;
        d = 1000.0 < d ? 1000.0 : d;
        this.projection.viewFactor_(d);
    }

    public double near() {
        return this.projection.near();
    }

    public void near_(double d) {
        this.projection.near_(d);
    }

    public double far() {
        return this.projection.far();
    }

    public void far_(double d) {
        this.projection.far_(d);
    }

    public double zoomHeight() {
        return this.projection.zoomHeight();
    }

    public void zoomHeight_(double d) {
        this.projection.zoomHeight_(d);
    }

    public double distance() {
        return this.projection.distance();
    }

    public void pan() {
        this.projection.pan();
    }

    public void pan_(double d) {
        this.projection.pan_(d);
    }

    public void zoom() {
        this.projection.zoom();
    }

    public void zoom_(double d) {
        this.projection.zoom_(d);
    }

    public Object value() {
        return this;
    }

    public StBlockValue compute_(StBlockClosure stBlockClosure) {
        return new StBlockValue(stBlockClosure, (StBlockValued)this);
    }

    public StObject postCopy() {
        super.postCopy();
        this.breakDependents();
        return this;
    }

    protected JunOpenGLProjection defaultProjection() {
        return JunOpenGLProjection.Default();
    }

    protected StSymbol defaultPresentation() {
        return JunOpenGLProjector.$((String)"solidPresentation");
    }

    protected StSymbol defaultShading() {
        return JunOpenGLProjector.$((String)"flatShading");
    }

    public void project_on_(JunOpenGL3dObject junOpenGL3dObject, JunOpenGLRenderingContext junOpenGLRenderingContext) {
        this.project_withLights_on_(junOpenGL3dObject, null, junOpenGLRenderingContext);
    }

    public void project_withLights_on_(JunOpenGL3dObject junOpenGL3dObject, JunOpenGLLight[] junOpenGLLightArray, JunOpenGLRenderingContext junOpenGLRenderingContext) {
        this.project_withLights_on_withDisplayList_(junOpenGL3dObject, junOpenGLLightArray, junOpenGLRenderingContext, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void project_withLights_on_withDisplayList_(JunOpenGL3dObject junOpenGL3dObject, JunOpenGLLight[] junOpenGLLightArray, JunOpenGLRenderingContext junOpenGLRenderingContext, StValueHolder stValueHolder) {
        this.projectOn_(junOpenGLRenderingContext);
        if (junOpenGLLightArray != null) {
            for (int i = 0; i < junOpenGLLightArray.length; ++i) {
                junOpenGLLightArray[i].lightingOn_(junOpenGLRenderingContext);
            }
        }
        try {
            if (junOpenGL3dObject != null) {
                this.render_on_withDisplayList_(junOpenGL3dObject, this.renderingContextFrom_(junOpenGLRenderingContext), stValueHolder);
            }
        }
        finally {
            junOpenGLRenderingContext.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void projectOn_(final JunOpenGLRenderingContext junOpenGLRenderingContext) {
        try {
            this.projection.projectOn_(junOpenGLRenderingContext);
            this.lightsDo_(new StBlockClosure(){

                public Object value_(Object object) {
                    ((JunOpenGLLight)((Object)object)).lightingOn_(junOpenGLRenderingContext);
                    return null;
                }
            });
        }
        finally {
            junOpenGLRenderingContext.flush();
        }
    }

    public void onChangeProjectionSend_to_(String string, StObject stObject) {
        this.expressInterestIn_for_sendBack_(JunOpenGLProjector.$((String)"projection"), stObject, string);
    }

    public void onChangeSend_to_(String string, StObject stObject) {
        this.expressInterestIn_for_sendBack_(JunOpenGLProjector.$((String)"value"), stObject, string);
    }

    public void retractInterestsFor_(StObject stObject) {
        this.retractInterestIn_for_(JunOpenGLProjector.$((String)"value"), stObject);
    }

    public void retractProjectionInterestsFor_(StObject stObject) {
        this.retractInterestIn_for_(JunOpenGLProjector.$((String)"projection"), stObject);
    }

    public void addAllLights_(Collection collection) {
        this.lights.addAll(collection);
    }

    public void addHeadLight() {
        final JunOpenGLSpotLight junOpenGLSpotLight = JunOpenGLSpotLight.At3dPoint_(this.eyePoint());
        this.addLight_(new StBlockValue(new StBlockClosure(){

            public Object value_(Object object) {
                junOpenGLSpotLight.position_(((JunOpenGLProjector)((Object)object)).eyePoint());
                return junOpenGLSpotLight;
            }
        }, (StBlockValued)this));
    }

    public void addLight_(JunOpenGLLight junOpenGLLight) {
        this.lights.add(junOpenGLLight);
    }

    public void addLight_(StBlockValue stBlockValue) {
        this.lights.add(stBlockValue);
    }

    public void lightsDo_(StBlockClosure stBlockClosure) {
        StValued[] stValuedArray = this.lights.toArray(new StValued[this.lights.size()]);
        for (int i = 0; i < stValuedArray.length; ++i) {
            stBlockClosure.value_(stValuedArray[i].value());
        }
    }

    public void removeAllLight_(Collection collection) {
        this.lights.removeAll(collection);
    }

    public void removeLight_(JunOpenGLLight junOpenGLLight) {
        this.lights.remove((Object)junOpenGLLight);
    }

    public StSymbol presentation() {
        return this.presentation;
    }

    public void presentation_(StSymbol stSymbol) {
        this.presentation = stSymbol;
    }

    public void solidPresentation() {
        this.presentation_(JunOpenGLProjector.$((String)"solidPresentation"));
    }

    public void wireframePresentation() {
        this.presentation_(JunOpenGLProjector.$((String)"wireframePresentation"));
    }

    public void hiddenlinePresentation() {
        this.presentation_(JunOpenGLProjector.$((String)"hiddenlinePresentation"));
    }

    public void parallelProjection() {
        this.projection_(this.projection.asParallelProjection());
    }

    public void perspectiveProjection() {
        this.projection_(this.projection.asPerspectiveProjection());
    }

    public StSymbol shading() {
        return this.shading;
    }

    public void shading_(StSymbol stSymbol) {
        this.shading = stSymbol;
    }

    public void flatShading() {
        this.shading_(JunOpenGLProjector.$((String)"flatShading"));
    }

    public void smoothShading() {
        this.shading_(JunOpenGLProjector.$((String)"smoothShading"));
    }

    public boolean lineSmooth() {
        return this.lineSmoothBoolean;
    }

    public void lineSmooth_(boolean bl) {
        this.lineSmoothBoolean = bl;
    }

    public boolean polygonSmooth() {
        return this.polygonSmoothBoolean;
    }

    public void polygonSmooth_(boolean bl) {
        this.polygonSmoothBoolean = bl;
    }

    protected void render_on_withDisplayList_(final JunOpenGL3dObject junOpenGL3dObject, final JunOpenGLRenderingContext junOpenGLRenderingContext, StValueHolder stValueHolder) {
        if (stValueHolder == null) {
            junOpenGL3dObject.renderOn_(junOpenGLRenderingContext);
        } else if (stValueHolder.value() == null) {
            int n = junOpenGLRenderingContext.createDisplayList_displayImmediately_(new StBlockClosure(){

                public Object value() {
                    junOpenGL3dObject.renderOn_(junOpenGLRenderingContext);
                    return null;
                }
            }, true);
            stValueHolder.value_(n);
        } else {
            junOpenGLRenderingContext.callDisplayList_(((Number)stValueHolder.value()).intValue());
        }
    }

    protected JunOpenGLRenderingContext renderingContextFrom_(JunOpenGLRenderingContext junOpenGLRenderingContext) {
        if (this.presentation == JunOpenGLProjector.$((String)"solidPresentation")) {
            junOpenGLRenderingContext.solidPresentation();
        } else if (this.presentation == JunOpenGLProjector.$((String)"wireframePresentation")) {
            junOpenGLRenderingContext.wireframePresentation();
        } else if (this.presentation == JunOpenGLProjector.$((String)"hiddenlinePresentation")) {
            junOpenGLRenderingContext.hiddenlinePresentation();
        }
        if (this.shading == JunOpenGLProjector.$((String)"smoothShading")) {
            junOpenGLRenderingContext.smoothShading();
        } else if (this.shading == JunOpenGLProjector.$((String)"flatShading")) {
            junOpenGLRenderingContext.flatShading();
        }
        if (this.lineSmooth()) {
            junOpenGLRenderingContext.lineSmoothNicest();
            junOpenGLRenderingContext.enableLineSmooth();
        } else {
            junOpenGLRenderingContext.disableLineSmooth();
        }
        if (this.polygonSmooth()) {
            junOpenGLRenderingContext.polygonSmoothFastest();
            junOpenGLRenderingContext.enablePolygonSmooth();
        } else {
            junOpenGLRenderingContext.disablePolygonSmooth();
        }
        return junOpenGLRenderingContext;
    }

    protected void setProjection_(JunOpenGLProjection junOpenGLProjection) {
        this.projection = junOpenGLProjection;
    }

    public void setEyePoint_(Jun3dPoint jun3dPoint) {
        this.projection.setEyePoint_(jun3dPoint);
    }

    public void setSightPoint_(Jun3dPoint jun3dPoint) {
        this.projection.setSightPoint_(jun3dPoint);
    }

    public void setUpVector_(Jun3dPoint jun3dPoint) {
        this.projection.setUpVector_(jun3dPoint);
    }

    public void setViewFactor_(double d) {
        this.projection.setViewFactor_(d);
    }

    public void setZoomHeight_(double d) {
        this.projection.setZoomHeight_(d);
    }

    public void setProjection() {
        if (this.eyePoint().equal_((Object)this.sightPoint())) {
            Jun3dPoint jun3dPoint = this.sightPoint();
            this.projection();
            this.setEyePoint_(jun3dPoint.plus_(JunOpenGLProjection.DefaultEyePoint));
        }
        this.projection.setProjection();
    }
}

