/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.opengl.objects;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.TextArea;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Map;
import java.util.Vector;
import jp.co.sra.jun.geometry.abstracts.JunGeometry;
import jp.co.sra.jun.geometry.basic.Jun2dPoint;
import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.basic.JunAngle;
import jp.co.sra.jun.geometry.boundaries.Jun3dBoundingBox;
import jp.co.sra.jun.geometry.curves.Jun3dLine;
import jp.co.sra.jun.geometry.surfaces.Jun3dTriangle;
import jp.co.sra.jun.geometry.transformations.Jun3dTransformation;
import jp.co.sra.jun.goodies.cursors.JunCursors;
import jp.co.sra.jun.goodies.lisp.JunLispCons;
import jp.co.sra.jun.goodies.lisp.JunLispList;
import jp.co.sra.jun.goodies.lisp.JunLispNil;
import jp.co.sra.jun.goodies.lisp.JunLispParser;
import jp.co.sra.jun.opengl.display.JunOpenGL3dModel;
import jp.co.sra.jun.opengl.display.JunOpenGLDisplayModel;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dCompoundObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dPolygon;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dPolyline;
import jp.co.sra.jun.opengl.objects.typical.JunOpenGL3dTypicalObjects;
import jp.co.sra.jun.opengl.objects.typical.JunOpenGL3dTypicalObjectsArrow;
import jp.co.sra.jun.opengl.objects.typical.JunOpenGL3dTypicalObjectsBall;
import jp.co.sra.jun.opengl.objects.typical.JunOpenGL3dTypicalObjectsBox;
import jp.co.sra.jun.opengl.objects.typical.JunOpenGL3dTypicalObjectsChemical;
import jp.co.sra.jun.opengl.objects.typical.JunOpenGL3dTypicalObjectsCircle;
import jp.co.sra.jun.opengl.objects.typical.JunOpenGL3dTypicalObjectsCone;
import jp.co.sra.jun.opengl.objects.typical.JunOpenGL3dTypicalObjectsCylinder;
import jp.co.sra.jun.opengl.objects.typical.JunOpenGL3dTypicalObjectsHedron;
import jp.co.sra.jun.opengl.objects.typical.JunOpenGL3dTypicalObjectsImage;
import jp.co.sra.jun.opengl.objects.typical.JunOpenGL3dTypicalObjectsMisc;
import jp.co.sra.jun.opengl.objects.typical.JunOpenGL3dTypicalObjectsMobius;
import jp.co.sra.jun.opengl.objects.typical.JunOpenGL3dTypicalObjectsPie;
import jp.co.sra.jun.opengl.objects.typical.JunOpenGL3dTypicalObjectsPlate;
import jp.co.sra.jun.opengl.objects.typical.JunOpenGL3dTypicalObjectsShpere;
import jp.co.sra.jun.opengl.objects.typical.JunOpenGL3dTypicalObjectsSpring;
import jp.co.sra.jun.opengl.objects.typical.JunOpenGL3dTypicalObjectsText;
import jp.co.sra.jun.opengl.objects.typical.JunOpenGL3dTypicalObjectsTorus;
import jp.co.sra.jun.opengl.support.JunOpenGLRenderingContext;
import jp.co.sra.jun.opengl.texture.JunOpenGLStipple;
import jp.co.sra.jun.opengl.texture.JunOpenGLTexture;
import jp.co.sra.jun.system.framework.JunAbstractObject;
import jp.co.sra.jun.vrml.support.JunVrmlRenderingContext;
import jp.co.sra.smalltalk.SmalltalkException;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StColorValue;
import jp.co.sra.smalltalk.StComposedText;
import jp.co.sra.smalltalk.StImage;
import jp.co.sra.smalltalk.StSymbol;
import jp.co.sra.smalltalk.StValueHolder;

public abstract class JunOpenGL3dObject
extends JunAbstractObject {
    private static long IdClock = System.currentTimeMillis();
    private static long IdNumber = 0L;
    protected static final String INDENT = "\t";
    protected String name;
    protected Color paint;
    protected float alpha;
    protected Jun3dBoundingBox bounds;

    public static Color DefaultPaint() {
        return Color.white;
    }

    public static JunOpenGL3dObject LoadFrom_(Object object) {
        JunLispList junLispList = (JunLispList)((Object)JunLispParser.Parse_(object));
        if (junLispList != null && junLispList instanceof JunLispCons) {
            return JunOpenGL3dCompoundObject.ObjectFromLispList_((JunLispCons)junLispList);
        }
        return null;
    }

    public static JunLispList ShowLispList_(JunLispList junLispList) {
        TextArea textArea = new TextArea(5, 40);
        textArea.setEditable(false);
        textArea.append(junLispList.saveString());
        Frame frame = new Frame();
        frame.add("Center", textArea);
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                windowEvent.getWindow().dispose();
            }
        });
        frame.setTitle("Lisp List");
        frame.pack();
        frame.setVisible(true);
        return junLispList;
    }

    public static Jun3dTransformation TransformationFromLispList_(JunLispList junLispList) {
        JunLispCons junLispCons = (JunLispCons)((Object)junLispList.detect_ifNone_(new StBlockClosure(){

            public Object value_(Object object) {
                return new Boolean(object instanceof JunLispCons && ((JunLispCons)((Object)object)).head() == 2.$((String)"transformation"));
            }
        }, new StBlockClosure()));
        if (junLispCons == null) {
            return null;
        }
        Object[] objectArray = ((JunLispCons)((Object)junLispCons.tail())).asArray();
        double[] dArray = new double[16];
        for (int i = 0; i < 16; ++i) {
            dArray[i] = ((Number)objectArray[i]).doubleValue();
        }
        return Jun3dTransformation.FromArray_(dArray);
    }

    public static JunLispList TransformationToLispList_(Jun3dTransformation jun3dTransformation) {
        double[] dArray = jun3dTransformation.asArray();
        JunLispCons junLispCons = JunLispCons.Cell();
        junLispCons.head_(JunOpenGL3dObject.$((String)"transformation"));
        junLispCons.add_(new Double(dArray[0]));
        junLispCons.add_(new Double(dArray[1]));
        junLispCons.add_(new Double(dArray[2]));
        junLispCons.add_(new Double(dArray[3]));
        junLispCons.add_(new Double(dArray[4]));
        junLispCons.add_(new Double(dArray[5]));
        junLispCons.add_(new Double(dArray[6]));
        junLispCons.add_(new Double(dArray[7]));
        junLispCons.add_(new Double(dArray[8]));
        junLispCons.add_(new Double(dArray[9]));
        junLispCons.add_(new Double(dArray[10]));
        junLispCons.add_(new Double(dArray[11]));
        junLispCons.add_(new Double(dArray[12]));
        junLispCons.add_(new Double(dArray[13]));
        junLispCons.add_(new Double(dArray[14]));
        junLispCons.add_(new Double(dArray[15]));
        return junLispCons;
    }

    public static JunOpenGL3dObject ArrowFrom_to_(Jun3dPoint jun3dPoint, Jun3dPoint jun3dPoint2) {
        return JunOpenGL3dTypicalObjectsArrow.ArrowFrom_to_(jun3dPoint, jun3dPoint2);
    }

    public static JunOpenGL3dObject ArrowFrom_to_color_(Jun3dPoint jun3dPoint, Jun3dPoint jun3dPoint2, Color color) {
        return JunOpenGL3dTypicalObjectsArrow.ArrowFrom_to_color_(jun3dPoint, jun3dPoint2, color);
    }

    public static JunOpenGL3dObject ArrowFrom_to_color_lineWidth_(Jun3dPoint jun3dPoint, Jun3dPoint jun3dPoint2, Color color, float f) {
        return JunOpenGL3dTypicalObjectsArrow.ArrowFrom_to_color_lineWidth_(jun3dPoint, jun3dPoint2, color, f);
    }

    public static JunOpenGL3dObject ArrowLine_(Jun3dLine jun3dLine) {
        return JunOpenGL3dTypicalObjectsArrow.ArrowLine_(jun3dLine);
    }

    public static JunOpenGL3dObject ArrowLine_color_lineWidth_(Jun3dLine jun3dLine, Color color) {
        return JunOpenGL3dTypicalObjectsArrow.ArrowLine_color_lineWidth_(jun3dLine, color);
    }

    public static JunOpenGL3dObject ArrowLine_color_lineWidth_(Jun3dLine jun3dLine, Color color, float f) {
        return JunOpenGL3dTypicalObjectsArrow.ArrowLine_color_lineWidth_(jun3dLine, color, f);
    }

    public static JunOpenGL3dObject XArrow() {
        return JunOpenGL3dTypicalObjectsArrow.XArrow();
    }

    public static JunOpenGL3dObject XUnitArrow() {
        return JunOpenGL3dTypicalObjectsArrow.XUnitArrow();
    }

    public static JunOpenGL3dObject XyArrows() {
        return JunOpenGL3dTypicalObjectsArrow.XyArrows();
    }

    public static JunOpenGL3dObject XyUnitArrows() {
        return JunOpenGL3dTypicalObjectsArrow.XyUnitArrows();
    }

    public static JunOpenGL3dObject XyzArrows() {
        return JunOpenGL3dTypicalObjectsArrow.XyzArrows();
    }

    public static JunOpenGL3dObject XyzUnitArrows() {
        return JunOpenGL3dTypicalObjectsArrow.XyzUnitArrows();
    }

    public static JunOpenGL3dObject YArrow() {
        return JunOpenGL3dTypicalObjectsArrow.YArrow();
    }

    public static JunOpenGL3dObject YUnitArrow() {
        return JunOpenGL3dTypicalObjectsArrow.YUnitArrow();
    }

    public static JunOpenGL3dObject YzArrows() {
        return JunOpenGL3dTypicalObjectsArrow.YzArrows();
    }

    public static JunOpenGL3dObject YzUnitArrows() {
        return JunOpenGL3dTypicalObjectsArrow.YzUnitArrows();
    }

    public static JunOpenGL3dObject ZArrow() {
        return JunOpenGL3dTypicalObjectsArrow.ZArrow();
    }

    public static JunOpenGL3dObject ZUnitArrow() {
        return JunOpenGL3dTypicalObjectsArrow.ZUnitArrow();
    }

    public static JunOpenGL3dObject ZxArrows() {
        return JunOpenGL3dTypicalObjectsArrow.ZxArrows();
    }

    public static JunOpenGL3dObject ZxUnitArrows() {
        return JunOpenGL3dTypicalObjectsArrow.ZxUnitArrows();
    }

    public static JunOpenGL3dObject Ball() {
        return JunOpenGL3dTypicalObjectsBall.Ball();
    }

    public static JunOpenGL3dObject Ball_(int n) {
        return JunOpenGL3dTypicalObjectsBall.Ball_(n);
    }

    public static JunOpenGL3dObject Ball_radius_(int n, double d) {
        return JunOpenGL3dTypicalObjectsBall.Ball_radius_(n, d);
    }

    public static JunOpenGL3dObject Ball_radius_center_(int n, double d, Jun3dPoint jun3dPoint) {
        return JunOpenGL3dTypicalObjectsBall.Ball_radius_center_(n, d, jun3dPoint);
    }

    public static JunOpenGL3dObject Ball_smooth_(JunOpenGL3dObject junOpenGL3dObject, int n) {
        return JunOpenGL3dTypicalObjectsBall.Ball_smooth_(junOpenGL3dObject, n);
    }

    public static JunOpenGL3dObject Ball_smooth_interim_(JunOpenGL3dObject junOpenGL3dObject, int n, StBlockClosure stBlockClosure) {
        return JunOpenGL3dTypicalObjectsBall.Ball_smooth_interim_(junOpenGL3dObject, n, stBlockClosure);
    }

    public static JunOpenGL3dObject BallHedron() {
        return JunOpenGL3dTypicalObjectsBall.BallHedron();
    }

    public static JunOpenGL3dObject ColorBall() {
        return JunOpenGL3dTypicalObjectsBall.ColorBall();
    }

    public static JunOpenGL3dObject ColorBall_(int n) {
        return JunOpenGL3dTypicalObjectsBall.ColorBall_(n);
    }

    public static JunOpenGL3dObject ColorBall_radius_(int n, double d) {
        return JunOpenGL3dTypicalObjectsBall.ColorBall_radius_(n, d);
    }

    public static JunOpenGL3dObject ColorBall_radius_center_(int n, double d, Jun3dPoint jun3dPoint) {
        return JunOpenGL3dTypicalObjectsBall.ColorBall_radius_center_(n, d, jun3dPoint);
    }

    public static JunOpenGL3dObject Earth() {
        return JunOpenGL3dTypicalObjectsBall.Earth();
    }

    public static JunOpenGL3dObject SoccerBall() {
        return JunOpenGL3dTypicalObjectsBall.SoccerBall();
    }

    public static JunOpenGL3dObject XUnitBall() {
        return JunOpenGL3dTypicalObjectsBall.XUnitBall();
    }

    public static JunOpenGL3dObject Box() {
        return JunOpenGL3dTypicalObjectsBox.Box();
    }

    public static JunOpenGL3dObject Box_(Jun3dPoint jun3dPoint) {
        return JunOpenGL3dTypicalObjectsBox.Box_(jun3dPoint);
    }

    public static JunOpenGL3dObject ColorCube() {
        return JunOpenGL3dTypicalObjectsBox.ColorCube();
    }

    public static JunOpenGL3dObject Cube() {
        return JunOpenGL3dTypicalObjectsBox.Cube();
    }

    public static JunOpenGL3dObject Origin_corner_(Jun3dPoint jun3dPoint, Jun3dPoint jun3dPoint2) {
        return JunOpenGL3dTypicalObjectsBox.Origin_corner_(jun3dPoint, jun3dPoint2);
    }

    public static JunOpenGL3dObject Origin_extent_(Jun3dPoint jun3dPoint, Jun3dPoint jun3dPoint2) {
        return JunOpenGL3dTypicalObjectsBox.Origin_extent_(jun3dPoint, jun3dPoint2);
    }

    public static JunOpenGL3dObject XUnitBox() {
        return JunOpenGL3dTypicalObjectsBox.XUnitBox();
    }

    public static JunOpenGL3dObject Acetylcholine() {
        return JunOpenGL3dTypicalObjectsChemical.Acetylcholine();
    }

    public static JunOpenGL3dObject Adrenaline() {
        return JunOpenGL3dTypicalObjectsChemical.Adrenaline();
    }

    public static JunOpenGL3dObject Alanine() {
        return JunOpenGL3dTypicalObjectsChemical.Alanine();
    }

    public static JunOpenGL3dObject Anthracene() {
        return JunOpenGL3dTypicalObjectsChemical.Anthracene();
    }

    public static JunOpenGL3dObject Benzene() {
        return JunOpenGL3dTypicalObjectsChemical.Benzene();
    }

    public static JunOpenGL3dObject Capsaicin() {
        return JunOpenGL3dTypicalObjectsChemical.Capsaicin();
    }

    public static JunOpenGL3dObject Catechin() {
        return JunOpenGL3dTypicalObjectsChemical.Catechin();
    }

    public static JunOpenGL3dObject Chloroform() {
        return JunOpenGL3dTypicalObjectsChemical.Chloroform();
    }

    public static JunOpenGL3dObject Cystine() {
        return JunOpenGL3dTypicalObjectsChemical.Cystine();
    }

    public static JunOpenGL3dObject Dopamine() {
        return JunOpenGL3dTypicalObjectsChemical.Dopamine();
    }

    public static JunOpenGL3dObject Luminol() {
        return JunOpenGL3dTypicalObjectsChemical.Luminol();
    }

    public static JunOpenGL3dObject Melatonin() {
        return JunOpenGL3dTypicalObjectsChemical.Melatonin();
    }

    public static JunOpenGL3dObject Methane() {
        return JunOpenGL3dTypicalObjectsChemical.Methane();
    }

    public static JunOpenGL3dObject Naphthalene() {
        return JunOpenGL3dTypicalObjectsChemical.Naphthalene();
    }

    public static JunOpenGL3dObject Serotonin() {
        return JunOpenGL3dTypicalObjectsChemical.Serotonin();
    }

    public static JunOpenGL3dObject Tryptophan() {
        return JunOpenGL3dTypicalObjectsChemical.Tryptophan();
    }

    public static JunOpenGL3dObject Tyrosine() {
        return JunOpenGL3dTypicalObjectsChemical.Tyrosine();
    }

    public static JunOpenGL3dObject Water() {
        return JunOpenGL3dTypicalObjectsChemical.Water();
    }

    public static JunOpenGL3dObject Circle() {
        return JunOpenGL3dTypicalObjectsCircle.Circle();
    }

    public static JunOpenGL3dObject CircleBy_(double d) {
        return JunOpenGL3dTypicalObjectsCircle.CircleBy_(d);
    }

    public static JunOpenGL3dObject CircleBy_radius_(double d, double d2) {
        return JunOpenGL3dTypicalObjectsCircle.CircleBy_radius_(d, d2);
    }

    public static JunOpenGL3dObject CircleBy_radius_upVector_(double d, double d2, Jun3dPoint jun3dPoint) {
        return JunOpenGL3dTypicalObjectsCircle.CircleBy_radius_upVector_(d, d2, jun3dPoint);
    }

    public static JunOpenGL3dObject XUnitCircle() {
        return JunOpenGL3dTypicalObjectsCircle.XUnitCircle();
    }

    public static JunOpenGL3dObject ColorCone() {
        return JunOpenGL3dTypicalObjectsCone.ColorCone();
    }

    public static JunOpenGL3dObject Cone() {
        return JunOpenGL3dTypicalObjectsCone.Cone();
    }

    public static JunOpenGL3dObject Cone_(double d) {
        return JunOpenGL3dTypicalObjectsCone.Cone_(d);
    }

    public static JunOpenGL3dObject Cone_radius_height_(double d, double d2, double d3) {
        return JunOpenGL3dTypicalObjectsCone.Cone_radius_height_(d, d2, d3);
    }

    public static JunOpenGL3dObject ConeFrom_to_radius_by_(Jun3dPoint jun3dPoint, Jun3dPoint jun3dPoint2, double d, int n) {
        return JunOpenGL3dTypicalObjectsCone.ConeFrom_to_radius_by_(jun3dPoint, jun3dPoint2, d, n);
    }

    public static JunOpenGL3dObject ConeFrom_to_width_(Jun3dPoint jun3dPoint, Jun3dPoint jun3dPoint2, double d) {
        return JunOpenGL3dTypicalObjectsCone.ConeFrom_to_width_(jun3dPoint, jun3dPoint2, d);
    }

    public static JunOpenGL3dObject XUnitCone() {
        return JunOpenGL3dTypicalObjectsCone.XUnitCone();
    }

    public static JunOpenGL3dObject Cylinder() {
        return JunOpenGL3dTypicalObjectsCylinder.Cylinder();
    }

    public static JunOpenGL3dObject CylinderBy_(double d) {
        return JunOpenGL3dTypicalObjectsCylinder.CylinderBy_(d);
    }

    public static JunOpenGL3dObject CylinderBy_radius_(double d, double d2) {
        return JunOpenGL3dTypicalObjectsCylinder.CylinderBy_radius_(d, d2);
    }

    public static JunOpenGL3dObject CylinderBy_radius_height_(double d, double d2, double d3) {
        return JunOpenGL3dTypicalObjectsCylinder.CylinderBy_radius_height_(d, d2, d3);
    }

    public static JunOpenGL3dObject CylinderFrom_to_radius_by_(Jun3dPoint jun3dPoint, Jun3dPoint jun3dPoint2, double d, double d2) {
        return JunOpenGL3dTypicalObjectsCylinder.CylinderFrom_to_radius_by_(jun3dPoint, jun3dPoint2, d, d2);
    }

    public static JunOpenGL3dObject CylinderFrom_to_width_(Jun3dPoint jun3dPoint, Jun3dPoint jun3dPoint2, double d) {
        return JunOpenGL3dTypicalObjectsCylinder.CylinderFrom_to_width_(jun3dPoint, jun3dPoint2, d);
    }

    public static JunOpenGL3dObject CylinderFrom_to_width_by_(Jun3dPoint jun3dPoint, Jun3dPoint jun3dPoint2, double d, double d2) {
        return JunOpenGL3dTypicalObjectsCylinder.CylinderFrom_to_width_by_(jun3dPoint, jun3dPoint2, d, d2);
    }

    public static JunOpenGL3dObject XUnitCylinder() {
        return JunOpenGL3dTypicalObjectsCylinder.XUnitCylinder();
    }

    public static JunOpenGL3dObject Cuboctahedron() {
        return JunOpenGL3dTypicalObjectsHedron.Cuboctahedron();
    }

    public static JunOpenGL3dObject Icosidodecahedron() {
        return JunOpenGL3dTypicalObjectsHedron.Icosidodecahedron();
    }

    public static JunOpenGL3dObject PentakisDodecahedron() {
        return JunOpenGL3dTypicalObjectsHedron.PentakisDodecahedron();
    }

    public static JunOpenGL3dObject RegularDodecahedron() {
        return JunOpenGL3dTypicalObjectsHedron.RegularDodecahedron();
    }

    public static JunOpenGL3dObject RegularHexahedron() {
        return JunOpenGL3dTypicalObjectsHedron.RegularHexahedron();
    }

    public static JunOpenGL3dObject RegularIcosahedron() {
        return JunOpenGL3dTypicalObjectsHedron.RegularIcosahedron();
    }

    public static JunOpenGL3dObject RegularOctahedron() {
        return JunOpenGL3dTypicalObjectsHedron.RegularOctahedron();
    }

    public static JunOpenGL3dObject RegularTetrahedron() {
        return JunOpenGL3dTypicalObjectsHedron.RegularTetrahedron();
    }

    public static JunOpenGL3dObject TetrakisHexahedron() {
        return JunOpenGL3dTypicalObjectsHedron.TetrakisHexahedron();
    }

    public static JunOpenGL3dObject TriakisIcosahedron() {
        return JunOpenGL3dTypicalObjectsHedron.TriakisIcosahedron();
    }

    public static JunOpenGL3dObject TriakisOctahedron() {
        return JunOpenGL3dTypicalObjectsHedron.TriakisOctahedron();
    }

    public static JunOpenGL3dObject TruncatedDodecahedron() {
        return JunOpenGL3dTypicalObjectsHedron.TruncatedDodecahedron();
    }

    public static JunOpenGL3dObject TruncatedHexahedron() {
        return JunOpenGL3dTypicalObjectsHedron.TruncatedHexahedron();
    }

    public static JunOpenGL3dObject TruncatedIcosahedron() {
        return JunOpenGL3dTypicalObjectsHedron.TruncatedIcosahedron();
    }

    public static JunOpenGL3dObject TruncatedOctahedron() {
        return JunOpenGL3dTypicalObjectsHedron.TruncatedOctahedron();
    }

    public static JunOpenGL3dObject TruncatedTetrahedron() {
        return JunOpenGL3dTypicalObjectsHedron.TruncatedTetrahedron();
    }

    public static StImage ImageBMWC() {
        return JunOpenGL3dTypicalObjectsImage.ImageBMWC();
    }

    public static StImage ImageBMWC_(int n) {
        return JunOpenGL3dTypicalObjectsImage.ImageBMWC_(n);
    }

    public static StImage ImageEarth() {
        return JunOpenGL3dTypicalObjectsImage.ImageEarth();
    }

    public static StImage ImageGCWY() {
        return JunOpenGL3dTypicalObjectsImage.ImageGCWY();
    }

    public static StImage ImageGCWY_(int n) {
        return JunOpenGL3dTypicalObjectsImage.ImageGCWY_(n);
    }

    public static StImage ImageKBCG() {
        return JunOpenGL3dTypicalObjectsImage.ImageKBCG();
    }

    public static StImage ImageKBCG_(int n) {
        return JunOpenGL3dTypicalObjectsImage.ImageKBCG_(n);
    }

    public static StImage ImageKGYR() {
        return JunOpenGL3dTypicalObjectsImage.ImageKGYR();
    }

    public static StImage ImageKGYR_(int n) {
        return JunOpenGL3dTypicalObjectsImage.ImageKGYR_(n);
    }

    public static StImage ImageKRMB() {
        return JunOpenGL3dTypicalObjectsImage.ImageKRMB();
    }

    public static StImage ImageKRMB_(int n) {
        return JunOpenGL3dTypicalObjectsImage.ImageKRMB_(n);
    }

    public static StImage ImageRBBR() {
        return JunOpenGL3dTypicalObjectsImage.ImageRBBR();
    }

    public static StImage ImageRBBR_(int n) {
        return JunOpenGL3dTypicalObjectsImage.ImageRBBR_(n);
    }

    public static StImage ImageRGBR() {
        return JunOpenGL3dTypicalObjectsImage.ImageRGBR();
    }

    public static StImage ImageRGBR_(int n) {
        return JunOpenGL3dTypicalObjectsImage.ImageRGBR_(n);
    }

    public static StImage ImageRYWM() {
        return JunOpenGL3dTypicalObjectsImage.ImageRYWM();
    }

    public static StImage ImageRYWM_(int n) {
        return JunOpenGL3dTypicalObjectsImage.ImageRYWM_(n);
    }

    public static JunOpenGL3dObject Anpanman() {
        return JunOpenGL3dTypicalObjectsMisc.Anpanman();
    }

    public static JunOpenGL3dObject Aoki() {
        return JunOpenGL3dTypicalObjectsMisc.Aoki();
    }

    public static JunOpenGL3dObject Aoki1() {
        return JunOpenGL3dTypicalObjectsMisc.Aoki1();
    }

    public static JunOpenGL3dObject Aoki2() {
        return JunOpenGL3dTypicalObjectsMisc.Aoki2();
    }

    public static JunOpenGL3dObject Arowana() {
        return JunOpenGL3dTypicalObjectsMisc.Arowana();
    }

    public static JunOpenGL3dObject Axes() {
        return JunOpenGL3dTypicalObjectsMisc.Axes();
    }

    public static JunOpenGL3dObject Axes2() {
        return JunOpenGL3dTypicalObjectsMisc.Axes2();
    }

    public static JunOpenGL3dObject Baby() {
        return JunOpenGL3dTypicalObjectsMisc.Baby();
    }

    public static JunOpenGL3dObject Bell() {
        return JunOpenGL3dTypicalObjectsMisc.Bell();
    }

    public static JunOpenGL3dObject Dolphin() {
        return JunOpenGL3dTypicalObjectsMisc.Dolphin();
    }

    public static JunOpenGL3dObject Doraemon() {
        return JunOpenGL3dTypicalObjectsMisc.Doraemon();
    }

    public static JunOpenGL3dObject Earl() {
        return JunOpenGL3dTypicalObjectsMisc.Earl();
    }

    public static JunOpenGL3dObject Eddy() {
        return JunOpenGL3dTypicalObjectsMisc.Eddy();
    }

    public static JunOpenGL3dObject Hand() {
        return JunOpenGL3dTypicalObjectsMisc.Hand();
    }

    public static JunOpenGL3dObject Mickey() {
        return JunOpenGL3dTypicalObjectsMisc.Mickey();
    }

    public static JunOpenGL3dObject Mickey1() {
        return JunOpenGL3dTypicalObjectsMisc.Mickey1();
    }

    public static JunOpenGL3dObject Mickey3() {
        return JunOpenGL3dTypicalObjectsMisc.Mickey3();
    }

    public static JunOpenGL3dObject Minnie() {
        return JunOpenGL3dTypicalObjectsMisc.Minnie();
    }

    public static JunOpenGL3dObject Mouse() {
        return JunOpenGL3dTypicalObjectsMisc.Mouse();
    }

    public static JunOpenGL3dObject Oni() {
        return JunOpenGL3dTypicalObjectsMisc.Oni();
    }

    public static JunOpenGL3dObject Panda() {
        return JunOpenGL3dTypicalObjectsMisc.Panda();
    }

    public static JunOpenGL3dObject Panda2() {
        return JunOpenGL3dTypicalObjectsMisc.Panda2();
    }

    public static JunOpenGL3dObject Penguin() {
        return JunOpenGL3dTypicalObjectsMisc.Penguin();
    }

    public static JunOpenGL3dObject Pooh() {
        return JunOpenGL3dTypicalObjectsMisc.Pooh();
    }

    public static JunOpenGL3dObject Raptor() {
        return JunOpenGL3dTypicalObjectsMisc.Raptor();
    }

    public static JunOpenGL3dObject Smalltalk() {
        return JunOpenGL3dTypicalObjectsMisc.Smalltalk();
    }

    public static JunOpenGL3dObject SmalltalkCube() {
        return JunOpenGL3dTypicalObjectsMisc.SmalltalkCube();
    }

    public static JunOpenGL3dObject SmalltalkPlane() {
        return JunOpenGL3dTypicalObjectsMisc.SmalltalkPlane();
    }

    public static JunOpenGL3dObject Stack() {
        return JunOpenGL3dTypicalObjectsMisc.Stack();
    }

    public static JunOpenGL3dObject Triball() {
        return JunOpenGL3dTypicalObjectsMisc.Triball();
    }

    public static JunOpenGL3dObject Wasp() {
        return JunOpenGL3dTypicalObjectsMisc.Wasp();
    }

    public static JunOpenGL3dObject Wyvern() {
        return JunOpenGL3dTypicalObjectsMisc.Wyvern();
    }

    public static JunOpenGL3dObject Mobius() {
        return JunOpenGL3dTypicalObjectsMobius.Mobius();
    }

    public static JunOpenGL3dObject MobiusRadius_divisions_stripRadius_(double d, int n, double d2) {
        return JunOpenGL3dTypicalObjectsMobius.MobiusRadius_divisions_stripRadius_(d, n, d2);
    }

    public static JunOpenGL3dObject MobiusRadius_divisions_stripRadius_divisions_(double d, int n, double d2, int n2) {
        return JunOpenGL3dTypicalObjectsMobius.MobiusRadius_divisions_stripRadius_divisions_(d, n, d2, n2);
    }

    public static JunOpenGL3dObject MobiusRadius_divisions_stripRadius_locusDo_(double d, int n, double d2, StBlockClosure stBlockClosure) {
        return JunOpenGL3dTypicalObjectsMobius.MobiusRadius_divisions_stripRadius_locusDo_(d, n, d2, stBlockClosure);
    }

    public static JunOpenGL3dObject MobiusRadius_stripRadius_(double d, double d2) {
        return JunOpenGL3dTypicalObjectsMobius.MobiusRadius_stripRadius_(d, d2);
    }

    public static JunOpenGL3dObject MobiusStrip() {
        return JunOpenGL3dTypicalObjectsMobius.MobiusStrip();
    }

    public static JunOpenGL3dObject MobiusStripRadius_divisions_stripRadius_divisions_(double d, int n, double d2, int n2) {
        return JunOpenGL3dTypicalObjectsMobius.MobiusStripRadius_divisions_stripRadius_divisions_(d, n, d2, n2);
    }

    public static JunOpenGL3dObject MobiusStripRadius_divisions_stripRadius_divisions_thicknessFactor_(double d, int n, double d2, int n2, double d3) {
        return JunOpenGL3dTypicalObjectsMobius.MobiusStripRadius_divisions_stripRadius_divisions_thicknessFactor_(d, n, d2, n2, d3);
    }

    public static JunOpenGL3dObject ChunkOfPieFrom_to_by_(double d, double d2, double d3) {
        return JunOpenGL3dTypicalObjectsPie.ChunkOfPieFrom_to_by_(d, d2, d3);
    }

    public static JunOpenGL3dObject ChunkOfPieFrom_to_by_radius_(double d, double d2, double d3, double d4) {
        return JunOpenGL3dTypicalObjectsPie.ChunkOfPieFrom_to_by_radius_(d, d2, d3, d4);
    }

    public static JunOpenGL3dObject ChunkOfPieFrom_to_by_radius_thickness_(double d, double d2, double d3, double d4, double d5) {
        return JunOpenGL3dTypicalObjectsPie.ChunkOfPieFrom_to_by_radius_thickness_(d, d2, d3, d4, d5);
    }

    public static JunOpenGL3dObject PieFrom_to_by_(double d, double d2, double d3) {
        return JunOpenGL3dTypicalObjectsPie.PieFrom_to_by_(d, d2, d3);
    }

    public static JunOpenGL3dObject PieFrom_to_by_radius_(double d, double d2, double d3, double d4) {
        return JunOpenGL3dTypicalObjectsPie.PieFrom_to_by_radius_(d, d2, d3, d4);
    }

    public static JunOpenGL3dObject PieFrom_to_by_radius_thickness_(double d, double d2, double d3, double d4, double d5) {
        return JunOpenGL3dTypicalObjectsPie.PieFrom_to_by_radius_thickness_(d, d2, d3, d4, d5);
    }

    public static JunOpenGL3dObject SlicedPieFrom_to_by_(double d, double d2, double d3) {
        return JunOpenGL3dTypicalObjectsPie.SlicedPieFrom_to_by_(d, d2, d3);
    }

    public static JunOpenGL3dObject SlicedPieFrom_to_by_radius_(double d, double d2, double d3, double d4) {
        return JunOpenGL3dTypicalObjectsPie.SlicedPieFrom_to_by_radius_(d, d2, d3, d4);
    }

    public static JunOpenGL3dObject SlicedPieFrom_to_by_radius_thickness_(double d, double d2, double d3, double d4, double d5) {
        return JunOpenGL3dTypicalObjectsPie.SlicedPieFrom_to_by_radius_thickness_(d, d2, d3, d4, d5);
    }

    public static JunOpenGL3dObject PlateBMWC() {
        return JunOpenGL3dTypicalObjectsPlate.PlateBMWC();
    }

    public static JunOpenGL3dObject PlateGCWY() {
        return JunOpenGL3dTypicalObjectsPlate.PlateGCWY();
    }

    public static JunOpenGL3dObject PlateKBCG() {
        return JunOpenGL3dTypicalObjectsPlate.PlateKBCG();
    }

    public static JunOpenGL3dObject PlateKGYR() {
        return JunOpenGL3dTypicalObjectsPlate.PlateKGYR();
    }

    public static JunOpenGL3dObject PlateKRMB() {
        return JunOpenGL3dTypicalObjectsPlate.PlateKRMB();
    }

    public static JunOpenGL3dObject PlateRYWM() {
        return JunOpenGL3dTypicalObjectsPlate.PlateRYWM();
    }

    public static JunOpenGL3dObject Globe() {
        return JunOpenGL3dTypicalObjectsShpere.Globe();
    }

    public static JunOpenGL3dObject Globe_(double d) {
        return JunOpenGL3dTypicalObjectsShpere.Globe_(d);
    }

    public static JunOpenGL3dObject Globe_radius_(double d, double d2) {
        return JunOpenGL3dTypicalObjectsShpere.Globe_radius_(d, d2);
    }

    public static JunOpenGL3dObject Globe_radius_center_(double d, double d2, Jun3dPoint jun3dPoint) {
        return JunOpenGL3dTypicalObjectsShpere.Globe_radius_center_(d, d2, jun3dPoint);
    }

    public static JunOpenGL3dObject Hemisphere() {
        return JunOpenGL3dTypicalObjectsShpere.Hemisphere();
    }

    public static JunOpenGL3dObject Hemisphere_(double d) {
        return JunOpenGL3dTypicalObjectsShpere.Hemisphere_(d);
    }

    public static JunOpenGL3dObject Hemisphere_redius_(double d, double d2) {
        return JunOpenGL3dTypicalObjectsShpere.Hemisphere_redius_(d, d2);
    }

    public static JunOpenGL3dObject Hemisphere_redius_center_(double d, double d2, Jun3dPoint jun3dPoint) {
        return JunOpenGL3dTypicalObjectsShpere.Hemisphere_redius_center_(d, d2, jun3dPoint);
    }

    public static JunOpenGL3dObject Sphere() {
        return JunOpenGL3dTypicalObjectsShpere.Sphere();
    }

    public static JunOpenGL3dObject Sphere_(double d) {
        return JunOpenGL3dTypicalObjectsShpere.Sphere_(d);
    }

    public static JunOpenGL3dObject Sphere_radius_(double d, double d2) {
        return JunOpenGL3dTypicalObjectsShpere.Sphere_radius_(d, d2);
    }

    public static JunOpenGL3dObject Sphere_radius_center_(double d, double d2, Jun3dPoint jun3dPoint) {
        return JunOpenGL3dTypicalObjectsShpere.Sphere_radius_center_(d, d2, jun3dPoint);
    }

    public static JunOpenGL3dObject Sphere_radius_longitude_latitude_(double d, double d2, double d3, double d4) {
        return JunOpenGL3dTypicalObjectsShpere.Sphere_radius_longitude_latitude_(d, d2, d3, d4);
    }

    public static Object[] XyPointsAndSphere_radius_longitude_latitude_(double d, double d2, double d3, double d4) {
        return JunOpenGL3dTypicalObjectsShpere.XyPointsAndSphere_radius_longitude_latitude_(d, d2, d3, d4);
    }

    public static JunOpenGL3dObject Spring() {
        return JunOpenGL3dTypicalObjectsSpring.Spring();
    }

    public static JunOpenGL3dObject SpringBy_radius_height_(int n, double d, int n2) {
        return JunOpenGL3dTypicalObjectsSpring.SpringBy_radius_height_(n, d, n2);
    }

    public static JunOpenGL3dObject SpringBy_radius_height_repeat_(int n, double d, int n2, int n3) {
        return JunOpenGL3dTypicalObjectsSpring.SpringBy_radius_height_repeat_(n, d, n2, n3);
    }

    public static JunOpenGL3dObject SpringFrom_to_width_(Jun3dPoint jun3dPoint, Jun3dPoint jun3dPoint2, double d) {
        return JunOpenGL3dTypicalObjectsSpring.SpringFrom_to_width_(jun3dPoint, jun3dPoint, d);
    }

    public static JunOpenGL3dObject SpringFrom_to_width_repeat_(Jun3dPoint jun3dPoint, Jun3dPoint jun3dPoint2, double d, int n) {
        return JunOpenGL3dTypicalObjectsSpring.SpringFrom_to_width_repeat_(jun3dPoint, jun3dPoint, d, n);
    }

    public static JunOpenGL3dObject XUnitSpring() {
        return JunOpenGL3dTypicalObjectsSpring.XUnitSpring();
    }

    public static JunOpenGL3dObject CharacterN() {
        return JunOpenGL3dTypicalObjectsText.CharacterN();
    }

    public static JunOpenGL3dObject Text_(StComposedText stComposedText) {
        return JunOpenGL3dTypicalObjectsText.Text_(stComposedText);
    }

    public static JunOpenGL3dObject Text_(String string) {
        return JunOpenGL3dTypicalObjectsText.Text_(string);
    }

    public static JunOpenGL3dObject Text_font_(String string, Font font) {
        return JunOpenGL3dTypicalObjectsText.Text_font_(string, font);
    }

    public static JunOpenGL3dObject Text2d_(String string) {
        return JunOpenGL3dTypicalObjectsText.Text2d_(string);
    }

    public static JunOpenGL3dObject Text2d_weight_(String string, double d) {
        return JunOpenGL3dTypicalObjectsText.Text2d_weight_(string, d);
    }

    public static JunOpenGL3dObject Text2d_weight_font_(String string, double d, Font font) {
        return JunOpenGL3dTypicalObjectsText.Text2d_weight_font_(string, d, font);
    }

    public static JunOpenGL3dObject Text2d_weight_(StComposedText stComposedText, double d) {
        return JunOpenGL3dTypicalObjectsText.Text2d_weight_(stComposedText, d);
    }

    public static JunOpenGL3dObject Text3d_(String string) {
        return JunOpenGL3dTypicalObjectsText.Text3d_(string);
    }

    public static JunOpenGL3dObject Text3d_weight_(String string, double d) {
        return JunOpenGL3dTypicalObjectsText.Text3d_weight_(string, d);
    }

    public static JunOpenGL3dObject Text3d_weight_font_(String string, double d, Font font) {
        return JunOpenGL3dTypicalObjectsText.Text3d_weight_font_(string, d, font);
    }

    public static JunOpenGL3dObject Text3d_weight_(StComposedText stComposedText, double d) {
        return JunOpenGL3dTypicalObjectsText.Text3d_weight_(stComposedText, d);
    }

    public static JunOpenGL3dObject Torus() {
        return JunOpenGL3dTypicalObjectsTorus.Torus();
    }

    public static JunOpenGL3dObject Torus_divisions_radius_divisions_(double d, int n, double d2, int n2) {
        return JunOpenGL3dTypicalObjectsTorus.Torus_divisions_radius_divisions_(d, n, d2, n2);
    }

    public static JunOpenGL3dObject Torus_radius_(int n, double d) {
        return JunOpenGL3dTypicalObjectsTorus.Torus_radius_(n, d);
    }

    public static JunOpenGL3dObject TorusRadius_divisions_tubeRadius_divisions_(double d, int n, double d2, int n2) {
        return JunOpenGL3dTypicalObjectsTorus.TorusRadius_divisions_tubeRadius_divisions_(d, n, d2, n2);
    }

    public static JunOpenGL3dObject TorusRadius_tubeRadius_(double d, double d2) {
        return JunOpenGL3dTypicalObjectsTorus.TorusRadius_tubeRadius_(d, d2);
    }

    public static JunOpenGL3dObject From_to_height_depth_with_(Jun3dPoint jun3dPoint, Jun3dPoint jun3dPoint2, double d, double d2, JunOpenGL3dObject junOpenGL3dObject) {
        return JunOpenGL3dTypicalObjects.From_to_height_depth_with_(jun3dPoint, jun3dPoint2, d, d2, junOpenGL3dObject);
    }

    public static JunOpenGL3dObject From_to_with_(Jun3dPoint jun3dPoint, Jun3dPoint jun3dPoint2, JunOpenGL3dObject junOpenGL3dObject) {
        return JunOpenGL3dTypicalObjects.From_to_with_(jun3dPoint, jun3dPoint2, junOpenGL3dObject);
    }

    public static JunOpenGL3dObject Rotate_divisions_(Jun2dPoint[] jun2dPointArray, int n) {
        return JunOpenGL3dTypicalObjects.Rotate_divisions_(jun2dPointArray, n);
    }

    public static Color SampleColor() {
        Vector vector = StColorValue.ConstantNames();
        StSymbol stSymbol = (StSymbol)vector.elementAt((int)Math.round(Math.random() * (double)(vector.size() - 1)));
        return StColorValue._GetColorByName_((String)stSymbol.toString());
    }

    public static JunOpenGLDisplayModel ShowWithNormalVectors_(JunOpenGL3dObject junOpenGL3dObject) {
        final JunOpenGL3dCompoundObject junOpenGL3dCompoundObject = new JunOpenGL3dCompoundObject();
        junOpenGL3dCompoundObject.add_(junOpenGL3dObject);
        junOpenGL3dObject.polygonsDo_(new StBlockClosure(){

            public Object value_(Object object) {
                JunOpenGL3dPolygon junOpenGL3dPolygon = (JunOpenGL3dPolygon)((Object)object);
                for (int i = 0; i < junOpenGL3dPolygon.numberOfVertexes(); ++i) {
                    if (i >= junOpenGL3dPolygon.normalVectors().length) continue;
                    Jun3dPoint jun3dPoint = junOpenGL3dPolygon.vertexAt(i);
                    JunOpenGL3dPolyline junOpenGL3dPolyline = new JunOpenGL3dPolyline(new Jun3dPoint[]{jun3dPoint, jun3dPoint.plus_(junOpenGL3dPolygon.normalVectors()[i])});
                    junOpenGL3dCompoundObject.add_(junOpenGL3dPolyline);
                }
                return null;
            }
        });
        return junOpenGL3dCompoundObject.show();
    }

    public static String UniqueId() {
        long l = System.currentTimeMillis();
        if (l == IdClock) {
            ++IdNumber;
        } else {
            IdClock = l;
            IdNumber = 0L;
        }
        return "id" + new Long(IdClock).toString() + new Long(IdNumber).toString();
    }

    public JunOpenGL3dObject() {
    }

    protected JunOpenGL3dObject(JunLispList junLispList) {
        this();
        this.fromLispList(junLispList);
    }

    protected void initialize() {
        super.initialize();
        this.name = null;
        this.paint = null;
        this.alpha = Float.NaN;
        this.bounds = null;
    }

    public float alpha() {
        if (!this.hasAlpha()) {
            return this.defaultAlpha();
        }
        return this.alpha;
    }

    public void alpha_(float f) {
        this.alpha = f;
    }

    public double area() {
        double d = 0.0;
        Jun3dTriangle[] jun3dTriangleArray = this.asTriangles();
        for (int i = 0; i < jun3dTriangleArray.length; ++i) {
            d += jun3dTriangleArray[i].area();
        }
        return d;
    }

    public void halftone() {
        this.halftone_(0.5);
    }

    public void halftone_(double d) {
    }

    public String legalName() {
        StringWriter stringWriter = new StringWriter();
        String string = this.name();
        if (!Character.isLetter(string.charAt(0))) {
            stringWriter.write("id");
        }
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (Character.isLetterOrDigit(c)) {
                stringWriter.write(c);
                continue;
            }
            stringWriter.write("_");
        }
        return stringWriter.toString();
    }

    public String name() {
        if (this.name == null) {
            return this.defaultName();
        }
        return this.name;
    }

    public void name_(String string) {
        this.name = string;
    }

    public Color paint() {
        if (this.paint == null) {
            return this.defaultPaint();
        }
        return this.paint;
    }

    public void paint_(Color color) {
        this.paint = color;
    }

    public void paint_alpha_(Color color, float f) {
        this.paint_(color);
        this.alpha_(f);
    }

    public JunAngle smoothingAngle() {
        return null;
    }

    public JunOpenGLStipple stipple() {
        return null;
    }

    public void stipple_(JunOpenGLStipple junOpenGLStipple) {
    }

    public JunOpenGLTexture texture() {
        return null;
    }

    public void texture_(JunOpenGLTexture junOpenGLTexture) {
        if (junOpenGLTexture != null) {
            junOpenGLTexture.object_(this);
            if (!this.hasColor()) {
                this.paint_(Color.white);
            }
        }
    }

    public Jun3dBoundingBox boundingBox() {
        if (this.bounds == null) {
            this.bounds = this.preferredBoundingBox();
        }
        return this.bounds;
    }

    public Jun3dPoint center() {
        return this.boundingBox().center();
    }

    public Jun3dPoint corner() {
        return this.boundingBox().corner();
    }

    public double depth() {
        return this.boundingBox().depth();
    }

    public Jun3dPoint extent() {
        return this.boundingBox().extent();
    }

    public double height() {
        return this.boundingBox().height();
    }

    public Jun3dPoint origin() {
        return this.boundingBox().origin();
    }

    public double width() {
        return this.boundingBox().width();
    }

    protected Jun3dBoundingBox preferredBoundingBox() {
        final StValueHolder stValueHolder = new StValueHolder(Double.POSITIVE_INFINITY);
        final StValueHolder stValueHolder2 = new StValueHolder(Double.POSITIVE_INFINITY);
        final StValueHolder stValueHolder3 = new StValueHolder(Double.POSITIVE_INFINITY);
        final StValueHolder stValueHolder4 = new StValueHolder(Double.NEGATIVE_INFINITY);
        final StValueHolder stValueHolder5 = new StValueHolder(Double.NEGATIVE_INFINITY);
        final StValueHolder stValueHolder6 = new StValueHolder(Double.NEGATIVE_INFINITY);
        this.pointsDo_(new StBlockClosure(){

            public Object value_(Object object) {
                Jun3dPoint jun3dPoint = (Jun3dPoint)((Object)object);
                stValueHolder.value_(Math.min(stValueHolder._doubleValue(), jun3dPoint.x()));
                stValueHolder2.value_(Math.min(stValueHolder2._doubleValue(), jun3dPoint.y()));
                stValueHolder3.value_(Math.min(stValueHolder3._doubleValue(), jun3dPoint.z()));
                stValueHolder4.value_(Math.max(stValueHolder4._doubleValue(), jun3dPoint.x()));
                stValueHolder5.value_(Math.max(stValueHolder5._doubleValue(), jun3dPoint.y()));
                stValueHolder6.value_(Math.max(stValueHolder6._doubleValue(), jun3dPoint.z()));
                return null;
            }
        });
        if (stValueHolder._doubleValue() == Double.POSITIVE_INFINITY) {
            stValueHolder.value_(0);
        }
        if (stValueHolder2._doubleValue() == Double.POSITIVE_INFINITY) {
            stValueHolder2.value_(0);
        }
        if (stValueHolder3._doubleValue() == Double.POSITIVE_INFINITY) {
            stValueHolder3.value_(0);
        }
        if (stValueHolder4._doubleValue() == Double.NEGATIVE_INFINITY) {
            stValueHolder4.value_(0);
        }
        if (stValueHolder5._doubleValue() == Double.NEGATIVE_INFINITY) {
            stValueHolder5.value_(0);
        }
        if (stValueHolder6._doubleValue() == Double.NEGATIVE_INFINITY) {
            stValueHolder6.value_(0);
        }
        Jun3dPoint jun3dPoint = new Jun3dPoint(stValueHolder._doubleValue(), stValueHolder2._doubleValue(), stValueHolder3._doubleValue());
        Jun3dPoint jun3dPoint2 = new Jun3dPoint(stValueHolder4._doubleValue(), stValueHolder5._doubleValue(), stValueHolder6._doubleValue());
        return Jun3dBoundingBox.Origin_corner_(jun3dPoint, jun3dPoint2);
    }

    public void establishAllNormalVectors() {
        this.establishAllNormalVectorsWithSmoothingAngle_(this.defaultSmoothingAngle());
    }

    public void establishAllNormalVectorsWithSmoothingAngle_(JunAngle junAngle) {
    }

    public abstract void flushAllAlphas();

    public void flushAllAlpha() {
        this.flushAllAlphas();
    }

    public abstract void flushAllBounds();

    public abstract void flushAllColors();

    public abstract void flushAllNames();

    public void flushAllName() {
        this.flushAllNames();
    }

    public abstract void flushAllNormalVectors();

    public abstract void flushAllPaints();

    public void flushAllPaint() {
        this.flushAllPaints();
    }

    public void flushAlpha() {
        this.alpha = Float.NaN;
    }

    public void flushBounds() {
        this.bounds = null;
    }

    public void flushColors() {
    }

    public void flushName() {
        this.name = null;
    }

    public void flushNormalVectors() {
    }

    public void flushPaint() {
        this.paint = null;
    }

    public boolean hasAlpha() {
        return !Float.isNaN(this.alpha);
    }

    public boolean hasColor() {
        return this.hasPaint() || this.hasAlpha();
    }

    public boolean hasColors() {
        return false;
    }

    public boolean hasName() {
        return this.name != null;
    }

    public boolean hasNormalVectors() {
        return false;
    }

    public boolean hasPaint() {
        return this.paint != null;
    }

    public boolean hasStipple() {
        return false;
    }

    public boolean hasTexture() {
        return false;
    }

    public boolean hasTransparency() {
        return this.hasAlpha() && (double)this.alpha() < 1.0;
    }

    public boolean isCompound() {
        return false;
    }

    public boolean isPolygon() {
        return false;
    }

    public boolean isPolyline() {
        return false;
    }

    public boolean isPrimitive() {
        return false;
    }

    public boolean isTransformedObject() {
        return false;
    }

    public boolean isVertexesObject() {
        return false;
    }

    public abstract void renderOn_(JunOpenGLRenderingContext var1);

    public void renderOn_(JunVrmlRenderingContext junVrmlRenderingContext) {
        junVrmlRenderingContext.displayObject_(this);
    }

    public abstract Object geometriesDo_(StBlockClosure var1);

    public abstract Object objectsDo_(StBlockClosure var1);

    public abstract Object primitivesDo_(StBlockClosure var1);

    public abstract void pointsDo_(StBlockClosure var1);

    public abstract void polygonsDo_(StBlockClosure var1);

    public abstract void polylinesDo_(StBlockClosure var1);

    public abstract JunOpenGL3dObject transform_(Jun3dTransformation var1);

    public Jun3dTransformation transformation() {
        return Jun3dTransformation.Unity();
    }

    public JunOpenGL3dObject rotatedBy_(JunAngle junAngle) {
        return this.transform_(Jun3dTransformation.Rotate_(junAngle));
    }

    public JunOpenGL3dObject scaledBy_(double d) {
        return this.transform_(Jun3dTransformation.Scale_(d));
    }

    public JunOpenGL3dObject scaledBy_(Jun3dPoint jun3dPoint) {
        return this.transform_(Jun3dTransformation.Scale_(jun3dPoint));
    }

    public JunOpenGL3dObject translatedBy_(double d) {
        return this.transform_(Jun3dTransformation.Translate_(d));
    }

    public JunOpenGL3dObject translatedBy_(Jun3dPoint jun3dPoint) {
        return this.transform_(Jun3dTransformation.Translate_(jun3dPoint));
    }

    public abstract JunOpenGL3dCompoundObject asCompoundObject();

    public StImage asImage() {
        Image image = this.toImage();
        return image == null ? null : new StImage(image);
    }

    public Image toImage() {
        return this.toImageExtent_(JunOpenGL3dModel.DefaultImageExtent);
    }

    public Image toImageExtent_(Dimension dimension) {
        JunOpenGL3dModel junOpenGL3dModel = new JunOpenGL3dModel(this);
        return this.toImageExtent_eyePoint_sightPoint_upVector_(dimension, junOpenGL3dModel.defaultEyePoint(), junOpenGL3dModel.defaultSightPoint(), junOpenGL3dModel.defaultUpVector());
    }

    public Image toImageExtent_eyePoint_sightPoint_upVector_(Dimension dimension, Jun3dPoint jun3dPoint, Jun3dPoint jun3dPoint2, Jun3dPoint jun3dPoint3) {
        JunOpenGL3dModel junOpenGL3dModel = new JunOpenGL3dModel(this);
        junOpenGL3dModel.defaultEyePoint_(jun3dPoint);
        junOpenGL3dModel.defaultSightPoint_(jun3dPoint2);
        junOpenGL3dModel.defaultUpVector_(jun3dPoint3);
        junOpenGL3dModel.resetView();
        return junOpenGL3dModel.toImageExtent_(dimension);
    }

    public JunOpenGL3dObject asJunOpenGL3dObject() {
        return this;
    }

    public Jun3dPoint[] asPointArray() {
        final ArrayList arrayList = new ArrayList();
        this.pointsDo_(new StBlockClosure(){

            public Object value_(Object object) {
                arrayList.add(object);
                return null;
            }
        });
        return arrayList.toArray(new Jun3dPoint[arrayList.size()]);
    }

    public Jun3dPoint[] asPointSet() {
        final ArrayList arrayList = new ArrayList();
        this.pointsDo_(new StBlockClosure(){

            public Object value_(Object object) {
                if (!arrayList.contains(object)) {
                    arrayList.add(object);
                }
                return null;
            }
        });
        return arrayList.toArray(new Jun3dPoint[arrayList.size()]);
    }

    public JunGeometry[] asGeometryArray() {
        final ArrayList arrayList = new ArrayList();
        this.geometriesDo_(new StBlockClosure(){

            public Object value_(Object object) {
                arrayList.add(object);
                return null;
            }
        });
        return arrayList.toArray(new JunGeometry[arrayList.size()]);
    }

    public Jun3dTriangle asTriangle() {
        Jun3dTriangle[] jun3dTriangleArray = this.asTriangles();
        if (jun3dTriangleArray.length == 0) {
            return null;
        }
        return jun3dTriangleArray[0];
    }

    public Jun3dTriangle[] asTriangles() {
        ArrayList<Jun3dTriangle> arrayList = new ArrayList<Jun3dTriangle>();
        JunGeometry[] junGeometryArray = this.asGeometryArray();
        for (int i = 0; i < junGeometryArray.length; ++i) {
            Jun3dTriangle[] jun3dTriangleArray = junGeometryArray[i].asArrayOf3dTriangles();
            if (jun3dTriangleArray == null) continue;
            for (int j = 0; j < jun3dTriangleArray.length; ++j) {
                arrayList.add(jun3dTriangleArray[j]);
            }
        }
        return arrayList.toArray(new Jun3dTriangle[arrayList.size()]);
    }

    public Jun3dPoint averageVertex() {
        Jun3dPoint jun3dPoint = new Jun3dPoint(0.0, 0.0, 0.0);
        Jun3dPoint[] jun3dPointArray = this.asPointArray();
        if (jun3dPointArray.length > 0) {
            for (int i = 0; i < jun3dPointArray.length; ++i) {
                jun3dPoint = jun3dPoint.plus_(jun3dPointArray[i]);
            }
            jun3dPoint = jun3dPoint.dividedBy_(jun3dPointArray.length);
        }
        return jun3dPoint;
    }

    public JunOpenGL3dCompoundObject flatten() {
        final JunOpenGL3dCompoundObject junOpenGL3dCompoundObject = new JunOpenGL3dCompoundObject();
        this.primitivesDo_(new StBlockClosure(){

            public Object value_(Object object) {
                junOpenGL3dCompoundObject.add_((JunOpenGL3dObject)((Object)object));
                return null;
            }
        });
        return junOpenGL3dCompoundObject;
    }

    public JunOpenGL3dCompoundObject flattenAsPolygons() {
        final JunOpenGL3dCompoundObject junOpenGL3dCompoundObject = new JunOpenGL3dCompoundObject();
        this.polygonsDo_(new StBlockClosure(){

            public Object value_(Object object) {
                junOpenGL3dCompoundObject.add_((JunOpenGL3dObject)((Object)object));
                return null;
            }
        });
        return junOpenGL3dCompoundObject;
    }

    public abstract JunOpenGL3dObject reversed();

    public JunOpenGL3dObject yourselfAndNormalVectorsObject() {
        return this;
    }

    public void _copyInto(JunOpenGL3dObject junOpenGL3dObject) {
        if (this.hasName()) {
            junOpenGL3dObject.name_(this.name());
        }
        if (this.hasAlpha()) {
            junOpenGL3dObject.alpha_(this.alpha());
        }
        if (this.hasPaint()) {
            junOpenGL3dObject.paint_(this.paint());
        }
        if (this.hasStipple()) {
            junOpenGL3dObject.stipple_(this.stipple());
        }
        if (this.hasTexture()) {
            junOpenGL3dObject.texture_(this.texture());
        }
    }

    public JunOpenGLDisplayModel show() {
        return this.showIn_(null);
    }

    public JunOpenGLDisplayModel showAt_(Point point) {
        return this.showIn_(new Rectangle(point.x, point.y, 300, 300));
    }

    public JunOpenGLDisplayModel showIn_(Rectangle rectangle) {
        return this.showEyePoint_sightPoint_upVector_viewFactor_in_(null, null, null, Double.NaN, rectangle);
    }

    public JunOpenGLDisplayModel showEyePoint_(Jun3dPoint jun3dPoint) {
        return this.showEyePoint_sightPoint_(jun3dPoint, null);
    }

    public JunOpenGLDisplayModel showEyePoint_sightPoint_(Jun3dPoint jun3dPoint, Jun3dPoint jun3dPoint2) {
        return this.showEyePoint_sightPoint_upVector_(jun3dPoint, jun3dPoint2, null);
    }

    public JunOpenGLDisplayModel showEyePoint_sightPoint_upVector_(Jun3dPoint jun3dPoint, Jun3dPoint jun3dPoint2, Jun3dPoint jun3dPoint3) {
        return this.showEyePoint_sightPoint_upVector_viewFactor_(jun3dPoint, jun3dPoint2, jun3dPoint3, Double.NaN);
    }

    public JunOpenGLDisplayModel showEyePoint_sightPoint_upVector_in_(Jun3dPoint jun3dPoint, Jun3dPoint jun3dPoint2, Jun3dPoint jun3dPoint3, Rectangle rectangle) {
        return this.showEyePoint_sightPoint_upVector_viewFactor_in_(jun3dPoint, jun3dPoint2, jun3dPoint3, Double.NaN, rectangle);
    }

    public JunOpenGLDisplayModel showEyePoint_sightPoint_upVector_viewFactor_(Jun3dPoint jun3dPoint, Jun3dPoint jun3dPoint2, Jun3dPoint jun3dPoint3, double d) {
        return this.showEyePoint_sightPoint_upVector_viewFactor_in_(jun3dPoint, jun3dPoint2, jun3dPoint3, d, null);
    }

    public JunOpenGLDisplayModel showEyePoint_sightPoint_upVector_viewFactor_in_(Jun3dPoint jun3dPoint, Jun3dPoint jun3dPoint2, Jun3dPoint jun3dPoint3, double d, Rectangle rectangle) {
        return this.showEyePoint_sightPoint_upVector_viewFactor_zoomHeight_in_(jun3dPoint, jun3dPoint2, jun3dPoint3, d, Double.NaN, rectangle);
    }

    public JunOpenGLDisplayModel showEyePoint_sightPoint_upVector_viewFactor_zoomHeight_in_(Jun3dPoint jun3dPoint, Jun3dPoint jun3dPoint2, Jun3dPoint jun3dPoint3, double d, double d2, Rectangle rectangle) {
        return JunOpenGLDisplayModel.Show_eyePoint_sightPoint_upVector_viewFactor_zoomHeight_in_(this, jun3dPoint, jun3dPoint2, jun3dPoint3, d, d2, rectangle);
    }

    public JunOpenGLDisplayModel showEyePoint_sightPoint_upVector_zoomHeight_(Jun3dPoint jun3dPoint, Jun3dPoint jun3dPoint2, Jun3dPoint jun3dPoint3, double d) {
        return this.showEyePoint_sightPoint_upVector_viewFactor_zoomHeight_in_(jun3dPoint, jun3dPoint2, jun3dPoint3, Double.NaN, d, null);
    }

    public JunOpenGLDisplayModel showEyePoint_sightPoint_upVector_zoomHeight_in_(Jun3dPoint jun3dPoint, Jun3dPoint jun3dPoint2, Jun3dPoint jun3dPoint3, double d, Rectangle rectangle) {
        return this.showEyePoint_sightPoint_upVector_viewFactor_zoomHeight_in_(jun3dPoint, jun3dPoint2, jun3dPoint3, Double.NaN, d, rectangle);
    }

    public JunOpenGLDisplayModel showProjectionTable_(Map map) {
        return this.showProjectionTable_in_(map, null);
    }

    public JunOpenGLDisplayModel showProjectionTable_in_(Map map, Rectangle rectangle) {
        return JunOpenGLDisplayModel.Show_projectionTable_in_(this, map, rectangle);
    }

    public JunOpenGLDisplayModel showWithAxes() {
        return this.withAxes().show();
    }

    public JunOpenGLDisplayModel showWithAxesIn_(Rectangle rectangle) {
        return this.withAxes().showIn_(rectangle);
    }

    public JunOpenGLDisplayModel showWithTranslatedAxes() {
        return this.withTranslatedAxes().show();
    }

    public JunOpenGLDisplayModel showWithTranslatedAxesIn_(Rectangle rectangle) {
        return this.withTranslatedAxes().showIn_(rectangle);
    }

    public JunOpenGLDisplayModel showWithUnitAxes() {
        return this.withUnitAxes().show();
    }

    public JunOpenGLDisplayModel showWithUnitAxesIn_(Rectangle rectangle) {
        return this.withUnitAxes().showIn_(rectangle);
    }

    public JunOpenGL3dCompoundObject withAxes() {
        Jun3dBoundingBox jun3dBoundingBox = this.boundingBox().merge_(Jun3dPoint.Zero().asBoundingBox());
        JunOpenGL3dObject junOpenGL3dObject = JunOpenGL3dObject.XyzArrows().scaledBy_(Math.max(Math.max(jun3dBoundingBox.width(), jun3dBoundingBox.height()), jun3dBoundingBox.depth()) * 1.2);
        return new JunOpenGL3dCompoundObject(this, junOpenGL3dObject);
    }

    public JunOpenGL3dCompoundObject withTranslatedAxes() {
        Jun3dBoundingBox jun3dBoundingBox = this.boundingBox();
        JunOpenGL3dObject junOpenGL3dObject = JunOpenGL3dObject.XyzArrows().scaledBy_(Math.max(Math.max(jun3dBoundingBox.width(), jun3dBoundingBox.height()), jun3dBoundingBox.depth()) * 0.8).translatedBy_(jun3dBoundingBox.center());
        return new JunOpenGL3dCompoundObject(this, junOpenGL3dObject);
    }

    public JunOpenGL3dCompoundObject withUnitAxes() {
        return new JunOpenGL3dCompoundObject(this, JunOpenGL3dObject.XyzArrows());
    }

    public float defaultAlpha() {
        return 1.0f;
    }

    public float defaultLineWidth() {
        return 1.0f;
    }

    protected String defaultName() {
        return JunOpenGL3dObject.UniqueId();
    }

    public Color defaultPaint() {
        return JunOpenGL3dObject.DefaultPaint();
    }

    public Jun3dPoint defaultPoint() {
        return new Jun3dPoint(0.0, 0.0, 0.0);
    }

    public float defaultSize() {
        return 1.0f;
    }

    public JunAngle defaultSmoothingAngle() {
        return JunAngle.FromDeg_(45.0);
    }

    public Jun3dTransformation defaultTransformation() {
        return Jun3dTransformation.Unity();
    }

    public abstract int numberOfPolygons();

    public abstract int numberOfPrimitives();

    public StSymbol kindName() {
        return this._className();
    }

    public JunLispCons lispCons() {
        return JunLispList.Cell();
    }

    public JunLispNil lispNil() {
        return JunLispList.NullList();
    }

    public JunLispCons toLispList() {
        JunLispCons junLispCons = this.lispCons();
        junLispCons.head_(this.kindName());
        if (this.hasName()) {
            junLispCons.add_((Object)this.nameToLispList());
        }
        if (this.hasColor()) {
            junLispCons.add_((Object)this.colorToLispList());
        }
        return junLispCons;
    }

    protected JunLispList nameToLispList() {
        if (!this.hasName()) {
            return this.lispNil();
        }
        JunLispCons junLispCons = this.lispCons();
        junLispCons.head_(JunOpenGL3dObject.$((String)"name"));
        junLispCons.tail_(this.name());
        return junLispCons;
    }

    protected JunLispList colorToLispList() {
        JunLispCons junLispCons = this.lispCons();
        junLispCons.head_(JunOpenGL3dObject.$((String)"color"));
        Color color = this.paint();
        junLispCons.add_(new Float((float)color.getRed() / 255.0f));
        junLispCons.add_(new Float((float)color.getGreen() / 255.0f));
        junLispCons.add_(new Float((float)color.getBlue() / 255.0f));
        if (this.hasAlpha()) {
            junLispCons.add_(new Float(this.alpha()));
        }
        return junLispCons;
    }

    public JunLispList showLispList() {
        return this.showLispList_(this.toLispList());
    }

    public JunLispList showLispList_(JunLispList junLispList) {
        return JunOpenGL3dObject.ShowLispList_(junLispList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveOn_(Writer writer) throws IOException {
        JunLispCons junLispCons;
        JunCursors junCursors = new JunCursors(new Cursor(3));
        try {
            junCursors._show();
            junLispCons = this.toLispList();
        }
        finally {
            junCursors._restore();
        }
        ((JunLispList)junLispCons).saveOn_(writer);
    }

    public void fromLispList(JunLispList junLispList) {
        this.nameFromLispList(junLispList);
        this.colorFromLispList(junLispList);
    }

    protected void nameFromLispList(JunLispList junLispList) {
        JunLispCons junLispCons = (JunLispCons)((Object)junLispList.detect_ifNone_(new StBlockClosure(){

            public Object value_(Object object) {
                return new Boolean(object instanceof JunLispCons && ((JunLispCons)((Object)object)).head() == 10.$((String)"name"));
            }
        }, new StBlockClosure()));
        if (junLispCons == null) {
            return;
        }
        this.name_((String)junLispCons.tail());
    }

    protected void colorFromLispList(JunLispList junLispList) {
        Number number;
        Number number2;
        JunLispCons junLispCons = (JunLispCons)((Object)junLispList.detect_ifNone_(new StBlockClosure(){

            public Object value_(Object object) {
                return new Boolean(object instanceof JunLispCons && ((JunLispCons)((Object)object)).head() == 11.$((String)"color"));
            }
        }, new StBlockClosure()));
        if (junLispCons == null) {
            return;
        }
        Number number3 = (Number)(junLispCons = (JunLispCons)((Object)junLispCons.tail())).nth_(1);
        if (number3 instanceof Integer) {
            number3 = new Float(Math.max(0.0f, Math.min(number3.floatValue() / 255.0f, 1.0f)));
        }
        if ((number2 = (Number)junLispCons.nth_(2)) instanceof Integer) {
            number2 = new Float(Math.max(0.0f, Math.min(number2.floatValue() / 255.0f, 1.0f)));
        }
        if ((number = (Number)junLispCons.nth_(3)) instanceof Integer) {
            number = new Float(Math.max(0.0f, Math.min(number.floatValue() / 255.0f, 1.0f)));
        }
        this.paint_(new Color(number3.floatValue(), number2.floatValue(), number.floatValue()));
        if (junLispCons.length() >= 4) {
            Number number4 = (Number)junLispCons.nth_(4);
            if (number4 instanceof Integer) {
                number4 = new Float(Math.max(0.0f, Math.min(number4.floatValue() / 255.0f, 1.0f)));
            }
            this.alpha_(number4.floatValue());
        }
    }

    protected void transformationFromLispList(JunLispList junLispList) {
        Jun3dTransformation jun3dTransformation = JunOpenGL3dObject.TransformationFromLispList_(junLispList);
        if (jun3dTransformation != null) {
            this.transform_(jun3dTransformation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void vrmlOn_(Writer writer) {
        PrintWriter printWriter = writer instanceof PrintWriter ? (PrintWriter)writer : new PrintWriter(writer);
        try {
            this.vrml20On_(printWriter, "");
        }
        finally {
            printWriter.flush();
        }
    }

    public String vrmlString() {
        return this.vrml20String();
    }

    public abstract void vrml10On_(Writer var1);

    public String vrml10String() {
        StringWriter stringWriter = new StringWriter();
        try {
            this.vrml10On_(stringWriter);
            stringWriter.close();
        }
        catch (Exception exception) {
            new SmalltalkException(exception);
        }
        return stringWriter.toString();
    }

    protected void vrml10ColorOn_(Writer writer) {
        if (!this.hasColor()) {
            return;
        }
        try {
            BufferedWriter bufferedWriter = writer instanceof BufferedWriter ? (BufferedWriter)writer : new BufferedWriter(writer);
            bufferedWriter.write(INDENT);
            bufferedWriter.write("Material {");
            bufferedWriter.newLine();
            bufferedWriter.write("\t\t");
            bufferedWriter.write("diffuseColor ");
            Color color = this.paint();
            bufferedWriter.write(String.valueOf((float)color.getRed() / 255.0f));
            bufferedWriter.write(" ");
            bufferedWriter.write(String.valueOf((float)color.getGreen() / 255.0f));
            bufferedWriter.write(" ");
            bufferedWriter.write(String.valueOf((float)color.getBlue() / 255.0f));
            bufferedWriter.newLine();
            bufferedWriter.write(INDENT);
            bufferedWriter.write("} #Material");
            bufferedWriter.newLine();
            bufferedWriter.flush();
        }
        catch (IOException iOException) {
            throw new SmalltalkException((Exception)iOException);
        }
    }

    public void vrml20On_(Writer writer) {
        PrintWriter printWriter = writer instanceof PrintWriter ? (PrintWriter)writer : new PrintWriter(writer);
        this.vrml20On_(printWriter, "");
    }

    public void vrml20On_(PrintWriter printWriter, String string) {
        this.vrml20ShapeOn_(printWriter, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String vrml20String() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        try {
            this.vrml20On_(printWriter, "");
        }
        finally {
            printWriter.flush();
        }
        return stringWriter.toString();
    }

    protected void vrml20ShapeOn_(PrintWriter printWriter, String string) {
        printWriter.println(string + "# " + this.name());
        printWriter.println(string + "Shape {");
        this.vrml20AppearanceOn_(printWriter, string + INDENT);
        this.vrml20GeometryOn_(printWriter, string + INDENT);
        printWriter.println(string + "} #Shape");
    }

    protected void vrml20AppearanceOn_(PrintWriter printWriter, String string) {
        if (!this.hasColor() && !this.hasTexture()) {
            return;
        }
        printWriter.println(string + "appearance Appearance {");
        if (this.hasColor()) {
            this.vrml20MaterialOn_(printWriter, string + INDENT);
        }
        if (this.hasTexture()) {
            this.vrml20TextureOn_(printWriter, string + INDENT);
        }
        printWriter.println(string + "} #Appearance");
    }

    protected void vrml20MaterialOn_(PrintWriter printWriter, String string) {
        printWriter.println(string + "material Material {");
        printWriter.print(string + INDENT + "diffuseColor ");
        Color color = this.paint();
        printWriter.print((float)color.getRed() / 255.0f);
        printWriter.print(' ');
        printWriter.print((float)color.getGreen() / 255.0f);
        printWriter.print(' ');
        printWriter.print((float)color.getBlue() / 255.0f);
        printWriter.println();
        printWriter.println(string + "} #Material");
    }

    protected void vrml20TextureOn_(PrintWriter printWriter, String string) {
        printWriter.println(string + "texture PixelTexture {");
        printWriter.println(string + INDENT + "image ");
        this.texture().vrmlSFImageOn_(printWriter);
        printWriter.println();
        printWriter.println(string + INDENT + "repeatS " + (this.texture().repeat() ? "TRUE" : "FALSE"));
        printWriter.println(string + INDENT + "repeatT " + (this.texture().repeat() ? "TRUE" : "FALSE"));
        printWriter.println(string + "} #PixelTexture");
    }

    protected void vrml20GeometryOn_(PrintWriter printWriter, String string) {
        throw SmalltalkException.SubclassResponsibility();
    }

    protected float rawAlpha() {
        return this.alpha;
    }

    protected String rawName() {
        return this.name;
    }

    protected Color rawPaint() {
        return this.paint;
    }
}

