/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.opengl.objects;

import java.io.Writer;
import java.util.Vector;
import jp.co.sra.jun.collections.sequences.JunDoubleMatrix;
import jp.co.sra.jun.collections.sequences.JunMatrix;
import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.surfaces.JunNurbsSurface;
import jp.co.sra.jun.geometry.transformations.Jun3dTransformation;
import jp.co.sra.jun.goodies.lisp.JunLispCons;
import jp.co.sra.jun.goodies.lisp.JunLispList;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dPrimitiveObject;
import jp.co.sra.jun.opengl.support.JunOpenGLRenderingContext;
import jp.co.sra.jun.opengl.texture.JunOpenGLStipple;
import jp.co.sra.jun.opengl.texture.JunOpenGLTexture;
import jp.co.sra.smalltalk.SmalltalkException;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StImage;
import jp.co.sra.smalltalk.StObject;
import jp.co.sra.smalltalk.StSymbol;

public class JunOpenGL3dNurbsSurface
extends JunOpenGL3dPrimitiveObject {
    protected JunOpenGLStipple stipple;
    protected JunOpenGLTexture texture;
    protected JunMatrix controlPoints;
    protected JunDoubleMatrix weights;
    protected double[] uKnotVector;
    protected double[] vKnotVector;

    public JunOpenGL3dNurbsSurface(JunMatrix junMatrix, JunDoubleMatrix junDoubleMatrix, double[] dArray, double[] dArray2) {
        this.controlPoints_(junMatrix);
        this.weights_(junDoubleMatrix);
        this.uKnotVector_(dArray);
        this.vKnotVector_(dArray2);
    }

    public JunOpenGL3dNurbsSurface(JunLispList junLispList) {
        this.fromLispList(junLispList);
    }

    public static JunOpenGL3dNurbsSurface BezierControlPoints_(JunMatrix junMatrix) {
        int n = junMatrix.columnSize();
        int n2 = junMatrix.rowSize();
        double[] dArray = new double[n2 * 2];
        for (int i = 0; i < n2; ++i) {
            dArray[i] = 0.0;
            dArray[i + n2] = 1.0;
        }
        double[] dArray2 = new double[n * 2];
        for (int i = 0; i < n; ++i) {
            dArray2[i] = 0.0;
            dArray2[i + n] = 1.0;
        }
        return JunOpenGL3dNurbsSurface.BSplineControlPoints_uKnotVector_vKnotVector_(junMatrix, dArray, dArray2);
    }

    public static JunOpenGL3dNurbsSurface BSplineControlPoints_uKnotVector_vKnotVector_(JunMatrix junMatrix, double[] dArray, double[] dArray2) {
        int n = junMatrix.rowSize();
        int n2 = junMatrix.columnSize();
        double[] dArray3 = new double[n * n2];
        for (int i = 0; i < dArray3.length; ++i) {
            dArray3[i] = 1.0;
        }
        return new JunOpenGL3dNurbsSurface(junMatrix, new JunDoubleMatrix(n, n2, dArray3), dArray, dArray2);
    }

    public static JunOpenGL3dNurbsSurface ControlPoints_weights_uKnotVector_vKnotVector_(JunMatrix junMatrix, JunDoubleMatrix junDoubleMatrix, double[] dArray, double[] dArray2) {
        return new JunOpenGL3dNurbsSurface(junMatrix, junDoubleMatrix, dArray, dArray2);
    }

    protected void initialize() {
        super.initialize();
        this.stipple = null;
        this.texture = null;
        this.controlPoints = null;
        this.weights = null;
        this.uKnotVector = null;
        this.vKnotVector = null;
    }

    public void halftone_(double d) {
        this.stipple_(JunOpenGLStipple.Halftone_(d));
    }

    public JunOpenGLStipple stipple() {
        return this.stipple;
    }

    public void stipple_(JunOpenGLStipple junOpenGLStipple) {
        this.stipple = junOpenGLStipple;
    }

    public JunOpenGLTexture texture() {
        return this.texture;
    }

    public void texture_(JunOpenGLTexture junOpenGLTexture) {
        this.texture = junOpenGLTexture;
        super.texture_(junOpenGLTexture);
    }

    public JunMatrix controlPoints() {
        return this.controlPoints;
    }

    public void controlPoints_(JunMatrix junMatrix) {
        this.controlPoints = junMatrix;
    }

    public JunDoubleMatrix weights() {
        return this.weights;
    }

    public void weights_(JunDoubleMatrix junDoubleMatrix) {
        this.weights = junDoubleMatrix;
    }

    public double[] uKnotVector() {
        return this.uKnotVector;
    }

    public void uKnotVector_(double[] dArray) {
        this.uKnotVector = dArray;
    }

    public double[] vKnotVector() {
        return this.vKnotVector;
    }

    public void vKnotVector_(double[] dArray) {
        this.vKnotVector = dArray;
    }

    public boolean hasStipple() {
        return this.stipple != null;
    }

    public boolean hasTexture() {
        return this.texture != null;
    }

    public void renderOn_(JunOpenGLRenderingContext junOpenGLRenderingContext) {
        int n = Integer.MIN_VALUE;
        if (this.hasPaint()) {
            junOpenGLRenderingContext.paint_(this.paint());
        }
        if (this.hasAlpha()) {
            junOpenGLRenderingContext.alpha_(this.alpha());
        }
        if (this.hasStipple()) {
            this.stipple().enableStippleOn_(junOpenGLRenderingContext);
        }
        if (this.hasTexture()) {
            n = junOpenGLRenderingContext.textureCoordinateIndex();
            junOpenGLRenderingContext.textureCoordinateIndex_(0);
            this.texture().enableTextureOn_(junOpenGLRenderingContext);
        }
        if (this.hasTransparency()) {
            junOpenGLRenderingContext.enableCullFace();
            junOpenGLRenderingContext.disableDepthMask();
            junOpenGLRenderingContext.enableBlending();
        }
        junOpenGLRenderingContext.displayNurbsSurface_(this._asJunNurbsSurface());
        if (this.hasTransparency()) {
            junOpenGLRenderingContext.disableCullFace();
            junOpenGLRenderingContext.enableDepthMask();
            junOpenGLRenderingContext.disableBlending();
        }
        if (this.hasTexture()) {
            this.texture().disableTextureOn_(junOpenGLRenderingContext);
            junOpenGLRenderingContext.textureCoordinateIndex_(n);
        }
        if (this.hasStipple()) {
            this.stipple().disableStippleOn_(junOpenGLRenderingContext);
        }
    }

    public Object geometriesDo_(StBlockClosure stBlockClosure) {
        return stBlockClosure.value_((Object)JunNurbsSurface.ControlPoints_weights_uKnotVector_vKnotVector_(this.controlPoints, this.weights, this.uKnotVector, this.vKnotVector));
    }

    public void pointsDo_(StBlockClosure stBlockClosure) {
        this.controlPoints.do_(stBlockClosure);
    }

    public JunOpenGL3dObject transform_(final Jun3dTransformation jun3dTransformation) {
        JunOpenGL3dNurbsSurface junOpenGL3dNurbsSurface = (JunOpenGL3dNurbsSurface)this.copy();
        final JunMatrix junMatrix = junOpenGL3dNurbsSurface.controlPoints();
        junMatrix.doIJ_(new StBlockClosure(){

            public Object value_value_value_(Object object, Object object2, Object object3) {
                Jun3dPoint jun3dPoint = ((Jun3dPoint)((Object)object)).transform_(jun3dTransformation);
                int n = ((Number)object2).intValue();
                int n2 = ((Number)object3).intValue();
                junMatrix.row_column_put_(n, n2, (Object)jun3dPoint);
                return null;
            }
        });
        return junOpenGL3dNurbsSurface;
    }

    public JunNurbsSurface _asJunNurbsSurface() {
        return JunNurbsSurface.ControlPoints_weights_uKnotVector_vKnotVector_(this.controlPoints, this.weights, this.uKnotVector, this.vKnotVector);
    }

    public JunOpenGL3dObject reversed() {
        throw new SmalltalkException("not implemented yet");
    }

    public StObject postCopy() {
        super.postCopy();
        this.controlPoints = (JunMatrix)this.controlPoints.copy();
        this.weights = (JunDoubleMatrix)this.weights.copy();
        double[] dArray = new double[this.uKnotVector.length];
        System.arraycopy(this.uKnotVector, 0, dArray, 0, this.uKnotVector.length);
        this.uKnotVector = dArray;
        double[] dArray2 = new double[this.vKnotVector.length];
        System.arraycopy(this.vKnotVector, 0, dArray2, 0, this.vKnotVector.length);
        this.vKnotVector = dArray2;
        return this;
    }

    public int numberOfPolygons() {
        return 1;
    }

    public StSymbol kindName() {
        return JunOpenGL3dNurbsSurface.$((String)"NurbsSurface");
    }

    public JunLispCons toLispList() {
        JunLispCons junLispCons = super.toLispList();
        if (this.hasStipple()) {
            junLispCons.add_((Object)this.stippleToLispList());
        }
        if (this.hasTexture()) {
            junLispCons.add_((Object)this.textureToLispList());
        }
        junLispCons.add_((Object)this.controlsToLispList());
        junLispCons.add_((Object)this.weightsToLispList());
        junLispCons.add_((Object)this.uKnotsToLispList());
        junLispCons.add_((Object)this.vKnotsToLispList());
        return junLispCons;
    }

    protected JunLispList stippleToLispList() {
        if (!this.hasStipple()) {
            return this.lispNil();
        }
        JunLispCons junLispCons = this.lispCons();
        junLispCons.head_(JunOpenGL3dNurbsSurface.$((String)"stipple"));
        junLispCons.tail_(this.stipple().image());
        return junLispCons;
    }

    protected JunLispList textureToLispList() {
        if (!this.hasTexture()) {
            return this.lispNil();
        }
        JunLispCons junLispCons = this.lispCons();
        junLispCons.head_(JunOpenGL3dNurbsSurface.$((String)"texture"));
        junLispCons.tail_((Object)this.texture().toLispList());
        return junLispCons;
    }

    protected JunLispList controlsToLispList() {
        final Vector<Object> vector = new Vector<Object>(this.controlPoints.size() + 3);
        vector.addElement(JunOpenGL3dNurbsSurface.$((String)"controls"));
        vector.addElement(new Integer(this.controlPoints.rowSize()));
        vector.addElement(new Integer(this.controlPoints.columnSize()));
        this.controlPoints.do_(new StBlockClosure(){

            public Object value_(Object object) {
                vector.addElement(object);
                return null;
            }
        });
        return JunLispCons.List_(vector);
    }

    protected JunLispList weightsToLispList() {
        final Vector<Object> vector = new Vector<Object>(this.weights.size() + 3);
        vector.addElement(JunOpenGL3dNurbsSurface.$((String)"weights"));
        vector.addElement(new Integer(this.weights.rowSize()));
        vector.addElement(new Integer(this.weights.columnSize()));
        this.weights.do_(new StBlockClosure(){

            public Object value_(Object object) {
                vector.addElement(object);
                return null;
            }
        });
        return JunLispCons.List_(vector);
    }

    protected JunLispList uKnotsToLispList() {
        Object[] objectArray = new Object[this.uKnotVector.length + 1];
        objectArray[0] = JunOpenGL3dNurbsSurface.$((String)"uKnots");
        for (int i = 0; i < this.uKnotVector.length; ++i) {
            objectArray[i + 1] = new Double(this.uKnotVector[i]);
        }
        return JunLispCons.List_(objectArray);
    }

    protected JunLispList vKnotsToLispList() {
        Object[] objectArray = new Object[this.vKnotVector.length + 1];
        objectArray[0] = JunOpenGL3dNurbsSurface.$((String)"vKnots");
        for (int i = 0; i < this.vKnotVector.length; ++i) {
            objectArray[i + 1] = new Double(this.vKnotVector[i]);
        }
        return JunLispCons.List_(objectArray);
    }

    public void fromLispList(JunLispList junLispList) {
        super.fromLispList(junLispList);
        this.stippleFromLispList(junLispList);
        this.textureFromLispList(junLispList);
        this.controlsFromLispList(junLispList);
        this.weightsFromLispList(junLispList);
        this.uKnotsFromLispList(junLispList);
        this.vKnotsFromLispList(junLispList);
        this.transformationFromLispList(junLispList);
        this.trimsFromLispList(junLispList);
    }

    protected void controlsFromLispList(JunLispList junLispList) {
        JunLispCons junLispCons = (JunLispCons)((Object)junLispList.detect_ifNone_(new StBlockClosure(){

            public Object value_(Object object) {
                return new Boolean(object instanceof JunLispCons && ((JunLispCons)((Object)object)).head() == 4.$((String)"controls"));
            }
        }, new StBlockClosure()));
        if (junLispCons == null) {
            this.controlPoints_(new JunMatrix());
        } else {
            junLispCons = (JunLispCons)((Object)junLispCons.tail());
            int n = ((Number)junLispCons.head()).intValue();
            junLispCons = (JunLispCons)((Object)junLispCons.tail());
            int n2 = ((Number)junLispCons.head()).intValue();
            junLispCons = (JunLispCons)((Object)junLispCons.tail());
            Object[] objectArray = junLispCons.asArray();
            JunMatrix junMatrix = new JunMatrix(n, n2, objectArray);
            this.controlPoints_(junMatrix);
        }
    }

    protected void stippleFromLispList(JunLispList junLispList) {
        JunLispCons junLispCons = (JunLispCons)((Object)junLispList.detect_ifNone_(new StBlockClosure(){

            public Object value_(Object object) {
                return new Boolean(object instanceof JunLispCons && ((JunLispCons)((Object)object)).head() == 5.$((String)"stipple"));
            }
        }, new StBlockClosure()));
        if (junLispCons == null) {
            return;
        }
        this.stipple_(new JunOpenGLStipple((StImage)junLispCons.tail()));
    }

    protected void textureFromLispList(JunLispList junLispList) {
        JunLispCons junLispCons = (JunLispCons)((Object)junLispList.detect_ifNone_(new StBlockClosure(){

            public Object value_(Object object) {
                return new Boolean(object instanceof JunLispCons && ((JunLispCons)((Object)object)).head() == 6.$((String)"texture"));
            }
        }, new StBlockClosure()));
        if (junLispCons == null) {
            return;
        }
        this.texture_(new JunOpenGLTexture((JunLispList)((Object)junLispCons.tail())));
    }

    protected void trimsFromLispList(JunLispList junLispList) {
    }

    protected void uKnotsFromLispList(JunLispList junLispList) {
        JunLispCons junLispCons = (JunLispCons)((Object)junLispList.detect_ifNone_(new StBlockClosure(){

            public Object value_(Object object) {
                return new Boolean(object instanceof JunLispCons && ((JunLispCons)((Object)object)).head() == 7.$((String)"uKnots"));
            }
        }, new StBlockClosure()));
        Object[] objectArray = junLispCons == null ? ((JunLispList)((Object)junLispList.tail())).asArray() : ((JunLispList)((Object)junLispCons.tail())).asArray();
        double[] dArray = new double[objectArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = ((Number)objectArray[i]).doubleValue();
        }
        this.uKnotVector_(dArray);
    }

    protected void vKnotsFromLispList(JunLispList junLispList) {
        JunLispCons junLispCons = (JunLispCons)((Object)junLispList.detect_ifNone_(new StBlockClosure(){

            public Object value_(Object object) {
                return new Boolean(object instanceof JunLispCons && ((JunLispCons)((Object)object)).head() == 8.$((String)"vKnots"));
            }
        }, new StBlockClosure()));
        Object[] objectArray = junLispCons == null ? ((JunLispList)((Object)junLispList.tail())).asArray() : ((JunLispList)((Object)junLispCons.tail())).asArray();
        double[] dArray = new double[objectArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = ((Number)objectArray[i]).doubleValue();
        }
        this.vKnotVector_(dArray);
    }

    protected void weightsFromLispList(JunLispList junLispList) {
        JunLispCons junLispCons = (JunLispCons)((Object)junLispList.detect_ifNone_(new StBlockClosure(){

            public Object value_(Object object) {
                return new Boolean(object instanceof JunLispCons && ((JunLispCons)((Object)object)).head() == 9.$((String)"weights"));
            }
        }, new StBlockClosure()));
        if (junLispCons == null) {
            this.controlPoints_(new JunMatrix());
        } else {
            junLispCons = (JunLispCons)((Object)junLispCons.tail());
            int n = ((Number)junLispCons.head()).intValue();
            junLispCons = (JunLispCons)((Object)junLispCons.tail());
            int n2 = ((Number)junLispCons.head()).intValue();
            junLispCons = (JunLispCons)((Object)junLispCons.tail());
            Object[] objectArray = junLispCons.asArray();
            double[] dArray = new double[objectArray.length];
            for (int i = 0; i < dArray.length; ++i) {
                dArray[i] = ((Number)objectArray[i]).doubleValue();
            }
            JunDoubleMatrix junDoubleMatrix = new JunDoubleMatrix(n, n2, dArray);
            this.weights_(junDoubleMatrix);
        }
    }

    public void vrml10On_(Writer writer) {
        throw new SmalltalkException("not implemented yet");
    }

    public void vrml20On_(Writer writer) {
        throw new SmalltalkException("not implemented yet");
    }
}

