/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.opengl.display;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import jp.co.sra.jun.geometry.basic.Jun2dPoint;
import jp.co.sra.jun.opengl.display.JunOpenGLDisplayController;
import jp.co.sra.jun.opengl.display.JunOpenGLShowModel;
import jp.co.sra.jun.opengl.display.JunOpenGLShowView;
import jp.co.sra.smalltalk.StSymbol;
import jp.co.sra.smalltalk.StView;

public class JunOpenGLShowController
extends JunOpenGLDisplayController
implements MouseListener,
MouseMotionListener {
    protected transient JunOpenGLShowView view;
    protected transient Point startPoint;

    public void initialize() {
        super.initialize();
        this.view = null;
        this.startPoint = null;
    }

    public void release() {
        Component component = this.getOpenGLDrawable().toComponent();
        component.removeMouseListener(this);
        component.removeMouseMotionListener(this);
        super.release();
    }

    protected void buildListener(StView stView) {
        Component component = this.getOpenGLDrawable().toComponent();
        component.addMouseListener(this);
        component.addMouseMotionListener(this);
    }

    protected JunOpenGLShowModel getOpenGLShowModel() {
        return (JunOpenGLShowModel)this.model();
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.startPoint = mouseEvent.getPoint();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.getOpenGLDrawable().toComponent().setCursor(Cursor.getPredefinedCursor(0));
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        Point point;
        if (mouseEvent.isMetaDown()) {
            return;
        }
        Point point2 = mouseEvent.getPoint();
        if (!point2.equals(point = this.startPoint)) {
            this.mouseDraggedFrom_to_with_(point, point2, mouseEvent);
            this.startPoint = point2;
        }
    }

    public void mouseDraggedFrom_to_with_(Point point, Point point2, MouseEvent mouseEvent) {
        StSymbol stSymbol = this.getOpenGLShowModel().buttonState();
        if (stSymbol == JunOpenGLShowController.$((String)"bull")) {
            this.bullActivityFrom_to_(point, point2);
        } else if (stSymbol == JunOpenGLShowController.$((String)"grab")) {
            this.grabActivityFrom_to_(point, point2);
        } else if (stSymbol == JunOpenGLShowController.$((String)"drag")) {
            this.dragActivityFrom_to_with_(point, point2, mouseEvent);
        }
    }

    protected void bullActivityFrom_to_(Point point, Point point2) {
        this.getOpenGLDrawable().toComponent().setCursor(Cursor.getPredefinedCursor(1));
        Jun2dPoint jun2dPoint = this.regularizePoint_(point2);
        Jun2dPoint jun2dPoint2 = this.regularizePoint_(point);
        if (!jun2dPoint.equals((Object)jun2dPoint2)) {
            this.getOpenGLShowModel().bull_xy_(jun2dPoint, jun2dPoint2);
        }
        this.getOpenGLDrawable().toComponent().setCursor(Cursor.getPredefinedCursor(0));
        this.getOpenGLShowModel().changed_(JunOpenGLShowController.$((String)"object"));
    }

    protected void dragActivityFrom_to_with_(Point point, Point point2, MouseEvent mouseEvent) {
        this.getOpenGLDrawable().toComponent().setCursor(Cursor.getPredefinedCursor(13));
        Jun2dPoint jun2dPoint = this.regularizePoint_(point2);
        Jun2dPoint jun2dPoint2 = this.regularizePoint_(point);
        if (jun2dPoint.equals((Object)jun2dPoint2)) {
            return;
        }
        if (mouseEvent.isShiftDown()) {
            this.getOpenGLShowModel().look_xy_(jun2dPoint2, jun2dPoint);
        } else {
            this.getOpenGLShowModel().slide_xy_(jun2dPoint2, jun2dPoint);
        }
    }

    protected void grabActivityFrom_to_(Point point, Point point2) {
        this.getOpenGLDrawable().toComponent().setCursor(Cursor.getPredefinedCursor(12));
        Jun2dPoint jun2dPoint = this.regularizePoint_(point2);
        Jun2dPoint jun2dPoint2 = this.regularizePoint_(point);
        if (!jun2dPoint.equals((Object)jun2dPoint2)) {
            this.getOpenGLShowModel().grab_xy_(jun2dPoint2, jun2dPoint);
        }
    }

    protected Jun2dPoint regularizePoint_(Point point) {
        Dimension dimension = this.getOpenGLDrawable().toComponent().getSize();
        double d = ((double)point.x - (double)dimension.width / 2.0) / ((double)dimension.height / 2.0);
        double d2 = -((double)point.y - (double)dimension.height / 2.0) / ((double)dimension.height / 2.0);
        return new Jun2dPoint(d, d2);
    }
}

