/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.opengl.cosmos;

import java.awt.event.WindowEvent;
import java.util.Vector;
import jp.co.sra.gl4jun.GLjInterface;
import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.boundaries.Jun3dBoundingBox;
import jp.co.sra.jun.geometry.surfaces.JunPlane;
import jp.co.sra.jun.opengl.display.JunOpenGLDisplayLight;
import jp.co.sra.jun.opengl.display.JunOpenGLDisplayModel;
import jp.co.sra.jun.opengl.lights.JunOpenGLLight;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dCompoundObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dPolygon;
import jp.co.sra.jun.opengl.projection.JunOpenGLProjector;
import jp.co.sra.jun.opengl.support.JunOpenGLRenderingContext;
import jp.co.sra.jun.system.support.JunSystem;
import jp.co.sra.smalltalk.DependentEvent;
import jp.co.sra.smalltalk.DependentListener;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StColorValue;

public class JunOpenGLMacrocosmModel
extends JunOpenGLDisplayModel {
    protected JunOpenGLDisplayModel insideModel;
    protected JunOpenGL3dObject stencilObject;
    protected JunOpenGL3dPolygon[] stencilPolygons;

    protected void initialize() {
        super.initialize();
        this.insideModel = null;
        this.stencilObject = null;
        this.stencilPolygons = null;
    }

    public JunOpenGLDisplayModel insideModel() {
        if (this.insideModel == null) {
            this.insideModel_(new JunOpenGLDisplayModel());
        }
        return this.insideModel;
    }

    public void insideModel_(JunOpenGLDisplayModel junOpenGLDisplayModel) {
        if (junOpenGLDisplayModel == this) {
            return;
        }
        if (this.insideModel != null && this.insideModel.myDependents().contains(this)) {
            this.insideModel.removeDependent_((DependentListener)this);
        }
        this.insideModel = junOpenGLDisplayModel;
        if (this.insideModel.myDependents() == null || !this.insideModel.myDependents().contains(this)) {
            this.insideModel.addDependent_((DependentListener)this);
        }
    }

    public JunOpenGL3dObject stencilObject() {
        if (this.stencilObject == null) {
            this.stencilObject_(new JunOpenGL3dCompoundObject());
        }
        return this.stencilObject;
    }

    public void stencilObject_(JunOpenGL3dObject junOpenGL3dObject) {
        this.stencilObject = junOpenGL3dObject;
    }

    public Jun3dBoundingBox boundingBox() {
        if (this.displayObject() == null) {
            return Jun3dBoundingBox.Origin_corner_(new Jun3dPoint(0.0, 0.0, 0.0), new Jun3dPoint(0.0, 0.0, 0.0));
        }
        return this.displayObject().boundingBox().merge_(this.stencilObject().boundingBox());
    }

    protected String windowTitle() {
        return JunSystem.$String((String)"Macrocosm");
    }

    public void noticeOfWindowClose(WindowEvent windowEvent) {
        super.noticeOfWindowClose(windowEvent);
        if (this.insideModel != null) {
            this.insideModel.closeRequest();
        }
    }

    public synchronized JunOpenGLDisplayLight[] displayLights() {
        if (this.displayLights == null) {
            this.displayLights = new JunOpenGLDisplayLight[5];
            this.displayLights[0] = JunOpenGLDisplayLight.ParallelLight_color_position_(false, StColorValue.Brightness_((double)0.1), this.defaultLightPoint());
            this.displayLights[1] = new JunOpenGLDisplayLight();
            this.displayLights[2] = new JunOpenGLDisplayLight();
            this.displayLights[3] = new JunOpenGLDisplayLight();
            this.displayLights[4] = JunOpenGLDisplayLight.AmbientLight_color_(true, this.defaultLightColor());
            for (int i = 0; i < this.displayLights.length; ++i) {
                this.displayLights[i].compute_(new StBlockClosure(){

                    public Object value() {
                        JunOpenGLMacrocosmModel.this.updateLightMenuIndication();
                        JunOpenGLMacrocosmModel.this.changed_(1.$((String)"light"));
                        return null;
                    }
                });
            }
        }
        return this.displayLights;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderOn_(JunOpenGLRenderingContext junOpenGLRenderingContext) {
        junOpenGLRenderingContext.clear();
        GLjInterface.Current().glEnable(2960);
        GLjInterface.Current().glStencilMask(1);
        GLjInterface.Current().glClear(1024);
        this.computeStencilPolygons();
        try {
            this.renderStencilObjectOn_(junOpenGLRenderingContext);
            this.renderInsideModelOn_((JunOpenGLRenderingContext)junOpenGLRenderingContext.clone());
            this.renderDisplayObjectOn_(junOpenGLRenderingContext);
        }
        finally {
            GLjInterface.Current().glDisable(2960);
            GLjInterface.Current().glStencilMask(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void renderStencilObjectOn_(JunOpenGLRenderingContext junOpenGLRenderingContext) {
        GLjInterface.Current().glColorMask(false, false, false, false);
        junOpenGLRenderingContext.disableDepthMask();
        try {
            GLjInterface.Current().glStencilFunc(519, 1, 1);
            GLjInterface.Current().glStencilOp(7681, 7681, 7681);
            for (int i = 0; i < this.stencilPolygons.length; ++i) {
                this.displayProjector().project_on_(this.stencilPolygons[i], junOpenGLRenderingContext);
            }
        }
        finally {
            junOpenGLRenderingContext.enableDepthMask();
            GLjInterface.Current().glColorMask(true, true, true, true);
        }
    }

    protected void renderInsideModelOn_(JunOpenGLRenderingContext junOpenGLRenderingContext) {
        GLjInterface.Current().glStencilFunc(514, 1, 1);
        GLjInterface.Current().glStencilOp(7680, 7680, 7680);
        this.insideModel().displayProjector().project_withLights_on_(this.insideModel.displayObject(), this.insideModel().displayLightCollection(), junOpenGLRenderingContext);
    }

    protected void renderDisplayObjectOn_(JunOpenGLRenderingContext junOpenGLRenderingContext) {
        GLjInterface.Current().glStencilFunc(517, 1, 1);
        GLjInterface.Current().glStencilOp(7680, 7680, 7680);
        JunOpenGLLight[] junOpenGLLightArray = this.displayLightCollection();
        JunOpenGL3dObject junOpenGL3dObject = this.displayObject();
        if (junOpenGL3dObject == null) {
            this.displayProjector().projectOn_(junOpenGLRenderingContext);
        } else if (this.selectedObjects().isEmpty()) {
            this.displayProjector().project_withLights_on_(junOpenGL3dObject, junOpenGLLightArray, junOpenGLRenderingContext);
        } else {
            JunOpenGLProjector junOpenGLProjector = (JunOpenGLProjector)this.displayProjector().copy();
            if (this.displayProjector().presentation() == JunOpenGLMacrocosmModel.$((String)"solidPresentation")) {
                junOpenGLProjector.wireframePresentation();
            } else if (this.displayProjector().presentation() == JunOpenGLMacrocosmModel.$((String)"wireframePresentation")) {
                junOpenGLProjector.wireframePresentation();
            } else if (this.displayProjector().presentation() == JunOpenGLMacrocosmModel.$((String)"hiddenlinePresentation")) {
                junOpenGLProjector.hiddenlinePresentation();
            }
            junOpenGLProjector.project_withLights_on_(junOpenGL3dObject, junOpenGLLightArray, junOpenGLRenderingContext);
            if (this.displayProjector().presentation() == JunOpenGLMacrocosmModel.$((String)"solidPresentation")) {
                junOpenGLProjector.solidPresentation();
            } else if (this.displayProjector().presentation() == JunOpenGLMacrocosmModel.$((String)"wireframePresentation")) {
                junOpenGLProjector.solidPresentation();
            } else if (this.displayProjector().presentation() == JunOpenGLMacrocosmModel.$((String)"hiddenlinePresentation")) {
                junOpenGLProjector.solidPresentation();
            }
            Object[] objectArray = this.selectedObjects().toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                junOpenGLProjector.project_on_((JunOpenGL3dObject)((Object)objectArray[i]), junOpenGLRenderingContext);
            }
        }
    }

    public void update_(DependentEvent dependentEvent) {
        super.update_(dependentEvent);
        if (dependentEvent.getAspect() != JunOpenGLMacrocosmModel.$((String)"state")) {
            this.changed_(dependentEvent);
        }
    }

    protected void computeStencilPolygons() {
        final Vector vector = new Vector(32);
        this.stencilObject().polygonsDo_(new StBlockClosure(){

            public Object value_(Object object) {
                JunOpenGL3dPolygon junOpenGL3dPolygon = (JunOpenGL3dPolygon)((Object)object);
                Jun3dPoint[] jun3dPointArray = junOpenGL3dPolygon.vertexes();
                double d = new JunPlane(jun3dPointArray[0], jun3dPointArray[1], jun3dPointArray[2]).valueF_(JunOpenGLMacrocosmModel.this.eyePoint());
                if (d > 0.0) {
                    vector.add(junOpenGL3dPolygon);
                }
                return null;
            }
        });
        this.stencilPolygons = vector.toArray(new JunOpenGL3dPolygon[vector.size()]);
    }
}

