/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.opengl.cosmos;

import java.awt.event.WindowEvent;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import jp.co.sra.gl4jun.GLjInterface;
import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.boundaries.Jun3dBoundingBox;
import jp.co.sra.jun.geometry.surfaces.JunPlane;
import jp.co.sra.jun.opengl.display.JunOpenGLDisplayLight;
import jp.co.sra.jun.opengl.display.JunOpenGLDisplayModel;
import jp.co.sra.jun.opengl.lights.JunOpenGLLight;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dPolygon;
import jp.co.sra.jun.opengl.projection.JunOpenGLProjector;
import jp.co.sra.jun.opengl.support.JunOpenGLRenderingContext;
import jp.co.sra.jun.system.support.JunSystem;
import jp.co.sra.smalltalk.DependentEvent;
import jp.co.sra.smalltalk.DependentListener;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StColorValue;

public class JunOpenGLHypercosmModel
extends JunOpenGLDisplayModel {
    protected Vector hyperDoors;
    protected Vector hyperSpaces;
    protected Hashtable stencilTable;

    public JunOpenGLHypercosmModel(JunOpenGL3dObject junOpenGL3dObject) {
        super(junOpenGL3dObject);
    }

    protected void initialize() {
        super.initialize();
        this.hyperDoors = null;
        this.hyperSpaces = null;
        this.stencilTable = null;
    }

    public Vector hyperDoors() {
        if (this.hyperDoors == null) {
            this.hyperDoors = new Vector();
        }
        return this.hyperDoors;
    }

    public JunOpenGL3dObject[] hyperDoorsNoDupulication() {
        Vector<JunOpenGL3dObject> vector = new Vector<JunOpenGL3dObject>(this.hyperDoors().size());
        Enumeration enumeration = this.hyperDoors().elements();
        while (enumeration.hasMoreElements()) {
            JunOpenGL3dObject junOpenGL3dObject = (JunOpenGL3dObject)((Object)enumeration.nextElement());
            if (vector.contains((Object)junOpenGL3dObject)) continue;
            vector.add(junOpenGL3dObject);
        }
        return vector.toArray(new JunOpenGL3dObject[vector.size()]);
    }

    public Vector hyperSpaces() {
        if (this.hyperSpaces == null) {
            this.hyperSpaces = new Vector();
        }
        return this.hyperSpaces;
    }

    public JunOpenGLDisplayModel[] hyperSpacesNoDupulication() {
        Vector<JunOpenGLDisplayModel> vector = new Vector<JunOpenGLDisplayModel>(this.hyperSpaces().size());
        Enumeration enumeration = this.hyperSpaces().elements();
        while (enumeration.hasMoreElements()) {
            JunOpenGLDisplayModel junOpenGLDisplayModel = (JunOpenGLDisplayModel)enumeration.nextElement();
            if (vector.contains(junOpenGLDisplayModel)) continue;
            vector.add(junOpenGLDisplayModel);
        }
        return vector.toArray(new JunOpenGLDisplayModel[vector.size()]);
    }

    public void add(JunOpenGL3dObject junOpenGL3dObject, JunOpenGLDisplayModel junOpenGLDisplayModel) {
        if (junOpenGLDisplayModel == this) {
            return;
        }
        this.hyperDoors().add(junOpenGL3dObject);
        this.hyperSpaces().add(junOpenGLDisplayModel);
        if (junOpenGLDisplayModel.myDependents() == null || !junOpenGLDisplayModel.myDependents().contains(this)) {
            junOpenGLDisplayModel.addDependent_((DependentListener)this);
        }
    }

    public Jun3dBoundingBox boundingBox() {
        if (this.displayObject() == null) {
            return Jun3dBoundingBox.Origin_corner_(new Jun3dPoint(0.0, 0.0, 0.0), new Jun3dPoint(0.0, 0.0, 0.0));
        }
        Jun3dBoundingBox jun3dBoundingBox = this.displayObject().boundingBox();
        Enumeration enumeration = this.hyperDoors().elements();
        while (enumeration.hasMoreElements()) {
            JunOpenGL3dObject junOpenGL3dObject = (JunOpenGL3dObject)((Object)enumeration.nextElement());
            jun3dBoundingBox = jun3dBoundingBox.merge_(junOpenGL3dObject.boundingBox());
        }
        return jun3dBoundingBox;
    }

    protected String windowTitle() {
        return JunSystem.$String((String)"Hypercosm");
    }

    public void noticeOfWindowClose(WindowEvent windowEvent) {
        super.noticeOfWindowClose(windowEvent);
        JunOpenGLDisplayModel[] junOpenGLDisplayModelArray = this.hyperSpacesNoDupulication();
        for (int i = 0; i < junOpenGLDisplayModelArray.length; ++i) {
            junOpenGLDisplayModelArray[i].closeRequest();
        }
    }

    public synchronized JunOpenGLDisplayLight[] displayLights() {
        if (this.displayLights == null) {
            this.displayLights = new JunOpenGLDisplayLight[5];
            this.displayLights[0] = JunOpenGLDisplayLight.ParallelLight_color_position_(false, StColorValue.Brightness_((double)0.1), this.defaultLightPoint());
            this.displayLights[1] = new JunOpenGLDisplayLight();
            this.displayLights[2] = new JunOpenGLDisplayLight();
            this.displayLights[3] = new JunOpenGLDisplayLight();
            this.displayLights[4] = JunOpenGLDisplayLight.AmbientLight_color_(true, this.defaultLightColor());
            for (int i = 0; i < this.displayLights.length; ++i) {
                this.displayLights[i].compute_(new StBlockClosure(){

                    public Object value() {
                        JunOpenGLHypercosmModel.this.updateLightMenuIndication();
                        JunOpenGLHypercosmModel.this.changed_(1.$((String)"light"));
                        return null;
                    }
                });
            }
        }
        return this.displayLights;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderOn_(JunOpenGLRenderingContext junOpenGLRenderingContext) {
        junOpenGLRenderingContext.clear();
        GLjInterface.Current().glEnable(2960);
        GLjInterface.Current().glStencilMask(1);
        GLjInterface.Current().glClear(1024);
        this.computeStencilTable();
        try {
            Enumeration enumeration = this.hyperDoors().elements();
            Enumeration enumeration2 = this.hyperSpaces().elements();
            while (enumeration.hasMoreElements() && enumeration2.hasMoreElements()) {
                JunOpenGL3dObject junOpenGL3dObject = (JunOpenGL3dObject)((Object)enumeration.nextElement());
                JunOpenGLDisplayModel junOpenGLDisplayModel = (JunOpenGLDisplayModel)enumeration2.nextElement();
                this.renderHyperDoor_on_(junOpenGL3dObject, junOpenGLRenderingContext);
                this.renderHyperSpace_on_(junOpenGLDisplayModel, (JunOpenGLRenderingContext)junOpenGLRenderingContext.clone());
                this.renderHyperDoorAux_on_(junOpenGL3dObject, junOpenGLRenderingContext);
            }
            this.renderHyperDoorsOn_(junOpenGLRenderingContext);
            this.renderDisplayObjectOn_(junOpenGLRenderingContext);
        }
        finally {
            GLjInterface.Current().glDisable(2960);
            GLjInterface.Current().glStencilMask(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void renderHyperDoor_on_(JunOpenGL3dObject junOpenGL3dObject, JunOpenGLRenderingContext junOpenGLRenderingContext) {
        GLjInterface.Current().glColorMask(false, false, false, false);
        junOpenGLRenderingContext.disableDepthMask();
        try {
            GLjInterface.Current().glStencilFunc(519, 1, 1);
            GLjInterface.Current().glStencilOp(7681, 7681, 7681);
            JunOpenGL3dPolygon[] junOpenGL3dPolygonArray = (JunOpenGL3dPolygon[])this.stencilTable.get((Object)junOpenGL3dObject);
            for (int i = 0; i < junOpenGL3dPolygonArray.length; ++i) {
                this.displayProjector().project_on_(junOpenGL3dPolygonArray[i], junOpenGLRenderingContext);
            }
        }
        finally {
            junOpenGLRenderingContext.enableDepthMask();
            GLjInterface.Current().glColorMask(true, true, true, true);
        }
    }

    protected void renderHyperSpace_on_(JunOpenGLDisplayModel junOpenGLDisplayModel, JunOpenGLRenderingContext junOpenGLRenderingContext) {
        GLjInterface.Current().glStencilFunc(514, 1, 1);
        GLjInterface.Current().glStencilOp(7680, 7680, 7680);
        junOpenGLDisplayModel.displayProjector().project_withLights_on_(junOpenGLDisplayModel.displayObject(), junOpenGLDisplayModel.displayLightCollection(), junOpenGLRenderingContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void renderHyperDoorAux_on_(JunOpenGL3dObject junOpenGL3dObject, JunOpenGLRenderingContext junOpenGLRenderingContext) {
        GLjInterface.Current().glColorMask(false, false, false, false);
        junOpenGLRenderingContext.disableDepthMask();
        try {
            GLjInterface.Current().glStencilFunc(514, 1, 1);
            GLjInterface.Current().glStencilOp(0, 0, 0);
            JunOpenGL3dPolygon[] junOpenGL3dPolygonArray = (JunOpenGL3dPolygon[])this.stencilTable.get((Object)junOpenGL3dObject);
            for (int i = 0; i < junOpenGL3dPolygonArray.length; ++i) {
                this.displayProjector().project_on_(junOpenGL3dPolygonArray[i], junOpenGLRenderingContext);
            }
        }
        finally {
            junOpenGLRenderingContext.enableDepthMask();
            GLjInterface.Current().glColorMask(true, true, true, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void renderHyperDoorsOn_(JunOpenGLRenderingContext junOpenGLRenderingContext) {
        GLjInterface.Current().glColorMask(false, false, false, false);
        junOpenGLRenderingContext.disableDepthMask();
        try {
            GLjInterface.Current().glStencilFunc(519, 1, 1);
            GLjInterface.Current().glStencilOp(7681, 7681, 7681);
            Enumeration enumeration = this.hyperDoors().elements();
            while (enumeration.hasMoreElements()) {
                JunOpenGL3dPolygon[] junOpenGL3dPolygonArray = (JunOpenGL3dPolygon[])this.stencilTable.get(enumeration.nextElement());
                for (int i = 0; i < junOpenGL3dPolygonArray.length; ++i) {
                    this.displayProjector().project_on_(junOpenGL3dPolygonArray[i], junOpenGLRenderingContext);
                }
            }
        }
        finally {
            junOpenGLRenderingContext.enableDepthMask();
            GLjInterface.Current().glColorMask(true, true, true, true);
        }
    }

    protected void renderDisplayObjectOn_(JunOpenGLRenderingContext junOpenGLRenderingContext) {
        GLjInterface.Current().glStencilFunc(517, 1, 1);
        GLjInterface.Current().glStencilOp(7680, 7680, 7680);
        JunOpenGLLight[] junOpenGLLightArray = this.displayLightCollection();
        JunOpenGL3dObject junOpenGL3dObject = this.displayObject();
        if (junOpenGL3dObject == null) {
            this.displayProjector().projectOn_(junOpenGLRenderingContext);
        } else if (this.selectedObjects().isEmpty()) {
            this.displayProjector().project_withLights_on_(junOpenGL3dObject, junOpenGLLightArray, junOpenGLRenderingContext);
        } else {
            JunOpenGLProjector junOpenGLProjector = (JunOpenGLProjector)this.displayProjector().copy();
            if (this.displayProjector().presentation() == JunOpenGLHypercosmModel.$((String)"solidPresentation")) {
                junOpenGLProjector.wireframePresentation();
            } else if (this.displayProjector().presentation() == JunOpenGLHypercosmModel.$((String)"wireframePresentation")) {
                junOpenGLProjector.wireframePresentation();
            } else if (this.displayProjector().presentation() == JunOpenGLHypercosmModel.$((String)"hiddenlinePresentation")) {
                junOpenGLProjector.hiddenlinePresentation();
            }
            junOpenGLProjector.project_withLights_on_(junOpenGL3dObject, junOpenGLLightArray, junOpenGLRenderingContext);
            if (this.displayProjector().presentation() == JunOpenGLHypercosmModel.$((String)"solidPresentation")) {
                junOpenGLProjector.solidPresentation();
            } else if (this.displayProjector().presentation() == JunOpenGLHypercosmModel.$((String)"wireframePresentation")) {
                junOpenGLProjector.solidPresentation();
            } else if (this.displayProjector().presentation() == JunOpenGLHypercosmModel.$((String)"hiddenlinePresentation")) {
                junOpenGLProjector.solidPresentation();
            }
            Object[] objectArray = this.selectedObjects().toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                junOpenGLProjector.project_on_((JunOpenGL3dObject)((Object)objectArray[i]), junOpenGLRenderingContext);
            }
        }
    }

    public void update_(DependentEvent dependentEvent) {
        super.update_(dependentEvent);
        if (dependentEvent.getAspect() != JunOpenGLHypercosmModel.$((String)"state")) {
            this.changed_(dependentEvent);
        }
    }

    protected void computeStencilTable() {
        this.stencilTable = new Hashtable();
        Enumeration enumeration = this.hyperDoors().elements();
        while (enumeration.hasMoreElements()) {
            JunOpenGL3dObject junOpenGL3dObject = (JunOpenGL3dObject)((Object)enumeration.nextElement());
            final Vector vector = new Vector(32);
            junOpenGL3dObject.polygonsDo_(new StBlockClosure(){

                public Object value_(Object object) {
                    JunOpenGL3dPolygon junOpenGL3dPolygon = (JunOpenGL3dPolygon)((Object)object);
                    Jun3dPoint[] jun3dPointArray = junOpenGL3dPolygon.vertexes();
                    double d = new JunPlane(jun3dPointArray[0], jun3dPointArray[1], jun3dPointArray[2]).valueF_(JunOpenGLHypercosmModel.this.eyePoint());
                    if (d > 0.0) {
                        vector.add(junOpenGL3dPolygon);
                    }
                    return null;
                }
            });
            this.stencilTable.put(junOpenGL3dObject, vector.toArray(new JunOpenGL3dPolygon[vector.size()]));
        }
    }
}

