/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.opengl.chart;

import java.awt.Color;
import java.awt.Point;
import java.util.Vector;
import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.opengl.chart.JunChartData;
import jp.co.sra.jun.opengl.chart.JunChartDataSheet;
import jp.co.sra.jun.opengl.chart.JunChartPlot;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dCompoundObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dPolyline;

public class JunChartLine
extends JunChartPlot {
    public static final double DefaultLineWidth = 1.0;
    protected double lineWidth;

    public JunChartLine() {
    }

    public JunChartLine(Vector vector) {
        super(vector);
    }

    public JunChartLine(Vector vector, int n) {
        super(vector, n);
    }

    public JunChartLine(JunChartData junChartData) {
        super(junChartData);
    }

    protected void initialize() {
        super.initialize();
        this.lineWidth = 1.0;
    }

    public double lineWidth() {
        return this.lineWidth;
    }

    public void lineWidth_(double d) {
        this.lineWidth = d;
    }

    protected void _copyAttributes(JunChartLine junChartLine) {
        super._copyAttributes(junChartLine);
        junChartLine.lineWidth_(this.lineWidth);
    }

    protected JunOpenGL3dCompoundObject createChart3dObject() {
        JunOpenGL3dCompoundObject junOpenGL3dCompoundObject = new JunOpenGL3dCompoundObject();
        JunChartData junChartData = this.data();
        JunChartDataSheet[] junChartDataSheetArray = junChartData.sheets();
        if (junChartDataSheetArray == null) {
            return junOpenGL3dCompoundObject;
        }
        for (int i = 0; i < junChartDataSheetArray.length; ++i) {
            JunChartDataSheet junChartDataSheet = junChartDataSheetArray[i];
            int n = junChartDataSheet.rowSize();
            double d = this.intervalBetweenCharts() * (double)i;
            double d2 = (1.0 - this.leftMargin() - this.rightMargin() - this.interval() * (double)(n - 1)) / (double)n;
            for (int j = 0; j < junChartDataSheet.valueSize(); ++j) {
                Jun3dPoint[] jun3dPointArray = new Jun3dPoint[n];
                Color color = this.nextColor();
                for (int k = 0; k < n; ++k) {
                    Jun3dPoint jun3dPoint;
                    Number number = (Number)junChartDataSheet.valueAtPoint_(new Point(k, j));
                    double d3 = this.leftMargin() + (d2 + this.interval) * (double)k + d2 / 2.0;
                    jun3dPointArray[k] = jun3dPoint = new Jun3dPoint(d3, junChartData.normalizeValue_(number.doubleValue()), d);
                    JunOpenGL3dObject junOpenGL3dObject = this.createSmallCubeAt_(jun3dPoint);
                    junOpenGL3dObject.paint_(color);
                    junOpenGL3dCompoundObject.add_(junOpenGL3dObject);
                    this.registerVisualObject_withValue_(junOpenGL3dObject, new Object[]{junChartDataSheet.keysAtRow_(k), number});
                }
                JunOpenGL3dPolyline junOpenGL3dPolyline = new JunOpenGL3dPolyline(jun3dPointArray);
                junOpenGL3dPolyline.paint_(color);
                junOpenGL3dPolyline.lineWidth_((float)this.lineWidth());
                junOpenGL3dCompoundObject.add_(junOpenGL3dPolyline);
            }
        }
        return junOpenGL3dCompoundObject;
    }
}

